<?php

class Discounts extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function manage_discounts($active = 0)
    {
        $data['title'] = 'Discounts';

        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/discounts/manage_discounts', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }


    public function getPeriodNetSales()
    {
        $vendor_id = $this->input->get('vendor_id');
        $category = $this->input->get('category');
        $from_date = date("Y-m-d", strtotime($this->input->get('from_date')));
        $to_date = date("Y-m-d", strtotime($this->input->get('to_date')));

        if ($from_date == '1970-01-01') {
            $json['status'] = 0;
            $json['message'] = 'Please select from date';
            echo json_encode($json);
            exit;
        }

        if ($to_date == '1970-01-01') {
            $json['status'] = 0;
            $json['message'] = 'Please select to date';
            echo json_encode($json);
            exit;
        }

        $where_from_check = array(
            "vendor_id" => $vendor_id,
            "from_date >= " => $from_date,
            "to_date <=" => $from_date,
        );

        $where_to_check = array(
            "vendor_id" => $vendor_id,
            "from_date >= " => $to_date,
            "to_date <=" => $to_date,
        );

        $from_check = $this->db->where($where_from_check)->get('tbl_creditnote_discounts')->row();

        if (!empty($from_check)) {
            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }

        $to_check = $this->db->where($where_to_check)->get('tbl_creditnote_discounts')->row();

        if (!empty($to_check)) {
            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }

        $where = array(
            "vendor_id" => $vendor_id,
            "DATE(CREATION_DATE) >=" => $from_date,
            "DATE(CREATION_DATE) <= " => $to_date,
            "category" => $category,
        );

        $this->db->select('sum(taxable_amount) as total_taxable, sum(tax) as total_tax, count(*) as total_quantity, sum(exempt_amount) as total_exempt, sum(discount_amount) as total_discount, sum(freight_amount) as total_freight');
        $result = $this->db->where($where)->get('NET_SALES_ITEM_VIEW')->row();

        $record = array(
            "net_amount" => $result->total_taxable + $result->total_exempt  - $result->total_discount / 1.18 + $result->total_freight / 1.18,
            "total_quantity" => $result->total_quantity,
        );

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

    public function getNetInvoiceSales()
    {
        $vendor_id = $this->input->get('vendor_id');
        $category = $this->input->get('category');
        $invoice_no = $this->input->get('invoice_no');

        $where = array(
            "vendor_id" => $vendor_id,
            "category" => $category,
            "invoice_code" => $invoice_no,
        );

        $this->db->select('sum(taxable_amount) as total_taxable, sum(tax) as total_tax, count(*) as total_quantity, sum(exempt_amount) as total_exempt, sum(discount_amount) as total_discount, sum(freight_amount) as total_freight, invoice_id');
        $result = $this->db->where($where)->get('NET_SALES_ITEM_VIEW')->row();

        if (empty($result)) {
            $json['status'] = 0;
            $json['message'] = 'Invalid Invoice No / Wrong Customer';
            echo json_encode($json);
            exit;
        }

        $record = array(
            "net_amount" => $result->total_taxable + $result->total_exempt  - $result->total_discount / 1.18 + $result->total_freight / 1.18,
            "total_quantity" => $result->total_quantity,
            "invoice_id" => $result->invoice_id,
        );

        $duplicate_check = $this->db->where('invoice_id', $result->invoice_id)->get('tbl_creditnote_discounts')->row();

        if (!empty($duplicate_check)) {
            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

    public function submitCreditNote()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $vendor_id = $data['vendor_id'];
        $creditnote_type = $data['creditnote_type'];
        $volume_rows = $data['volume_rows'];
        $other_rows = $data['other_rows'];
        if (empty($vendor_id) || !in_array($creditnote_type, ["VOLUME", "OTHER"])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        //Create Invoices
        $this->db->select('max(CAST(SUBSTRING_INDEX(creditnote_discount_no,"-",-1) as UNSIGNED)) as max');
        $res = $this->db->get('tbl_creditnote_discounts')->row_array();
        $max_number = $res['max'];

        if ($creditnote_type == 'VOLUME') {

            if (empty($volume_rows)) {
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }
            $next_number = $max_number + 1;
            $records[] = array(
                "creditnote_discount_no" => "CND-HYD-" . $next_number,
                "vendor_id" => $data['vendor_id'],
                "cn_date" => $data['cn_date'],
                "creditnote_type" => $creditnote_type,
                "status" => "FINANCE_PENDING",
                "category" => $volume_rows['category'],
                "from_date" => $volume_rows['from_date'],
                "to_date" => $volume_rows['to_date'],
                "tax_type" => $volume_rows['tax_type'],
                "discount_value" => $volume_rows['discount_value'],
                "discount_type" => $volume_rows['discount_type'],
                "discount_tax" => $volume_rows['discount_tax'],
                "total_quantity" => $volume_rows['total_quantity'],
                "sale_amount" => $volume_rows['total_amount'],
                "net_discount_amount" => $volume_rows['net_discount_amount'],
                "total_discount" => $volume_rows['total_discount_amount'],
                "created_by" => $this->session->userdata('user_id'),
            );
        }

        if ($creditnote_type == 'OTHER') {
            if (empty($other_rows)) {
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            foreach ($other_rows as $rowValue) {
                $next_number = $max_number + 1;
                $records[] = array(
                    "vendor_id" => $data['vendor_id'],
                    "creditnote_discount_no" => "CND-HYD-" . $next_number,
                    "creditnote_type" => $creditnote_type,
                    "cn_date" => $data['cn_date'],
                    "invoice_id" => $rowValue['invoice_id'],
                    "status" => "FINANCE_PENDING",
                    "tax_type" => $rowValue['tax_type'],
                    "purpose" => $rowValue['purpose'],
                    "category" => $rowValue['category'],
                    "discount_value" => $rowValue['discount_value'],
                    "discount_type" => $rowValue['discount_type'],
                    "discount_tax" => $rowValue['discount_tax'],
                    "net_discount_amount" => $rowValue['net_discount_amount'],
                    "total_discount" => $rowValue['total_discount_amount'],
                    "created_by" => $this->session->userdata('user_id'),
                );
            }
        }

        if (empty($records)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->insert_batch('tbl_creditnote_discounts', $records);

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getCreditnoteList()
    {
        $status = $this->input->get('status');
        $records = array();

        if (empty($status)) {
            $status = 'FINANCE_PENDING';
        }

        $result = $this->db->where('status', $status)->get('CREDITNOTE_DISCOUNT_VIEW')->result_array();

        foreach ($result as $rowValue) {

            $records[] = array(
                "creditnote_discounts_id" => $rowValue['creditnote_discounts_id'],
                "creditnote_discount_no" => $rowValue['creditnote_discount_no'],
                "status" => $rowValue['status'],
                "vendor_id" => $rowValue['vendor_id'],
                "invoice_id" => $rowValue['invoice_id'],
                "from_date" => $rowValue['from_date'],
                "to_date" => $rowValue['to_date'],
                "cn_date" => $rowValue['cn_date'],
                "purpose" => $rowValue['purpose'],
                "category" => $rowValue['category'],
                "creditnote_type" => $rowValue['creditnote_type'],
                "tax_type" => $rowValue['tax_type'],
                "discount_value" => $rowValue['discount_value'],
                "discount_type" => $rowValue['discount_type'],
                "discount_tax" => $rowValue['discount_tax'],
                "net_discount_amount" => $rowValue['net_discount_amount'],
                "total_discount" => $rowValue['total_discount'],
                "vendor_name" => $rowValue['vendor_name'],
                "invoice_code" => $rowValue['invoice_code'],
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
                "created_by" => $rowValue['created_by'],
                "last_updated_by" => $rowValue['last_updated_by'],
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function updateCreditnoteForm($creditnote_discount_id = 0)
    {
        if ((int) $creditnote_discount_id > 0) {
            $data['active'] = 3;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = "UPDATE CREDIT NOTE";

        $data['subview'] = $this->load->view('admin/discounts/manage_discounts', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    // public function getCreditNoteCategory(){

    //     $vendor_id = $this->input->get('vendor_id');

    //     if(empty($vendor_id) || (int)$vendor_id <=0){
    //         $json['status'] = 0;
    //         echo json_encode($json);
    //         exit;
    //     }

    //     $this->db->select('tbl_invoice_item.category','tbl_salesreturn.quantity')->from("tbl_invoice_item");
    //     $this->db->join('tbl_invoice', 'tbl_invoice.invoice_id = tbl_invoice_item.invoice_id');
    //     $this->db->join('tbl_salesreturn', 'tbl_invoice.invoice_id = tbl_salesreturn.invoice_id');
    //     $result = $this->db->where('tbl_invoice.vendor_id', $vendor_id)->get()->result_array();

    //     $records = array();

    //     foreach($result as $rowValue){
    //         $records[] = array(
    //                     "category" => $rowValue['category'],
    //                     "quantity" => $rowValue['quantity']
    //                    );
    //     }

    //     $json['status'] = 1;
    //     $json['data'] = $records;
    //     echo json_encode($json);
    //     exit;
    // }


    public function getpdfDetails()
    {
        $discount_id = $this->input->get('discount_id');
        $records = array();

        if (empty($discount_id)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('creditnote_discounts_id', $discount_id)->get('CREDITNOTE_PDF_DISCOUNT_VIEW')->result_array();

        foreach ($result as $rowValue) {

            $records = array(
                "creditnote_discount_id" => $rowValue['creditnote_discount_id'],
                "creditnote_discount_no" => $rowValue['creditnote_discount_no'],
                "creditnote_type" => $rowValue['creditnote_type'],
                "status" => $rowValue['status'],
                "vendor_id" => $rowValue['vendor_id'],
                "cn_date" => $rowValue['cn_date'],
                "invoice_id" => $rowValue['invoice_id'],
                "from_date" => date("d-m-Y", strtotime($rowValue['from_date'])),
                "to_date" => date("d-m-Y", strtotime($rowValue['to_date'])),
                "purpose" => $rowValue['purpose'],
                "category" => $rowValue['category'],
                "creditnote_type" => $rowValue['creditnote_type'],
                "tax_type" => $rowValue['tax_type'],
                "discount_value" => $rowValue['discount_value'],
                "discount_type" => $rowValue['discount_type'],
                "discount_tax" => $rowValue['discount_tax'],
                "net_discount_amount" => $rowValue['net_discount_amount'],
                "total_discount" => round($rowValue['total_discount']),
                "vendor_name" => $rowValue['vendor_name'],
                "invoice_code" => $rowValue['invoice_code'],
                "vendor_address" => $rowValue['address'],
                "city" => $rowValue['city'],
                "pincode" => $rowValue['pincode'],
                "vendor_gstin" => $rowValue['gstin'],
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
                "created_by" => $rowValue['created_by'],
                "last_updated_by" => $rowValue['last_updated_by'],
            );

            $state = $this->db->where('state_id', $rowValue['state'])->get('tbl_states')->row();
            $records['state_name'] = $state->name;
            $records['state_gst_id'] = $state->state_gst_id;

            $openbox_arr = OPENBOX_CATEGORY;
            $new_arr = NEW_CATEGORY;
            if(in_array($rowValue['category'], $new_arr)){
                $records['product_name'] = 'New Smartphones';
            }
            else if (in_array($rowValue['category'], $openbox_arr)) {
                $records['product_name'] = 'Open Box Smartphones';
            } else {
                $records['product_name'] = 'Pre-owned Smartphones';
            }

            if ($rowValue['tax_type'] == 'NO TAX') {
                $records['tax_rate'] = 0;
            } else {
                $records['tax_rate'] = 18;
            }
            $records['amount_in_words'] = $this->getIndianCurrency(round($rowValue['total_discount']));

            if($state->state_gst_id != 36){
                $records['gst_type'] = 'IGST';
            }else{
                $records['gst_type'] = 'CGST/SGST';
            }

        }
        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    function getIndianCurrency(float $number)
    {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(
            0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
        );
        $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str[] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ? 'Rupees ' . $Rupees : '') . $paise . 'Only';
    }
}
