<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Device extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		$this->load->model('Stamphistory_model');
		$this->load->model('Device_model');
		
		/*load model*/
    }

    public function manage_device($id = NULL,$activeId=NULL)
    {  
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		
		$data['productInfo']='';
		if($id>0)
		{
			$data['productInfo']=$this->db->where('product_id',$id)->get('tbl_product_details')->row();
		} 
				
		$data['device_type']=$this->db->where('status','1')->order_by('name','asc')->get('tbl_device_type')->result();
		$data['device_brand']=$this->db->where('status','1')->order_by('name','asc')->get('tbl_device_brand')->result();
		$data['result']=$this->db->order_by('product_id','desc')->get('tbl_product_details')->result();
        $data['title'] = lang('manage_device'); //Page title
 
        $data['page'] = lang('device');
 
        $data['subview'] = $this->load->view('admin/device/manage_device', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }
	
	
	public function deviceTypeList()
	{
		$data['active'] = 1;
		$data['device_type']=$this->db->where('status','1')->order_by('name','asc')->get('tbl_device_type')->result();
		$data['page'] = lang('device');
		$data['title'] = "Device Type List"; //Page title
		$data['subview'] = $this->load->view('admin/device/type_list', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function deviceBrandList()
	{
		$data['active'] = 1;
		$data['device_brand']=$this->db->where('status','1')->order_by('name','asc')->get('tbl_device_brand')->result();
		$data['page'] = lang('device');
		$data['title'] = "Device Brand List"; //Page title
		$data['subview'] = $this->load->view('admin/device/brand_list', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function getNhmodCode()
	{
		
		 $type=$_POST['type'];
		 
		 $brand=$_POST['brand'];
		 $accessories_id=$_POST['accessories_id'];
		  
		 /*==GET Brand Code==*/
		$brandCode='';
		 
		$brandResult=$this->db->select('code')->where('brand_id',$brand)->get('tbl_device_brand')->row();
       
		if(!empty($brandResult))
		{
			$brandCode=$brandResult->code; 
		}
		 
		 /*==GET sequence Code==*/
		
		$sequenceCode='';

		$sequenceResult=$this->Common_model->getRowResult('value','tbl_config',array('config_key'=>'devicetype_sequence'));

		if(!empty($sequenceResult))
		{
			$sequenceCode=str_pad((int) $sequenceResult['value'], 4, "0", STR_PAD_LEFT);
		}
		 
		 /*==GET Accessories  Code==*/
		
		  $code='';
		  
		  $accessoriesResult=$this->db->select('code')->where('accessories_id',$accessories_id)->get('tbl_device_accessories')->row(); 
		  
		  if(!empty($accessoriesResult))
		 {
			$code=$accessoriesResult->code;
		 }
		 
		
		  /*==Create NHMOD Code==*/
		  
		  $nhmod=$brandCode.$code.$sequenceCode;
 
	
	/*==GET Product Result==*/	
		  
		 
		  $productResult=$this->db->select('COUNT(product_id) as product_total')->where('nhmod',$nhmod)->get('tbl_product_details')->row();   
		  $total_product=$productResult->product_total;
	     // print $this->db->last_query(); exit;		  
		  if($total_product=='0')
		  {
			  $data=$nhmod;
		  }
		  else
		  {
			  $data="-";
		  }
		  
		  echo $data;
		  
		  die;
	}
	
	public function create_device($id = NULL)
    {
		$data=$this->input->post();  
		
		if(!empty($data))
		{			
			if($id!='')
			{				 
				// check model name
				
				$modelResult=$this->Common_model->getRowResult('product_id','tbl_product_details',array('model'=>$data['model'],'brand_id'=>$data['brand_id'],'product_id !='=>$id));
				
				
				if(empty($modelResult))
				{
					$this->db->where('product_id',$id)->update('tbl_product_details',array('model'=>$data['model'],'product_name'=>$data['brand_name']." ".$data['model']));							
					$type="success";				
					$msg="MODEL NAME UPDATED SUCCESSFULLY."; 
				} 
				else
				{
					$type="error";				
					$msg="THIS MODEL NAME ALREADY EXIST."; 
				}					
				
			}
			else
			{
				// check model name
				
				$modelResult=$this->Common_model->getRowResult('product_id','tbl_product_details',array('model'=>$data['model'],'brand_id'=>$data['brand_id']));
				
				if(empty($modelResult))
				{
					/*==GET Brand Code==*/
		
						$brandName='';
						 
						$brandResult=$this->db->select('name')->where('brand_id',$data['brand_id'])->get('tbl_device_brand')->row();
						 
						if(!empty($brandResult))
						{
							$brandName=$brandResult->name; 
						}
						 
						$data['product_name']=$brandName." ".$data['model'];
						
						/*==check product nhmod==*/
				
						$productResult=$this->db->select('COUNT(product_id) as product_total')->where('nhmod',$data['nhmod'])->get('tbl_product_details')->row();
				
						$product_total=$productResult->product_total;
				
						if($product_total==0)
						{  
					 
							$this->db->insert('tbl_product_details',$data);
 
							$insert_id = $this->db->insert_id();
							
							/*==UPDATE KMOD SEQUENCE==*/			
							
							$database=$this->load->database('default',TRUE); 
					  
							$database->query("UPDATE tbl_config SET value = value + 1 WHERE config_key='devicetype_sequence'");

							$database->close();

							/*===set message==*/ 
							
							$type="success";   
							$msg="PRODUCT CREATED SUCCESSFULLY"; 
						}
						else
						{
							$type="error"; 							
							$msg=$data['nhmod']." Already Exists!"; 
						}
				}
				else
				{
					$type="error";				
					$msg="THIS MODEL NAME ALREADY EXIST."; 
				}
			}
		}
		else
		{
			$type="error";			
			$msg="SOME ERROR FOUND.PLEASE CHECK."; 
		}
 
		$this->session->set_userdata($type,$msg); 
				
		header("location:".$_SERVER['HTTP_REFERER']); 
		
		die;	
	}
	
	 
	public function depleteProduct($id)
	{
		 $productResult=$this->db->where('product_id',$id)->get('tbl_product_details')->row();
		 
		$module="Item Master";
		$activity="activity_a_delete_device";
		$msg=$productResult->product_name. " Device deleted successfully";
		$this->Common_model->insertActivities($module,$id,$activity,$msg);
		
		$this->db->where('product_id',$id)->delete('tbl_product_details');
		 
		 set_message('success', $msg);
		 redirect($_SERVER['HTTP_REFERER']);
	}
	 
	public function depleteBrand($id)
	{
		 
		$brandResult=$this->db->where('brand_id',$id)->get('tbl_device_brand')->row();
  
		$module="Item Master";
		$activity="activity_a_delete_device_brand";
		$msg=$brandResult->name. " Device Brand deleted successfully";
		$this->Common_model->insertActivities($module,$id,$activity,$msg);
		
		$this->db->where('brand_id',$id)->delete('tbl_device_brand');
		 
		set_message('success', $msg);
		redirect($_SERVER['HTTP_REFERER']);
	}
	
	
	public function deleteDeviceType($id)
	{
		 
		$typeResult=$this->db->where('type_id',$id)->get('tbl_device_type')->row();		 
		$module="Item Master";
		$activity="activity_a_delete_device_type";
		$msg=$typeResult->name. " Device Type deleted successfully";
		$this->Common_model->insertActivities($module,$id,$activity,$msg);
		
		$this->db->where('type_id',$id)->delete('tbl_device_type');
		 
		 set_message('success', $msg);
		 redirect($_SERVER['HTTP_REFERER']);
	}
	 
	public function AdddeviceBrandEnd()
	{
		 $name=$_POST['name'];  
		 
		 $checkBrandName=$this->db->where('name',$name)->get('tbl_device_brand')->result(); 

        if (!empty($checkBrandName)) // if input data already exist show error alert
		{ 
            echo 2; die;
        }
		else 
		{
			$code=strtoupper(substr($name,0,3));
			
			$this->db->insert('tbl_device_brand',array('name'=>$name,'code'=>$code));
			
			$insert_id = $this->db->insert_id();
						
			/*==InsertActivities==*/
			
			$module="Item Master";
			$activity="activity_added_a_new_device_brandname";
			$msg=$name. " Device Brand added successfully";
			$this->Common_model->insertActivities($module,$insert_id,$activity,$msg);
			
			/*==get brand Result==*/
			$brandResult = $this->db->order_by('name','ASC')->get('tbl_device_brand')->result();
			$option="";
			if(!empty($brandResult)){
				foreach($brandResult as $brandResultKey=>$brandResultValue){
					$option.='<option value="'.$brandResultValue->brand_id.'">'.ucfirst($brandResultValue->name).'</option>';
				}
			}
			echo $option;die;
		}
		 echo 1;die;
	}
	
	public function AdddeviceTypeEnd()
	{
		 $name=$_POST['name']; 
		 
		 $checkTypeName=$this->db->where('name',$name)->get('tbl_device_type')->result();

        if (!empty($checkTypeName)) // if input data already exist show error alert
		{ 
            echo 2;die;
        } 
		else 
		{
			$this->db->insert('tbl_device_type',array('name'=>$name));
			$insert_id = $this->db->insert_id();
			
			
			/*==InsertActivities==*/
			
			$module="Item Master";
			$activity="activity_added_a_new_device_typename";
			$msg=$name. " Device Type added successfully";
			$this->Common_model->insertActivities($module,$insert_id,$activity,$msg);
			
			/*==get Type Result==*/
			$typeResult = $this->db->order_by('name','ASC')->get('tbl_device_type')->result();
			$option="";
			if(!empty($typeResult)){
				foreach($typeResult as $typeResultKey=>$typeResultValue){
					$option.='<option value="'.$typeResultValue->type_id.'">'.ucfirst($typeResultValue->name).'</option>';
				}
			}
			echo $option;die;
		}
		 echo 1;die;
	}
	
	
	public function device_history($id = NULL,$activeId=NULL)
	{
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 2;
            }
        } else {
            $data['active'] = 1;
        } 
 	
        $data['title'] = lang('device_history'); //Page title 
		
		$data['history_result']='';
		
		if(isset($_GET['nhdin']))
		{
			$data['history_result']=$this->Stamphistory_model->getRelatedNhdinHistory($_GET['nhdin']);
		}
				
		$data['bulkstatus'] = $this->db->order_by('bulkstatus_id')->get('tbl_bulkstatus')->result();
		
        $data['subview'] = $this->load->view('admin/device/manage_device_history', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
 
 
	//accessories work
	
	function AddAccessoriesNameEnd()
	{
		if($this->input->server('REQUEST_METHOD') == 'POST')
		{ 
			$this->form_validation->set_rules('name', 'Accessories Name', 'trim|required|is_unique[tbl_device_accessories.name]',array('required' => 'You have not provided %s.', 'is_unique' => 'This %s already exists.'));
			
			if ($this->form_validation->run() == FALSE)
            {
               $json['error']='1';
			  $json['msg']=validation_errors();
            }
            else
            {
				$code = strtoupper(substr($this->input->post('name'), 0, 2));
				
				$this->db->insert('tbl_device_accessories',array('name'=>$this->input->post('name'),'code'=>$code));
				$id=$this->db->insert_id();
				
				if($id>0)
				{
					$json['error']='0';
					
					$accessoriesresult = $this->db->order_by('name','ASC')->get('tbl_device_accessories')->result_array();
					
					$option="";
					if(!empty($accessoriesresult))
					{
						foreach($accessoriesresult as $accessoriesresultValue)
						{
							$option.='<option value="'.$accessoriesreaccessoriesresultValuesultValue['accessories_id'].'">'.ucfirst($accessoriesresultValue['name']).'</option>';
						}
					}
					
					$json['option']=$option;
					$json['msg']="Accessories Name Added Successfully";
					
				}
				else
				{
					$json['error']='1';
					$json['msg']='Something went wrong.Please try Again.';
				} 
	 
			}
		}
		else
		{
			$json['error']='1';
			$json['msg']='Something went wrong.Please try Again';
		}
		
		echo json_encode($json);
		die;
	}
	
	public function getDeviceInfo() {
        $deviceid = $_GET['deviceid'];
		$result  = $this->Device_model->getDeviceInfo($deviceid);
		
		$department_id = $this->session->userdata('department_id');
		$user_id = $this->session->userdata('user_id');
		$departmentId_arr = array(2,8,6,12,16);
		if (!in_array($department_id, $departmentId_arr)){
		    unset($result->PROC_COST);
		} else if($user_id == 68 || $user_id == 42){
			unset($result->PROC_COST);
		}
        if(!empty($result)){
            $json = $result;
		} else{
			http_response_code(500);
			$json['status']='Device not found';
		}   
		
		echo json_encode($json);
		die;
	}
	
	public function Devicedetails() {
		$deviceid = $_GET['deviceid'];
		$result =$this->db->where('nhdin',$deviceid)->order_by('creation_date','desc')->get('DEVICE_DETAILS_VIEW')->result_array();
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;
	}
	
	public function getGroupBySKU() {
        $input = file_get_contents("php://input");
		$request = json_decode($input,false);
		
		$this->db->select('grnreport_id, nhdin,product_brand,device_name,SKU,stock_type,saletype,status,certification_grade, device_sub_category, mrp, device_condition');
		$this->db->where_in('nhdin', $request);
		$this->db->group_by('nhdin,status,SKU,stock_type,certification_grade');
		$this->db->order_by('device_name asc');
		$result  = $this->db->get('tbl_grnreport')->result_array();
        
		if(!empty($result)){
            $json['data'] = $result;
		} else{
			
			$json['status'] = 0;
			$json['msg']='Device not found';
			http_response_code(500);
		}   
		
		echo json_encode($json);
		die;
    }

	public function getGroupBySKU_bulktrace() {
        $input = file_get_contents("php://input");
		$request = json_decode($input,false);
		$nhdin_arr = [];
		$imei_arr = [];
		$othervendor_id = [];

		foreach($request as $key => $value){
			// if $value starts with TD and contains 11 digits after td
			if(preg_match('/^TD[0-9]{11}$/', strtoupper($value))){
				$nhdin_arr[] = $value;
			}else if (preg_match('/^[0-9]{15}$/', strtoupper($value))){
				$imei_arr[] = $value;
			}else{
				$othervendor_id[] = $value;
			}
		}
        
		if(!empty($nhdin_arr)){
			$this->db->where_in('nhdin', $nhdin_arr);
			$result1  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}

		if(!empty($imei_arr)){
			$this->db->where_in('imei1_no', $imei_arr)->or_where_in('imei2_no', $imei_arr);
			$result2  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}

		if(!empty($othervendor_id)){
			$this->db->where_in('othervendor_id', $othervendor_id);
			$result3  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}
		
		if(empty($result1)) $result1 = [];
		if(empty($result2)) $result2 = [];
		if(empty($result3)) $result3 = [];

		// merge all non empty result arrays
		$result = array_merge($result1, $result2, $result3);
		
		$department_id = $this->session->userdata('department_id');
		$user_id = $this->session->userdata('user_id');
		$departmentId_arr = array(2,8,6,12,16);
		foreach($result as $key => $val){
			$grnreport_id = $val['grnreport_id'];
			if($val['status'] == "SOLD"){
				$grnData = $this->db->select('DATE(grn_inwarddate) as inward_date, DATE(modify_time) as last_updated')->from('tbl_grnreport')->get()->row();
				$inward_time = strtotime($grnData->inward_date);
				$sold_time = strtotime($grnData->last_updated); 
				$datediff = $sold_time - $inward_time;
				$device_aging = round($datediff / (60 * 60 * 24));
			} else {
				$device_aging = $val['age'];
			}
			
			if (in_array($department_id, $departmentId_arr)){
				if($val['saletype'] == "AMAZON"){
					$tbl_name = "tbl_ecom_invoice_item";
					$order_by = "ecom_invoice_item_id";
				} else{
					$tbl_name = "tbl_invoice_item";
					$order_by = "invoice_item_id";
				}
				if($user_id != 68){
					if($val['status'] == "SOLD"){
						$sale_cost = $this->db->order_by($order_by, 'DESC')->get_where($tbl_name, array("grnreport_id" => $grnreport_id))->row()->price;
					} else {
						$sale_cost = "NA";
					}
					if($user_id == 42){
						$result[$key]['proc_cost'] = "NA";
					}
					
					$result[$key]['sale_cost'] = $sale_cost;
				} else{
					$result[$key]['sale_cost'] = "NA"; 
			   		$result[$key]['proc_cost'] = "NA";
				}
				
		  } else {
	   
	   			$result[$key]['sale_cost'] = "NA"; 
			   	$result[$key]['proc_cost'] = "NA";
			}
			unset($result[$key]['age']);
			$result[$key]['device_aging'] = $device_aging;  
		}
		if(!empty($result)){
            	$json = $result;
		} else{
			http_response_code(500);
			$json['status']='Device not found';
		}   
		
		echo json_encode($json);
		die;
    }

	public function getGroupBySKU_bulktraceWithoutSalePrice() {
        
        $input = file_get_contents("php://input");
		$request = json_decode($input,false);
		$nhdin_arr = [];
		$imei_arr = [];
		$othervendor_id = [];

		foreach($request as $key => $value){
			// if $value starts with TD and contains 11 digits after td
			if(preg_match('/^TD[0-9]{11}$/', strtoupper($value))){
				$nhdin_arr[] = $value;
			}else if (preg_match('/^[0-9]{15}$/', strtoupper($value))){
				$imei_arr[] = $value;
			}else{
				$othervendor_id[] = $value;
			}
		}
        
		if(!empty($nhdin_arr)){
			$this->db->where_in('nhdin', $nhdin_arr);
			$result1  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}

		if(!empty($imei_arr)){
			$this->db->where_in('imei1_no', $imei_arr)->or_where_in('imei2_no', $imei_arr);
			$result2  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}

		if(!empty($othervendor_id)){
			$this->db->where_in('othervendor_id', $othervendor_id);
			$result3  = $this->db->get('DEVICE_BULKTRACE_VIEW')->result_array();
		}
		
		if(empty($result1)) $result1 = [];
		if(empty($result2)) $result2 = [];
		if(empty($result3)) $result3 = [];

		// merge all non empty result arrays
		$result = array_merge($result1, $result2, $result3);
		
		$department_id = $this->session->userdata('department_id');
		$user_id = $this->session->userdata('user_id');
		$departmentId_arr = array(2,8,6,12,16);
		foreach($result as $key => $val){
			
			$device_aging = $val['age'];
			
		    	if (in_array($department_id, $departmentId_arr)){
				
				if($user_id == 42){
					$result[$key]['proc_cost'] = "NA";
				}
				  
			} else {
				$result[$key]['proc_cost'] = "NA";
			}
			$result[$key]['sale_cost'] = "NA";
			unset($result[$key]['age']);
			$result[$key]['device_aging'] = $device_aging;
		}	
		if(!empty($result)){
            	$json = $result;
		} else{
			http_response_code(500);
			$json['status']='Device not found';
		}   
		
		echo json_encode($json);
		die;
    }
	
	public function getDeviceLogInfo(){
		$deviceid = $_GET['deviceid'];
		$result =$this->db->where('device_id',$deviceid)->order_by('last_updated', 'Desc')->get('DEVICE_LOG_VIEW')->result_array();
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;
	}

	public function getGroupByBundle() {
        $input = file_get_contents("php://input");
		$request = json_decode($input,false);
		$bundleData = $this->db->where_in('bundle_no', $request)->get('tbl_dealer_bundle')->result();
		if(count($bundleData) <= 0){
		        $json['status'] = 0;
		        $json['msg']= 'No available data for Uploaded Bundles';
		        //http_response_code(500);
		        echo json_encode($json);
		        die;
		   }
		$total_amount = 0;
		$result = [];
		$bundle_ids = [];
		foreach($bundleData as $row){
		    $bundle_status = $row->status;
		    
		    if($bundle_status != "ACTIVE"){
		        $json['status'] = 0;
		        $json['msg']= $row->bundle_no.' is not in ACTIVE';
		        //http_response_code(500);
		        echo json_encode($json);
		        die;
		    }
		    $bundle_id = $row->bundle_id;
		    array_push($bundle_ids,$bundle_id);
		}
		//echo "<pre>"; print_r($bundleData); echo"</pre>"; exit;
		$this->db->select('grnreport_id, nhdin,product_brand,device_name,SKU,stock_type,saletype,status,certification_grade, device_sub_category,mrp');
		$this->db->where_in('bundle_id', $bundle_ids);
		$this->db->group_by('nhdin,status,SKU,stock_type,certification_grade');
		$this->db->order_by('device_name asc');
		$resultArr  = $this->db->get('tbl_grnreport')->result();
		
        foreach($resultArr as $value){
            
            $result[] = array(
                "grnreport_id" => $value->grnreport_id,
                "nhdin" => $value->nhdin,
                "product_brand" => $value->product_brand,
                "device_name" => $value->device_name,
                "SKU" => $value->SKU,
                "stock_type" => $value->stock_type,
                "saletype" => $value->saletype,
                "status" => $value->status,
                "certification_grade" => $value->certification_grade,
                "device_sub_category" => $value->device_sub_category,
                "mrp" => $value->mrp
                
                );
                $total_amount += $value->mrp;
        }
        
        $bundel_value = $total_amount;
        $bundle_quantity = count($result);
        $today_date = date('Y-m-d');
        
        
        $bundleDiscountData = $this->db->select('category,bundle_type,discount_criteria,discount_type,min_invoice_amount,min_quantity,discount_percent,discount_amount,maximum_discount_amount')
            ->from('tbl_dealerapp_discount_rules')
            ->where('bundle_type','ALL')
            ->where('status', 'ACTIVE')
            ->where('category', 'bundle')
            ->where("DATE(START_DATE) <=", $today_date)
            ->where("DATE(END_DATE) >=", $today_date)
            ->get()->row();
		//echo "<pre>"; print_r($bundleDiscountData); echo"</pre>"; exit;
		if(count($bundleDiscountData) > 0){ 
			$discountCriteria = $bundleDiscountData->discount_criteria;
			$bundle_quantity = count($result);
			if($discountCriteria == "quantity"){
				$where = array("min_quantity <= " => $bundle_quantity);
			} else{
				$where = array("min_invoice_amount <= " => $bundel_value);
			}
			$today_date = date('Y-m-d');
        	$discountData = $this->db->select('category,bundle_type,discount_criteria,discount_type,min_invoice_amount,min_quantity,discount_percent,discount_amount,maximum_discount_amount')
				->from('tbl_dealerapp_discount_rules')
				->where('bundle_type','ALL')
				->where('status', 'ACTIVE')
				->where('category', 'bundle')
				->where($where)
				->where("DATE(START_DATE) <=", $today_date)
				->where("DATE(END_DATE) >=", $today_date)
				->order_by('discount_rule_id','DESC')
				->limit(1)
				->get()->row();
			if(count($discountData) > 0){
    			//echo count($discountData); exit;
    			$dc_type = $discountData->discount_type;
                $bndlDiscount = 0;
                $discount_criteria = $discountData->discount_criteria;
                
                if($discount_criteria == "quantity"){
                        $discount_qnty = $discountData->min_quantity;
                        if($bundle_quantity >= $discount_qnty){
                          
                          if($dc_type == "amount"){
                    
                            $bndlDiscount += $discountData->discount_amount;
                            $value = $bndlDiscount;
                        } else{
                            $maxDcAmount =  $discountData->maximum_discount_amount;
                            $dcPercent = $discountData->discount_percent;
                            $actual_percent = (100 + $dcPercent);
                            $value = $dcPercent;
                            //$percentVal = ($total_amount * $dcPercent) / $actual_percent;
							$percentVal = ($total_amount * $dcPercent) / 100;
                             
                            if ($percentVal > $maxDcAmount && $maxDcAmount != 0) {
                                $bndlDiscount += $maxDcAmount;
                              } else {
                                $bndlDiscount += $percentVal;
                              }
                             
                            }  
                        }
                        
                        
                } elseif($discount_criteria == "value"){
                        $discount_amount = $discountData->min_invoice_amount;
                        if($bundle_amount >= $discount_amount){
                            if($dc_type == "amount"){
                    
                            $bndlDiscount += $discountData->discount_amount;
                            $value = $bndlDiscount;
                            } else{
                                $maxDcAmount =  $discountData->maximum_discount_amount;
                                $dcPercent = $discountData->discount_percent;
                                $actual_percent = (100 + $dcPercent);
                                $value = $dcPercent;
                                //$percentVal = ($total_amount * $dcPercent) / $actual_percent;
								$percentVal = ($total_amount * $dcPercent) / 100;
                                 
                                if ($percentVal > $maxDcAmount && $maxDcAmount != 0) {
                                    $bndlDiscount += $maxDcAmount;
                                  } else {
                                    $bndlDiscount += $percentVal;
                                  }
                            } 
                        }
                }
		    } else{
    		    $value = 0;
                $dc_type = "NULL";
		}
		} 
		else{
			$value = 0;
            $dc_type = "NULL";
		}
        
        if(!empty($result)){
            $json['data'] = $result;
            $json['discount_type'] = $dc_type;
            $json['value'] = $value;
		} else{
			http_response_code(500);
			$json['msg']='Device not found';
		}   
		
		echo json_encode($json);
		die;
    }


}
