<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/*
 * To change this license header,choose License Headers in Project Properties.
 * To change this template file,choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of admistrator
 *
 * @author pc mart ltd
 */
class Dashboard extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        // $this->load->model('admin_model');
        // $this->load->model('invoice_model');
        // $this->load->model('estimates_model'); 
        $this->load->model('Dashboard_model');   
    }
 
    public function index($action = NULL)
    {  
	
		// set session value for default location
		$this->session->set_userdata('locationValue','ALL');
		$this->session->set_userdata('userlocationValue','ALL');
		
		
        $data['title'] = config_item('company_name');
        $data['page'] = lang('dashboard');

        //total expense count
        $this->admin_model->_table_name = "tbl_transactions"; //table name
        $this->admin_model->_order_by = "transactions_id"; // order by 
        $total_income_expense = $this->admin_model->get(); // get result
        $today_income_expense = $this->admin_model->get_by(array('date' => date('Y-m-d'))); // get result

        $today_income = 0;
        $today_expense = 0;
        foreach ($today_income_expense as $t_income_expense) {
            if ($t_income_expense->type == 'Income') {
                $today_income += $t_income_expense->amount;

            } elseif ($t_income_expense->type == 'Expense') {
                $today_expense += $t_income_expense->amount;
            }
        }
        $data['today_income'] = $today_income;

        $data['today_expense'] = $today_expense;

        $total_income = 0;
        $total_expense = 0;
        foreach ($total_income_expense as $v_income_expense) {
            if ($v_income_expense->type == 'Income') {
                $total_income += $v_income_expense->amount;

            } elseif ($v_income_expense->type == 'Expense') {
                $total_expense += $v_income_expense->amount;
            }
        }
        $data['total_income'] = $total_income;

        $data['total_expense'] = $total_expense;

        $data['role'] = $this->session->userdata('user_type');

        $data['invoce_total'] = $this->invoice_totals_per_currency();
        if (!empty($action) && $action == 'payments') {
            $data['yearly'] = $this->input->post('yearly',TRUE);
        } else {
            $data['yearly'] = date('Y'); // get current year
        }
        if (!empty($action) && $action == 'Income') {
            $data['Income'] = $this->input->post('Income',TRUE);
        } else {
            $data['Income'] = date('Y'); // get current year
        }
        if ($this->input->post('year',TRUE)) { // if input year 
            $data['year'] = $this->input->post('year',TRUE);
        } else { // else current year
            $data['year'] = date('Y'); // get current year
        }
        // get all expense list by year and month
        $data['all_income'] = $this->get_transactions_list($data['Income'],'Income');

        $data['all_expense'] = $this->get_transactions_list($data['year'],'Expense');

        $data['yearly_overview'] = $this->get_yearly_overview($data['yearly']);

        if ($this->input->post('month',TRUE)) { // if input year 
            $data['month'] = $this->input->post('month',TRUE);
        } else { // else current year
            $data['month'] = date('Y-m'); // get current year
        }
        $data['income_expense'] = $this->get_income_expense($data['month']);

        // goal tracking
        if ($this->input->post('goal_month',TRUE)) { // if input year
            $data['goal_month'] = $this->input->post('goal_month',TRUE);
        } else { // else current year
            $data['goal_month'] = date('Y-m'); // get current year
        }
        $data['goal_report'] = $this->get_goal_report($data['goal_month']);

        if ($this->input->post('finance_overview',TRUE)) { // if input year
            $data['finance_year'] = $this->input->post('finance_overview',TRUE);
        } else { // else current year
            $data['finance_year'] = date('Y'); // get current year
        }
        // get all income/expense list by year and month
        $data['finance_overview_by_year'] = $this->finance_overview_by_year($data['finance_year']);
        // get all income/expense and profit by year.
        // here true used for tracking it's annual
		
		$data['department_id']=$this->session->userdata('department_id');
		$data['total_annual'] = $this->finance_overview_by_year($data['finance_year'],true);
		//$this->load->view('admin/_layout_main',$data);
		$data['test']=$data;
		$data['subview'] = $this->load->view('admin/main_content',$data,true);
        $this->load->view('admin/_layout_main',$data);
    }

    public function finance_overview_by_year($year,$annual = null)
    {// this function is to create get monthy recap report
        $this->load->model('report_model');
        for ($i = 1; $i <= 12; $i++) { // query for months
            if ($i >= 1 && $i <= 9) { // if i<=9 concate with Mysql.becuase on Mysql query fast in two digit like 01.
                $start_date = $year . "-" . '0' . $i . '-' . '01';
				
				if($i==1 || $i==3 || $i==5 || $i==7 || $i==8){ //Months with 31 days
					$end_date = $year . "-" . '0' . $i . '-' . '31';
				}elseif($i==2){ //February
					if($year%4==0){ //Leap Year
						$end_date = $year . "-" . '0' . $i . '-' . '29';
					}else{
						$end_date = $year . "-" . '0' . $i . '-' . '28';
					}
				}else{	//Months with 30 days
					$end_date = $year . "-" . '0' . $i . '-' . '30';
				}
            } else {
				$start_date = $year . "-" . $i . '-' . '01';
				if($i==10 || $i==12)
					$end_date = $year . "-" . $i . '-' . '31';
				else
					$end_date = $year . "-" . $i . '-' . '30';
            }
            $finance_overview_list[$i] = $this->report_model->get_report_by_date($start_date,$end_date); // get all report by start date and in date
        }
        if (!empty($annual)) {
            $f_total_expense = 0;
            $f_total_income = 0;
            if (!empty($finance_overview_list)) {
                foreach ($finance_overview_list as $v_finance_overview) {
                    if (!empty($v_finance_overview)) {
                        foreach ($v_finance_overview as $finance_overview) {
                            if ($finance_overview->type == 'Income') {
                                $f_total_income += $finance_overview->amount;
                            }
                            if ($finance_overview->type == 'Expense') {
                                $f_total_expense += $finance_overview->amount;
                            }
                        }
                    }
                }
            }
            $tatal_annual = array(
                'total_income' => $f_total_income,
                'total_expense' => -$f_total_expense,
                'total_profit' => $f_total_income - $f_total_expense,
            );
            return $tatal_annual;
        }

        return $finance_overview_list; // return the result
    }

    public function get_goal_report($month)
    {// this function is to create get monthy recap report

        //m = date('m',strtotime($month));
        $m = date('m',strtotime($month));
        $year = date('Y',strtotime($month));
        $start_date = $year . "-" . $m . '-' . '01';
        $end_date = $year . "-" . $m . '-' . '31';

        $get_goal_report = $this->admin_model->get_goal_report_by_month($start_date,$end_date); // get all report by start date and in date

        return $get_goal_report; // return the result
    }

    function invoice_totals_per_currency()
    {
        $invoices_info = $this->db->where('inv_deleted','No')->get('tbl_invoices')->result();

        $paid = $due = array();
        $currency = 'USD';
        $symbol = array();
        foreach ($invoices_info as $v_invoices) {
            if (!isset($paid[$v_invoices->currency])) {
                $paid[$v_invoices->currency] = 0;
            }
            if (!isset($due[$v_invoices->currency])) {
                $due[$v_invoices->currency] = 0;
            }
            $paid[$v_invoices->currency] += $this->invoice_model->get_invoice_paid_amount($v_invoices->invoices_id);
            $due[$v_invoices->currency] += $this->invoice_model->get_invoice_due_amount($v_invoices->invoices_id);
            $currency = $this->admin_model->check_by(array('code' => $v_invoices->currency),'tbl_currencies');
            $symbol[$v_invoices->currency] = $currency->symbol;
        }

        return array("paid" => $paid,"due" => $due,"symbol" => $symbol);
    }

    public function get_yearly_overview($year)
    {// this function is to create get monthy recap report
        for ($i = 1; $i <= 12; $i++) { // query for months
            if ($i >= 1 && $i <= 9) { // if i<=9 concate with Mysql.becuase on Mysql query fast in two digit like 01.
                $month = '0' . $i;
            } else {
                $month = $i;
            }
            $yearly_report[$i] = $this->admin_model->calculate_amount($year,$month); // get all report by start date and in date 
        }
        return $yearly_report; // return the result
    }

    public function get_income_expense($month)
    {// this function is to create get monthy recap report
        //m = date('m',strtotime($month));
        $m = date('m',strtotime($month));
        $year = date('Y',strtotime($month));
        /* if ($m >= 1 && $m <= 9) { // if i<=9 concate with Mysql.becuase on Mysql query fast in two digit like 01.
            $start_date = $year . "-" . '0' . $m . '-' . '01';
            $end_date = $year . "-" . '0' . $m . '-' . '20';
        } else {
            $start_date = $year . "-" . $m . '-' . '01';
            $end_date = $year . "-" . $m . '-' . '31';
        } */
		
		$start_date = $year . "-" . '0' . $i . '-' . '01';
		
		if($m==1 || $m==3 || $m==5 || $m==7 || $m==8 || $i==10 || $i==12){ //Months with 31 days
			$end_date = $year . "-" .sprintf('%02d',$m) . '-' . '31';
		}elseif($m==2){ //February
			if($year%4==0){ //Leap Year
				$end_date = $year . "-" .sprintf('%02d',$m). '-' . '29';
			}else{
				$end_date = $year . "-" .sprintf('%02d',$m). '-' . '28';
			}
		}else{	//Months with 30 days
			$end_date = $year . "-" . sprintf('%02d',$m). '-' . '30';
		}
            
			
        $get_expense_list = $this->admin_model->get_transactions_list_by_month($start_date,$end_date); // get all report by start date and in date 

        return $get_expense_list; // return the result
    }

    public function get_transactions_list($year,$type)
    {// this function is to create get monthy recap report
        for ($i = 1; $i <= 12; $i++) { // query for months
            if ($i >= 1 && $i <= 9) { // if i<=9 concate with Mysql.becuase on Mysql query fast in two digit like 01.
                $start_date = $year . "-" . '0' . $i . '-' . '01';
				
				if($i==1 || $i==3 || $i==5 || $i==7 || $i==8){ //Months with 31 days
					$end_date = $year . "-" . '0' . $i . '-' . '31';
				}elseif($i==2){ //February
					if($year%4==0){ //Leap Year
						$end_date = $year . "-" . '0' . $i . '-' . '29';
					}else{
						$end_date = $year . "-" . '0' . $i . '-' . '28';
					}
				}else{	//Months with 30 days
					$end_date = $year . "-" . '0' . $i . '-' . '30';
				}
            } else {
				$start_date = $year . "-" . $i . '-' . '01';
				if($i==10 || $i==12)
					$end_date = $year . "-" . $i . '-' . '31';
				else
					$end_date = $year . "-" . $i . '-' . '30';
            }
            $get_expense_list[$i] = $this->admin_model->get_transactions_list_by_date($type,$start_date,$end_date); // get all report by start date and in date
        }
        return $get_expense_list; // return the result
    }

    public function set_language($lang)
    {
        $this->session->set_userdata('lang',$lang);
        redirect($_SERVER["HTTP_REFERER"]);
    }

    public function set_clocking($id = NULL,$user_id = null,$row = null,$redirect = null)
    {

        if ($id == 0) {
            $id = null;
        }
        if ($row == 0) {
            $row = null;
        }
        // sate into attendance table
        if (!empty($user_id)) {
            $adata['user_id'] = $user_id;
        } else {
            $adata['user_id'] = $this->session->userdata('user_id');
        }

        if (!empty($row)) {
            $clocktime = 1;
        } else {
            $clocktime = $this->input->post('clocktime',TRUE);
        }

        $date = $this->input->post('clock_date',TRUE);
        $clock_date = date('Y',strtotime($date));
        if (empty($date)) {
            $date = date('Y-m-d');
        } elseif ($clock_date >= 1969 && $clock_date <= 1999) {
            $date = date('Y-m-d');
        }
        $time = $this->input->post('clock_time',TRUE);
        if (empty($time)) {
            $time = date('h:i:s');;
        }
//        $already_clocking = $this->admin_model->check_by(array('user_id' => $adata['user_id'],'clocking_status' => 1),'tbl_attendance');
        if ($clocktime == 1) {
            $adata['date_in'] = $date;
        } else {
            $adata['date_out'] = $date;
        }

        if (!empty($adata['date_in'])) {
            // check existing date is here or not
            $check_date = $this->admin_model->check_by(array('user_id' => $adata['user_id'],'date_in' => $adata['date_in']),'tbl_attendance');
        }
        if (!empty($check_date)) { // if exis do not save date and return id
            $this->admin_model->_table_name = "tbl_attendance"; // table name
            $this->admin_model->_primary_key = "attendance_id"; // $id

            if ($check_date->attendance_status != '1') {
                $udata['attendance_status'] = 1;
                $this->admin_model->save($udata,$check_date->attendance_id);
            }
            if ($check_date->clocking_status == 0) {
                $udata['date_out'] = $date;
                $udata['clocking_status'] = 1;
                $this->admin_model->save($udata,$check_date->attendance_id);
            }
            $data['attendance_id'] = $check_date->attendance_id;
        } else { // else save data into tbl attendance
            // get attendance id by clock id into tbl clock
            // if attendance id exist that means he/she clock in
            // return the id
            // and update the day out time

            $check_existing_data = $this->admin_model->check_by(array('clock_id' => $id),'tbl_clock');
            $this->admin_model->_table_name = "tbl_attendance"; // table name
            $this->admin_model->_primary_key = "attendance_id"; // $id
            if (!empty($check_existing_data)) {
                $adata['clocking_status'] = 0;
                $this->admin_model->save($adata,$check_existing_data->attendance_id);
            } else {
                $adata['attendance_status'] = 1;
                $adata['clocking_status'] = 1;
                //save data into attendance table
                $data['attendance_id'] = $this->admin_model->save($adata);
            }
        }
        // save data into clock table
        if ($clocktime == 1) {
            $data['clockin_time'] = $time;
        } else {
            $data['clockout_time'] = $time;
            $data['comments'] = $this->input->post('comments',TRUE);
        }
        $data['ip_address'] = $this->input->ip_address();
        //save data in database
        $this->admin_model->_table_name = "tbl_clock"; // table name
        $this->admin_model->_primary_key = "clock_id"; // $id
        if (!empty($id)) {
            $data['clocking_status'] = 0;
            $this->admin_model->save($data,$id);
        } else {
            $data['clocking_status'] = 1;
            $id = $this->admin_model->save($data);
            if (!empty($check_date)) {
                if ($check_date->clocking_status == 1) {
                    $data['clockout_time'] = $time;
                    $data['clocking_status'] = 0;
                    $this->admin_model->save($data,$id);
                }
            }
        }
        if (empty($redirect)) {
            redirect($_SERVER["HTTP_REFERER"]);
        } else {
            return true;
        }
    }

    public function update_clock()
    {
        $clock_in = $this->input->post('clock_in',true);
        $clock_out = $this->input->post('clock_out',true);
        if (!empty($clock_in)) {
            foreach ($clock_in as $user_id) {
                $this->set_clocking(0,$user_id,true,true);
            }
        }
        if (!empty($clock_out)) {
            foreach ($clock_out as $clock_out_id) {
                $clock_id = $this->input->post($clock_out_id,true);
                $this->set_clocking($clock_id,$clock_out_id,0,true);
            }
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    public
    function mark_attendance()
    {
        $this->load->model('global_model');
        $this->load->model('attendance_model');

        $data['title'] = lang('mark_attendance');
        $date = $this->input->post('attend_date',TRUE);

        if (empty($date)) {
            $date = date('Y-m-d');
        }
        $data['date'] = $date;

        $month = date('n',strtotime($date));
        $year = date('Y',strtotime($date));
        $day = date('d',strtotime($date));

        $data['users'] = get_staff_details();

        $holidays = $this->global_model->get_holidays(); //tbl working Days Holiday

        if ($month >= 1 && $month <= 9) {
            $yymm = $year . '-' . '0' . $month;
        } else {
            $yymm = $year . '-' . $month;
        }

        $public_holiday = $this->global_model->get_public_holidays($yymm);

        //tbl a_calendar Days Holiday
        if (!empty($public_holiday)) {
            foreach ($public_holiday as $p_holiday) {
                $p_hday = $this->global_model->GetDays($p_holiday->start_date,$p_holiday->end_date);
            }
        }
        foreach ($data['users'] as $sl => $v_employee) {
            if ($v_employee->user_id != $this->session->userdata('user_id')) {
                $x = 1;
                if ($day >= 1 && $day <= 9) {
                    $sdate = $yymm . '-' . '0' . $day;
                } else {
                    $sdate = $yymm . '-' . $day;
                }
                $day_name = date('l',strtotime("+$x days",strtotime($year . '-' . $month . '-' . $day)));

                // get leave info

                if (!empty($holidays)) {
                    foreach ($holidays as $v_holiday) {
                        if ($v_holiday->day == $day_name) {
                            $flag = 'H';
                        }
                    }
                }
                if (!empty($p_hday)) {
                    foreach ($p_hday as $v_hday) {
                        if ($v_hday == $sdate) {
                            $flag = 'H';
                        }
                    }
                }
                if (!empty($flag)) {
                    $data['attendace_info'][$sl] = $this->attendance_model->attendance_report_by_empid($v_employee->user_id,$sdate,$flag);
                } else {
                    $data['attendace_info'][$sl] = $this->attendance_model->attendance_report_by_empid($v_employee->user_id,$sdate);
                }
                $flag = '';
            }
        }
        $data['subview'] = $this->load->view('admin/settings/mark_attendance',$data,TRUE);
        $this->load->view('admin/_layout_main',$data); //page load
    }

    public function change_report($status,$type = null)
    {
        if (!empty($type)) {
            if ($status == 'show') {
                $input_data[$type . '_state'] = 'block';
            } else {
                $input_data[$type . '_state'] = 'none';
            }
        } else {
            if ($status == 'show') {
                $input_data['invoice_state'] = 'block';
            } else {
                $input_data['invoice_state'] = 'none';
            }
        }
        foreach ($input_data as $key => $value) {
            $data = array('value' => $value);
            $this->db->where('config_key',$key)->update('tbl_config',$data);
            $exists = $this->db->where('config_key',$key)->get('tbl_config');
            if ($exists->num_rows() == 0) {
                $this->db->insert('tbl_config',array("config_key" => $key,"value" => $value));
            }
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    public function new_todo($id = null)
    {
        $data['title'] = lang('new') . ' ' . lang('to_do');
        if (!empty($id)) {
            $data['todo_info'] = $this->db->where('todo_id',$id)->get('tbl_todo')->row();;
        }
        $data['modal_subview'] = $this->load->view('admin/settings/new_todo',$data,FALSE);
        $this->load->view('admin/_layout_modal_lg',$data); //page load
    }

    public function save_todo($id = null)
    {
        $data = $this->admin_model->array_from_post(array('user_id','title','status','due_date'));
        if (!empty($data['user_id']) && $data['user_id'] != $this->session->userdata('user_id')) {
            $data['assigned'] = $this->session->userdata('user_id');
        } else {
            $data['assigned'] = 0;
        }
        if (empty($data['user_id'])) {
            $data['user_id'] = $this->session->userdata('user_id');
        }
        if (empty($id)) {
            $data['order'] = 1;
        }
        $this->admin_model->_table_name = "tbl_todo"; // table name
        $this->admin_model->_primary_key = "todo_id"; // $id
        $this->admin_model->save($data,$id);
        $type = "success";
        $message = lang('todo_information_updated');
        set_message($type,$message);
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function delete_todo($todo_id = '')
    {
        $this->db->where('todo_id',$todo_id);
        $this->db->delete('tbl_todo');
        $type = "success";
        $message = lang('todo_information_deleted');
        set_message($type,$message);
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function completed_todo($todo_id = '')
    {
        $data['status'] = $this->input->post('status',true);
        $this->db->where('todo_id',$todo_id);
        $this->db->update('tbl_todo',$data);
        $type = "success";
        $message = lang('todo_status_change');
        echo json_encode(array("status" => $type,"message" => $message));
    }

    public function change_todo_status($id = null,$status = null)
    {

        $_status = $this->input->post('status',true);
        if (!empty($_status)) {
            $todo_id = $this->input->post('todo_id',true);
            foreach ($todo_id as $key => $id) {
                $data['status'] = $_status;
                $data['order'] = $key + 1;
                //save data into table.
                $this->admin_model->_table_name = "tbl_todo"; // table name
                $this->admin_model->_primary_key = "todo_id"; // $id
                $this->admin_model->save($data,$id);
            }
            $post = true;

        } else {
            $data['status'] = $status;
            $todo_id = $id;

            $this->admin_model->_table_name = "tbl_todo"; // table name
            $this->admin_model->_primary_key = "todo_id"; // $id
            $this->admin_model->save($data,$todo_id);

        }
        if (!empty($post)) {
            $type = "success";
            $message = lang('todo_status_change');
            echo json_encode(array("status" => $type,"message" => $message));
        } else {
            redirect($_SERVER["HTTP_REFERER"]);
        }

    }

    public function all_todo($id = null)
    {
        $data['title'] = lang('all') . ' ' . lang('to_do') . ' ' . lang('list');
        $user_id = $this->input->post('user_id');
        if ($id == 'kanban') {
            $k_session['todo_kanban'] = $id;
            $this->session->set_userdata($k_session);
        } elseif ($id == 'list') {
            $data['active'] = 1;
            $this->session->unset_userdata('todo_kanban');
        }
        if (!empty($user_id)) {
            $data['user_id'] = $user_id;
            if ($user_id != $this->session->userdata('user_id')) {
                $data['where'] = array('assigned' => $this->session->userdata('user_id'));
            } else {
                $data['where'] = null;
            }

        } else {
            $data['user_id'] = $this->session->userdata('user_id');
            $data['where'] = null;
        }

        $data['subview'] = $this->load->view('admin/settings/all_todo',$data,TRUE);
        $this->load->view('admin/_layout_main',$data); //page load
    }
	
	public function setLocationValue($location)
	{
		$this->session->set_userdata('locationValue',$location);
		$this->session->set_userdata('userlocationValue',$location);
		$this->session->set_userdata('success','LOCATION HAS BEEN SET SUCCESSFULLY'); 
		redirect($_SERVER['HTTP_REFERER']);
	}
	
	
	/*==export file in csv format===*/
	

	public function exportCsvOfPurchaseReject()
	{
		 
		$csv_output="INWARDID,STATUS,INVOICE NO,REMARK,BIN NUMBER,WARHOUSE";
		
		$result=$this->db->select('nhdin,invoice_no,remark')->where('status','1')->get('tbl_purchasereject')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= "PURCHASE REJECT,";
				$csv_output .= $value['invoice_no'].","; 			
				$csv_output .= $value['remark'].","; 	

				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				$csv_output.="\n";
			}
		}
 
		$file="reject_purchase";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfRecivedStores()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('recived_store','1')->get('tbl_grnreport')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "WAREHOUSE,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",,,,";
				$csv_output .= $value['issued_category'].",";
				$csv_output .= $value['invoice_no'].",,"; 
				
				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $value['unit_price'].",";  
				}
		 
				$csv_output .= $value['remark'].",,";   
				 
				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['movestoreuser_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				$userName='';
				
				if(!empty($userResult))
				{ 
					$userName=$userResult['username'];
				}
				
				$csv_output .= $value['recivedstore_datetime'].',';
				 
				
				$csv_output .= strtoupper($userName).','; 
				
				$csv_output.="\n";
			}
		}
 
		$file="warehouse";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfDismantlingDevice()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_dismantling_devices')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "DISMANTLING DEVICE,";  
				$csv_output .= $value['product_type'].",";
				$csv_output .= ucfirst($value['product_name']).",,,,,,";  
				
				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $value['unit_price'].",";  
				}
		 
				$csv_output .= $value['remark'].",,,";   
				 
				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $value['warehouse'].",";  
				
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				$userName='';
				
				if(!empty($userResult))
				{ 
					$userName=$userResult['username'];
				}
				
				$csv_output .= $value['recivedstore_datetime'].',';
				 
				
				$csv_output .= strtoupper($userName).','; 
				
				$csv_output.="\n";
			}
		}
 
		$file="dismantling_device";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfretWarehouseByTriage()
	{		
		$csv_output="S.NO,INWARDID,IMEI,NHMOD,PRODUCT TYPE,PRODUCT NAME,DAYS SINCE,USER,BIN NUMBER,WARHOUSE";
		
		$result=$this->Common_model->getAllResult('*','tbl_returntowarehousetriage',array('status'=>'1'));
	 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{
				$i++;
				$csv_output .= $i.",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= $value['nhmod'].","; 
				$csv_output .= $value['product_type'].","; 
				$csv_output .= $value['product_name'].","; 
				$csv_output .= $value['created_date'].",";  
			 
				$userResult=$this->db->select('username')->where('user_id',$value['user_id'])->get('tbl_users')->row_array();
				
				$userName='';
				
				if(!empty($userResult))
				{ 
					$userName=$userResult['username'];
				} 
				$csv_output .= strtoupper($userName).','; 
				
				
				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				
				$csv_output.="\n";
			}
		}
 
		$file="return_to_warehouse_by_triage";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfretWarehouseByCertification()
	{		
		$csv_output="S.NO,INWARDID,IMEI,NHMOD,PRODUCT TYPE,PRODUCT NAME,DAYS SINCE,USER,BIN NUMBER,WAREHOUSE";
		
		$result=$this->Common_model->getAllResult('*','tbl_returntowarehousecertification',array('status'=>'1'));
	 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{
				$i++;
				$csv_output .= $i.",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= $value['nhmod'].","; 
				$csv_output .= $value['product_type'].","; 
				$csv_output .= $value['product_name'].","; 
				$csv_output .= $value['created_date'].",";  
			 
				$userResult=$this->db->select('username')->where('user_id',$value['user_id'])->get('tbl_users')->row_array();
				
				$userName='';
				
				if(!empty($userResult))
				{ 
					$userName=$userResult['username'];
				} 
				
				$csv_output .= strtoupper($userName).','; 
				
				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				
				$csv_output.="\n";
			}
		}
 
		$file="return_to_warehouse_by_certification";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfRecivedAssesmentStores()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_recivedasses_stores')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "RECEIVED ASSESSMENT STORES,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="received_assesment_stores";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function totalTriageToWarehouse()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_comtriageto_warehouse')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "TRIAGE TO WAREHOUSE,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['bin_number'].",";  		 
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="triage_to_warehouse";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvtotalRecivedAssessStoresAss()
	{ 
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('receivedassstore_status','1')->get('tbl_receivedassess_ass')->result_array();
	 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "RECEIVED ASSESSMENT STORES-ASS,";  
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= strtoupper($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";				
				$csv_output .= strtoupper($value['invoice_code']).","; 		
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id'])).","; 				
				$csv_output .= $value['nhsp'].",";				
				$csv_output .= strtoupper($value['remark']).","; 
				$csv_output .= strtoupper($value['other_remark']).",";						
				$csv_output .= strtoupper($value['warehouse']).",";					
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="received_assesment_stores_ass";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	public function exportCsvOfonHold()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE ,USER";
		
		$result=$this->db->where('status','1')->get('tbl_onhold')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "ON HOLD,";				 				
				$csv_output .= strtoupper($value['product_type']).","; 
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ","; 
				$csv_output .= ",";  
				$csv_output .= ",";  
				$csv_output .= ",";   
				$csv_output .= ",";   
				$csv_output .= ",";   
				$csv_output .= ",";  
				$csv_output .= $value['remark'].","; 
				$csv_output .= ","; 
				$csv_output .= strtoupper($value['warehouse']).","; 
				$csv_output .= $value['created_date'].',';				
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);				
				$csv_output .= strtoupper($userName).","; 				
				$csv_output.="\n";
			}
		}
 
		$file="on_hold";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfReturnOrigin()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->select('tbl_returntoorigin.nhdin,tbl_returntoorigin.created_date,tbl_returntoorigin.user_id,tbl_grnreport.device_name,tbl_createinvoice.sale_channel,tbl_createinvoice.order_id,tbl_createinvoice.selling_mode,tbl_returntoorigin.imei_no,tbl_createinvoice.category,tbl_createinvoice.invoice_code,tbl_createinvoice.nhsp,tbl_createinvoice.name')->join('tbl_soldstamp','tbl_soldstamp.stamp_id=tbl_returntoorigin.sold_id')->where('tbl_returntoorigin.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_soldstamp.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_soldstamp.invoice_id')->get('tbl_returntoorigin')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "RETURN TO ORIGIN,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= strtoupper($value['sale_channel']).",";
				$csv_output .= ($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_code']).",";
				$csv_output .= ","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= strtoupper($value['name']).",";
				$csv_output .= ",";
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				
				$csv_output .= strtoupper($wareHouse).",";
				
				$csv_output .= $value['created_date'].',';
				
				$csv_output .= strtoupper($userName).","; 	 
				
				$csv_output.="\n";
			}
		}
 
		$file="return_to_origin";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfSalesReturn()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.="SLYSP";
		}
		
		$csv_output.="REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
	 
		$result=$this->db->get('tbl_salesreturn')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "SALES RETURN,";
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['product_name'].",";
				$csv_output .= $value['sales_channel'].",";
				$csv_output .= $value['order_id'].",";
				$csv_output .= $value['selling_mode'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= ","; 
				
				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $value['nhsp'].",";
				}
				
				$csv_output .= ",";
				$csv_output .= ",";				 
				
				// get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				
				$csv_output .= $value['created_date'].',';
				
				$csv_output .= $this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']).","; 	 
				
				$csv_output.="\n";
			}
		}
 
		$file="sales_return";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
 
	
	public function exportCsvOfPurchaseReturn()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_bulkstatus.update_status','PURCHASE RETURN')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_bulkstatus')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "PURCHASE RETURN,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",,,,,,,,,,";
				$csv_output .= $this->Common_model->getFullStateNameOfShortName(substr($value['nhdin'],0,3)).",";
				$csv_output .= $value['created_date'].',';
				$csv_output .= ucfirst($this->session->userdata('user_name')).",";
				$csv_output.="\n";
			}
		}
 
		$file="purchase_return";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfInTransitOutbondSoldAss()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_bulkstatus.update_status','IN TRANSIT OUTBOUND SOLD - ASS')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_bulkstatus')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "IN TRANSIT OUTBOUND SOLD - ASS,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",,,,,,,,,,";
				$csv_output .= $this->Common_model->getFullStateNameOfShortName(substr($value['nhdin'],0,3)).",";
				$csv_output .= $value['created_date'].',';
				$csv_output .= ucfirst($this->session->userdata('user_name')).",";
				$csv_output.="\n";
			}
		}
 
		$file="in_transit_outbound_sold_ass";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfInTransitOutbondSold()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
 
		$result=$this->db->get('tbl_intransitoutbondsold')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "IN TRANSIT OUTBOUND SOLD,"; 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= $value['order_id'].",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_no']).",";
				$csv_output .= ","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= strtoupper($value['remark']).",";
				$csv_output .= ","; 

				
				 // get binnumber and warehouse
				
				$grnResult=$this->Common_model->getRowResult('bin_number,warehouse','tbl_grnreport',array('nhdin'=>$value['nhdin']));
				$csv_output .= $grnResult['bin_number'].","; 
				$csv_output .= $grnResult['warehouse'].",";  
				
				$csv_output .= $value['created_date'].',';				
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);				
				$csv_output .= strtoupper($userName).","; 	 				
				$csv_output.="\n";
			}
		}
 
		$file="in_transit_outbound_sold";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfMovedToAmazon()
	{
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE ,USER";
		
		$result=$this->db->select('tbl_moved_toamazon.imei_no,tbl_grnreport.nhdin,tbl_grnreport.device_name,tbl_moved_toamazon.user_id,tbl_moved_toamazon.created_date')->where('tbl_moved_toamazon.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_moved_toamazon.nhdin')->get('tbl_moved_toamazon')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "MOVED TO AMAZON,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= strtoupper($typeName).","; 
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ","; 
				$csv_output .= ",";
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				
				$csv_output .= strtoupper($wareHouse).",";
				$csv_output .= $value['created_date'].',';
				$csv_output .= strtoupper($userName).","; 
				$csv_output.="\n";
			}
		}
 
		$file="moved_to_amazon";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	 
	public function exportCsvOfTotalTrc()
	{	
	
		/*==set condition for get result location wise==*/
		 
		$csv_output="SL.NO,INWARDID,Report,Certification Date,Triage Issued Date,Triage 2nd Issued Date,Triage 3rd Issued Date,Triage 1st Attempt Date,Triage 2nd Attempt Date,Triage 3rd Attempt Date,Issued Purpose,DEVICE BAR CODE,WSN,GRADE,SKU CODE,Ynew code,WID,Brand,Model name,Model No,Brand and Model name,Brand and Model name,COLOUR,RAM,ROM,IMEI 1,IMEI2,CERTIFICATION CATEGORY (A/B/C/FF),CERTIFICATION REMARKS,COSMETIC REMARKS,Certification Comment,CERTIFICATION TECHNICIAN,ISSUE BY WH EMP NAME,RECEIVED BY TRIAGE EMP NAME,ISSUED TO ENGINEER-NAME,1st Issue time,1st Return time,1st TAT,2nd Issue time,2nd Return time,2nd TAT,3rd Issue time,3rd Return time,3rd TAT,TOTAL TAT,TRIAGE Remarks,COMPLIANT CODE,COMPLIANT CODE DESCRIPTION,Attempt Level,TRIAGE STATUS,DEVICE CURRENT STATUS,Part Request Date,LCD Color,REQUIRED PART-1,REQUIRED PART-2,REQUIRED PART-3,REQUIRED PART-4,REQUIRED PART-5,Partial parts inward date,Parts inward date,SECONDARY FAULT FOUND,PART REQUEST DATE FOR SFF,PART REQUEST NAME FOR SFF,REPLACED PART - 1,REPLACED PART - 2,REPLACED PART - 3,REPLACED PART - 4,REPLACED PART - 5,DEVICE DONE DATE,DEVICE DONE DATE,YNEW-SEAL,TRIAGE RETURN REMARKS,BAT,ADAPTER,CABLE,EARPHONES,Approved by,RECEIVER WH EMP NAME,RETURNER TRIAGE EMP NAME,ESTIMATED EXPENSES,PENDING REASON,VALIDATED BY (TRIAGE MANAGER),FINAL REMARKS,REMARK";
		
		$result=$this->db->where('status','1')->get('tbl_trcassessment')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{
				$i++;
				$csv_output .= $i.","; 					
				$csv_output .= $value['nhdin'].","; 					
				$csv_output .= $value['report'].","; 					
				$csv_output .= $value['certification_date'].","; 					
				$csv_output .= $value['triage_issued_date'].","; 					
				$csv_output .= $value['triage_2ndissued_date'].","; 					
				$csv_output .= $value['triage_3rdissued_date'].","; 					
				$csv_output .= $value['triage_1stattemptdate'].","; 					
				$csv_output .= $value['triage_2ndattemptdate'].","; 					
				$csv_output .= $value['triage_3rdattemptdate'].","; 					
				$csv_output .= $value['issued_purpose'].","; 					
				$csv_output .= $value['device_barcode'].","; 					
				$csv_output .= $value['wsn'].","; 					
				$csv_output .= $value['category'].","; 					
				$csv_output .= $value['sku_code'].","; 					
				$csv_output .= $value['ynew_code'].","; 					
				$csv_output .= $value['wid'].","; 					
				$csv_output .= $value['brand'].","; 					
				$csv_output .= $value['model_name'].","; 					
				$csv_output .= $value['model_no'].","; 					
				$csv_output .= $value['brand_modelname'].","; 					
				$csv_output .= $value['network'].","; 					
				$csv_output .= $value['colour'].","; 					
				$csv_output .= $value['ram'].","; 					
				$csv_output .= $value['rom'].","; 					
				$csv_output .= $value['imei_no'].","; 					
				$csv_output .= $value['imei2_no'].","; 					
				$csv_output .= $value['certification_category'].","; 					
				$csv_output .= $value['certification_remarks'].","; 					
				$csv_output .= $value['cosmetic_remarks'].","; 					
				$csv_output .= $value['certification_comment'].","; 					
				$csv_output .= $value['certification_technician'].","; 					
				$csv_output .= $value['issuedby_whempname'].","; 					
				$csv_output .= $value['receivedby_triageempname'].","; 					
				$csv_output .= $value['issuedto_engname'].","; 					
				$csv_output .= $value['1st_issuetime'].","; 					
				$csv_output .= $value['1st_returntime'].","; 					
				$csv_output .= $value['1st_tat'].","; 					
				$csv_output .= $value['2nd_issuetime'].","; 					
				$csv_output .= $value['2nd_returntime'].","; 					
				$csv_output .= $value['2nd_tat'].","; 					
				$csv_output .= $value['3rd_issuetime'].","; 					
				$csv_output .= $value['3rd_returntime'].","; 					
				$csv_output .= $value['3rd_tat'].","; 					
				$csv_output .= $value['total_tat'].","; 					
				$csv_output .= $value['triage_remarks'].","; 					
				$csv_output .= $value['compliant_code'].","; 					
				$csv_output .= $value['compliant_code_description'].","; 					
				$csv_output .= $value['attempt_level'].","; 					
				$csv_output .= $value['traige_status'].","; 					
				$csv_output .= $value['device_current_status'].","; 					
				$csv_output .= $value['part_request_date'].","; 					
				$csv_output .= $value['lcd_color'].","; 					
				$csv_output .= $value['required_part1'].","; 					
				$csv_output .= $value['required_part2'].","; 					
				$csv_output .= $value['required_part3'].","; 					
				$csv_output .= $value['required_part4'].","; 					
				$csv_output .= $value['required_part5'].","; 					
				$csv_output .= $value['partialparts_inwarddate'].","; 					
				$csv_output .= $value['parts_inwarddate'].","; 					
				$csv_output .= $value['secondary_fault_found'].","; 					
				$csv_output .= $value['part_request_date_sff'].","; 					
				$csv_output .= $value['part_request_name_sff'].","; 					
				$csv_output .= $value['replace_part1'].","; 					
				$csv_output .= $value['replace_part2'].","; 					
				$csv_output .= $value['replace_part3'].","; 					
				$csv_output .= $value['replace_part4'].","; 					
				$csv_output .= $value['replace_part5'].","; 					
				$csv_output .= $value['device_done_date'].","; 					
				$csv_output .= $value['closed_date'].","; 					
				$csv_output .= $value['ynew_seal'].","; 					
				$csv_output .= $value['triage_return_remarks'].","; 					
				$csv_output .= $value['bat'].","; 					
				$csv_output .= $value['adapter'].","; 					
				$csv_output .= $value['cable'].","; 					
				$csv_output .= $value['earphones'].","; 					
				$csv_output .= $value['approved_by'].","; 					
				$csv_output .= $value['receiverwh_empname'].","; 					
				$csv_output .= $value['returnertriage_empname'].","; 					
				$csv_output .= $value['esmated_expenses'].","; 					
				$csv_output .= $value['pending_Reason'].","; 					
				$csv_output .= $value['validatedby_triagemanager'].","; 					
				$csv_output .= $value['final_remarks'].","; 					
				$csv_output .= $value['pending_reasons'].","; 					
				$csv_output .= $value['remark'].","; 					
				$csv_output.="\n";
			}
		}
 
		$file="triage";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	 
	public function exportCsvOfrepairedOk()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
	 
		$result=$this->db->where('status','1')->where('device_pass_status','REPAIRED OK')->get('tbl_recivedasses_stores')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "REPAIRED OK,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['bin_number'].",";  		 
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="repaired_ok";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	 
	public function exportCsvOfber()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
		 
		$result=$this->db->where('status','1')->where('device_pass_status','BER')->get('tbl_recivedasses_stores')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "BER,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['bin_number'].",";  		 
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="ber";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	 
	public function exportCsvOpfp()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output=",REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
 
		$result=$this->db->where('status','1')->where('device_pass_status','PFP')->get('tbl_recivedasses_stores')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "PFP,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['bin_number'].",";  		 
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="pfp";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	 
	public function exportCsvOfrwr()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output=",REMARK,OTHER REMARK,BIN NUMBER,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->where('device_pass_status','PFP')->get('tbl_recivedasses_stores')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= "RWR,";	 
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).","; 
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				
				$csv_output .= ",";
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['bin_number'].",";  		 
				$csv_output .= strtoupper($value['warehouse']).",";  		 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($userName).",";					   
				$csv_output.="\n";
			}
		}
 
		$file="rwr";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	 
	 
	 
	public function exportCsvOfInQc()
	{
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where(array('trc_engassessment.status'=>'1','trc_engassessment.current_status'=>'IN QC'))->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_engassessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('trc_engassessment')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "IN QC,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				
				$csv_output .= ",";
				
				$engName=''; $engTitleResult=array();$engineer_remark='';
				
				$engTitleResult=$this->db->select('remark,engineer_remark')->where('eng_assesment_id',$value['assessment_id'])->order_by('connectivity_id','DESC')->get('tbl_title_connectivity')->row();
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);
				  
				if(!empty($engTitleResult))
				{
					$remark=$engTitleResult->remark;
					
					$engineer_remark=$engTitleResult->engineer_remark;
					
			 	}
				
				
				$csv_output .= strtoupper($engName).","; 
				
				$csv_output .= ","; 
				
				$csv_output .= ",";
				
				$csv_output .= ",";
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				
				$csv_output .= strtoupper($wareHouse).",";
					
				$csv_output .= $value['created_date'].',';
				
				$csv_output .= strtoupper($userName).",";		 					 
  
				$csv_output.="\n";
			}
		}
 
		$file="in_qc";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	public function exportCsvOfInQcPass()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->select('tbl_inqcpass_stamp.created_date,tbl_inqcpass_stamp.nhdin,tbl_inqcpass_stamp.user_id,tbl_inqcpass_stamp.imei_no,tbl_inqcpass_stamp.eng_assessment_id,tbl_grnreport.device_name')->where('tbl_inqcpass_stamp.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_inqcpass_stamp.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_inqcpass_stamp')->result_array();
 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "IN QC PASS,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				
				$csv_output .= ",";
				
				$engName=''; $engTitleResult=array();$engineer_remark='';
				
				$engTitleResult=$this->db->select('remark,engineer_remark')->where('eng_assesment_id',$value['eng_assessment_id'])->order_by('connectivity_id','DESC')->get('tbl_title_connectivity')->row();
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);
				 
			 	if(!empty($engTitleResult))
				{
					$remark=$engTitleResult->remark;
					
					$engineer_remark=$engTitleResult->engineer_remark;
					
			 	}
				
				
				$csv_output .= strtoupper($engName).","; 
				
				$csv_output .= ","; 
				
				$csv_output .= "IN QC PASS,";
				  
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $engineer_remark).",";
			  
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				
				$csv_output .= strtoupper($wareHouse).",";
				
				$createDateResult=json_decode($value['created_date']);
 
				$csv_output .= $createDateResult[0].',';
				
				$csv_output .= strtoupper($userName).",";				 
  
				$csv_output.="\n";
			}
		}
 
		$file="in_qc_pass";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfInQcFail()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_inqcfail_stamp.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_inqcfail_stamp.nhdin')->get('tbl_inqcfail_stamp')->result_array();
 	
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "IN QC FAIL,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				
				$csv_output .= ",";
				
				$engName=''; $engTitleResult=array();$engineer_remark='';
				
				$engTitleResult=$this->db->select('remark,engineer_remark')->where('eng_assesment_id',$value['eng_assessment_id'])->order_by('connectivity_id','DESC')->get('tbl_title_connectivity')->row();
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);
				 
				if(!empty($engTitleResult))
				{
					$remark=$engTitleResult->remark;
					
					$engineer_remark=$engTitleResult->engineer_remark;
					
			 	}
				
				
				$csv_output .= strtoupper($engName).","; 
				
				$csv_output .= ","; 
				
				$csv_output .= "IN QC FAIL,";
				 
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $engineer_remark).",";
 
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				
				$csv_output .= strtoupper($wareHouse).",";
					
				$csv_output .= $value['modify_time'].',';
				
				$csv_output .= strtoupper($userName).",";					 
  
				$csv_output.="\n";
			}
		}
 
		$file="in_qc_fail";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfModalMismatch()
	{	
		/*==set condition for get result location wise==*/
		
		
		$cond="confirm_mismatch='1'";
		
		if($this->session->userdata('locationValue')!='ALL')
		{
			$cond.=" and warehouse='".$this->session->userdata('locationValue')."'";
		}
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type'=='1'))
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		 
		$result=$this->db->where($cond)->get('tbl_modalmismatch')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "MODEL MISMATCH,"; 				
				$csv_output .= strtoupper($value['imei_no']).",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $value['new_nhdin'].",";
				$csv_output .= ",";
				$csv_output .= strtoupper($value['warehouse']).",";
			 	
				$csv_output .= $value['created_date'].',';
				 
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['mismatch_userid'])).",";					
				$csv_output.="\n";
			}
		}
 
		$file="model_mismatch";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfTotalOutQc()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_outqcstamp.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcstamp.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_outqcstamp')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "OUT QC,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= strtoupper($value['sale_channel']).",";
				$csv_output .= strtoupper($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= ",";
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_name']);
				
				$csv_output .= strtoupper($engName).",";
				
				$csv_output .= ",";
				
				$csv_output .= strtoupper($value['remark']).",";
				
				$csv_output .= ",";
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				$csv_output .= strtoupper($wareHouse).",";
				
				$csv_output .= $value['created_date'].',';
			  
				$csv_output .= strtoupper($userName).","; 		
				
				$csv_output.="\n";
			}
		}
 
		$file="out_qc";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfTotalrfsTrc()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('trc_closedrfsassess.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_closedrfsassess.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('trc_closedrfsassess')->result_array();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "READY FOR SALE- TRC,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				 
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);
				
				$connectivityResult=$this->db->select('engineer_remark')->where('bulkstatus_id',$value['bulkstatus_id'])->get('tbl_title_connectivity')->row();
				
				$engResultResult=$this->db->select('current_status')->where('bulkstatus_id',$value['bulkstatus_id'])->get('trc_engassessment')->row();
				
				$engRemark='';
				
				if(!empty($connectivityResult))
				{ 
					$engRemark=preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $connectivityResult->engineer_remark).","; 
				}
				
				$currentStatus='';
				
				if(!empty($engResultResult))
				{
					$currentStatus=$engResultResult->current_status;
				}
				
				$csv_output .= strtoupper($engName).",";
				$csv_output .= ",";
				$csv_output .= strtoupper($currentStatus).","; 
				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $engRemark).",";  
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				$csv_output .= strtoupper($wareHouse).",";
				
				$csv_output .= $value['created_date'].',';
  
				$csv_output .= strtoupper($userName).",";		
				
				$csv_output.="\n";
			}
		}
 
		$file="ready_for_sale_trc";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfAfterSaleServiceTrc()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_receivedassess_ass')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$createdDateTime=$date = date('Y-m-d H:i:s',strtotime('+1 seconds',strtotime($value['created_date'])));
				
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "AFTER SALE SERVICE- TRC,";				
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['product_name'].",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";				 
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);			
				$csv_output .= strtoupper($engName).",";
				$csv_output .= ",";
				$csv_output .= strtoupper($value['remark']).",";
				$csv_output .= strtoupper($value['other_remark']).","; 
				$userName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id']);
				$csv_output .= strtoupper($value['warehouse']).",";				
				$csv_output .= $createdDateTime.',';  
				$csv_output .= strtoupper($userName).",";						
				$csv_output.="\n";
			}
		}
 
		$file="after_sale_service_trc";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfTotalOutQcFail()
	{	
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		 $result=$this->db->where('status','1')->get('tbl_outqcfail_salesstamp')->result_array();
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "OUT QC FAIL,"; 
				$csv_output .= $value['product_type'].",";
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= strtoupper($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= ",";				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);				
				$csv_output .= strtoupper($engName).",";				
				$csv_output .= ",";				
				$csv_output .= strtoupper($value['remark']).",";		
				$csv_output .=  preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).","; 
				$csv_output .= strtoupper($value['wareHouse']).",";			
				
				$jsonCreateDate=json_decode($value['created_date']);
				
				$csv_output .= $jsonCreateDate[0].',';		
				
				$csv_output .= strtoupper($engName).",";				
				$csv_output.="\n";
			}
		}
 
		$file="out_qc_fail";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	
	public function exportCsvOfAssPass()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where(array('update_status'=>'ass_pass'))->get('tbl_receivedassess_ass')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei'].",";
				$csv_output .= "ASS PASS,";  
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= $value['order_id'].",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_no']).",";
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id'])).","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= strtoupper($value['remark']).",";				 
				$csv_output .= strtoupper($value['other_remark']).",";

				$csv_output .= strtoupper($value['warehouse']).",";
				
				$csv_output .= $value['created_date'].',';
				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).","; 	 
				
				$csv_output.="\n";
			}
		}
 
		$file="ass_pass";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
	
	
	public function exportCsvOfAssFail()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where(array('update_status'=>'ass_fail'))->get('tbl_receivedassess_ass')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei'].",";
				$csv_output .= "ASS FAIL,";  
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= ($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_code']).",";
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_name'])).","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= strtoupper($value['remark']).",";				 
				$csv_output .= strtoupper($value['other_remark']).",";
				
				$csv_output .= strtoupper($value['warehouse']).",";
				
				$csv_output .= $value['created_date'].',';
				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).",";  
				
				$csv_output.="\n";
			}
		}
 
		$file="ass_fail";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
	
	
	public function exportCsvOfAssRejected()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where(array('update_status'=>'ass_rejected'))->get('tbl_receivedassess_ass')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei'].",";
				$csv_output .= "ASS REJECTED,"; 
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= ($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_no']).",";
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id'])).","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= "ASS REJECTED,";
				$csv_output .= "Not Eligible for ASS,";
				$csv_output .= strtoupper($value['warehouse']).",";				
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).","; 	 				
				$csv_output.="\n";
			}
		}
 
		$file="ass_rejected";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
	
	
	public function exportCsvOfAssInspCompleted()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_ass_inpectioncompleted')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "ASS INSPECTION COMPLETED,";			 			
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['product_name'].",";
				$csv_output .= $value['sales_channel'].",";
				$csv_output .= $value['order_id'].",";
				$csv_output .= $value['selling_mode'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_id'])).","; 
				$csv_output .= $value['nhsp'].","; 
				$csv_output .=  preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .=  preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= $value['warehouse'].",";				
				$csv_output .= $value['created_date'].',';	 			
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).","; 	 				
				$csv_output.="\n";
			}
		}
		
		$file="ass_inspection_completed";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
	
	
	public function exportCsvOfAssDispatched()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->get('tbl_ass_dispatched')->result_array();
		
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "ASS DISPATCHED,"; 				
				$csv_output .= strtoupper($value['product_type']).",";
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sales_channel']).",";
				$csv_output .= $value['order_id'].",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= strtoupper($value['invoice_no']).",";
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_id'])).","; 
				$csv_output .= $value['nhsp'].","; 				
				$csv_output .=  preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['other_remark']).",";
				$csv_output .= strtoupper($value['warehouse']).",";				
				$csv_output .= $value['created_date'].',';				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).","; 	 				
				$csv_output.="\n";
			}
		}
		
		$file="ass_dispatched";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
		
	public function exportCsvOfAfterSalesServiceInspection()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,OTHER REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('status','1')->get('tbl_assinspection')->result_array();

		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "AFTER-SALES-SERVICE-INSPECTION,";				 
				$csv_output .= ucfirst($value['product_type']).",";
				$csv_output .= ucfirst($value['product_name']).",";
				$csv_output .= ucfirst($value['sales_channel']).",";
				$csv_output .= ucfirst($value['order_id']).",";
				$csv_output .= ucfirst($value['selling_mode']).",";
				$csv_output .= ucfirst($value['category']).",";
				$csv_output .= ucfirst($value['invoice_no']).",";
				$csv_output .= ucfirst($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_id'])).","; 
				$csv_output .= $value['nhsp'].",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $value['created_date'].",";  
				$csv_output .= ucfirst($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).","; 				
				$csv_output.="\n";
			}
		}
 
		$file="after_sales_service-inspection";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit; 
	}
	
	public function exportCsvOfAssInspection()
	{
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_bulkstatus.update_status','AFTER SALES SERVICE')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_bulkstatus')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "SALES SERVICE INSPECTION,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",,,,,,,,,,";
				$csv_output .= $this->Common_model->getFullStateNameOfShortName(substr($value['nhdin'],0,3)).",";
				$csv_output .= $value['created_date'].',';
				$csv_output .= ucfirst($this->session->userdata('user_name')).",";
				$csv_output.="\n";
			}
		}
 
		$file="ass_inspection_completed";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	public function exportCsvOfInwardPending()
	{
		$csv_output="INWARDID,VENDOR DEVICE ID,MRN NUMBER,INVOICE NO,VENDOR CODE,STATUS,PRODUCT TYPE,MODEL ID,PRODUCT NAME,RAM, ROM, STOCK TYPE,STOCK SUB TYPE,IMEI,INVOICE TYPE,UNIT PRICE,	TAX (%),ENTRY PASS NO";
	
  	    if($this->session->userdata('user_type')=='1')
		{
			//$csv_output.=",SLYSP";
		}
		
		//$csv_output.=",REMARK,Other REMARK,DAYS SINCE,USER";
		  
		$result=$this->db->where('status','INWARD')->get('tbl_grnreport')->result_array();
 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['othervendor_id'].",";
				$csv_output .= "MRNHY-".str_pad($value['order_refno'], 5, "0", STR_PAD_LEFT).",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= "INWARD PENDING FINANCE,";
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['nhmod'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= $value['ram'].",";
				$csv_output .= $value['rom'].",";
				$csv_output .= $value['invoice_type'].",";
				$csv_output .= $value['unit_price'].",";
				$csv_output .= $value['unit_price_tax'].",";
				$csv_output .= $value['tax'].",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['entrypass_no'].",";
				$csv_output.="\n";
				
				
			}
		}
 
		$file="inward_pending_finance";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfsparePartReq()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output=",REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		 
		$result=$this->db->where('inward_pending','1')->get('tbl_grnreport')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= "INWARD PENDING FINANCE,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= ucfirst($value['device_name']).",,,,,,,,,,";
				$csv_output .= $this->Common_model->getFullStateNameOfShortName(substr($value['nhdin'],0,3)).",";
				$csv_output .= $value['created_date'].',';
				$csv_output .= ucfirst($this->session->userdata('user_name')).",";
				$csv_output.="\n";
			}
		}
 
		$file="spare_part_requirement";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfOutQcPass()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		 
		$result=$this->db->where('status','1')->get('tbl_outqcpass_salesstamp')->result_array();
	 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "OUT QC PASS-SALES,";				
				$csv_output .= $value['product_type'].",";
				$csv_output .= strtoupper($value['product_name']).",";
				$csv_output .= strtoupper($value['sale_channel']).",";
				$csv_output .= strtoupper($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= ",";				 
				$csv_output .= ",";				
				$csv_output .= ",";
				$csv_output .= strtoupper($value['remark']).",";				
				$csv_output .= ",";				
				$wareHouse='';$userName='';
				$csv_output .= strtoupper($value['warehouse']).",";	
				$createdDateResult=json_decode($value['created_date']);
				$csv_output .= $createdDateResult[0].',';				
				$csv_output .= strtoupper($this->Common_model->getFieldValue('username','tbl_users','user_id',$value['user_id'])).",";
				
				$csv_output.="\n";
			}
		}
 
		$file="out_qc_pass_sales";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfSoldStamp()
	{
		/*==set condition for get result location wise==*/
		
		$locCond="status='1'";
		
		$designationId=$this->session->userdata('designations_id');
	
		$allow='0';
		
		if($this->session->userdata('user_type')=='1' || $designationId=='10' || $designationId=='11' || $designationId=='24' || $designationId=='25')
		{
			$allow='1';
		}
		
		if($allow=='1')
		{
			$csv_output="SALES CHANNEL,ORDER ID,LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,BILL TYPE,DEVICE TYPE,BRAND,MODEL ID,INWARD ID,IMEI,PRODUCT NAME,SALES TERMS,GRADE,PAYMENT MODE,COST,SLYSP,MARGIN,MARGIN %,INVOICE NO,INVOICE DATE,TAX IN RS,BUYER CODE,NAME,MOBILE,ADDRESS,CITY,STATE,PINCODE,GST NO,SALES CODE";
		}
		else
		{
			$csv_output="SALES CHANNEL,ORDER ID,LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,BILL TYPE,DEVICE TYPE,BRAND,MODEL ID,INWARD ID,IMEI,PRODUCT NAME,SALES TERMS,GRADE,PAYMENT MODE,INVOICE NO,INVOICE DATE,TAX IN RS,BUYER CODE,NAME,MOBILE,ADDRESS,CITY,STATE,PINCODE,GST NO,SALES CODE";
		}
		
		$result=$this->db->where($locCond)->get('tbl_soldstamp')->result_array();
	 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['sale_channel'].",";
				
				$csv_output .= $value['order_id'].",";
				
				$csv_output .= strtoupper($value['warehouse']).",";
				
				$csv_output .= strtoupper($value['rfs_type']).",";
				
				$csv_output .= strtoupper($value['stock_type']).",";
				
				$csv_output .= strtoupper($value['stock_subtype']).",";
				
				$csv_output .= strtoupper($value['bill_type']).",";
								 
				$csv_output .= strtoupper($value['device_type']).",";
				
				$csv_output .= strtoupper($value['device_brand']).",";
				
				$csv_output .= $value['nhmod'].",";
				
				$csv_output .= $value['nhdin'].","; 
				
				$csv_output .= $value['imei_no'].","; 
				
				$csv_output .= strtoupper($value['product_name']).",";
				
				$csv_output .= strtoupper($value['selling_mode']).",";
				
				$csv_output .= strtoupper($value['category']).",";
				
				$csv_output .= strtoupper($value['payment_mode']).",";
				
				if($allow=='1')
				{
					$csv_output .= strtoupper($value['nhpp']).",";
					$csv_output .= strtoupper($value['nhsp']).",";
					$csv_output .= strtoupper(round($value['rs_margin'])).","; 
					$csv_output .= strtoupper(round($value['percent_margin'])).",";
				}
				  
 	
				$csv_output .= strtoupper($value['invoice_no']).",";
				
				$csv_output .= strtoupper($value['created_date']).",";
				
				$csv_output .= ($value['tax_rsvalue']).",";
				
				$csv_output .= ($value['vendor_code']).",";
				
				$csv_output .= strtoupper($value['name']).",";
				
				$csv_output .= strtoupper($value['mobile']).",";
				
				$address=preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['address']).",";
				
				$csv_output .= strtoupper($address).",";
				
				$csv_output .= strtoupper($value['city']).",";
				
				$stateName=$this->Common_model->getFieldValue('name','tbl_states','state_id',$value['state']);
				
				$csv_output .= strtoupper($stateName).",";
				
				$csv_output .= ($value['pincode']).",";
				
				$csv_output .= ($value['gst']).","; 
				
				$csv_output .= strtoupper($value['sales_code']).","; 
				
				$csv_output.="\n";
			}
		}
 
		$file="sold";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	public function exportCsvOfSalesReport()
	{
		$designationId=$this->session->userdata('designations_id');
	
		$allow='0';
		
		if($this->session->userdata('user_type')=='1' || $designationId=='10' || $designationId=='11' || $designationId=='24' || $designationId=='25')
		{
			$allow='1';
		}
		
		if($allow=='1')
		{
			$csv_output="SALES CHANNEL,ORDER ID,LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,BILL TYPE,DEVICE TYPE,BRAND,MODELID,NHDIN,IMEI,PRODUCT NAME,SALES TERMS,GRADE,PAYMENT MODE,COST,SLYSP,MARGIN,MARGIN %,INVOICE NO,INVOICE DATE,TAX IN RS,BUYER CODE,NAME,MOBILE,ADDRESS,CITY,STATE,PINCODE,GST NO,SALES CODE";
		}
		else
		{
			$csv_output="SALES CHANNEL,ORDER ID,LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,BILL TYPE,DEVICE TYPE,BRAND,MODELID,NHDIN,IMEI,PRODUCT NAME,SALES TERMS,GRADE,PAYMENT MODE,SLYSP,INVOICE NO,INVOICE DATE,TAX IN RS,BUYER CODE,NAME,MOBILE,ADDRESS,CITY,STATE,PINCODE,GST NO,SALES CODE";
		}
		
		$result=$this->db->get('tbl_soldstamp')->result_array();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['sale_channel'].",";
				
				$csv_output .= $value['order_id'].",";
				
				$csv_output .= strtoupper($value['warehouse']).",";
				
				$csv_output .= strtoupper($value['rfs_type']).",";
				
				$csv_output .= strtoupper($value['stock_type']).",";
				
				$csv_output .= strtoupper($value['stock_subtype']).",";
				
				$csv_output .= strtoupper($value['bill_type']).",";
								 
				$csv_output .= strtoupper($value['device_type']).",";
				
				$csv_output .= strtoupper($value['device_brand']).",";
				
				$csv_output .= $value['nhmod'].",";
				
				$csv_output .= $value['nhdin'].","; 
				
				$csv_output .= $value['imei_no'].","; 
				
				$csv_output .= strtoupper($value['product_name']).",";
				
				$csv_output .= strtoupper($value['selling_mode']).",";
				
				$csv_output .= strtoupper($value['category']).",";
				
				$csv_output .= strtoupper($value['payment_mode']).",";
				
				if($allow=='1')
				{
					$csv_output .= strtoupper($value['nhpp']).",";
				}
				
				
				$csv_output .= strtoupper($value['nhsp']).",";
				
				if($allow=='1')
				{
					$csv_output .= strtoupper(round($value['rs_margin'])).",";
				
					$csv_output .= strtoupper(round($value['percent_margin'])).",";
				}
 	
				$csv_output .= strtoupper($value['invoice_no']).",";
				
				$csv_output .= $value['created_date'].",";
				
				$csv_output .= ($value['tax_rsvalue']).",";
				
				$csv_output .= ($value['vendor_code']).",";
				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['name']).",";
				
				$csv_output .= strtoupper($value['mobile']).",";
				
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['address']).","; 
				 
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['city']).",";
				
				$stateName=$this->Common_model->getFieldValue('name','tbl_states','state_id',$value['state']);
				
				$csv_output .= strtoupper($stateName).",";
				
				$csv_output .= ($value['pincode']).",";
				
				$csv_output .= ($value['gst']).","; 
				
				$csv_output .= strtoupper($value['sales_code']).","; 
				
				$csv_output.="\n";
			}
		}
 
		$file="sales_report";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfpreLove()
	{
		/*==set condition for get result location wise==*/
		 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,DAYS SINCE,USER";
		 
		$result=$this->db->where('tbl_prelove.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_prelove.nhdin')->get('tbl_prelove')->result_array(); 
	 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "PRELOVE,";				
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= "OFFLINE,";
				$csv_output .= ",";
				$csv_output .= "AXIX,";
				$csv_output .= $value['issued_category'].",";
				$csv_output .= $value['invoice_no'].","; 
				$csv_output .= ",";	

				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $value['unit_price'].","; 
				}				
					
				$csv_output .= $value['remark'].","; 	 
				$csv_output .= ",";		 			
				$csv_output .= $value['created_date'].",";	 		
				$csv_output .= "ADMIN,";
				$csv_output.="\n";
			}
		}
 
		$file="prelove";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfOutQcPassSales()
	{
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_outqcpass_salesstamp.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcpass_salesstamp.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_outqcpass_salesstamp')->result_array();
		 
		$csv_output.="\n";
		if(!empty($result))
		{
			 
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $this->Common_model->getDeviceImeiNo($value['nhdin']).",";
				$csv_output .= "OUT QC PASS SALES,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).","; 
				$csv_output .= strtoupper($value['sale_channel']).","; 
				$csv_output .= strtoupper($value['order_id']).","; 
				$csv_output .= strtoupper($value['selling_mode']).","; 
				$csv_output .= strtoupper($value['category']).","; 
				$csv_output .= ","; 
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['eng_id']);
				
				$csv_output .= strtoupper($engName).","; 
				$csv_output .= ",";   
				 
				$csv_output .= strtoupper($value['remark']).","; 
				$csv_output .= ","; 
				
				$wareHouse='';$wareHouse='';$userName='';
				 
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				 
				$csv_output .= strtoupper($wareHouse).",";
 	
				$csv_output .= $value['created_date'].","; 
				 
				$csv_output .= strtoupper($userName).','; 		
				
				$csv_output.="\n";
			}
		}
 
		$file="out_qc_pass_sales";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfOutQcPassFinance()
	{ 
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",COST,SLYSP";
		}
		
		$csv_output.=",REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
	 
		$result=$this->db->where('tbl_outqcpass_finance.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcpass_finance.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_outqcpass_finance')->result_array();
 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "OUT QC PASS-FINANCE,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= trim(strtoupper($value['device_name'])).","; 
				$csv_output .= strtoupper($value['sale_channel']).","; 
				$csv_output .= strtoupper($value['order_id']).","; 
				$csv_output .= strtoupper($value['selling_mode']).","; 
				$csv_output .= strtoupper($value['category']).","; 
				$csv_output .= ","; 
				$csv_output .= ",";  
			
				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $value['nhpp'].","; 
					$csv_output .= $value['nhsp'].","; 
				}
				
				$csv_output .= strtoupper($value['remark']).","; 
				$csv_output .= ","; 
				
				$wareHouse='';$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				$csv_output .= strtoupper($wareHouse).",";
 	
				$csv_output .= $value['created_date'].","; 
			 	
				$csv_output .= strtoupper($userName).','; 		
				
				$csv_output.="\n";
			}
		}
 
		$file="out_qc_pass_finance";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfrEADYfOrSale()
	{ 
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,COMPANY CODE,DEVICE TYPE,BRAND,MODEL ID,PRODUCT NAME,INWARD ID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE CATEGORY 1,DEVICE CATEGORY 2";
		
		if($this->session->userdata('user_type')=='1')
		{
			$csv_output.=",COST";
		} 
		
		$csv_output.=",REPAIR COST,SHIPPING COST,LANDING PRICE,COST PRICE,ASIS-SLYDP,POD-SLYDP,FULL QC-SLYDP,WEBSITE SLYDP,SLYOP,SLYWP,SLYW LISTING,WORKING CONDITION 1,WORKING CONDITION 2,WORKING CONDITION 3,WORKING CONDITION 4,WORKING CONDITION 5,SCREEN CONDITION 1,SCREEN CONDITION 2,HOUSING CONDITION 1,HOUSING CONDITION 2,HOUSING CONDITION 3,HOUSING CONDITION 4,HOUSING CONDITION 5,HOUSING CONDITION 6,HOUSING CONDITION 7";
		  
		$result=$this->db->where('status','1')->get('tbl_readyforsale')->result_array();
        
		$csv_output.="\n";
		
		if(!empty($result))
		{
			foreach($result as $resultValue)
			{
				$csv_output .= $resultValue['warehouse'].",";
				$csv_output .= $resultValue['rfs_type'].",";
				$csv_output .= $resultValue['stock_type'].",";
				$csv_output .= $resultValue['stock_subtype'].",";
				$csv_output .= $resultValue['tax_type'].",";
				$csv_output .= $resultValue['supplier_name'].",";
				$csv_output .= ",";
				$csv_output .= strtoupper($resultValue['company_code']).",";
				$csv_output .= strtoupper($resultValue['device_type']).",";
				$csv_output .= strtoupper($resultValue['device_brand']).",";
				$csv_output .= $resultValue['nhmod'].",";
				$csv_output .= $resultValue['product_name'].",";
				$csv_output .= $resultValue['nhdin'].",";
				$csv_output .= $resultValue['imei_no'].",";
				$csv_output .= $resultValue['imei2_no'].","; 
				$csv_output .= $resultValue['product_id'].","; 
				$csv_output .= $resultValue['qc_status'].",";
				$csv_output .= $resultValue['color'].",";
				$csv_output .= $resultValue['ram'].",";
				$csv_output .= $resultValue['rom'].",";
				$csv_output .= $resultValue['front_camera'].",";
				$csv_output .= $resultValue['primary_camera'].","; 
				$csv_output .= $resultValue['display'].",";  
				$csv_output .= $resultValue['processor'].",";   
				$csv_output .= $resultValue['sim_type'].",";    
				$csv_output .= $resultValue['clock_speed'].",";   
				$csv_output .= $resultValue['os'].",";    
				$csv_output .= $resultValue['battery'].",";     
				$csv_output .= $resultValue['weight'].",";   
				$csv_output .= $resultValue['network_brand'].",";
				$csv_output .= $resultValue['network_type'].",";
				$csv_output .= $resultValue['ageing_id'].",";
				$csv_output .= $resultValue['device_cond'].",";
				$csv_output .= $resultValue['device_category'].",";
				$csv_output .= $resultValue['device_category2'].",";
				
				if($this->session->userdata('user_type')=='1')
				{
					$csv_output .= $resultValue['nhpp'].",";
				} 
				
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $resultValue['fullqc_nhdpvalue'].",";
				$csv_output .= $resultValue['website_nhdp'].",";
				$csv_output .= $resultValue['nhop_value'].",";
				$csv_output .= $resultValue['nhwp_value'].",";
				$csv_output .= ",";
				$csv_output .= $resultValue['working_cond1'].",";
				$csv_output .= $resultValue['working_cond2'].",";
				$csv_output .= $resultValue['working_cond3'].",";
				$csv_output .= $resultValue['working_cond4'].",";
				$csv_output .= $resultValue['working_cond5'].",";
				$csv_output .= $resultValue['screen_cond1'].",";
				$csv_output .= $resultValue['screen_cond2'].",";
				$csv_output .= $resultValue['housing_cond1'].",";
				$csv_output .= $resultValue['housing_cond2'].",";
				$csv_output .= $resultValue['housing_cond3'].",";
				$csv_output .= $resultValue['housing_cond4'].",";
				$csv_output .= $resultValue['housing_cond5'].",";
				$csv_output .= $resultValue['housing_cond6'].",";
				$csv_output .= $resultValue['housing_cond7'].",";
				$csv_output.="\n";
			}
		}
		
		 
 
		$file="ready_for_sale";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfL1Assessment()
	{ 
		
		$csv_output="INWARDID,IMEI,STATUS,PRODUCT TYPE,PRODUCT NAME,SALES CHANNEL,ORDER ID,SALES TERMS,GRADE,INVOICE NO,ENGINEER,SLYSP,REMARK,Other REMARK,WAREHOUSE,DAYS SINCE,USER";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
	
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei_no'].",";
				$csv_output .= "L1 ASSESSMENT,";
				
				$typeId=0;$typeName='';
				$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','product_name',$value['device_name']);
				$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$typeId));
				
				$csv_output .= $typeName.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= strtoupper($value['sale_channel']).",";
				$csv_output .= strtoupper($value['order_id']).",";
				$csv_output .= strtoupper($value['selling_mode']).",";
				$csv_output .= strtoupper($value['category']).",";
				$csv_output .= ",";
				
				$engName=$this->Common_model->getFieldValue('username','tbl_users','user_id',$value['engineer_name']);
				
				$csv_output .= strtoupper($engName).",";
				
				$csv_output .= ",";
				
				$csv_output .= strtoupper($value['remark']).",";
				
				$csv_output .= ",";
				
				$wareHouse='';$userName='';
				
				$userResult=$this->db->select('tbl_users.username,tbl_account_details.location')->where('tbl_account_details.user_id',$value['user_id'])->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->row_array();
				
				if(!empty($userResult))
				{
					$wareHouse=$userResult['location'];
					
					$userName=$userResult['username'];
				}
				
				$csv_output .= strtoupper($wareHouse).",";
				
				$csv_output .= $value['created_date'].',';
			  
				$csv_output .= strtoupper($userName).","; 		
				
				$csv_output.="\n";
			}
		}
		
		$file="l1_assessment";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
 
	public function exportCsvOfL2Assessment()
	{  
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,DEVICE TYPE,BRAND,MODELID,PRODUCT NAME,INWARDID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE GRADE,COST,REPAIR COST,SHIPPING,LANDING PRICE,COST PRICE,ASIS-NHDP,POD-NHDP,FULL QC-NHDP,NHOP,NHWP,NHW LISTING,WORKING CONDITION,SCREEN CONDITION,HOUSING CONDITION,QC REMARK 3,QC REMARK 4,QC REMARK 5,QC REMARK 6";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$rfsType=$this->Common_model->checkRfsType($value['nhdin']);
				
				$supplierName=$this->Common_model->getVendorNameFormVendorCode($value['vendor_code']);
				
				$typeName='';$brandName='';$nhmod='';
				
				$productDetails=$this->Common_model->getDeviceDetailByNhdin($value['nhdin']);
				
				if(!empty($productDetails))
				{
					$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$productDetails['type_id']));
					
					$brandName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_brand','brand_id',$productDetails['brand_id'])); 
				
					$nhmod=$productDetails['nhmod'];
				}
			 
				$deviceResult=$this->Common_model->getTitleConnectDataByNhdin($value['nhdin']);
 		  
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $rfsType.",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['tax_type'].",";
				$csv_output .= $supplierName.",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= $typeName.",";
				$csv_output .= $brandName.",";
				$csv_output .= $nhmod.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= ",";
				$csv_output .= "QC PASS,";
				$csv_output .= $deviceResult['device_color'].",";
				$csv_output .= $deviceResult['ram'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['camera_front'].",";
				$csv_output .= $deviceResult['camera_main'].",";
				$csv_output .= $deviceResult['display_screen'].",";
				$csv_output .= $deviceResult['processor'].",";
				$csv_output .= $deviceResult['sim_info'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['os'].",";
				$csv_output .= $deviceResult['battery_charging'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['network_brand'].",";
				$csv_output .= $deviceResult['network_type'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['device_condition'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['nhpp'].",";
				$csv_output .= "0,";
				$csv_output .= "0,";
				$csv_output .= $value['nhsp'].",";
				$csv_output .= $value['nhpp'].",,,,,,,,,,,,,,"; 
				$csv_output.="\n";
			}
		}
 
		$file="l2_assessment";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfL1Enginerring()
	{ 
		
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,DEVICE TYPE,BRAND,MODELID,PRODUCT NAME,INWARDID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE CATEGORY,COST,REPAIR COST,SHIPPING,LANDING PRICE,COST PRICE,ASIS-NHDP,POD-NHDP,FULL QC-NHDP,NHOP,NHWP,NHW LISTING,WORKING CONDITION,SCREEN CONDITION,HOUSING CONDITION,QC REMARK 3,QC REMARK 4,QC REMARK 5,QC REMARK 6";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$rfsType=$this->Common_model->checkRfsType($value['nhdin']);
				
				$supplierName=$this->Common_model->getVendorNameFormVendorCode($value['vendor_code']);
				
				$typeName='';$brandName='';$nhmod='';
				
				$productDetails=$this->Common_model->getDeviceDetailByNhdin($value['nhdin']);
				
				if(!empty($productDetails))
				{
					$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$productDetails['type_id']));
					
					$brandName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_brand','brand_id',$productDetails['brand_id'])); 
				
					$nhmod=$productDetails['nhmod'];
				}
			 
				$deviceResult=$this->Common_model->getTitleConnectDataByNhdin($value['nhdin']);
 		  
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $rfsType.",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['tax_type'].",";
				$csv_output .= $supplierName.",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= $typeName.",";
				$csv_output .= $brandName.",";
				$csv_output .= $nhmod.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= ",";
				$csv_output .= "QC PASS,";
				$csv_output .= $deviceResult['device_color'].",";
				$csv_output .= $deviceResult['ram'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['camera_front'].",";
				$csv_output .= $deviceResult['camera_main'].",";
				$csv_output .= $deviceResult['display_screen'].",";
				$csv_output .= $deviceResult['processor'].",";
				$csv_output .= $deviceResult['sim_info'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['os'].",";
				$csv_output .= $deviceResult['battery_charging'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['network_brand'].",";
				$csv_output .= $deviceResult['network_type'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['device_condition'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['nhpp'].",";
				$csv_output .= "0,";
				$csv_output .= "0,";
				$csv_output .= $value['nhsp'].",";
				$csv_output .= $value['nhpp'].",,,,,,,,,,,,,,"; 
				$csv_output.="\n";
			}
		}
 
		$file="l1_engineering";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfL2Enginerring()
	{ 
		
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,DEVICE TYPE,BRAND,MODELID,PRODUCT NAME,INWARDID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE CATEGORY,COST,REPAIR COST,SHIPPING,LANDING PRICE,COST PRICE,ASIS-NHDP,POD-NHDP,FULL QC-NHDP,NHOP,NHWP,NHW LISTING,WORKING CONDITION,SCREEN CONDITION,HOUSING CONDITION,QC REMARK 3,QC REMARK 4,QC REMARK 5,QC REMARK 6";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$rfsType=$this->Common_model->checkRfsType($value['nhdin']);
				
				$supplierName=$this->Common_model->getVendorNameFormVendorCode($value['vendor_code']);
				
				$typeName='';$brandName='';$nhmod='';
				
				$productDetails=$this->Common_model->getDeviceDetailByNhdin($value['nhdin']);
				
				if(!empty($productDetails))
				{
					$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$productDetails['type_id']));
					
					$brandName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_brand','brand_id',$productDetails['brand_id'])); 
				
					$nhmod=$productDetails['nhmod'];
				}
			 
				$deviceResult=$this->Common_model->getTitleConnectDataByNhdin($value['nhdin']);
 		  
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $rfsType.",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['tax_type'].",";
				$csv_output .= $supplierName.",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= $typeName.",";
				$csv_output .= $brandName.",";
				$csv_output .= $nhmod.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= ",";
				$csv_output .= "QC PASS,";
				$csv_output .= $deviceResult['device_color'].",";
				$csv_output .= $deviceResult['ram'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['camera_front'].",";
				$csv_output .= $deviceResult['camera_main'].",";
				$csv_output .= $deviceResult['display_screen'].",";
				$csv_output .= $deviceResult['processor'].",";
				$csv_output .= $deviceResult['sim_info'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['os'].",";
				$csv_output .= $deviceResult['battery_charging'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['network_brand'].",";
				$csv_output .= $deviceResult['network_type'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['device_condition'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['nhpp'].",";
				$csv_output .= "0,";
				$csv_output .= "0,";
				$csv_output .= $value['nhsp'].",";
				$csv_output .= $value['nhpp'].",,,,,,,,,,,,,,"; 
				$csv_output.="\n";
			}
		}
 
		$file="l2_engineering";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	public function exportCsvOfL3Enginerring()
	{ 
		
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,DEVICE TYPE,BRAND,MODELID,PRODUCT NAME,INWARDID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE CATEGORY,COST,REPAIR COST,SHIPPING,LANDING PRICE,COST PRICE,ASIS-NHDP,POD-NHDP,FULL QC-NHDP,NHOP,NHWP,NHW LISTING,WORKING CONDITION,SCREEN CONDITION,HOUSING CONDITION,QC REMARK 3,QC REMARK 4,QC REMARK 5,QC REMARK 6";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$rfsType=$this->Common_model->checkRfsType($value['nhdin']);
				
				$supplierName=$this->Common_model->getVendorNameFormVendorCode($value['vendor_code']);
				
				$typeName='';$brandName='';$nhmod='';
				
				$productDetails=$this->Common_model->getDeviceDetailByNhdin($value['nhdin']);
				
				if(!empty($productDetails))
				{
					$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$productDetails['type_id']));
					
					$brandName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_brand','brand_id',$productDetails['brand_id'])); 
				
					$nhmod=$productDetails['nhmod'];
				}
			 
				$deviceResult=$this->Common_model->getTitleConnectDataByNhdin($value['nhdin']);
 		  
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $rfsType.",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['tax_type'].",";
				$csv_output .= $supplierName.",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= $typeName.",";
				$csv_output .= $brandName.",";
				$csv_output .= $nhmod.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= ",";
				$csv_output .= "QC PASS,";
				$csv_output .= $deviceResult['device_color'].",";
				$csv_output .= $deviceResult['ram'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['camera_front'].",";
				$csv_output .= $deviceResult['camera_main'].",";
				$csv_output .= $deviceResult['display_screen'].",";
				$csv_output .= $deviceResult['processor'].",";
				$csv_output .= $deviceResult['sim_info'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['os'].",";
				$csv_output .= $deviceResult['battery_charging'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['network_brand'].",";
				$csv_output .= $deviceResult['network_type'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['device_condition'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['nhpp'].",";
				$csv_output .= "0,";
				$csv_output .= "0,";
				$csv_output .= $value['nhsp'].",";
				$csv_output .= $value['nhpp'].",,,,,,,,,,,,,,"; 
				$csv_output.="\n";
			}
		}
 
		$file="l3_engineering";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	
	public function exportCsvOfGrnReport()
	{
		 
		$csv_output="VENDOR CODE,INVOICE NO,INVOICE DATE,INVOICE TYPE,COMPANY CODE,VENDOR NAME,INWARDID,DEVICE TYPE,DEVICE NAME,MODEL NAME,IMEI,IMEI2,COLOR, RAM, ROM";
		
		if($this->session->userdata('user_type')=='1' || $this->session->userdata('department_id')=='6')
    	{
		    $csv_output.=",UNIT PRICE,TAX,TAX TYPE,COST";
    	}
    	
		$csv_output.=",INWARD DATE,STOCK TYPE,STOCK SUBTYPE,WAREHOUSE,BIN NUMBER,ENTRY PASS NO.,REMARK";
		
		$result=$this->db->get('tbl_grnreport')->result_array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{  		 

				$flipcartArray=array('2167','2292','2379','2408','1','2','54','55','107','147','197','198','1570','1571','1586','1587','1589','1628','1643','1758','1797','1834','1836','1837','1948','1953','1976','1985','1995','2020','2022','2023','2068','2069','2077','2078','2079','2080','2127','2155','2273','2290','2291','2327','2336','2343','2344','2379','2407','2408','2449','2450','2458','2460','2461','2462','2463','2479','2482','2483','2484','2485','2545','2589','2590','2592','2593','2604','2605','2613','2615','2642','2643','2645','2646','2661','2677','2678','2679','2682','2683','2684','2707','2708','2709','2714');
				
				$amazonArray=array('2454','2380');
				
				$snapdealArray=array('359');
				
				if($value['vendor_code']=='')
				{
					$companyCode="FLIKART";
				}
				else if(in_array(($value['vendor_code']),$flipcartArray))
				{
					$companyCode="FLIKART";
				}
				else if(in_array(($value['vendor_code']),$amazonArray))
				{
					$companyCode="AMAZON";
				}
				else if(in_array(($value['vendor_code']),$snapdealArray))
				{
					$companyCode="SNAPDEAL";
				}
				else
				{
					$companyCode=$this->Common_model->getFieldValue('name','tbl_vendor','vendor_code',$value['vendor_code']);
				}
				
				$deviceTypeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','nhmod',$value['nhmod']);
				
				$deviceType=$this->Common_model->getFieldValue('name','tbl_device_type','type_id',$deviceTypeId);
				
				$csv_output .= $value['vendor_code'].","; 
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= date("Y-m-d", strtotime($value['invoice_date'])).",";
				$csv_output .= $value['invoice_type'].",";
				$csv_output .= $companyCode.","; 
				$csv_output .= strtoupper($value['vendor_name']).","; 
				$csv_output .= ($value['nhdin']).",";
				$csv_output .= $deviceType.",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['device_name']).",";
				$modelName=$this->Common_model->getFieldValue('model','tbl_product_details','product_name',$value['device_name']);
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $modelName).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['imei1_no']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['imei2_no']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['color']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['ram']).",";
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['rom']).",";
				
				
				
				if($this->session->userdata('user_type')=='1' || $this->session->userdata('department_id')=='6')
            	{
			    	$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['unit_price']).",";
			    	$csv_output .= $value['tax'].",";   
				    $csv_output .= $value['tax_type'].",";   
			    	$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['nhpp']).",";
            	}
            	
				$csv_output .= strftime(config_item('date_format'), strtotime($value['grn_inwarddate'])).",";   
				$csv_output .= $value['stock_type'].",";   
				$csv_output .= $value['stock_subtype'].",";   
				$csv_output .= strtoupper($value['warehouse']).",";   
				$csv_output .= strtoupper($value['bin_number']).",";   
				$csv_output .= $value['entrypass_no'].",";   
				$csv_output .= preg_replace('/[^a-zA-Z0-9-_\.]/',' ', $value['remark']).",";
				$csv_output.="\n";
			}
		}
 
		$file="mrn_report";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfL4Enginerring()
	{ 
		
		$csv_output="LOCATION,RFS TYPE,STOCK TYPE,STOCK SUB TYPE,TAX TYPE,SUPPLIER NAME,SUPPLIER CODE,DEVICE TYPE,BRAND,MODELID,PRODUCT NAME,INWARDID,IMEI 1,IMEI 2,PRODUCT ID,QC STATUS,COLOR,RAM,ROM,FRONT CAMERA,PRIMARY CAMERA,DISPLAY,PROCESSOR,SIM TYPE,CLOCK SPEED,OS,BATTERY,WEIGHT,NETWORK BRAND,NETWORK TYPE,AGEING,DEVICE CONDITION,DEVICE CATEGORY,COST,REPAIR COST,SHIPPING,LANDING PRICE,COST PRICE,ASIS-NHDP,POD-NHDP,FULL QC-NHDP,NHOP,NHWP,NHW LISTING,WORKING CONDITION,SCREEN CONDITION,HOUSING CONDITION,QC REMARK 3,QC REMARK 4,QC REMARK 5,QC REMARK 6";
		
		$result=$this->db->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_l1assessment')->result_array();
		$result=array();
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$rfsType=$this->Common_model->checkRfsType($value['nhdin']);
				
				$supplierName=$this->Common_model->getVendorNameFormVendorCode($value['vendor_code']);
				
				$typeName='';$brandName='';$nhmod='';
				
				$productDetails=$this->Common_model->getDeviceDetailByNhdin($value['nhdin']);
				
				if(!empty($productDetails))
				{
					$typeName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_type','type_id',$productDetails['type_id']));
					
					$brandName=ucfirst($this->Common_model->getFieldValue('name','tbl_device_brand','brand_id',$productDetails['brand_id'])); 
				
					$nhmod=$productDetails['nhmod'];
				}
			 
				$deviceResult=$this->Common_model->getTitleConnectDataByNhdin($value['nhdin']);
 		  
				$csv_output .= $value['warehouse'].",";
				$csv_output .= $rfsType.",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output .= $value['tax_type'].",";
				$csv_output .= $supplierName.",";
				$csv_output .= $value['vendor_code'].",";
				$csv_output .= $typeName.",";
				$csv_output .= $brandName.",";
				$csv_output .= $nhmod.",";
				$csv_output .= strtoupper($value['device_name']).",";
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= ",";
				$csv_output .= "QC PASS,";
				$csv_output .= $deviceResult['device_color'].",";
				$csv_output .= $deviceResult['ram'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['camera_front'].",";
				$csv_output .= $deviceResult['camera_main'].",";
				$csv_output .= $deviceResult['display_screen'].",";
				$csv_output .= $deviceResult['processor'].",";
				$csv_output .= $deviceResult['sim_info'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['os'].",";
				$csv_output .= $deviceResult['battery_charging'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['network_brand'].",";
				$csv_output .= $deviceResult['network_type'].",";
				$csv_output .= ",";
				$csv_output .= $deviceResult['device_condition'].",";
				$csv_output .= $value['category'].",";
				$csv_output .= $value['nhpp'].",";
				$csv_output .= "0,";
				$csv_output .= "0,";
				$csv_output .= $value['nhsp'].",";
				$csv_output .= $value['nhpp'].",,,,,,,,,,,,,,"; 
				$csv_output.="\n";
			}
		}
 
		$file="l4_engineering";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfCertificationDept()
	{
		 
		$csv_output="S.NO,DATE,CATEGORY (UNBOX/PREXO/BUYBACK-E/T/P),WSN,WID,BRAND,MODEL,MODEL NO ( As per Black Belt),NETWORK,COLOUR,RAM,ROM,IMEI 1,IMEI 2,CERTIFICATION GRADE(A/B/C/FF),DEVICE SNO,CHECKED BY,General Comments,ISSUED CAT,,BIN NUMBER,WARHOUSE";
		
		$result=$this->db->where('tbl_certification_dept.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_certification_dept.nhdin')->get('tbl_certification_dept')->result_array();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{ 
				$i++; 
				$csv_output .= $i.","; 
				$csv_output .= $value['created_date'].","; 
				$csv_output .= $value['stock_type'].","; 
				$csv_output .= $value['stock_subtype'].","; 
				$csv_output .= ","; 
				$csv_output .= $value['product_brand'].","; 
				$csv_output .= $value['nhmod'].","; 
				$csv_output .= $value['device_name'].",";  
				$csv_output .= $value['network'].","; 
				$csv_output .= $value['color'].","; 
				$csv_output .= $value['ram'].","; 
				$csv_output .= $value['rom'].","; 
				$csv_output .= $value['imei1_no'].","; 
				$csv_output .= $value['imei2_no'].","; 
				$csv_output .= $value['certification_grade'].","; 
				$csv_output .= $value['nhdin'].","; 
				$csv_output .= $value['checked_by'].","; 
				$csv_output .= $value['remark'].","; 
				$csv_output .= $value['issued_category'].","; 
				$csv_output .= $value['bin_number'].","; 
				$csv_output .= $value['warehouse'].","; 
				$csv_output.="\n";
			}
		}
 
		$file="certification_department";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOfpassCertified()
	{
		 
		$csv_output="INWARD ID,DATE,CATEGORY (UNBOX/PREXO/BUYBACK-E/T/P),WSN,WID,BRAND,MODEL,MODEL NO ( As per Black Belt),NETWORK,COLOUR,RAM,ROM,IMEI 1,IMEI 2,CERTIFICATION GRADE(A/B/C/FF),DEVICE SNO,CHECKED BY,General Comments,ISSUED CAT,BIN NUMBER,WARHOUSE";
		
		$result=$this->db->where('tbl_certification_pass.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_certification_pass.nhdin')->get('tbl_certification_pass')->result_array();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{ 
				$i++; 
				$csv_output .= $value['nhdin'].","; 
				$csv_output .= $value['created_date'].","; 
				$csv_output .= $value['stock_type'].","; 
				$csv_output .= $value['stock_subtype'].","; 
				$csv_output .= ","; 
				$csv_output .= $value['product_brand'].","; 
				$csv_output .= $value['nhmod'].","; 
				$csv_output .= $value['device_name'].",";  
				$csv_output .= $value['network'].","; 
				$csv_output .= $value['color'].","; 
				$csv_output .= $value['ram'].","; 
				$csv_output .= $value['rom'].","; 
				$csv_output .= $value['imei1_no'].","; 
				$csv_output .= $value['imei2_no'].","; 
				$csv_output .= $value['certification_grade'].","; 
				$csv_output .= $value['nhdin'].","; 
				$csv_output .= $value['checked_by'].","; 
				$csv_output .= $value['remark'].","; 
				$csv_output .= $value['issued_category'].","; 
				$csv_output .= $value['bin_number'].","; 
				$csv_output .= $value['warehouse'].","; 
				$csv_output.="\n";
			}
		}
 
		$file="certification_department_pass";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function exportCsvOffailCertified()
	{
		 
		$csv_output="INWARD ID,DATE,CATEGORY (UNBOX/PREXO/BUYBACK-E/T/P),WSN,WID,BRAND,MODEL,MODEL NO ( As per Black Belt),NETWORK,COLOUR,RAM,ROM,IMEI 1,IMEI 2,CERTIFICATION GRADE(A/B/C/FF),DEVICE SNO,CHECKED BY,General Comments,ISSUED CAT,BIN NUMBER,WARHOUSE";
		
		$result=$this->db->where('tbl_certification_fail.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_certification_fail.nhdin')->get('tbl_certification_fail')->result_array();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{ 
				$i++; 
				$csv_output .= $value['nhdin'].","; 
				$csv_output .= $value['created_date'].","; 
				$csv_output .= $value['stock_type'].","; 
				$csv_output .= $value['stock_subtype'].","; 
				$csv_output .= ","; 
				$csv_output .= $value['product_brand'].","; 
				$csv_output .= $value['nhmod'].","; 
				$csv_output .= $value['device_name'].",";  
				$csv_output .= $value['network'].","; 
				$csv_output .= $value['color'].","; 
				$csv_output .= $value['ram'].","; 
				$csv_output .= $value['rom'].","; 
				$csv_output .= $value['imei1_no'].","; 
				$csv_output .= $value['imei2_no'].","; 
				$csv_output .= $value['certification_grade'].","; 
				$csv_output .= $value['nhdin'].","; 
				$csv_output .= $value['checked_by'].","; 
				$csv_output .= $value['remark'].","; 
				$csv_output .= $value['issued_category'].","; 
				$csv_output .= $value['bin_number'].","; 
				$csv_output .= $value['warehouse'].","; 
				$csv_output.="\n";
			}
		}
 
		$file="certification_department_fail";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	 
		
	public function CheckNhdin()
	{	
		$nhdin=$_POST['nhdin'];
 
		$grnCond="nhdin='".$nhdin."' OR old_nhdin='".$nhdin."' or imei1_no='".$nhdin."' or imei2_no='".$nhdin."' or eng_imei_no='".$nhdin."'";
			
		$result=$this->db->where($grnCond)->get('tbl_grnreport')->row();
		
		$invoiceCond="imei1_no='".$nhdin."' or imei2_no='".$nhdin."'";
		
		$invoiceResult=$this->db->where($invoiceCond)->get('tbl_grnreport')->row();
	
		$invoiceCodeResult=$this->db->where('invoice_code',$nhdin)->get('tbl_createinvoice')->row();
		
		$oldStampResult=$this->db->where('nhdin',$nhdin)->get('tbl_oldstamphistory')->row();

		if(empty($result) && empty($invoiceResult) && empty($invoiceCodeResult) && empty($oldStampResult))
		{
			$json['status']='0';
			
			$json['msg']='INVALID INWARDID OR INVOICE NO.PLEASE ENTER CORRECT INWARDID OR INVOICE NO.';
		}
		else
		{
			
			if(!empty($result) || !empty($invoiceResult) || !empty($oldStampResult))
			{
				
				/*==when search by invoice no==*/
				
				if(!empty($invoiceResult))
				{
					$result=$invoiceResult;
				}
				
				/*==when search by old stamp result==*/
				
				if(!empty($oldStampResult))
				{
					$result=$oldStampResult;
				}
				
				$newNhdin=$result->nhdin;
				
				$engResult=$this->db->select('purpose,assessment_id,eng_id')->where('nhdin',$newNhdin)->order_by('assessment_id','DESC')->get('trc_engassessment')->row();
				
				$purpose='';
				
				if(!empty($engResult))
				{
					$engConnectivityResult=$this->db->select('connectivity_id')->where(array('eng_assesment_id'=>$engResult->assessment_id))->get('tbl_title_connectivity')->row();
					
					// if(empty($engConnectivityResult) && $engResult->eng_id!=$this->session->userdata('user_id') && $this->session->userdata('user_type')!='1')
									
					if(empty($engConnectivityResult))
					{
						$purpose='';
					}
					else
					{
						$purpose=$engResult->purpose;
					}					
				}
				
				$html='<h5 class="modal-title" style="margin-top:-8px;margin-bottom: 9px;">
				'.$nhdin.'
				</h5>
				<div class="form-group table-responsive">
					<table id="classTable" class="table table-bordered" style="width:100%">
					  <thead>
					  </thead>
					  <tbody>
						<tr>
						  <td style="width: 13%"><a href="'.base_url('admin/Searchbox/manage_searchbox?nhdin='.str_replace("&","%26",$nhdin).'').'">HISTORY</a></td>
						  <td style="width: 9%;cursor:not-allowed"><a href="#" style="pointer-events:none" >L1</a></td>
						  <td style="width: 9%;cursor:not-allowed"><a href="#" style="pointer-events:none">L2</a></td>
						  <td style="width: 9%;cursor:not-allowed"><a href="#" style="pointer-events:none" >L3</a></td>
						  <td style="width: 10%;cursor:not-allowed"><a href="#" style="pointer-events:none" >L4</a></td>
						  <td style="width: 10%; '; if($purpose!='OUTQC'){ $html.='cursor:not-allowed'; }else { $html.='background-color:gray'; } $html.='"><a href="'.base_url().'admin/Trc/manage_engassesment?nhdin='.$nhdin.'&status=OUTQC" style=" '; if($purpose!='OUTQC'){ $html.='pointer-events:none'; }else{ $html.='color:white'; } $html.=' ">OUT QC</a></td>
						  <td style="width: 10%; '; if($purpose!='IN QC'){ $html.='cursor:not-allowed'; }else { $html.='background-color:gray'; } $html.='"><a href="'.base_url().'admin/Trc/manage_engassesment?nhdin='.$nhdin.'&status=IN QC" style=" '; if($purpose!='IN QC'){ $html.='pointer-events:none'; }else{ $html.='color:white'; } $html.=' " >IN QC</a></td>
						  <td style="width: 10%; '; if($purpose!='ASS'){ $html.='cursor:not-allowed'; }else { $html.='background-color:gray'; } $html.=' "><a href="'.base_url().'admin/Trc/manage_engassesment?nhdin='.$nhdin.'&status=ASS"  style=" '; if($purpose!='ASS'){ $html.='pointer-events:none'; }else{ $html.='color:white'; } $html.=' " >ASS</a></td>
						  <td style="width: 10%;cursor:not-allowed"><a href="#" style="pointer-events:none" >SPARE</a></td> 
						</tr>
					  </tbody>
					</table>
				  </div>';
				$json['type']='nhdin';
				$json['status']='1';
				$json['html']=$html;
			}   
			else
			{
				$allInvoiceResult=$this->db->group_by('invoice_code')->select('COUNT(invoice_id) as total,SUM(nhsp) as totalValue')->where('invoice_code',$nhdin)->get('tbl_createinvoice')->row_array();
				
				if($invoiceCodeResult->sale_channel=='OFFLINE')
				{
					$customerName=$this->Common_model->getVendorNameFormVendorCode($invoiceCodeResult->vendor_code);
					
					$channelType='OFFLINE';
				}
				else
				{
					$customerName=$this->db->select('name')->where('vendor_code',$invoiceCodeResult->vendor_code)->get('tbl_createinvoice')->row()->name;
					
					$channelType='ONLINE';
				}
				
				$html=' <div>
				  <div class="table-responsive">
					<table id="classTable" class="table">
					  <thead>
					  </thead>
					  <tbody>
						<tr>
						  <td>INWARDID</td>
						  <td>:</td>
						  <td style="text-align:left">'.$invoiceCodeResult->nhdin.'</td>
						</tr>
						<tr>
						  <td>Total QTY</td>
						   <td>:</td>
						  <td style="text-align:left">'.$allInvoiceResult['total'].' NOS</td>
						</tr>
						<tr>
						  <td>INVOICE VALUE</td>
						  <td>:</td>
						  <td style="text-align:left" >'.number_format($allInvoiceResult['totalValue']).'</td>
						</tr>
						<tr>
						  <td>CUSTOMER NAME</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$customerName.'</td>
						</tr>
						<tr>
						  <td>CHANNEL TYPE</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$channelType.'</td>
						</tr>
						<tr>
						  <td>CHANNEL NAME</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$invoiceCodeResult->sale_channel.'</td>
						</tr>
						<tr>
						  <td>BUYER CODE</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$invoiceCodeResult->vendor_code.'</td>
						</tr>
						<tr>
						  <td>INVOICE NO.</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$invoiceCodeResult->invoice_code.'</td>
						</tr>
						<tr>
						  <td>INVOICE DATE</td>
						  <td>:</td>
						  <td style="text-align:left" >'.$invoiceCodeResult->created_date.' &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a target="_blank" href="'.base_url().'admin/Finance/printCreateInvoiceData/'.$invoiceCodeResult->invoice_code.'" class="btn btn-primary">VIEW</a></td>
						</tr>
					  </tbody>
					</table>
				  </div>
				  </div>';
					  
				$json['type']='soldinvoice';
				$json['status']='1';
				$json['html']=$html;
			}
		}
		
		echo json_encode($json);
		die;
	}

	public function exportCsvOfSalesOrder()
	{
		$this->load->model('SalesOrder_model');
		$csv_output="SALESORDER ID,CODE,VENDOR,SALES REPRESENTATIVE,STATUS,CREATION DATE,UPDATE DATE,CREATED BY,UPDATED BY, AMOUNT";
		
		$result=$this->SalesOrder_model->get_salesorder();
		 
		$csv_output.="\n";
		
		if(!empty($result))
		{
			$i=0;
			foreach($result as $value)
			{ 
				$i++; 
				$csv_output.=$value['salesorder_id'].",";
				$csv_output.=$value['salesorder_code'].",";
				$csv_output.=$value['vendor_name'].",";
				$csv_output.=$value['fullname'].",";
				$csv_output.=$value['status'].",";
				$csv_output.=date('d-m-Y', strtotime($value['CREATION_DATE'])).",";
				$csv_output.=date('d-m-Y', strtotime($value['LAST_UPDATE_DATE'])).",";
				$csv_output.=$value['CREATED_BY'].",";
				$csv_output.=$value['LAST_UPDATED_BY'].",";
				$csv_output.=$value['amount'].",";
				$csv_output.="\n";
			}
		}
 
		$file="Salesorderlist";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
}
