<?php

class Customer_escalation extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function manage_customer_escalation($active = 0)
    {
        $data['active'] = 1;

        if ($active > 0) {
            $data['active'] = $active;
        }

        $data['title'] = 'CUSTOMER ESCALATION';
        $data['subview'] = $this->load->view('admin/customer_escalation/manage_customer_escalation', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    function getDeviceDetails()
    {

        $invoice_id = $this->input->get('invoice_id');
        $device_id = $this->input->get('device_id');

        $where_arr = array(
            "nhdin" => $device_id,
            "invoice_id" => $invoice_id
        );
        $result = $this->db->select('nhdin, certification_grade')->where($where_arr)->get('INVOICE_PDF_ROWS_VIEW')->row();

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $device_row = $this->db->select('device_name, checked_by, imei1_no, imei2_no')->where('nhdin', $device_id)->get('tbl_grnreport')->row();
        $record = array(
            "device_name" => $device_row->device_name,
            "grade" => $result->certification_grade,
            "certification_remarks" => $device_row->checked_by,
            "imei_1" => $device_row->imei1_no,
            "imei_2" => $device_row->imei2_no,
            "triage_remarks" => ""
        );

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

    public function createNewEscalation()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(escl_no,"-",-1) as UNSIGNED)) as max')->from('tbl_customer_escl')->get()->row_array();
        $next_number = $res['max'] + 1;
        $escl_no = 'CEN-' . $next_number;

        $record = array(
            "escl_no" => $escl_no,
            "invoice_no" => $data['invoice_no'],
            "device_id" => $data['device_id'],
            "escl_type" => $data['escalation_type'],
            "assigned_to" => "OPERATIONS",
            "device_issue_type" => $data['damage_device_issue'],
            "device_grade" => $data['device_grade'],
            "physical_device" => $data['physical_device'],
            "status" => "OPEN",
            "creation_date" => date("Y-m-d H:i:s"),
            "created_by" => $this->session->userdata('user_name')
        );

        $this->db->trans_start();
        $this->db->insert('tbl_customer_escl', $record);

        $escl_id = $this->db->insert_id();

        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'CERTIFICATION',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['certification_remarks'],
            "date" => date("Y-m-d H:i:s")
        );

        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'TRIAGE',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['triage_remarks'],
            "date" => date("Y-m-d H:i:s")
        );

        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'CUSTOMER',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['customer_remarks'],
            "date" => date("Y-m-d H:i:s")
        );

        $this->db->insert_batch('tbl_customer_escl_remarks', $remark_array);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getEscalationList()
    {
        $records = [];
        $status = $this->input->get('status');
        $result = $this->db->where('status', $status)->get('tbl_customer_escl')->result_array();

        foreach ($result as $rowValue) {

            $vendor_name = $this->db->select('vendor_name')->where('invoice_code', $rowValue['invoice_no'])->get('INVOICE_LIST_VIEW')->row()->vendor_name;
            $device_row = $this->db->select('device_name, ram, rom')->where('nhdin', $rowValue['device_id'])->get('tbl_grnreport')->row();
            $records[] = array(
                "customer_escl_id" => $rowValue['customer_escl_id'],
                "escl_no" => $rowValue['escl_no'],
                "vendor_name" => $vendor_name,
                "invoice_no" => $rowValue['invoice_no'],
                "device_id" => $rowValue['device_id'],
                "variant" => $device_row->device_name . '-' . $device_row->ram . '-' . $device_row->rom,
                "device_grade" => $rowValue['device_grade'],
                "device_issue_type" => $rowValue['device_issue_type'],
                "status" => $rowValue['status'],
                "escl_status" => $rowValue['escl_status'],
                "escl_type" => $rowValue['escl_type'],
                "assigned_to" => $rowValue['assigned_to'],
                "created_by" => $rowValue['created_by'],
                "last_updated_by" => $rowValue['last_updated_by'],
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getCustomerEscalationHeader()
    {
        $customer_escl_id = $this->input->get('customer_escl_id');

        if (empty($customer_escl_id)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('customer_escl_id', $customer_escl_id)->get('tbl_customer_escl')->row();

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $vendor_name = $this->db->select('vendor_name')->where('invoice_code', $result->invoice_no)->get('INVOICE_LIST_VIEW')->row()->vendor_name;
        $device_det = $this->db->select('device_name, imei1_no, imei2_no')->where('nhdin', $result->device_id)->get('tbl_grnreport')->row();

        $records = array(
            "customer_escl_id" => $result->customer_escl_id,
            "escl_no" => $result->escl_no,
            "vendor_name" => $vendor_name,
            "device_name" => $device_det->device_name,
            "imei1_no" => $device_det->imei1_no,
            "imei2_no" => $device_det->imei2_no,
            "invoice_no" => $result->invoice_no,
            "device_id" => $result->device_id,
            "device_grade" => $result->device_grade,
            "device_issue_type" => $result->device_issue_type,
            "status" => $result->status,
            "escl_status" => $result->escl_status,
            "escl_type" => $result->escl_type,
            "assigned_to" => $result->assigned_to,
            "created_by" => $result->created_by,
            "last_updated_by" => $result->last_updated_by,
            "creation_date" => date("d-m-Y", strtotime($result->creation_date)),
            "last_update_date" => date("d-m-Y", strtotime($result->last_update_date)),
        );
        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getEscalationRemarks()
    {
        $customer_escl_id = $this->input->get('customer_escl_id');

        $result = $this->db->where('customer_escl_id', $customer_escl_id)->order_by('date', 'DESC')->order_by('remarks_id', 'DESC')->get('tbl_customer_escl_remarks')->result_array();
        $records = [];
        foreach ($result as $rowValue) {
            $records[] = array(
                "date" => date("d-m-Y h:i A", strtotime($rowValue['date'])),
                "department" => $rowValue['department'],
                "remarks_by" => $rowValue['remarks_by'],
                "remarks" => $rowValue['remarks'],
            );
        }

        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function updateOpsEscalationForm($customer_escl_id = 0)
    {
        if (empty($customer_escl_id) || (int) $customer_escl_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'CUSTOMER ESCALATION';
        } else {

            $data['active'] = 3;
            $data['title'] = 'UPDATE CUSTOMER ESCALATION';
            $data['update_ops_customer_escl_id'] = $customer_escl_id;
        }

        $data['subview'] = $this->load->view('admin/customer_escalation/manage_customer_escalation', $data, TRUE);

        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateCertificationEscalationForm($customer_escl_id = 0)
    {
        if (empty($customer_escl_id) || (int) $customer_escl_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'CUSTOMER ESCALATION';
        } else {

            $data['active'] = 4;
            $data['title'] = 'UPDATE CUSTOMER ESCALATION';
            $data['update_cert_customer_escl_id'] = $customer_escl_id;
        }

        $data['subview'] = $this->load->view('admin/customer_escalation/manage_customer_escalation', $data, TRUE);

        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateTriageEscalationForm($customer_escl_id = 0)
    {
        if (empty($customer_escl_id) || (int) $customer_escl_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'CUSTOMER ESCALATION';
        } else {

            $data['active'] = 5;
            $data['title'] = 'UPDATE CUSTOMER ESCALATION';
            $data['update_trg_customer_escl_id'] = $customer_escl_id;
        }

        $data['subview'] = $this->load->view('admin/customer_escalation/manage_customer_escalation', $data, TRUE);

        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function UpdateOpsEscalation()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if (empty($data) || (int) $data['customer_escl_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $escl_id = $data['customer_escl_id'];
        $curr_status = $this->db->select('status')->where('customer_escl_id', $escl_id)->get('tbl_customer_escl')->row()->status;
        if ($curr_status == 'OPEN') {
            $assign = 'CERTIFICATION';
            $status = 'IN_PROGRESS';
        }
        if ($curr_status == 'IN_PROGRESS') {
            $assign = 'TRIAGE';
            $status = 'IN_PROGRESS';
        }

        $remark_check = $this->db->select('department')->where('customer_escl_id', $escl_id)->order_by('remarks_id', 'DESC')->get('tbl_customer_escl_remarks')->row()->department;

        if ($remark_check == 'TRIAGE - AFT' || $data['close_escl'] == true) {
            $status = 'COMPLETE';
            $assign = 'OPERATIONS';
        }

        $record = array(
            "customer_escl_id" => $data['customer_escl_id'],
            "status" => $status,
            "assigned_to" => $assign,
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_name')
        );

        $this->db->trans_start();
        $this->db->update('tbl_customer_escl', $record, array('customer_escl_id' => $record['customer_escl_id']));

        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $remark_array = [];

        if (!empty($data['rca_remarks'])) {
            $remark_array[] = array(
                'customer_escl_id' => $escl_id,
                'department' => 'OPS - RCA',
                'remarks_by' => $this->session->userdata('user_name'),
                'remarks' => $data['rca_remarks'],
                "date" => date("Y-m-d H:i:s")
            );
        }
        if (!empty($data['findings_remarks'])) {
            $remark_array[] = array(
                'customer_escl_id' => $escl_id,
                'department' => 'OPS - FINDINGS',
                'remarks_by' => $this->session->userdata('user_name'),
                'remarks' => $data['findings_remarks'],
                "date" => date("Y-m-d H:i:s")
            );
        }
        if (!empty($data['action_taken_remarks'])) {
            $remark_array[] = array(
                'customer_escl_id' => $escl_id,
                'department' => 'OPS - ACTION TAKEN',
                'remarks_by' => $this->session->userdata('user_name'),
                'remarks' => $data['action_taken_remarks'],
                "date" => date("Y-m-d H:i:s")
            );
        }

        $this->db->insert_batch('tbl_customer_escl_remarks', $remark_array);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function UpdateCertEscalation()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if (empty($data) || (int) $data['customer_escl_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $escl_id = $data['customer_escl_id'];

        $record = array(
            "customer_escl_id" => $data['customer_escl_id'],
            "status" => "IN_PROGRESS",
            "assigned_to" => "OPERATIONS",
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_name')
        );

        $this->db->trans_start();
        $this->db->update('tbl_customer_escl', $record, array('customer_escl_id' => $record['customer_escl_id']));

        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $remark_array = [];

        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'ODD Done',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['odd_done'],
            "date" => date("Y-m-d H:i:s")
        );


        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'CERTIFICATION',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['cert_remarks'],
            "date" => date("Y-m-d H:i:s")
        );


        $this->db->insert_batch('tbl_customer_escl_remarks', $remark_array);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function UpdateTriageEscalation()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if (empty($data) || (int) $data['customer_escl_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $escl_id = $data['customer_escl_id'];

        $record = array(
            "customer_escl_id" => $data['customer_escl_id'],
            "status" => "IN_PROGRESS",
            "assigned_to" => "OPERATIONS",
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_name')
        );

        $this->db->trans_start();
        $this->db->update('tbl_customer_escl', $record, array('customer_escl_id' => $record['customer_escl_id']));

        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $remark_array = [];

        $remark_array[] = array(
            'customer_escl_id' => $escl_id,
            'department' => 'TRIAGE - AFT',
            'remarks_by' => $this->session->userdata('user_name'),
            'remarks' => $data['cert_remarks'],
            "date" => date("Y-m-d H:i:s")
        );

        $this->db->insert_batch('tbl_customer_escl_remarks', $remark_array);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
}
