<?php 

class CreditNotes extends Admin_Controller
{
    public function __construct()
    {
		parent::__construct();
	   	$this->load->model('creditnotes_model');
	   	$this->load->model('auditlog_model');
		$this->load->library('hostbooks_authenticator');
        log_message('error','In controller');

	}
	
	public function manage_salesreturn($active=0){
		
		$data['title'] = "SALES RETURN";
		if($active>0){
			$data['active'] = $active;
		}else{
			$data["active"] = 1;
		}
		
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
	}

	public function updateSalesReturnForm($salesreturn_id){
		
		$data['salesreturn_id'] = $salesreturn_id;
		$data['title'] = "UPDATE SALES RETURN";
		$data["active"] = 3;
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
	}

	public function updateSalesReturnOfflineForm($salesreturn_id){
		
		$data['salesreturn_id'] = $salesreturn_id;
		$data['title'] = "UPDATE SALES RETURN";
		$data["active"] = 10;
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
	}
	 
	public function updateWHSalesReturnForm($salesreturn_id){
		
		$data['salesreturn_id'] = $salesreturn_id;
		$data['title'] = "UPDATE SALES RETURN";
		$data["active"] = 5;
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
	}
	 
	public function updateLostSalesReturnForm($salesreturn_id){
		
		if($salesreturn_id>0){
			$data['lost_salesreturn_id'] = $salesreturn_id;
			$data['title'] = "UPDATE SALES RETURN";
			$data["active"] = 8;
		}else{
			$data['title'] = "SALES RETURN";
			$data['active'] = 1;
		}
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
 	}
  
	 public function getDeviceInfoBySalesReference(){

		$sales_channel = $this->input->get('channel');
		$saleschannel_ref_id = $this->input->get('ref_id');
		
		$result = $this->creditnotes_model->getDeviceInfoBySalesReference($sales_channel,$saleschannel_ref_id);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
    }

    public function getDeviceInfoByInvoice(){
    	$invoice_code = $_GET['invoice_code'];
		
		$result = $this->creditnotes_model->getDeviceInfoByInvoice($invoice_code);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}

		$invoice = $this->db->select('invoice_id')->where('invoice_code',$invoice_code)->get('tbl_invoice')->row();

		$json['invoice'] = $invoice->invoice_id;
 		$json['status'] = 1;
		$json["rows"] = $result; 
		echo json_encode($json);
		die;
	}
	
	public function getDeviceInfoByInvoiceId(){
		
		$invoice_id = $this->input->get('invoice_id');

		$result = $this->db->where('invoice_id', $invoice_id)->get('SEARCHBY_INVOICE_VIEW')->result_array();

        if(!empty($result) && count($result)==0){
			
			$json['status']=0;
			http_response_code(500);
			echo json_encode($json);
			die;
		}

		$this->db->select('tbl_invoice.invoice_code, tbl_invoice.warehouse, tbl_salesorder.sales_channel, tbl_salesorder.saleschannel_ref_id');
		$this->db->join('tbl_salesorder', 'tbl_salesorder.salesorder_id=tbl_invoice.salesorder_id','Left');
		
		$salesorder = $this->db->where('invoice_id',$invoice_id)->get('tbl_invoice')->row();

		$json['sales_channel'] = $salesorder->sales_channel;
		$json['saleschannel_ref_id'] = $salesorder->saleschannel_ref_id;
		$json['invoice_code'] = $salesorder->invoice_code;
		$json['warehouse'] = $salesorder->warehouse;
 		$json['status'] = 1;
		$json["rows"] = $result; 
		echo json_encode($json);
		die;
    }

    public function getDeviceInfoByIMEI(){
    	$imei1_no = $_GET['imei1_no'];
		
		$result = $this->creditnotes_model->getDeviceInfoByIMEI($imei1_no);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
    }

     public function getDeviceInfoById(){
    	$deviceid = $_GET['deviceid'];
		
		$result = $this->creditnotes_model->getDeviceInfoById($deviceid);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
	}

	public function getInvoiceByDeviceId(){
    	$device_id = $_GET['device_id'];
		
		$result = $this->creditnotes_model->getInvoiceByDeviceId($device_id);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
	}

	public function getInvoiceNo(){
    	$name = $_GET['name'];
		
		$result = $this->creditnotes_model->getInvoiceNo($name);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
	}

	public function getInvoiceByImei(){
    	$imei1_no = $_GET['imei1_no'];
		
		$result = $this->creditnotes_model->getInvoiceByImei($imei1_no);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
	}

	public function getInvoiceBySalesChanelRefId(){
    	$refid = $_GET['refid'];
		
		$result = $this->creditnotes_model->getInvoiceBySalesChanelRefId($refid);
        if(!empty($result) && count($result)==0){
			$json['status']=0;
			
			http_response_code(500);
			echo json_encode($json);
			die;
		}
		
		$json = $result; 
		echo json_encode($json);
		die;
	}
	
	
		
	public function createSalesReturn(){
		
		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);
		
		$res=$this->db->select('max(CAST(SUBSTRING_INDEX(salesreturn_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesreturn')->get()->row_array();
       		$next_number=$res['max']+1;
		$salesreturn_code='SR-'.$data[0]["warehouse"].'-'.$next_number;
		   
		$record = array(
			"saleschannel"=> $data[0]["sales_channel"],
			"saleschannel_refid"=> $data[0]["saleschannel_ref_id"],
			"mode_of_receipt"=>$data[0]["mode_of_receipt"],
			"status"=>"PENDING",
			"salesreturn_code"=>$salesreturn_code,
			"claim_required" => $data[0]["claim_required"],
			"auto_claim" => $data[0]["auto_claim"],
			"delivered_by"=>$data[0]["delivered_by"],
			"quantity"=>$data[0]["quantity"],
			"no_of_pkg"=>$data[0]["package_no"],
			"invoice_no"=>$data[0]["invoice_no"],
			"docket_no"=>$data[0]["docket_no"],
			"return_type"=>$data[0]["return_type"],	
			"reason_for_return"=>$data[0]["reason_for_return"],	
			"warehouse"=>$data[0]["warehouse"],		
			"CREATED_BY"=>$this->session->userdata('user_id'),
			"created_date"=>date("Y-m-d H:i:s")
		);

		// Start Inserting

		$this->db->trans_start(FALSE);
		$id = $this->db->insert('tbl_salesreturn',$record);
		

		if($id>0){
			$this->db->trans_complete();
			$json["status"] = 1;
		}else{
			$this->db->trans_rollback();
			$json["status"] = 0;
		}
		
		echo json_encode($json);
		die;
	}
	
	public function updateSalesReturn(){
		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$record = array(
			"salesreturn_id"=>$data[0]["salesreturn_id"],
			"saleschannel"=> $data[0]["sales_channel"],
			"saleschannel_refid"=> $data[0]["saleschannel_ref_id"],
			"mode_of_receipt"=>$data[0]["mode_of_receipt"],
			"status"=>"WH_PENDING",
			"invoice_id"=>$data[0]["invoice_id"],
			"claim_required" => $data[0]["claim_required"],
			"auto_claim" => $data[0]["auto_claim"],
			"delivered_by"=>$data[0]["delivered_by"],
			"quantity"=>$data[0]["quantity"],
			"no_of_pkg"=>$data[0]["package_no"],
			"invoice_no"=>$data[0]["invoice_no"],
			"docket_no"=>$data[0]["docket_no"],
			"return_type"=>$data[0]["return_type"],
			"returned_date"=>$data[0]["returned_date"],	
			"reason_for_return"=>$data[0]["reason_for_return"],	
			"warehouse"=>$data[0]["warehouse"],		
			"LAST_UPDATED_BY"=>$this->session->userdata('user_id'),
			"last_modified"=>date("Y-m-d H:i:s")
		);
		
		$this->db->trans_start();
		$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$record['salesreturn_id']));
		$error=$this->db->error();
		if($error['code']!=0){

			$this->db->trans_rollback();
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		$dataItems = $data[0]["rows"];
		$records= array();
		$invoice_item_id_arr = [];

		foreach($dataItems as $data){
			$grn = $this->db->select('grnreport_id')->where('nhdin',$data["device_id"])->get('tbl_grnreport')->row();
			$records[] = array(
				"salesreturn_id"=>$data["salesreturn_id"],
				"device_id"=> $grn->grnreport_id,
				"product_condition"=>$data["product_condition"],
				"received_product"=>$data["received_product"],
				"damage_type"=>$data["damage_type"],
				"dent_type"=>$data["dent_type"],
				"remarks"=>$data["remarks"],
				"invoice_item_id"=>$data["invoice_item_id"],
			);
			$invoice_item_id_arr[] = $data["invoice_item_id"];
		}

		$exis_items = $this->db->where_in('invoice_item_id',$invoice_item_id_arr)
				->join('tbl_salesreturn_item', 'tbl_salesreturn_item.salesreturn_id = tbl_salesreturn.salesreturn_id', 'Left')
 				->where('tbl_salesreturn.status !=', 'CANCEL')
				->get('tbl_salesreturn')->result_array();

		if(!empty($exis_items)){
			
			$this->db->trans_rollback();
			$json['status']=0;
			$json['message'] = 'Return Already Created For Some Items';
			echo json_encode($json);
			die;
		}
		$this->db->insert_batch('tbl_salesreturn_item',$records);
		$error = $this->db->error();
		
		if($error['code']!=0){
			$this->db->trans_rollback();
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		
		$this->db->trans_complete();
		$json["status"]=1;
		echo json_encode($json);
		die;
	}
	
	public function bulk_update_salesreturn() {
		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$crnt_date = date("Y-m-d H:i:s");

		$device_ids = [];
		$sales_return_wise = [];
		foreach($data['devices'] as $row) {
			$sales_return_wise[ $row['sales_return_code'] ][] = $row;

			if (in_array($row['deviceid'], $device_ids)) {
				$msg = $row['deviceid'] . ' device entry came multiple times';
				GOTO ERROR;
			}
			$device_ids[] = $row['deviceid'];
		}

		// echo json_encode($sales_return_wise); exit;

		$prod_cond_types = [];
		$where_arr = ['CONDITION', 'DAMAGE', 'DENTS'];
		foreach($where_arr as $val) {
			$prod_cond_types[$val] = [];
		}
		$rs = $this->db->from('tbl_dropdown')->where_in('type', $where_arr)->order_by('type')->order_by('value')->get()->result_array();
		foreach($rs as $row) {
			$prod_cond_types[ $row['type'] ][] = $row['name'];
		}
		// echo json_encode($prod_cond_types);exit;

		$sr_records = [];
		$sri_records = [];
		$invoice_item_id_arr = [];

		foreach($sales_return_wise as $sr_code => $sr_row) {
			$rs = $this->db->from('tbl_salesreturn AS sr')
			              ->join('tbl_invoice AS inv', 'inv.invoice_id = sr.invoice_id')
						  ->join('tbl_invoice_item AS ini', 'ini.invoice_id = inv.invoice_id')
						  ->join('tbl_grnreport AS d', 'd.grnreport_id = ini.grnreport_id')
						  ->where('sr.salesreturn_code', $sr_code)
						  ->select('sr.salesreturn_id, ini.invoice_item_id, ini.grnreport_id, d.nhdin')
						  ->get()->result_array();

			$device_wise = [];
			foreach($rs as $row) {
				$device_wise[ $row['nhdin'] ] = $row;
			}

			foreach($sr_row as $row) {
				if (!isset($device_wise[ $row['deviceid'] ])) {
					$msg = 'Device ' . $row['deviceid'] . ' is not a part of SalesReturnCode- ' . $sr_code;
					GOTO ERROR;
				}

				$info = $device_wise[ $row['deviceid'] ];

				if (!in_array($row["prod_cond"], $prod_cond_types['CONDITION']) && ($row["prod_cond"] != '')) {
					$msg = 'Please check the Product Condition for the device '. $row['deviceid'];
					GOTO ERROR;
				}
				if (!in_array($row["prod_damage"], $prod_cond_types['DAMAGE']) && ($row["prod_damage"] != '')) {
					$msg = 'Please check the Damage Type for the device '. $row['deviceid'];
					GOTO ERROR;
				}
				if (!in_array($row["prod_dents"], $prod_cond_types['DENTS']) && ($row["prod_dents"] != '')) {
					$msg = 'Please check the Dent Type for the device '. $row['deviceid'];
					GOTO ERROR;
				}

				$sri_records[] = array(
					"salesreturn_id"=>$info["salesreturn_id"],
					"invoice_item_id"=>$info["invoice_item_id"],
					"device_id"=> $info['grnreport_id'],
					"received_product"=>$row["prod_received"],
					"product_condition"=>$row["prod_cond"],
					"damage_type"=>$row["prod_damage"],
					"dent_type"=>$row["prod_dents"],
					"remarks"=>$row["remarks"],
					'created_date' => $crnt_date,
					'user_id' => $this->session->userdata('user_id')
				);
				$invoice_item_id_arr[] = $info["invoice_item_id"];

				if (!isset( $sr_records[ $info["salesreturn_id"] ] )) {
					$sr_records[ $info["salesreturn_id"] ] = [
						'salesreturn_id' => $info["salesreturn_id"],
						"status" => "WH_PENDING",
						"returned_date" => $crnt_date,	
						"LAST_UPDATED_BY" => $this->session->userdata('user_id'),
						"last_modified" => $crnt_date
					];
				}
			}
		}

		$exis_items = $this->db->where_in('invoice_item_id',$invoice_item_id_arr)
				->join('tbl_salesreturn_item', 'tbl_salesreturn_item.salesreturn_id = tbl_salesreturn.salesreturn_id', 'Left')
 				->where('tbl_salesreturn.status !=', 'CANCEL')
				->get('tbl_salesreturn')->result_array();

		if(!empty($exis_items)) {
			$msg = 'Return Already Created For Some Items';
			GOTO ERROR;
		}

		// echo json_encode($sri_records); exit;
		// echo json_encode(array_values($sr_records)); exit;

		$this->db->trans_start();
		
		$this->db->insert_batch('tbl_salesreturn_item', $sri_records);
		if ($this->db->error()['code'] != 0) { GOTO ERROR; }

		$this->db->update_batch('tbl_salesreturn', array_values($sr_records), 'salesreturn_id');
		if ($this->db->error()['code'] != 0) { GOTO ERROR; }
		
		$this->db->trans_complete();
		
        echo json_encode([
            'status' => true,
            'message' => 'Sales Returns are updated with the Device IDs whose count is '. count($sri_records)
        ]);
        exit;

		ERROR:
		$this->db->trans_rollback();
		
		echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request'
        ]);
        exit;

	}
	
	public function createSalesReturnFromInvoice(){

		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$status = $this->db->select('status')->where('invoice_id',$data[0]["invoice_id"])->get('tbl_invoice')->row();

		if($status->status != "SHIPPED" && $status->status != "PART_RETURN"){
			$json["status"] = 0;
			echo json_encode($json);
			die;
		}

		$res=$this->db->select('max(CAST(SUBSTRING_INDEX(salesreturn_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesreturn')->get()->row_array();
       	$next_number=$res['max']+1;
		$salesreturn_code='SR-'.$data[0]["warehouse"].'-'.$next_number;

		$record = array(
			"salesreturn_id"=>$data[0]["salesreturn_id"],
			"saleschannel"=> $data[0]["sales_channel"],
			"saleschannel_refid"=> $data[0]["saleschannel_ref_id"],
			"mode_of_receipt"=>$data[0]["mode_of_receipt"],
			"status"=>"IN_TRANSIT",
			"salesreturn_code"=>$salesreturn_code,
			"invoice_id"=>$data[0]["invoice_id"],
			"claim_required" => $data[0]["claim_required"],
			"auto_claim" => $data[0]["auto_claim"],
			"delivered_by"=>$data[0]["delivered_by"],
			"quantity"=>$data[0]["quantity"],
			"request_date"=>$data[0]["requested_date"],
			"no_of_pkg"=>$data[0]["package_no"],
			"invoice_no"=>$data[0]["invoice_no"],
			"docket_no"=>$data[0]["docket_no"],
			"return_type"=>$data[0]["return_type"],	
			"reason_for_return"=>$data[0]["reason_for_return"],	
			"warehouse"=>$data[0]["warehouse"],		
			"CREATED_BY"=>$this->session->userdata('user_id'),
			"last_modified"=>date("Y-m-d H:i:s")
		);
		
		$this->db->trans_start();
		$this->db->insert('tbl_salesreturn',$record);

		$salesreturn_id = $this->db->insert_id();

		$error=$this->db->error();
		if($error['code']!=0){

			$this->db->trans_rollback();
			$json['status']=0;
			echo json_encode($json);
			die;
		}


		
		$this->db->trans_complete();
		$json["status"]=1;
		echo json_encode($json);
		die;

	}
	
	public	function getDeviceKey($device_id){
	
		$result = $this->db->select('grnreport_id')->where('nhdin',$device_id)->get('tbl_grnreport')->row();
		return $result->grnreport_id;
	}

	public function getInvoiceCode(){
		
		$sales_channel = $this->input->get('sales_channel');
		$saleschannel_ref_id = $this->input->get('saleschannel_ref_id');
		$where_arr = array(
						"tbl_salesorder.sales_channel"=>$sales_channel,
						"tbl_salesorder.saleschannel_ref_id"=>$saleschannel_ref_id
					);

		$this->db->select('tbl_invoice.invoice_code')->where($where_arr);
		$this->db->from('tbl_invoice');
		$this->db->join('tbl_salesorder','tbl_invoice.salesorder_id=tbl_salesorder.salesorder_id');
		$invoice_data= $this->db->get()->row();
		//print $this->db->last_query();exit;
		if(!empty($invoice_data)){
			$json["invoice_code"] = $invoice_data->invoice_code;
		}else{
			$json["invoice_code"] = "";
		}

		echo json_encode($json);
		die;
	}


	public function getSalesReturnList(){
		
		$status=$this->input->get('status');
		$data=array();
		$json=array();
		$result=$this->creditnotes_model->getSalesReturnList($status);
      	if(!empty($result)){
			foreach($result as $rowValue){
			    $returned_date = date("d-m-Y", strtotime($rowValue['returned_date']));
 				if($returned_date == '01-01-1970' || $returned_date == '30-11--0001'){
             		$returned_date = '';
				}
				$request_date = date("d-m-Y", strtotime($rowValue['request_date']));
 				if($request_date == '01-01-1970' || $request_date == '30-11--0001'){
             		$request_date = '';
        		}
      
                $data[]=array(
					"salesreturn_id"=>$rowValue['salesreturn_id'],
					"salesreturn_code"=>$rowValue['salesreturn_code'],
					"creditnote_code"=>$rowValue['creditnote_code'],
					"vendor_name"=>$rowValue['vendor_name'],
					"invoice_qty"=>$rowValue['invoice_qty'],
					"saleschannel"=>$rowValue['saleschannel'],
					"saleschannel_refid"=>$rowValue['saleschannel_refid'],
					"mode_of_receipt"=>$rowValue['mode_of_receipt'],
					"status"=>$rowValue['status'],
					"claim_no" => $rowValue["claim_no"],
					"delivered_by"=>$rowValue['delivered_by'],
					"quantity"=>$rowValue['quantity'],
					"no_of_pkg"=>$rowValue['no_of_pkg'],
					"invoice_no"=>$rowValue['invoice_no'],
					"claim_required"=>$rowValue['claim_required'],
					"auto_claim"=>$rowValue['auto_claim'],
					"return_type"=>$rowValue['return_type'],
					"reason_for_return"=>$rowValue['reason_for_return'],
					"returned_date"=>$returned_date,
					"request_date" =>$request_date,
					"docket_no"=>$rowValue['docket_no'],
					"warehouse"=>$rowValue['warehouse'],
					"created_date"=>date("d-m-Y",strtotime($rowValue['created_date'])),
					"last_modified"=>date("d-m-Y",strtotime($rowValue['last_modified'])),
					"CREATED_BY"=>$rowValue['CREATED_BY'],
					"LAST_UPDATED_BY"=>$rowValue['LAST_UPDATED_BY'],
				);
					 
			}
		}
		$json["data"]=$data;

		echo json_encode($json);
		die;
	}

	public function getSalesReturnHeader($salesreturn_id){

		$data=array();

		if($salesreturn_id>0){
			
			$rowValue = $this->db->where('salesreturn_id',$salesreturn_id)->get('tbl_salesreturn')->row_array();
			if(empty($rowValue)){
				$data["status"]=0;
				echo json_encode($data);
				exit;
			}

			if($rowValue['status'] != 'PENDING'){
				$invoice = $this->db->select('vendor_id')->where('invoice_id', $rowValue['invoice_id'])->get('tbl_invoice')->row();
				$vendor_id = $invoice->vendor_id;
			}

			$data=array(
				"salesreturn_id"=>$rowValue['salesreturn_id'],
				"saleschannel"=>$rowValue['saleschannel'],
				"saleschannel_refid"=>$rowValue['saleschannel_refid'],
				"mode_of_receipt"=>$rowValue['mode_of_receipt'],
				"return_status"=>$rowValue['status'],
				"delivered_by"=>$rowValue['delivered_by'],
				"quantity"=>$rowValue['quantity'],
				"no_of_pkg"=>$rowValue['no_of_pkg'],
				"invoice_no"=>$rowValue['invoice_no'],
				"claim_required"=>$rowValue['claim_required'],
				"auto_claim"=>$rowValue['auto_claim'],
				"return_type"=>$rowValue['return_type'],
				"request_date"=>$rowValue['request_date'],
				"reason_for_return"=>$rowValue['reason_for_return'],
                "returned_date"=>$rowValue['returned_date'],
				"docket_no"=>$rowValue['docket_no'],
				"warehouse"=>$rowValue['warehouse'],
				"salesreturn_code"=>$rowValue['salesreturn_code'],
				"creditnote_code"=>$rowValue['creditnote_code'],
				"customer"=>$vendor_id
			);

			$data["status"]=1;
			echo json_encode($data);
			exit;

		}else{
			$data["status"]=0;
			echo json_encode($data);
			exit;
		}
	}

	public function getSalesReturnDetails(){
		
		$salesreturn_id = $this->input->get('salesreturn_id');
		$data = [];
		$rows = [];
		if($salesreturn_id > 0){
			$result = $this->creditnotes_model->getSalesReturnDetails($salesreturn_id);

			if(!empty($result)){
				foreach($result as $rowValue){

					$rows[]=array(
						"deviceid"=>$rowValue['nhdin'],
						"product_name"=>$rowValue['device_name'],
						"received_product"=>$rowValue['received_product'],
						"product_condition"=>$rowValue['product_condition'],
						"damage_type"=>$rowValue['damage_type'],
						"dent_type"=>$rowValue['dent_type'],
						"remarks"=>$rowValue['remarks']
					);
				}
			}
		}
		$data["result"] = $rows;
		echo json_encode($data);
		exit;
	}

	public function getSalesReturnRowsforCN($salesreturn_id){

		$data = [];
		$rows = [];
		if($salesreturn_id > 0){
			$result = $this->creditnotes_model->getSalesReturnRowsforCN($salesreturn_id);

			if(!empty($result)){
				foreach($result as $rowValue){

					$rows[]=array(
						"deviceid"=>$rowValue['nhdin'],
						"device_name"=>$rowValue['device_name'],
						"received_product"=>$rowValue['received_product'],
						"product_condition"=>$rowValue['product_condition'],
						"damage_type"=>$rowValue['damage_type'],
						"dent_type"=>$rowValue['dent_type'],
						"remarks"=>$rowValue['remarks'],
						"category"=>$rowValue['category'],
						"sku"=>$rowValue['sku'],
						"grade"=>$rowValue['grade'],
						"price"=>$rowValue['price'],
						"taxable_amount"=>$rowValue['taxable_amount'],
						"exempt_amount"=>$rowValue['exempt_amount'],
						"tax_amount"=>$rowValue['tax_amount'],
						"tax_type"=>$rowValue['tax_type'],
						"bill_type"=>$rowValue['bill_type'],
						"grnreport_id"=>$rowValue['grnreport_id']
					);
				}
			}
		}
		$data["result"] = $rows;
		echo json_encode($data);
		exit;
	}

	public function getVendorDetailsById($vendor_id)
	  {
		$json=array();
		if($vendor_id>0){
			$vendorResult=$this->db->where('vendor_id',$vendor_id)->get('tbl_vendor')->row();
			$stateResult = $this->db->select('name,state_gst_id')->where('state_id',$vendorResult->state)->get('tbl_states')->row();
			if(!empty($vendorResult))
			{
				$json['name'] = $vendorResult->name;
				$json['company'] = $vendorResult->company;	
				$json['email'] = $vendorResult->email;	
				$json['mobile'] = $vendorResult->mobile;
				$json['address'] = $vendorResult->address;
				$json['city'] = $vendorResult->city;
				$json['state_id'] = $vendorResult->state;
				$json['state'] = $stateResult->name;
				$json['pincode'] = $vendorResult->pincode;
				$json['code'] = $vendorResult->vendor_code;
				$json['gstno'] = $vendorResult->gst_no;
				$json['vendor_id'] = $vendorResult->vendor_id;
				$json['state_gst_id'] = $stateResult->state_gst_id;
				
			}
		}
				  
		
				  
		  echo json_encode($json);
		  die;  
	  }
	 
	public function createCreditNotesForm($salesreturn_id){
		
		if($salesreturn_id > 0){

			$result = $this->db->selecT('reason_for_return, return_type')->where('salesreturn_id', $salesreturn_id)->get('tbl_salesreturn')->row();

			if($result->reason_for_return == 'LOST IN TRANSIT' || $result->return_type == 'LOST IN TRANSIT'){
				$data['lost_salesreturn_id'] = $salesreturn_id;
				$data['title'] = "UPDATE SALES RETURN";
				$data["active"] = 8;
			}else{
				$data['salesreturn_id'] = $salesreturn_id;
				$data['title'] = "CREATE CREDIT NOTES";
				$data["active"] = 4;
			}
		}else{
			$data['title'] = "SALES RETURN";
			$data["active"] = 1;
		}
		
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
	}

	public function updateWHSalesReturn(){
		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$salesreturn_id = $data[0]["salesreturn_id"];

		if($salesreturn_id>0){
			$this->db->trans_start();
		
			$record = array(
				"status" => 'FINANCE_PENDING',
				"LAST_UPDATED_BY" => $this->session->userdata('user_id') ,
				"last_modified" => date( "Y-m-d H:i:s")
			);
			
			$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			if(!empty($data[0]["remarks"])){

				$remark_data=array(
					"reference_id"=>$salesreturn_id,
					"reference_type"=>"credit_note",
					"remark"=>$data[0]["remarks"],
					"user_id"=>$this->session->userdata('user_id')
				);
				$this->db->insert('tbl_remark',$remark_data);
			}

			$this->db->trans_complete();
			$json["status"] = 1;
			echo json_encode($json);
			die;

		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}

	}

	public function createCreditNotes(){
		
		$request = file_get_contents("php://input");  
		
		$data = json_decode($request,true);

		$salesreturn_id = $data[0]["salesreturn_id"];

		if($salesreturn_id>0){
			
			$this->db->trans_start();
			
			//Credit Note Serial Code
			$salescode_obj = $this->db->select('salesreturn_code, invoice_id, warehouse, return_type')->where('salesreturn_id', $salesreturn_id)->get('tbl_salesreturn')->row();
			$salescode = $salescode_obj->salesreturn_code;
			$invoice_id = $salescode_obj->invoice_id;
			$warehouse = $salescode_obj->warehouse;
			$return_type = $salescode_obj->return_type;

			$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
            		$next_year = $current_year + 1;
            		$string = substr($warehouse, 0, 1);
            		$series = "CN".$string.$current_year.$next_year;

			$cn_obj = $this->db->select('max(CAST(SUBSTRING_INDEX(creditnote_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesreturn')
			->like('creditnote_code',$series)
			->get()->row_array();
			
			$next_number = $cn_obj['max']+1;
			//$creditnote_code = 'CN-'.$warehouse.'-'.$next_number;
            		$creditnote_code=$series.'-'.$next_number;

			$record = array(
				"creditnote_code"=>$creditnote_code,
				"status"=>'CN_CREATED',
				"last_modified" => date( "Y-m-d H:i:s")

			);
			
			$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			//Update device Status
			$return_grn = $this->db->select('device_id, product_condition')->where('salesreturn_id', $salesreturn_id)->get('tbl_salesreturn_item')->result_array();
			$condition_arr = ["LOST IN TRANSIT", "MODEL MISMATCH", "DIFFERENT ITEM", "EMPTY/TRASH", "FAKE/DUMMY"];
			foreach($return_grn as $rowdata){
				
				if(in_array($rowdata['product_condition'], $condition_arr)){
					$device_status = 'LOST';
				}else{
					$device_status = 'IN_STOCK';

				}
				$grndata[] = array(
					"grnreport_id"=>$rowdata['device_id'],
					"status"=> $device_status,
					"bundle_id"=> NULL,
					"remark" => $rowdata['product_condition'].' || '.$salescode
				);
			}

			$this->db->update_batch('tbl_grnreport',$grndata,'grnreport_id');
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			//Update Invoice Status
			$invoice_item = $this->db->select('count(invoice_item_id) as invoice_quantity')->where('invoice_id', $invoice_id)->group_by('invoice_id')->get('tbl_invoice_item')->row();
			$invoice_quantity = $invoice_item->invoice_quantity;

			$sr_ids = $this->db->select('salesreturn_id')->where('invoice_id', $invoice_id)->where('status', 'CN_CREATED')->get('tbl_salesreturn')->result_array();
			$sr_ids_arr = array_column($sr_ids, 'salesreturn_id');

			$return_item = $this->db->select('count(invoice_item_id) as return_quantity')->where_in('salesreturn_id', $sr_ids_arr)->get('tbl_salesreturn_item')->row();
			$return_quantity = $return_item->return_quantity;

			//$return_item = $this->db->select('count(invoice_item_id) as return_quantity')->where('salesreturn_id', $salesreturn_id)->group_by('salesreturn_id')->get('tbl_salesreturn_item')->row();
			//$return_quantity = $return_item->return_quantity;

			if($return_quantity < $invoice_quantity){
				$invoice_status = 'PART_RETURN';
			}else{
				$invoice_status = 'FULL_RETURN';
			}

			$record = array(
				"status"=>$invoice_status,
				"LAST_UPDATED_BY" => $this->session->userdata('user_id'),
				"LAST_UPDATE_DATE" => date("Y-m-d H:i:s")
			);
			
			$this->db->update('tbl_invoice',$record,array('invoice_id'=>$invoice_id));
			$error=$this->db->error();

			if($error['code']!=0){

				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			//Update Sales Order Status
			$salesorder = $this->db->select('salesorder_id')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();
			$salesorder_id = $salesorder->salesorder_id;

			$this->db->update('tbl_salesorder',$record,array('salesorder_id'=>$salesorder_id));
			$error=$this->db->error();

			if($error['code']!=0){

				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			$so_details = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

			if($invoice_status == "FULL_RETURN"){
				
				$tcs_amount = $so_details->tcs_amount;
				$insurance_amount = $so_details->insurance_amount;
				$discount = $so_details->discount_amount;
				$freight = $so_details->freight_amount;
			}else{
				$so_amount = $this->db->select('sum(amount) as so_amount')->where('salesorder_id', $salesorder_id)->group_by('salesorder_id')->get('tbl_salesorder_item')->row();
				$sr_amount = $this->db->select('sum(price) as sr_amount')->where('salesreturn_id', $salesreturn_id)->group_by('salesreturn_id')->get('SALESRETURN_CN_ROWS_VIEW')->row();
				$tcsAmount = $so_details->tcs_amount;
				if((int) $tcsAmount > 0){
				    
				    $tcs_amount = ($sr_amount * 0.1) / 100;
				} else{
				    $tcs_amount = $so_details->tcs_amount;
				}
				$freight = 0;
				$insurance_amount = 0;
				$discount = $so_details->discount_amount * $sr_amount->sr_amount/$so_amount->so_amount;

			}

			$record = array(
				"tcs_amount"=>$tcs_amount,
				"freight_amount"=>$freight,
				"insurance_amount"=>$insurance_amount,
				"discount_amount"=>$discount,
				"LAST_UPDATED_BY"=>'CN_CREATED',
				"last_modified" => date( "Y-m-d H:i:s")
			);
			
			$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			//insert Remarks
			if(!empty($data[0]["remarks"])){

				$remark_data=array(
					"reference_id"=>$salesreturn_id,
					"reference_type"=>"credit_note",
					"remark"=>$data[0]["remarks"],
					"user_id"=>$this->session->userdata('user_id')
				);
				$this->db->insert('tbl_remark',$remark_data);
			}

			$this->db->trans_complete();
			$this->hostbooks_authenticator->postOfflineCreditNote($salesreturn_id) ;
			$json["status"] = 1;
			echo json_encode($json);
			die;

		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}

	}

	public function checkReturnExists(){
		$invoice_id = $this->input->get('invoice_id');

		if(empty($invoice_id) || (int) $invoice_id <=0){
			$json['status'] = 0;
			$json['message'] = "Invoice ID Not Selected/Valid";
			echo json_encode($json);
			exit;
		}
		//CANCEL STATUS NEWLY ADDED, NEED DISCUSSION WITH PRASAD ON THIS. REVERTED TO ORIGINAL
		//ADDED TEMPORARY TO RESOLVE SITUATION.
		//$where_status = ["CN_CREATED", "CANCELLED", "CANCELED","CANCEL", "VOID", "LOST_IN_TRANSIT"];
		$where_status = ["CN_CREATED", "CANCELLED", "CANCELED","VOID", "LOST_IN_TRANSIT"];
		$result = $this->db->where('invoice_id', $invoice_id)->where_not_in('status', $where_status)->from('tbl_salesreturn')->count_all_results();
		
		if($result>0){
			$json['status'] = 0;// TEMP MADE 1 FROM 0 TO GET PART RETURN DEViCES.
			$json['message'] = "Sales Return Already Exists";
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}

	public function createReturnFromInvoiceForm($invoice_id){
		
		if($invoice_id > 0){
			
			
			$data['active'] = 6;
		}else{
			$data['active'] = 1;
		}

		$status = $this->db->select('status')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row()->status;
		if($status != "SHIPPED" && $status != "PART_RETURN"){
			$data['active'] = 1;
		}

		$data['invoice_id'] = $invoice_id;
		$data['title'] = "CREATE SALES RETURN";
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE); 
		$this->load->view('admin/_layout_main', $data); //page load
	}

	public function claimrequiredStatusChange(){

		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$salesreturn_id = $data["salesreturn_id"];

		if($salesreturn_id>0){

			$this->db->trans_start();
		
			$record = array(
				"claim_required" => $data['claim_required'],
				"LAST_UPDATED_BY" => $this->session->userdata('user_id'),
				"last_modified" => date( "Y-m-d H:i:s")
			);
			
			$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			if(!empty($data["remarks"])){

				$remark_data=array(
					"reference_id"=>$salesreturn_id,
					"reference_type"=>"credit_note",
					"remark"=>$data["remarks"],
					"user_id"=>$this->session->userdata('user_id')
				);
				$this->db->insert('tbl_remark',$remark_data);
			}

			$this->db->trans_complete();
			$json["status"] = 1;
			echo json_encode($json);
			die;

		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}
	}

	public function cancelSR_awaiting($salesreturn_id){

		if( (int) $salesreturn_id <= 0){
			$json['status'] = 0;
				$json['error'] = "No Sales Return Selected";
				echo json_encode($json);
				die;
		}

		$remarks = $this->input->post('remarks_header');

		$record = array(
			"status"=>'CANCEL',
			"last_modified" => date( "Y-m-d H:i:s"),
			"LAST_UPDATED_BY" => $this->session->userdata('user_id')

		);

		$this->db->trans_start();
		
		$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
		$error=$this->db->error();

		if($error['code']!=0){
			$this->db->trans_rollback();
			$json['status']=0;
			echo json_encode($json);
			die;
		}

		if(!empty($remarks)){

			$remark_data=array(
				"reference_id"=>$salesreturn_id,
				"reference_type"=>"credit_note",
				"remark"=>$remarks,
				"user_id"=>$this->session->userdata('user_id')
			);
			$this->db->insert('tbl_remark',$remark_data);
		}
        
        $this->auditlog_model->insert_auditlog($salesreturn_id,'salesreturn',"CANCEL",$this->session->userdata('user_id'));

		$this->db->trans_complete();

		if(!empty($_FILES['file'])){

			if (!is_dir('upload_sr/'.$salesreturn_id)) {
				mkdir('./upload_sr/' . $salesreturn_id, 0777, TRUE);
			
			}
			
			$config['upload_path'] = './upload_sr/'.$salesreturn_id.'/';
			$config['allowed_types'] = 'jpeg|jpg|png';

			$this->load->library('upload', $config);

			$file_result = $this->upload->do_upload('file');

			/* if ( !$file_result)
			{
					$error = $this->upload->display_errors();

					$json['status'] = 0;
					$json['error'] = $error;
					echo json_encode($json);
					die;
			} */
		}
				
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function voidSR(){
		
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);

		$salesreturn_id = $data["salesreturn_id"];

		if( (int) $salesreturn_id <= 0){
			$json['status'] = 0;
				$json['error'] = "No Sales Return Selected";
				echo json_encode($json);
				die;
		}

		$record = array(
			"status"=>'VOID',
			"last_modified" => date( "Y-m-d H:i:s"),
			"LAST_UPDATED_BY" => $this->session->userdata('user_id')

		);

		$this->db->trans_start();
		
		$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
		$error=$this->db->error();

		if($error['code']!=0){
			$this->db->trans_rollback();
			$json['status']=0;
			echo json_encode($json);
			die;
		}

		if(!empty($data["remarks_header"])){

			$remark_data = array(
								"reference_id" => $salesreturn_id,
								"reference_type" => "credit_note",
								"remark" => $data["remarks_header"],
								"user_id" => $this->session->userdata('user_id')
							);
							$this->db->insert('tbl_remark',$remark_data);
		}
        
        $this->auditlog_model->insert_auditlog($salesreturn_id,'salesreturn',"VOID",$this->session->userdata('user_id'));

		$this->db->trans_complete();

		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function getSRFileslist(){

        $salesreturn_id = $this->input->get('salesreturn_id');

        if(empty($salesreturn_id)){
            
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir( "./upload_sr/".$salesreturn_id."/" );
        $file_names = array();
         
        foreach( $files as $file ){

            if($file != '.' && $file != '..'){

                $file_names[] = array(

                    "file_name" => $file
                );
            }
            
        }

        $json['status'] = 1;
        $json["directory"] = "upload_sr/".$salesreturn_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
	}

	public function checkLostReturnExists(){
		$invoice_id = $this->input->get('invoice_id');

		if(empty($invoice_id) || (int) $invoice_id <=0){
			$json['status'] = 0;
			$json['message'] = "Invoice ID Not Selected/Valid";
			echo json_encode($json);
			exit;
		}
		$status_arr = ["FINANCE_PENDING", "LOST_IN_TRANSIT"];
		$result = $this->db->where_in('status', $status_arr)->where('invoice_id', $invoice_id)->from('tbl_salesreturn')->count_all_results();
		if($result>0){
			$json['status'] = 0;
			$json['message'] = "Sales Return for Lost Already Exists";
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}

	public function newSalesreturnLostForm($invoice_id = 0){
		
		if($invoice_id > 0){
			$data['active'] = 7;
		}else{
			$data['active'] = 1;
		}

		$data['lost_invoice_id'] = $invoice_id;
		$data['title'] = "CREATE SALES RETURN";
		$data['subview'] = $this->load->view('admin/salesreturn/manage_salesreturn', $data, TRUE);
		$this->load->view('admin/_layout_main', $data); //page load
	}

	public function createLostSalesReturn(){

		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);
		
		$res=$this->db->select('max(CAST(SUBSTRING_INDEX(salesreturn_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesreturn')->get()->row_array();
       	$next_number=$res['max']+1;
		$salesreturn_code='SR-'.$data[0]["warehouse"].'-'.$next_number;
		   
		$record = array(
			"saleschannel"=> $data[0]["sales_channel"],
			"saleschannel_refid"=> $data[0]["saleschannel_ref_id"],
			"mode_of_receipt"=>$data[0]["mode_of_receipt"],
			"status"=>"FINANCE_PENDING",
			"salesreturn_code"=>$salesreturn_code,
			"claim_required" => $data[0]["claim_required"],
			"auto_claim" => $data[0]["auto_claim"],
			"delivered_by"=>$data[0]["delivered_by"],
			"quantity"=>$data[0]["quantity"],
			"no_of_pkg"=>$data[0]["package_no"],
			"invoice_no"=>$data[0]["invoice_no"],
			"invoice_id"=>$data[0]["invoice_id"],
			"docket_no"=>$data[0]["docket_no"],
			"return_type"=>$data[0]["return_type"],	
			"reason_for_return"=>$data[0]["reason_for_return"],	
			"warehouse"=>$data[0]["warehouse"],		
			"CREATED_BY"=>$this->session->userdata('user_id'),
			"created_date"=>date("Y-m-d H:i:s")
		);

		// Start Inserting

		$this->db->trans_start(FALSE);
		$result = $this->db->insert('tbl_salesreturn',$record);
		$error = $this->db->error();
		$salesreturn_id = $this->db->insert_id();
		
		if($error['code'] != 0){
			$this->db->trans_rollback();
			$json["status"] = 0;
			json_encode($json);
			exit;
		}

		$records= array();
		foreach($data[0]["rows"] as $data){
			$grn = $this->db->select('grnreport_id')->where('nhdin',$data["device_id"])->get('tbl_grnreport')->row();
			$records[] = array(
				"salesreturn_id"=>$salesreturn_id,
				"device_id"=> $grn->grnreport_id,
				"product_condition"=>$data["product_condition"],
				"received_product"=>$data["received_product"],
				"damage_type"=>$data["damage_type"],
				"dent_type"=>$data["dent_type"],
				"remarks"=>$data["remarks"],
				"invoice_item_id"=>$data["invoice_item_id"],
			);
		}	
		$this->db->insert_batch('tbl_salesreturn_item',$records);
		$error=$this->db->error();
		
		if($error['code'] != 0){
			$this->db->trans_rollback();
			$json["status"] = 0;
			json_encode($json);
			exit;
		}
		
		$this->db->trans_complete();
		$json["status"] = 1;
		
		echo json_encode($json);
		die;
	}

	public function updateLostSalesReturn(){
		$request = file_get_contents("php://input");  
		
		// FALSE : CONVERT TO OBJECT/CLASS
		// TRUE : CONVERT TO ARRAY
		$data = json_decode($request,true);

		$salesreturn_id = $data[0]["salesreturn_id"];

		if($salesreturn_id>0){
			$this->db->trans_start();
		
			$record = array(
				"status" => 'LOST_IN_TRANSIT',
				"LAST_UPDATED_BY" => $this->session->userdata('user_id') ,
				"last_modified" => date( "Y-m-d H:i:s")
			);
			
			$this->db->update('tbl_salesreturn',$record,array('salesreturn_id'=>$salesreturn_id));
			$error=$this->db->error();

			if($error['code']!=0){
				$this->db->trans_rollback();
				$json['status']=0;
				echo json_encode($json);
				die;
			}

			if(!empty($data[0]["remarks"])){

				$remark_data=array(
					"reference_id"=>$salesreturn_id,
					"reference_type"=>"credit_note",
					"remark"=>$data[0]["remarks"],
					"user_id"=>$this->session->userdata('user_id')
				);
				$this->db->insert('tbl_remark',$remark_data);
			}

			$this->db->trans_complete();
			$json["status"] = 1;
			echo json_encode($json);
			die;

		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}

	}
	public function open_CNpdf(){
		$download = $this->input->get('download');
		$salesreturn_id = $this->input->get('salesreturn_id');
		
		$creditnote_header = $this->db->where('salesreturn_id', $salesreturn_id)->get('SALESRETURN_LIST_VIEW')->result_array();
		if($salesreturn_id > 0){
			$result = $this->db->where('salesreturn_id', $salesreturn_id)->get('SALESRETURN_CN_ROWS_VIEW')->result_array();
			$total_amount = 0;
			$taxable_amount = 0;
			$exempt_amount = 0;
			$tax_amount = 0;
			foreach($result as $rowValue){

					$credinotes_rows[]=array(
						"imei"=>$rowValue['imei1_no'],
						"nhdin"=>$rowValue['nhdin'],
						"device_name"=>$rowValue['device_name'],
						"received_product"=>$rowValue['received_product'],
						"product_condition"=>$rowValue['product_condition'],
						"damage_type"=>$rowValue['damage_type'],
						"dent_type"=>$rowValue['dent_type'],
						"remarks"=>$rowValue['remarks'],
						"category"=>$rowValue['category'],
						"sku"=>$rowValue['sku'],
						"grade"=>$rowValue['grade'],
						"price"=>$rowValue['price'],
						"taxable_amount"=>$rowValue['taxable_amount'],
						"exempt_amount"=>$rowValue['exempt_amount'],
						"tax_amount"=>$rowValue['tax_amount'],
						"tax_type"=>$rowValue['tax_type'],
						"bill_type"=>$rowValue['bill_type'],
					);
					$total_amount += $rowValue['price'];
					$taxable_amount += $rowValue['taxable_amount'];
					$exempt_amount += $rowValue['exempt_amount'];
					$tax_amount += $rowValue['tax_amount'];
			}
			
		}
		$discount_amount = $creditnote_header[0]["discount_amount"];
		$tcs_amount = $creditnote_header[0]["tcs_amount"];
		$insurance_amount = $creditnote_header[0]["insurance_amount"];
		$freight_amount = $creditnote_header[0]["freight_amount"];
//var_dump($creditnote_header);exit;
		//$net_amount =  $tcs_amount;
		$net_amount = $total_amount + $tcs_amount + $insurance_amount + $freight_amount - $discount_amount;
		$amount_words = $this->getIndianCurrency($net_amount);
		
		$data['credinotes_rows'] = $credinotes_rows; 
		$data['discount_amount'] = $discount_amount; 
		$data['tcs_amount'] = $tcs_amount; 
		$data['insurance_amount'] = $insurance_amount; 
		$data['freight_amount'] = $freight_amount; 
		$data['gross_taxable'] = $taxable_amount;
		$data['gross_exempt'] = $exempt_amount; 
		$data['gross_tax'] = $tax_amount; 
		$data['net_amount'] = $net_amount; 
		if(!empty($invoice_header[0]["gst_no"]))
			$supply_place = $this->db->select('name')->where('state_gst_id',substr($invoice_header[0]["gst_no"],0,2))->get('tbl_states')->row();
		$invoice_header = $this->db->where('invoice_code',$creditnote_header[0]["invoice_no"])->get('PDF_INVOICE_HEADER_VIEW')->result_array();
		if(!empty($invoice_header)){
			$data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
			$data['place_supply'] = $supply_place->name;
			$data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];
		}
	
				if(!empty($creditnote_header)){
           			$data["salesreturn_code"] = $creditnote_header[0]["salesreturn_code"];
					$data["invoice_no"] = $creditnote_header[0]["invoice_no"];
					$data["creditnote_code"] = $creditnote_header[0]["creditnote_code"];
					$data["received_date"] = date("d-m-Y",strtotime($creditnote_header[0]["returned_date"]));
					$data["created_date"] = date("d-m-Y",strtotime($creditnote_header[0]["created_date"]));
					$data["creditnote_date"] = date("d-m-Y",strtotime($creditnote_header[0]["last_modified"]));
					$data["amount_words"] = $amount_words;
				}
		 $this->load->helper('dompdf');		 
		 $viewfile = $this->load->view('admin/salesreturn/creditnotes_pdf', $data, TRUE);
		 $header = $data["salesreturn_code"];
		 pdf_create($viewfile, $data["salesreturn_code"],TRUE,'',$download,null,$header);
    }
	
	function getIndianCurrency(float $number){
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
        $digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ?'Rupees '.$Rupees: '') . $paise.'Only';
    }

	public function submitCustomerReturnRemarks()
	{
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		$sales_remarks_insert = [];
		$triage_remarks_insert = [];
		$certification_remarks_insert = [];

		if((int) $data['salesreturn_id'] <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$sales_remarks = $data['sales_remarks'];
		$triage_remarks = $data['triage_remarks'];
		$certification_remarks = $data['certification_remarks'];

		if(empty($sales_remarks) && empty($triage_remarks) && empty($certification_remarks)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		foreach($sales_remarks as $rowValue){
			$sales_remarks_insert[] = array(
								"reference_id" => $rowValue['salesreturn_item_id'],
								"reference_type" => "return_sales_remark",
								"remark" => $rowValue['remarks'],
								"date" => date("Y-m-d H:i:s"),
								"user_id" => $this->session->userdata('user_id')
							);
		}

		foreach($triage_remarks as $rowValue){
			$triage_remarks_insert[] = array(
								"reference_id" => $rowValue['salesreturn_item_id'],
								"reference_type" => "return_triage_remark",
								"remark" => $rowValue['remarks'],
								"date" => date("Y-m-d H:i:s"),
								"user_id" => $this->session->userdata('user_id')
							);
		}

		foreach($certification_remarks as $rowValue){
			$certification_remarks_insert[] = array(
								"reference_id" => $rowValue['salesreturn_item_id'],
								"reference_type" => "return_certification_remark",
								"remark" => $rowValue['remarks'],
								"date" => date("Y-m-d H:i:s"),
								"user_id" => $this->session->userdata('user_id')
							);
		}

		$this->db->trans_start();

		if(!empty($sales_remarks_insert)){
			
			$this->db->insert_batch('tbl_remark', $sales_remarks_insert);
			$error = $this->db->error();
			
			if($error['code'] != 0){
				$this->db->trans_rollback();
				$json['status'] = 0;
				echo json_encode($json);
				exit;
			}
		}

		if(!empty($triage_remarks_insert)){
			
			$this->db->insert_batch('tbl_remark', $triage_remarks_insert);
			$error = $this->db->error();
			
			if($error['code'] != 0){
				$this->db->trans_rollback();
				$json['status'] = 0;
				echo json_encode($json);
				exit;
			}
		}

		if(!empty($certification_remarks_insert)){
			
			$this->db->insert_batch('tbl_remark', $certification_remarks_insert);
			$error = $this->db->error();
			
			if($error['code'] != 0){
				$this->db->trans_rollback();
				$json['status'] = 0;
				echo json_encode($json);
				exit;
			}
		}

		$this->db->trans_complete();
		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function getCustomerReturnRemarks()
	{
		$salesreturn_id = $this->input->get('salesreturn_id');

		if((int) $salesreturn_id <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
		$remark_arr = [];
		$result = $this->db->where('salesreturn_id', $salesreturn_id)->get('CUSTOMER_RETURN_REMARKS_VIEW')->result_array();

		foreach($result as $rowValue){
			$remark_arr[] = array(
				"salesreturnitem_id" => $rowValue['salesreturnitem_id'],
				"nhdin" => $rowValue['nhdin'],
				"return_sales_remark" => $rowValue['return_sales_remark'],
				"return_certification_remark" => $rowValue['return_certification_remark'],
				"return_triage_remark" => $rowValue['return_triage_remark'],
			);
		}

		$json['status'] = 1;
		$json['result'] = $remark_arr;
		echo json_encode($json);
		exit;
	}
	
	// ADD SALES RETURN INVOICES TO HOST BOOKS MANUALLY
	
	public function addSalesReturnInvoiceToHostBook(){
		$salesreturn_id = 5151;
		$this->hostbooks_authenticator->manualPostOfflineCreditNote($salesreturn_id) ;
	

	}
}

?>