<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Cliq extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('cliq_api');
        
    }

    private $authorize_url = "https://accounts.zoho.com/oauth/v2/auth";

    private $scope = "ZohoCliq.Webhooks.CREATE,ZohoCliq.Channels.CREATE,ZohoCliq.Channels.READ,ZohoCliq.Channels.UPDATE,ZohoCliq.Channels.DELETE";
    //	callback URL specified when the application was defined--has to match what the application says
    private $callback_uri = "https://erp.sloyd.in/admin/Cliq/accessRefreshToken";

    //private $client_id = "1000.VO0GJDWMMGF137E2ZMETY8N8390E7O";
    //private $client_secret = "27f12a057df8392ecf9ffff0bfac0b244f0451d47e";

    public function getAuthorizationCode()
    {
        //global $authorize_url, $client_id, $callback_uri;

        $client_id = $this->db->select('value')->where('config_key', 'cliq_client_id')->get('tbl_config')->row()->value;
        $client_secret = $this->db->select('value')->where('config_key', 'cliq_client_secret')->get('tbl_config')->row()->value;

        $authorization_redirect_url = $this->authorize_url . "?response_type=code&client_id=";
        $authorization_redirect_url .= $client_id;
        $authorization_redirect_url .= "&redirect_uri=" . $this->callback_uri;
        $authorization_redirect_url .= "&scope=" . $this->scope;
        $authorization_redirect_url .= "&access_type=Offline";
        $authorization_redirect_url .= "&consent=prompt";

        header("Location: " . $authorization_redirect_url, TRUE, 302);
    }

    public function accessRefreshToken()
    {
        $auth_code = $this->input->get('code');

        $client_id = $this->db->select('value')->where('config_key', 'cliq_client_id')->get('tbl_config')->row()->value;
        $client_secret = $this->db->select('value')->where('config_key', 'cliq_client_secret')->get('tbl_config')->row()->value;

        $url = 'https://accounts.zoho.com/oauth/v2/token';

        $ch = curl_init($url);

        //$data = array("contactList" => [$data]);
        $data = array(
            "code" => $auth_code,
            "client_id" => $client_id,
            "client_secret" => $client_secret,
            "grant_type" => "authorization_code",
            "redirect_uri" => $this->callback_uri,
            "scope" => $this->scope
        );

        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        //curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);
        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $access_token = $result['access_token'];
        $refresh_token = $result['refresh_token'];

        $access_token_array = array(
            "value" => $access_token
        );

        $refresf_token_array = array(
            "value" => $refresh_token
        );
        $access_expire_array = array(
            "value" => mktime() + 3000
        );
        $this->db->where('config_key', "cliq_access_token")->update('tbl_config', $access_token_array);
        if (!empty($refresh_token)) {
            $this->db->where('config_key', "cliq_refresh_token")->update('tbl_config', $refresf_token_array);
        }
        $this->db->where('config_key', "cliq_access_expire")->update('tbl_config', $access_expire_array);
    }

    public function postMessage()
    {
        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);

        // The text to draw
        $lines[] = 'S.O Created By    : Prasad';
        $lines[] = 'Sales Executive   : Prasad';
        $lines[] = 'S.O No            : SO-HYD-3457';
        $lines[] = 'Vendor Name       : 3D COMMUNICATIONS';
        $lines[] = 'Vendor Code       : SO-HB2B-3456';
        $lines[] = 'Amount            : 4500000.00';
        $lines[] = 'Freight Amount    : 4500000.00';
        $lines[] = 'Discount Amount   : 4500000.00';
        $lines[] = 'TCS Amount        : 4500000.00';
        $lines[] = 'Net Amount        : 4500000.00';
        $lines[] = 'Please Approve this S.O';

        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 499, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);

            $y += 25;
            imageline($img, $x, $y - 5, 499, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y-5, $blue);
        imageline($img, 499, 20, 499, $y-5, $blue);

        imagesetthickness($img, 10);

        // Using imagepng() results in clearer text compared with imagejpeg() 
        //header('Content-Type: image/png');

        imagepng($img, "./uploads/sales.png");
        //$p = base64_encode($img);
        imagedestroy($img);
        //var_dump($data);exit; 
        //$this->cliq_api->postMessage("text", $p, "sales.png");
    }

    public function postSampleImage($salesorder_id = 0)
    {
        $this->cliq_api->postSalesImage($salesorder_id);
    }

    public function postSTNImage($stn_id = 0)
    {
        $this->cliq_api->postStocktransferImage($stn_id);
    }
}
