<?php

class Claims extends Admin_Controller{

    public function __construct()
    {
        parent::__construct(); 
        /*load model*/
        $this->load->model('auditlog_model');
        
    }

    public function manage_claims($active = 0){

        if($active > 0){

            $data['active'] = $active;
        }else{
            $data['active'] = 1;
        }

        $data['title'] = 'CLAIMS';
        
        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function newClaimForm($salesreturn_id = 0){


        if(empty($salesreturn_id) || (int) $salesreturn_id <=0){

            $data['actiive'] = 1;
            $data['title'] = 'CLAIMS';
        
        }else{

            $data['active'] = 2;
            $data['title'] = 'NEW CLAIM';
            $data['salesreturn_id'] = $salesreturn_id;
        }


        
        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function updateClaimForm($claims_id = 0){

        if(empty($claims_id) || (int) $claims_id <=0){

            $data['actiive'] = 1;
            $data['title'] = 'CLAIMS';
        
        }else{

            $data['active'] = 3;
            $data['title'] = 'UPDATE CLAIM';
            $data['update_claims_id'] = $claims_id;
        }

        
        
        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function receiveClaimForm($claims_id){

        if(empty($claims_id) || (int) $claims_id <=0){

            $data['actiive'] = 1;
            $data['title'] = 'CLAIMS';
        
        }else{

            $data['active'] = 4;
            $data['title'] = 'NEW CLAIM';
            $data['receive_claims_id'] = $claims_id;
        }

        
        
        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function getSalesReturnHeader(){

        $salesreturn_id = $this->input->get('salesreturn_id');

        if(empty($salesreturn_id) || (int) $salesreturn_id <=0){

           $json['status'] = 0;
           echo json_encode($json);
           exit;
        
        }

        $select = $this->db->select('claims_id')->where('salesreturn_id', $salesreturn_id)->get('tbl_claims')->result_array();

        if(!empty($select)){

            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('salesreturn_id', $salesreturn_id)->get('SALESRETURN_LIST_HEADER_VIEW')->row();

        if(empty($result)){
        
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['data'] = array(

                            "salesreturn_id" => $result->salesreturn_id,
                            "salesreturn_no" => $result->salesreturn_no,
                            "invoice_id" => $result->invoice_id,
                            "invoice_no" => $result->invoice_no,
                            "invoice_amount" => $result->invoice_amount,
                            "salesorder_no" => $result->salesorder_no,
                            "salesorder_id" => $result->salesorder_id,
                            "sales_channel" => $result->sales_channel,
                            "saleschannel_ref_id" => $result->saleschannel_ref_id,
                            "vendor_id" => $result->vendor_id,
                            "vendor_name" => $result->vendor_name,
                            "quantity" => $result->quantity,
                            "claim_required" => $result->claim_required,
                        );

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function createNewClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['salesreturn_id'] <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $res=$this->db->select('max(CAST(SUBSTRING_INDEX(claim_no,"-",-1) as UNSIGNED)) as max')->from('tbl_claims')->get()->row_array();
       	$next_number=$res['max']+1;
		$claim_no='CLM-'.$next_number;

        $record = array(
                    
                    "claim_no" => $claim_no,
                    "salesreturn_id" => $data['salesreturn_id'],
                    "claim_date" => $data['claim_date'],
                    "claim_amount" => $data['claim_amount'],
                    "status" => $data['status'],
                    "approved_amount" => $data['approved_amount'],
                    "approved_date" => $data['approved_date'],
                    "payment_ref_id" => $data['payment_ref_id'],
                    "incident_no" => $data['incident_no'],
                    "CREATION_DATE" => date("Y-m-d H:i:s"),
                    "CREATED_BY" => $user_id
                );

        $this->db->trans_start();
        $this->db->insert('tbl_claims', $record);

        $claims_id = $this->db->insert_id();

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
    
        // UPDATE Claim Required
    
        $claim_required = array(

                                "salesreturn_id" => $data['salesreturn_id'],
                                "claim_required" => 'CLAIMED'
                            );

        $this->db->update('tbl_salesreturn', $claim_required, array('salesreturn_id'=>$claim_required['salesreturn_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }



        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$claims_id,
                'reference_type'=>'claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($claims_id,'claims', $data['status'] ,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['claims_id'] <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $record = array(
                    
                    "claims_id" => $data['claims_id'],
                    "claim_date" => $data['claim_date'],
                    "claim_amount" => $data['claim_amount'],
                    "status" => $data['status'],
                    "approved_amount" => $data['approved_amount'],
                    "approved_date" => $data['approved_date'],
                    "payment_ref_id" => $data['payment_ref_id'],
                    "incident_no" => $data['incident_no'],
                    "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
                    "LAST_UPDATED_BY" => $user_id
                );

        $this->db->trans_start();
        $this->db->update('tbl_claims',$record,array('claims_id'=>$record['claims_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$data['claims_id'],
                'reference_type'=>'claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($data['claims_id'],'claims', $data["status"], $this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function receiveClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['claims_id'] <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $record_claim_update = array(
                    
                    "claims_id" => $data['claims_id'],
                    "status" => "SETTLED",
                    "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
                    "LAST_UPDATED_BY" => $user_id
                );

        $record_received_insert = array(
                    
                    "claims_id" => $data["claims_id"],
                    "reference_no" => $data['reference_no'],
                    "account_no" => $data['account_no'],
                    "amount" => $data['amount'],
                    "received_date" => $data['received_date'],
                    "CREATION_DATE" => date("Y-m-d H:i:s"),
                    "CREATED_BY" => $user_id
                );

        $this->db->trans_start();

        //Upate Status for Claim
        $this->db->update('tbl_claims',$record_claim_update,array('claims_id'=>$record_claim_update['claims_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        // Insert Claim in receipts
        $this->db->insert('tbl_claims_receipt', $record_received_insert);

        $claims_id = $data["claims_id"];

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$claims_id,
                'reference_type'=>'claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($claims_id,'claims',"SETTLED",$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function financeRejectClaim(){

        $request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
        $claims_id = $data["claims_id"];

        $user_id = $this->session->userdata('user_id');

        if( empty($claims_id) || (int) $claims_id <=0 ){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $record_claim_update = array(
                    
                                "claims_id" => $data['claims_id'],
                                "status" => "FINANCE_REJECTED",
                                "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
                                "LAST_UPDATED_BY" => $user_id
                            );
        $this->db->trans_start();

        //Upate Status for Claim
        $this->db->update('tbl_claims',$record_claim_update,array('claims_id'=>$record_claim_update['claims_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        
        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$claims_id,
                'reference_type'=>'claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($claims_id,'claims',"FINANCE_REJECTED",$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;

    }

    public function getClaimsList(){

        $status = $this->input->get('status');
        $result = $this->db->where('status', $status)->get('CLAIMS_LIST_VIEW')->result_array();

        if(empty($result)){

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        foreach($result as $rowValue){

            $approved_date = date("d-m-Y", strtotime($rowValue['approved_date']));

            if($approved_date == '01-01-1970' || $approved_date == '30-11--0001'){
                $approved_date = '';
            }

            $records [] = array(
                            
                            "claims_id" => $rowValue["claims_id"],
                            "claim_no" => $rowValue["claim_no"],
                            "incident_no" => $rowValue["incident_no"],
                            "claim_date" => date("d-m-Y", strtotime($rowValue["claim_date"])),
                            "salesreturn_id" => $rowValue["salesreturn_id"],
                            "salesreturn_no" => $rowValue["salesreturn_no"],
                            "invoice_id" => $rowValue["invoice_id"],
                            "invoice_no" => $rowValue["invoice_no"],
                            "invoice_amount" => $rowValue["invoice_amount"],
                            "salesorder_no" => $rowValue["salesorder_no"],
                            "salesorder_id" => $rowValue["salesorder_id"],
                            "sales_channel" => $rowValue["sales_channel"],
                            "saleschannel_ref_id" => $rowValue["saleschannel_ref_id"],
                            "vendor_id" => $rowValue["vendor_id"],
                            "vendor_name" => $rowValue["vendor_name"],
                            "quantity" => $rowValue["quantity"],
                            "claim_amount" => $rowValue["claim_amount"],
                            "approved_amount" => $rowValue["approved_amount"],
                            "approved_date" => $approved_date,
                            "payment_ref_id" => $rowValue["claim_amount"],
                            "status" => $rowValue["status"],
                            "created_by" => $rowValue["created_by"],
                            "last_updated_by" => $rowValue["last_updated_by"],
                            "creation_date" => date("d-m-Y", strtotime($rowValue['CREATION_DATE'])),
                            "last_update_date" => date("d-m-Y", strtotime($rowValue["LAST_UPDATE_DATE"])),

                            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;

    }

    public function getClaimHeader(){

        $claims_id = $this->input->get('claims_id');

        if( (int) $claims_id <= 0){

            $json['status'] = 0;
           echo json_encode($json);
           exit;
        
        }

        $result = $this->db->where('claims_id', $claims_id)->get('CLAIMS_LIST_VIEW')->row();

        if(empty($result)){
        
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['data'] = array(

                            "claim_no" => $result->claim_no,
                            "incident_no" => $result->incident_no,
                            "claim_date" => $result->claim_date,
                            "salesreturn_id" => $result->salesreturn_id,
                            "salesreturn_no" => $result->salesreturn_no,
                            "invoice_id" => $result->invoice_id,
                            "invoice_no" => $result->invoice_no,
                            "invoice_amount" => $result->invoice_amount,
                            "salesorder_no" => $result->salesorder_no,
                            "salesorder_id" => $result->salesorder_id,
                            "sales_channel" => $result->sales_channel,
                            "status" => $result->status,
                            "approved_amount" => $result->approved_amount,
                            "approved_date" => $result->approved_date,
                            "payment_ref_id" => $result->payment_ref_id,
                            "saleschannel_ref_id" => $result->saleschannel_ref_id,
                            "vendor_id" => $result->vendor_id,
                            "vendor_name" => $result->vendor_name,
                            "quantity" => $result->quantity,
                            "claim_amount" => $result->claim_amount,
                            "created_by" => $result->created_by,
                            "last_updated_by" => $result->last_updated_by,
                            "creation_date" => $result->CREATION_DATE,
                            "last_update_date" => $result->LAST_UPDATE_DATE,
                        );

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getReceipts($claims_id = 0){

        if( empty($claims_id) || (int) $claims_id <= 0){

            $json['status'] = 0;
            
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where("claims_id", $claims_id)->get('tbl_claims_receipt')->result_array();

        $records = array();

        if(empty($result)){
            $json['status'] = 0;
            
            echo json_encode($json);
            exit;
        }

        foreach($result as $rowValue){

            $records[] = array(

                            "claims_id" => $rowValue["claims_id"],
                            "account_no" => $rowValue["account_no"],
                            "reference_no" => $rowValue["reference_no"],
                            "received_date" => date("d-m-Y", strtotime($rowValue["received_date"])),
                            "amount" => $rowValue["amount"]
                        );
        }

        $json["result"] = $records;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    
    public function newFFClaim($stocktransfer_id){
         
        $data['active'] = 1;
        $data['title'] = "CREATE CLAIM";
        
        if($stocktransfer_id>0){
            $result = $this->db->select('status')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer')->row();
            
            if($result->status == 'COMPLETED'){
                $data['active'] = 5 ;
                $data["inward_stocktransfer_id"] = $stocktransfer_id;
            }
        }

        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function sumbitNewFFClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['stocktransfer_id'] <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $res=$this->db->select('max(CAST(SUBSTRING_INDEX(ff_claim_no,"-",-1) as UNSIGNED)) as max')->from('tbl_ff_claims')->get()->row_array();
        $next_number=$res['max']+1;
		$claim_no='FF-CLM-'.$next_number;

        $record = array(
                    
                    "ff_claim_no" => $claim_no,
                    "ff_incident_no" => $data['incident_no'],
                    "stocktransfer_id" => $data['stocktransfer_id'],
                    "claim_date" => $data['claim_date'],
                    "claim_amount" => $data['claim_amount'],
                    "status" => $data['status'],
                    "CREATED_BY" => $user_id,
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                 
                );
        
        $this->db->trans_start();
        $this->db->insert('tbl_ff_claims', $record);
       
        $ff_claims_id = $this->db->insert_id();

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
    
        // UPDATE Claim Required
    
         $claim_required = array(

                                 "stocktransfer_id" => $data['stocktransfer_id'],
                                 "claim_required" => 'C'
                             );

         $this->db->update('tbl_stocktransfer', $claim_required, array('stocktransfer_id'=>$claim_required['stocktransfer_id']));

         $error = $this->db->error();

         if($error['code'] != 0){
            
             $this->db->trans_rollback();
             $json['status'] = 0;
             echo json_encode($json);
             exit;
         }



        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$ff_claims_id,
                'reference_type'=>'ff_claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($ff_claims_id,'ff_claims', $data['status'] ,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getFFClaimsList(){

        $status = $this->input->get('status');
        $result = $this->db->where('status', $status)->get('FF_CLAIMS_LIST_VIEW')->result_array();

        if(empty($result)){

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        foreach($result as $rowValue){

            $approved_date = date("d-m-Y", strtotime($rowValue['approved_date']));

            if($approved_date == '01-01-1970' || $approved_date == '30-11--0001'){
                $approved_date = '';
            }

            $records [] = array(
                            
                            "claims_id" => $rowValue["claims_id"],
                            "claim_no" => $rowValue["claim_no"],
                            "incident_no" => $rowValue["incident_no"],
                            "claim_date" => date("d-m-Y", strtotime($rowValue["claim_date"])),
                            "stocktransfer_id" => $rowValue["stocktransfer_id"],
                            "stocktransfer_no" => $rowValue["stocktransfer_no"],

                            "sales_channel" => $rowValue["sales_channel"],
                            "removable_id" => $rowValue["removable_id"],

                            "claim_amount" => $rowValue["claim_amount"],
                            "approved_amount" => $rowValue["approved_amount"],
                            "approved_date" => $approved_date,
                            "payment_ref_id" => $rowValue["claim_amount"],
                            "status" => $rowValue["status"],
                            "created_by" => $rowValue["created_by"],
                            "last_updated_by" => $rowValue["last_updated_by"],
                            "creation_date" => date("d-m-Y", strtotime($rowValue['CREATION_DATE'])),
                            "last_update_date" => date("d-m-Y", strtotime($rowValue["LAST_UPDATE_DATE"])),

                            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;

    }

    public function updateFFClaimForm($claims_id = 0){

        if(empty($claims_id) || (int) $claims_id <=0){

            $data['actiive'] = 1;
            $data['title'] = 'CLAIMS';
        
        }else{

            $data['active'] = 7;
            $data['title'] = 'UPDATE CLAIM';
            $data['update_ff_claims_id'] = $claims_id;
        }

        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function getFFClaimHeader(){

        $claims_id = $this->input->get('claims_id');

        if( (int) $claims_id <= 0){

            $json['status'] = 0;
           echo json_encode($json);
           exit;
        
        }

        $result = $this->db->where('claims_id', $claims_id)->get('FF_CLAIMS_LIST_VIEW')->row();

        if(empty($result)){
        
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['data'] = array(

                            "claim_no" => $result->claim_no,
                            "incident_no" => $result->incident_no,
                            "claim_date" => $result->claim_date,
                            "stocktransfer_id" => $result->stocktransfer_id,
                            "stocktransfer_no" => $result->stocktransfer_no,
                            "removable_id" => $result->removable_id,
                            "sales_channel" => $result->sales_channel,
                            "status" => $result->status,
                            "approved_amount" => $result->approved_amount,
                            "approved_date" => $result->approved_date,
                            "payment_ref_id" => $result->payment_ref_id,
                            "quantity" => $result->quantity,
                            "claim_amount" => $result->claim_amount,
                            "created_by" => $result->created_by,
                            "last_updated_by" => $result->last_updated_by,
                            "creation_date" => $result->CREATION_DATE,
                            "last_update_date" => $result->LAST_UPDATE_DATE,
                        );

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateFFClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['claims_id'] <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $record = array(
                    
                    "ff_claims_id" => $data['claims_id'],
                    "claim_date" => $data['claim_date'],
                    "claim_amount" => $data['claim_amount'],
                    "status" => $data['status'],
                    "approved_amount" => $data['approved_amount'],
                    "approved_date" => $data['approved_date'],
                    "payment_ref_id" => $data['payment_ref_id'],
                    "ff_incident_no" => $data['incident_no'],
                    "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
                    "LAST_UPDATED_BY" => $user_id
                );

        $this->db->trans_start();
        $this->db->update('tbl_ff_claims',$record,array('ff_claims_id'=>$record['ff_claims_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$data['claims_id'],
                'reference_type'=>'ff_claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($data['claims_id'],'claims', $data["status"], $this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function receiveFFClaimForm($claims_id){

        if(empty($claims_id) || (int) $claims_id <=0){

            $data['actiive'] = 1;
            $data['title'] = 'CLAIMS';
        
        }else{

            $data['active'] = 8;
            $data['title'] = 'NEW CLAIM';
            $data['receive_ff_claims_id'] = $claims_id;
        }

        
        
        $data['subview'] = $this->load->view('admin/claims/manage_claims', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function receiveFFClaim(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $user_id = $this->session->userdata('user_id');

        if(empty($data) || (int) $data['claims_id'] <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $claims = $this->db->select('claim_amount, approved_amount')->where('ff_claims_id', $data['claims_id'])->get('tbl_ff_claims')->row();
        if($claims->approved_amount < $claims->claim_amount){
            $status = 'PART_SETTLED';
        }else{
            $status = 'FULL_SETTLED';
        }

        $record_claim_update = array(
                    
                    "ff_claims_id" => $data['claims_id'],
                    "status" => $status,
                    "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
                    "LAST_UPDATED_BY" => $user_id
                );

        $record_received_insert = array(
                    
                    "ff_claims_id" => $data["claims_id"],
                    "reference_no" => $data['reference_no'],
                    "account_no" => $data['account_no'],
                    "amount" => $data['amount'],
                    "received_date" => $data['received_date'],
                    "CREATION_DATE" => date("Y-m-d H:i:s"),
                    "CREATED_BY" => $user_id
                );

        $this->db->trans_start();

        //Upate Status for Claim
        $this->db->update('tbl_ff_claims',$record_claim_update,array('ff_claims_id'=>$record_claim_update['ff_claims_id']));

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        // Insert Claim in receipts
        $this->db->insert('tbl_ff_claims_receipt', $record_received_insert);

        $claims_id = $data["claims_id"];

        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$claims_id,
                'reference_type'=>'ff_claims',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
        }

        $this->auditlog_model->insert_auditlog($claims_id,'claims',"SETTLED",$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
}