<?php

use function PHPSTORM_META\type;


class Certification extends Admin_Controller
{

    public function __construct()
    {
		parent::__construct(); 
		$this->load->library('Mail');
		$this->load->library('cliq_api');
		/*load model*/
    }
 
    public function manage_certification($id = NULL,$activeId=NULL)
    {   
	
		$this->load->model('Stamphistory_model');
		
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
 
		$data['user_designation']=$this->session->userdata('designations_id');

		$data['certification_list']=$this->db->where('status','1')->get('tbl_certification_dept')->result();
		
        $data['title'] = "CERTIFICATION DEPARTMENT"; //Page title 
   
        $data['subview'] = $this->load->view('admin/certification_department/manage_certification', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }	  
	
	public function uploadCertifiedDevices(){
		//var_dump($_FILES['csv_file']);exit;
	    $errors = array(); $type=""; $msg=""; 
	    if (isset($_FILES["csv_file"])){ 
	      $file_name = $_FILES['csv_file']['name'];
		  $file_size =$_FILES['csv_file']['size'];
		  $file_tmp =$_FILES['csv_file']['tmp_name'];
		  $file_type=$_FILES['csv_file']['type'];
		  $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
		  
		  $extensions= array("csv");
		  
		  if(in_array($file_ext,$extensions)=== false){
			 $errors[]="extension not allowed, please choose a CSV file.";
			 $msg = "extension not allowed, please choose a CSV file.";
		  }
		  
		  if($file_size > 2097152){
			 $errors[]='File size must not exceed 2 MB';
			 $msg = 'File size must not exceed 2 MB';
		  }

		  if(empty($errors)==true){
         	 $handle = fopen($_FILES['csv_file']['tmp_name'], "r");
			 $first_line = true;
			 $stock_type_arr = array();
			 while($col = fgetcsv($handle)){
				if($first_line == false){
					$color=trim($col[9]);
					$ram=strtoupper(trim($col[10]));
					$rom=strtoupper(trim($col[11]));
					$imei1=$col[12];
					$imei2=$col[13];
					$grade=trim($col[14]);
					$deviceid = $col[15];
					$remarks = $col[16].'-'.$col[17];
					$grade_type = $col[19];
					$status = 'CERTIFIED';	

					$grade_result = $this->db->where(array('grade'=>$grade,'type'=>$grade_type))->get('tbl_grade')->row();
					if(empty($grade_result)){
					   $msg='Grade '.$grade.' not found for '.$deviceid; 
					   $type="error";
					   break;				
					}
									
					
					if(strlen($imei1) != 15 && $imei1 != 'NA'){
					   $msg = "Invalid IMEI1 NO For ".$deviceid; 
					   $type = "error";
					   break;
					}

					if(strlen($imei2) != 15 && $imei2 != 'NA'){
						$msg = "Invalid IMEI2 NO For ".$deviceid; 
						$type = "error";
						break;
					 }

					$ram_result = $this->db->where(array('type' => 'RAM', 'value' => $ram))->get('tbl_device_memory')->row();
					if(empty($ram_result)){
					$msg='Invalid RAM value #'.$ram; 
					   $type="error";
					   break;
					}
					$rom_result = $this->db->where(array('type' => 'ROM', 'value' => $rom))->get('tbl_device_memory')->row();
				
					if(empty($rom_result)){
					   $msg='Invalid ROM value #'.$rom; 
					   $type="error";
					   break;
					}

					$variant_result = $this->db->where(array('nhdin'=>$deviceid,'record_status'=>'NEW'))->get('tbl_device_variant_change')->row();
					
					if(!empty($variant_result)){
					   $msg=$deviceid.' is Pending in Variant changed list'; 
					   $type="error";
					   break;				
					}

					$color_check = $this->db->where('color', $color)->get('tbl_colorcode')->row();
					
					if(empty($color_check)){
					   $msg = $color.' is not a valid Color'; 
					   $type="error";
					   break;
					}
					
					if($grade == 'FF') 
						$status = 'FAULTED';
					
					if($grade == 'BER') 
						$status = 'BER';
					
					$modelid_result = $this->db->where('nhdin',$deviceid)->get('tbl_grnreport')->row();
					// $status_arr = array("CERTIFIED","FAULTED");
					// $check_odd = $this->db->order_by('last_updated', 'DESC')->where('device_id', $deviceid)->where_in('status',$status_arr)->get('tbl_device_log')->row();
					// if(empty($check_odd)){
						
					// 	$device_color = $modelid_result->color;
					// } else{
						
					// 	$device_color = $check_odd->color;
					// }
					$device_color = $modelid_result->color;
					$device_color = strtoupper($device_color);
					
					$sku = $this->Common_model->getSKU($modelid_result->nhmod,$ram,$rom,$color);
					
					if($modelid_result->status == 'CIP'){
						
						if(($modelid_result->ram != 'NA' && $modelid_result->ram != $ram) || ($modelid_result->rom != 'NA' && $modelid_result->rom != $rom ) || ($device_color != 'NA' && $device_color != $color)){
							
							$variant_change_array[] = array(
								"old_ram" => $modelid_result->ram,
								"old_rom" => $modelid_result->rom,
								"old_color" => $device_color,
								//"old_color" => $modelid_result->color,
								'nhdin'=> strtoupper(trim($deviceid)),
								'status' => $status,
								'color'=>$color,
								'new_ram'=>$ram,
								'new_rom'=>$rom,
								'imei1_no'=>$imei1,
								'imei2_no'=>$imei2,						
								'certification_grade'=>$grade,
								'sku'=>$sku,
								'checked_by'=>$remarks,
								'certified_date' => date("Y-m-d H:i:s"),
								'created_by' => $this->session->userdata('user_id'),
								'record_status' => 'NEW'
							);
							
						}else{

							$updateArray[] = array(
								'nhdin'=> strtoupper(trim($deviceid)),
								'status' => $status,
								'color'=>$color,
								'ram'=>$ram,
								'rom'=>$rom,
								'imei1_no'=>$imei1,
								'imei2_no'=>$imei2,						
								'certification_grade'=>$grade,
								'sku'=>$sku,
								'checked_by'=>$remarks,
								'certified_date' => date("Y-m-d H:i:s"),
							);
						}

						if(empty($stock_type_arr[$modelid_result->stock_type])){
							$stock_type_arr[$modelid_result->stock_type] = 1;
						}else{
							$stock_type_arr[$modelid_result->stock_type]++;
						}

					}else{
						$type = "error";
						$msg = "Device Status not in CIP -".$deviceid;
						break;
					}
			   }
			   $first_line = false;
			} // end of while
			
			if($type == ''){
				  
				if(!empty($updateArray)){
					$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
				}
				if(!empty($variant_change_array)){
					$this->db->insert_batch('tbl_device_variant_change', $variant_change_array);
					$this->changedDevicesList();
				}

				$this->cliq_api->postCertificationImage($stock_type_arr, 'SUBMIT');
			}
			
		  }	
	    }else{
			
			$type="error";
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN"; 
	    }
		
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);
   }

	public function uploadCertifiedDevices_newForKRA(){
		//var_dump($_FILES['csv_file']);exit;
	    $errors = array(); $type=""; $msg=""; 
		
		$Device_IDs = [];
		
	    if (isset($_FILES["csv_file"])){ 
	      $file_name = $_FILES['csv_file']['name'];
		  $file_size =$_FILES['csv_file']['size'];
		  $file_tmp =$_FILES['csv_file']['tmp_name'];
		  $file_type=$_FILES['csv_file']['type'];
		  $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
		  
		  $extensions= array("csv");
		  
		  if(in_array($file_ext,$extensions)=== false){
			 $errors[]="extension not allowed, please choose a CSV file.";
			 $msg = "extension not allowed, please choose a CSV file.";
		  }
		  
		  if($file_size > 2097152){
			 $errors[]='File size must not exceed 2 MB';
			 $msg = 'File size must not exceed 2 MB';
		  }

		  if(empty($errors)==true){
				$handle = fopen($_FILES['csv_file']['tmp_name'], "r");
				$first_line = true;
				$stock_type_arr = array();
				while($col = fgetcsv($handle)){
					if($first_line == false){
						$color=trim($col[9]);
						$ram=strtoupper(trim($col[10]));
						$rom=strtoupper(trim($col[11]));
						$imei1=$col[12];
						$imei2=$col[13];
						$grade=trim($col[14]);
						$deviceid = $col[15];
						$remarks = $col[16].'-'.$col[17];
						$grade_type = $col[19];
						$status = 'CERTIFIED';	

						$grade_result = $this->db->where(array('grade'=>$grade,'type'=>$grade_type))->get('tbl_grade')->row();
						if(empty($grade_result)){
						$msg='Grade '.$grade.' not found for '.$deviceid; 
						$type="error";
						break;				
						}
										
						
						if(strlen($imei1) != 15 && $imei1 != 'NA'){
						$msg = "Invalid IMEI1 NO For ".$deviceid; 
						$type = "error";
						break;
						}

						if(strlen($imei2) != 15 && $imei2 != 'NA'){
							$msg = "Invalid IMEI2 NO For ".$deviceid; 
							$type = "error";
							break;
						}

						$ram_result = $this->db->where(array('type' => 'RAM', 'value' => $ram))->get('tbl_device_memory')->row();
						if(empty($ram_result)){
						$msg='Invalid RAM value #'.$ram; 
						$type="error";
						break;
						}
						$rom_result = $this->db->where(array('type' => 'ROM', 'value' => $rom))->get('tbl_device_memory')->row();
					
						if(empty($rom_result)){
						$msg='Invalid ROM value #'.$rom; 
						$type="error";
						break;
						}

						$variant_result = $this->db->where(array('nhdin'=>$deviceid,'record_status'=>'NEW'))->get('tbl_device_variant_change')->row();
						
						if(!empty($variant_result)){
						$msg=$deviceid.' is Pending in Variant changed list'; 
						$type="error";
						break;				
						}

						$color_check = $this->db->where('color', $color)->get('tbl_colorcode')->row();
						
						if(empty($color_check)){
						$msg = $color.' is not a valid Color'; 
						$type="error";
						break;
						}
					
						if($grade == 'FF') 
							$status = 'FAULTED';
						
						if($grade == 'BER') 
							$status = 'BER';
						
						$modelid_result = $this->db->where('nhdin',$deviceid)->get('tbl_grnreport')->row();
						$sku = $this->Common_model->getSKU($modelid_result->nhmod,$ram,$rom,$color);
						
						if($modelid_result->status == 'CIP'){

							$deviceid = strtoupper(trim($deviceid));

							if(($modelid_result->ram != 'NA' && $modelid_result->ram != $ram) || ($modelid_result->rom != 'NA' && $modelid_result->rom != $rom )){
								$variant_change_array[] = array(
									"old_ram" => $modelid_result->ram,
									"old_rom" => $modelid_result->rom,
									'nhdin'=> $deviceid,
									'status' => $status,
									'color'=>$color,
									'new_ram'=>$ram,
									'new_rom'=>$rom,
									'imei1_no'=>$imei1,
									'imei2_no'=>$imei2,						
									'certification_grade'=>$grade,
									'sku'=>$sku,
									'checked_by'=>$remarks,
									'certified_date' => date("Y-m-d H:i:s"),
									'created_by' => $this->session->userdata('user_id'),
									'record_status' => 'NEW'
								);
								
							}else{

								$updateArray[] = array(
									'nhdin'=> $deviceid,
									'status' => $status,
									'color'=>$color,
									'ram'=>$ram,
									'rom'=>$rom,
									'imei1_no'=>$imei1,
									'imei2_no'=>$imei2,						
									'certification_grade'=>$grade,
									'sku'=>$sku,
									'checked_by'=>$remarks,
									'certified_date' => date("Y-m-d H:i:s"),
								);
							}

							if(empty($stock_type_arr[$modelid_result->stock_type])){
								$stock_type_arr[$modelid_result->stock_type] = 1;
							}else{
								$stock_type_arr[$modelid_result->stock_type]++;
							}

							if ($grade == 'FF') {
								$Device_IDs[] = $deviceid;
							}
							

						}else{
							$type = "error";
							$msg = "Device Status not in CIP -".$deviceid;
							break;
						}
				}
				$first_line = false;
				} // end of while
				if($type == ''){
					
					/** Get KRA Data for Triage AtStake to update in DB */
					
					$this->load->model('KRA_Model', 'kra_model');

					$kra_data = $this->kra_model->get_KraData_movingToFF($Device_IDs);
					if (!$kra_data['status']) {
						$msg = $kra_data['message'];
						GOTO ERROR;
					}

					$this->db->trans_start();

					
					if (count($kra_data['data']['triage_atStake']) > 0) {
						foreach($kra_data['data']['triage_atStake'] as $stake_arr) {
							$where = [
								'fin_year' => $stake_arr['fin_year'],
								'goal_id' => $stake_arr['goal_id'],
							];
							unset($stake_arr['fin_year']);
							unset($stake_arr['goal_id']);

							$this->db->where($where)->update('tbl_kra_triage_atstake', $stake_arr);
							if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
						}
					}

					if (count($kra_data['data']['kra_ff_arr']) > 0) {
						$this->db->insert_batch('tbl_kra_ff_devices', $kra_data['data']['kra_ff_arr']);
						if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
					}
					
					if(!empty($updateArray)){
						$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
					}
					if(!empty($variant_change_array)){
						$this->db->insert_batch('tbl_device_variant_change', $variant_change_array);
						$this->changedDevicesList();
					}

					$this->db->trans_complete();

					$this->cliq_api->postCertificationImage($stock_type_arr, 'SUBMIT');
				}
			}
	    }else{
			
			$type="error";
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN"; 
	    }
		
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);

		ERROR:
		$this->db->trans_rollback();
		$type="error";
		$msg = isset($msg)? $msg : "Unable to perform your request";
		$this->session->set_userdata($type, $msg);  
		header("location:".$_SERVER['HTTP_REFERER']);

   }
	
	public function getDeviceDetails(){
		$device_id=$_POST['deviceid'];
		  
		$result=$this->db->where('nhdin',$device_id)->get('tbl_grnreport')->row();
		
		if($result==null){
			http_response_code(500);
		}	
		
		echo json_encode($result);
		die;		
	}
	
	// public function getDeviceDetailsByStatus(){
	// 	$status = $_POST['status'];
		
	// 	if(isset($_POST['saletype'])){
	// 	    $saletype = $_POST['saletype'];	
	// 		$result = $this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age')->where(array('status'=>$status,'saletype'=>$saletype))->get('tbl_grnreport')->result_array();
	// 	}else{
	// 	  $result=$this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age')->where('status',$status)->get('tbl_grnreport')->result_array();
	// 	}
		
	// 	echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
	// 	die;		
	// }
	public function getDeviceDetailsByStatus(){
		// $module_type = $_POST['module_type'];
		$status = $_POST['status'];

		$query = $this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age')
					->where('module_type', 1)
					->where('status', $status);
		
		if(isset($_POST['saletype'])){
			$query->where('saletype', $_POST['saletype']);
		}

		$result = $query->get('tbl_grnreport')->result_array();
		
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;		
	}

	public function getDeviceDetailsByAge() {
		$batch_catg_arr = [
			'AMZ_BRANDSEALBOX' => 'AMZ_BRANDSEALBOX',
			'Amz_Buyback' => 'AMZ_BUYBACK',
			'BUYBACK' => 'AMZ_BUYBACK',
			'AMZ_OPENBOX' => 'AMZ_OPENBOX',
			'EXPO' => 'EXPORTS',
			'FK_AOSPREXO' => 'FK_AOS_PREXO',
			'FK_F1_Refurb' => 'FK_F1',
			'FK_Prexo_Laptop' => 'FK_LAPTOPS',
			// 'FK_RVP_Openbox' => 'FK_RVP',
			'FK_RVP_OPENBOX' => 'FK_RVP',
			'Accuspeed_Insurance' => 'INSURANCE',
			'Openbox' => 'OPENBOX_OTHERS',
			'' => 'OPENBOX_OTHERS',
			'FK_PREXO' => 'FK_PREXO',
			'FK_Yan_Prexo' => 'FK_PREXO_YANTRA',
		];
		foreach($batch_catg_arr as $k => $v) {
			$batch_catg_arr[strtolower($k)] = $v;
		}

		$age_bracket = "CASE WHEN (DATEDIFF(CURDATE(),grn_inwarddate) <= 30) THEN '<= 30 Days'
								WHEN (DATEDIFF(CURDATE(),grn_inwarddate) <= 90) THEN '30 - 90 Days'
								WHEN (DATEDIFF(CURDATE(),grn_inwarddate) <= 80) THEN '90 - 180 Days'
								ELSE '> 180 Days'
						END AS age_bracket";
		$rs = $this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age, ' . $age_bracket)
							->where('module_type', 1)
							->where('status!= "SOLD"')
							->order_by('age', 'DESC')
							->get('tbl_grnreport')->result_object();
		
		foreach ($rs as $k => $row) {
			$batch_no = $row->batch_no;
			$invoice_date = $row->invoice_date;
			$device_ID = $row->nhdin;

			$inv_year = (int) date('Y', strtotime($invoice_date));
			$inv_Month = (int) date('m', strtotime($invoice_date));
			$crnt_Year = (int) date('Y');
			// $crnt_Month = (int) date('m');

			if (empty($batch_no)) {
				$batch_category = 'OTHERS_BEFORE FY 2020_MIXED';
			} else {
				$arr = explode('_', $batch_no);
				$catg = '';
				foreach($arr as $i => $v) {
					if ($v > 0) break;
					$catg .= ($i == 0)? $v : '_' . $v;
					if ($i == 0 && strtolower($v) == 'expo') break;
				}
				$catg = strtolower($catg);
				// echo $batch_no;
				// echo $catg;

				$batch_category = $batch_catg_arr[$catg];

				if (substr($device_ID, 1, 1) == 'A') {
					$batch_category = 'ACCESSORIES';

				} else if (in_array($catg, ['amz_buyback', 'buyback'])) {
					$batch_category .= ($inv_year == $crnt_Year)? '_NEW' : '_OLD';
					
				} else if (in_array($catg, ['amz_openbox'])) {
					$batch_category .= ($inv_year >= ($crnt_Year - 1))? '_NEW' : '_OLD';

				} else if (in_array($catg, ['fk_rvp_openbox'])) {
					$batch_category .= (($inv_year == $crnt_Year) || ($inv_year == $crnt_Year-1 && $inv_Month == 12) )? '_NEW' : '_OLD';
				}
				// echo '-'. $batch_category;
				// exit;
			}

			$rs[$k]->batch_category = $batch_category;
		}
		
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($rs),"recordsFiltered"=>count($rs),"data"=>$rs));
		die;
	}
	
	public function downloadDeviceDetailsByStatus(){
		$status = $_POST['status'];
	
		$stock_type = $this->input->post('stock_type');
			$saletype = $this->input->post('saletype');
		$where_arr = array('status'=>$status);
	
		if(!empty($stock_type)){
			$where_arr['stock_type'] = str_replace('_', ' ',$stock_type);
		}

		// $select = 'nhdin,stock_type,device_sub_category,product_brand,device_name,SKU,certification_grade,saletype,status,bin_number,batch_no, DATEDIFF(CURDATE(), grn_inwarddate) as age, charging_status, cleaning_status, is_copydisplay, final_qa, module_type';
		$select = 'nhdin,stock_type,device_sub_category,product_brand,device_name,SKU,certification_grade,saletype,status,bin_number,batch_no, DATEDIFF(CURDATE(), grn_inwarddate) as age, module_type';
		
		if(!empty($_POST['saletype'])){
			$saletype = $_POST['saletype'];	
			$result	=$this->db->select($select)
			->where('module_type', 1)
			->where(array('status'=>$status,'saletype'=>$saletype))
			->get('tbl_grnreport')->result_array();
		}else{
			$result=$this->db->select($select)
			->where('module_type', 1)
			->where($where_arr)
			->get('tbl_grnreport')->result_array();
		}
		// print $this->db->last_query(); 
		// exit;

		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;		
	}
	
	//
	public function blockDevice(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
				
		$updateArray = array();

		$updateArray[] = array(
			'nhdin'=> $data['deviceid'],
			'status' => $data['status'],
			'user_id' => $this->session->userdata('user_id')
		);
		  
		
		$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		
		echo json_encode(array("status"=>"success"));
		die;		
	}

	
	//
	public function updateDeviceStatusToCIP(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		$stock_type_arr = array();
		$updateArray = array();
		$msg = '';
		for($x = 0; $x < sizeof($data); $x++){
			$device = $this->db->select('status, stock_type')->where('nhdin', $data[$x]->deviceid)->get('tbl_grnreport')->row();
			if($device->status == 'SOLD'){
				$msg = 'Cannot Certify SOLD Devices '.$data[$x]->deviceid;
				break;
			}
			if($device->stock_type == 'NEW'){
				$msg = 'Cannot Certify NEW Devices '.$data[$x]->deviceid;
				break;
			}

			if(empty($stock_type_arr[$device->stock_type])){
				$stock_type_arr[$device->stock_type] = 1;
			}else{
				$stock_type_arr[$device->stock_type]++;
			}

			$updateArray[] = array(
				'nhdin'=>$data[$x]->deviceid,
				'status' => 'CIP',
				'issued_category'=> $data[$x]->issued_category,
				'issued_date' => date("Y-m-d H:i:s"),
				'user_id' => $this->session->userdata('user_id')
			);
		}
		if($msg != ''){
			echo json_encode(array("status"=>"error", "msg"=> $msg));
			die;
		}
		if(sizeof($updateArray)>0){
			$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
			$error = $this->db->error();
			
			if($error['code'] == 0){
				$this->cliq_api->postCertificationImage($stock_type_arr);
				echo json_encode(array("status"=>"success"));
				die;
			}

		}else{
			echo json_encode(array("status"=>"error", "msg"=> "No Devices Selected"));
			die;
		}	 
				
	}
	
	// Update Device status to IN_STOCK for Unattempted devices
	public function updateStatusToInStock(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=>$data[$x],
				'status' => 'IN_STOCK',
				'remark' => 'CERTIFICATION UNATTEMPTED',				
				'user_id' => $this->session->userdata('user_id')
			);
		}      
		if(sizeof($updateArray)>0){
			$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		} 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	// Update Status To RFS
	public function updateStatusToRFS(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=>$data[$x]->deviceid,
				'bin_number'=>$data[$x]->bin,				
				'status' => 'RFS',
				'remark' => 'UPDATE STATUS AND BIN '.$data[$x]->bin,
				'user_id' => $this->session->userdata('user_id')
			);
		}      
		if(sizeof($updateArray)>0){
		   $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	// Update Bin number
	public function updateBinNumber(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=>$data[$x]->deviceid,
				'bin_number'=>$data[$x]->bin,	
				'remark'=> "UPDATE BIN NUMBER ".$data[$x]->bin,
				'user_id' => $this->session->userdata('user_id')				
			);
		}      
		if(sizeof($updateArray)>0){
				 $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	// Update Device status to TRIAGE for Faulted devices
	public function updateDeviceStatusToTriage(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=>$data[$x],
				'status' => 'TRIAGE',
				'remark'=> "ALLOCATE TO TRIAGE",
				'user_id' => $this->session->userdata('user_id')
			);
		}      
		if(sizeof($updateArray)>0){
			$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	public function gradeandstatus(){
		$this->load->view('admin/certification_department/updatestatusandgrade');
	}
	
	// Update Grade and Status
	public function updateGradeAndStatus(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		$updateArray = array();
		
		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=>$data[$x]['deviceid'],
				'status'=>'RFS',
				'remark'=>'Manual override of grade.',
                'certification_grade'=>$data[$x]['grade'], 	
				'user_id' => $this->session->userdata('user_id')				
			);
		}      
		if(sizeof($updateArray)>0){
		   $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}

	
	// Upload after Triage status
	public function updateAfterTriageStatus(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		$updateArray = array();
		$wrong_devices = array();
				
		for($x = 0; $x < sizeof($data); $x++){

			$old_status = $this->db->select('status')->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row()->status;

			if($old_status != 'TRIAGE'){	
				$wrong_devices[] = $data[$x]['deviceid'];
			}

			if($data[$x]['status'] == "FF"){
				$status = 'FAULTED';
			}else if($data[$x]['status'] == "NFF"){
				$status = 'IN_STOCK';
			}else if(strtoupper(trim($data[$x]['status'])) == "SERVICE"){
				$status = 'FOR_SERVICE';
			}else{
				echo json_encode(array("status"=>"Error: Device Status Mismatch - ".$data[$x]['status']));
				http_response_code(500);
				die;
			}
			
			$updateArray[] = array(
				'nhdin'=>$data[$x]['deviceid'],
				'status'=>$status,
				'remark'=> 'RETURN FROM TRIAGE', 
				'user_id' => $this->session->userdata('user_id')
			);
		}

		if(sizeof($wrong_devices)>0){
			echo json_encode(array("status"=>"Error: Device Status Mismatch - ".implode(",", $wrong_devices)));
			http_response_code(500);
			die;
		}
		if(sizeof($updateArray)>0){
		   $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"Device Status Updated."));
		die;
	}
	
	/** Bulk Update Status to Triage */
	public function bulkUpdateStatus_toTriage(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
		$updateArray = array();
		$wh_status_arr = ['FAULTED'];

		$Grn_IDs = [];
		$warehouse_arr = array("DELHI","NOIDA");
		try {
			foreach($data as $i => $obj) {
				$device = strtoupper(trim($obj));
				$device_row = $this->db->select('grnreport_id, stock_type, status, warehouse')->where('nhdin', $device)->get('tbl_grnreport')->row();
				
				if (!isset($device_row)) {
					$msg = $device . ' device is invalid at row: ' . ($i + 1);
					GOTO ERROR;
				}
				$crnt_status = $device_row->status;
				// $category = $device_row->stock_type;
				
				if(!in_array($crnt_status, $wh_status_arr)) {
					$msg = $device . ' device status is neither in "' . implode(', ', $wh_status_arr) . '"';
					GOTO ERROR;
				}
				if(in_array($device_row->warehouse,$warehouse_arr)){
					$msg = $device . ' is a '. $device_row->warehouse. ' device';
					GOTO ERROR;
				}
				
				$temp_arr = array(
					'nhdin'=> $device,
					'status' => 'TRIAGE',
					'remark'=> 'ALLOCATE TO TRIAGE', 
					'user_id' => $this->session->userdata('user_id')
				);

				if (!in_array($device_row->grnreport_id, $Grn_IDs)) {
					$updateArray[] = $temp_arr;

					$Grn_IDs[] = $device_row->grnreport_id;
				}
			}
		} catch(Exception $e) {
			$error = "Exception: " . $e->getMessage();
            GOTO ERROR;
		}
		
		if(count($updateArray) == 0) {
			$msg = "Please fill the CSV File";
			GOTO ERROR;
		}
		

		/** Get KRA Data for Triage Targets to update in DB */
		
		// $this->load->model('KRA_Model', 'kra_model');

		// $kra_data = $this->kra_model->get_KraData_movingToTriage($Grn_IDs);
		// if (!$kra_data['status']) {
		// 	$msg = $kra_data['message'];
		// 	GOTO ERROR;
		// }
		// // echo print_r($kra_data['data']['kra_triage_achv']);exit;
		
		$this->db->trans_start();
		

		// if (count($kra_data['data']['kra_triage_achv']) > 0) {
		// 	$this->db->update_batch('tbl_kra_triage_targets', $kra_data['data']['kra_triage_achv'], 'id');
		// 	if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
		// }

		// if (count($kra_data['data']['kra_ff_arr']) > 0) {
		// 	$this->db->update_batch('tbl_kra_ff_devices', $kra_data['data']['kra_ff_arr'], 'id');
		// 	if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
		// }

		$this->db->update_batch('tbl_grnreport', $updateArray, 'nhdin');
		if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }


		$this->db->trans_complete();

		echo json_encode([
			"status" => true,
			'message' => count($updateArray) . ' Device(s) status allocated to "Triage"'
		]);
		die;
		

        ERROR:
		$this->db->trans_rollback();
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ]);
        die;
	}

	/** Bulk Update Status to RFS */
	public function bulkUpdateStatusToRFS(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
		$updateArray = array();
		$wh_status_arr = ['IN_STOCK', 'FAULTED', 'CERTIFIED', 'QA_PASS', 'QA_FAIL'];
		// $wh_status_arr = ['IN_STOCK', 'FAULTED', 'QA_PASS', 'QA_FAIL'];

		$Grn_IDs = [];

		try {
			foreach($data as $i => $obj) {
				$device = strtoupper(trim($obj->deviceid));
				$device_row = $this->db->select('grnreport_id, stock_type, status')->where('nhdin', $device)->get('tbl_grnreport')->row();
				
				if (!isset($device_row)) {
					$msg = $device . ' device is invalid at row: ' . ($i + 1);
					GOTO ERROR;
				}
				$crnt_status = $device_row->status;
				// $category = $device_row->stock_type;
				
				if(!in_array($crnt_status, $wh_status_arr)) {
					$msg = $device . ' device status is neither in "' . implode(', ', $wh_status_arr) . '"';
					GOTO ERROR;
				}
				
				$temp_arr = array(
					'nhdin'=> $device,
					'status' => 'RFS',
					'remark'=> 'BULK STATUS UPDATE TO RFS', 
					'user_id' => $this->session->userdata('user_id')
				);

				if ($obj->bin > 0) {
					$temp_arr['bin_number'] = $obj->bin;
					$temp_arr['remark'] = 'BULK BIN UPDATE ' . $obj->bin;
				}

				if (!in_array($device_row->grnreport_id, $Grn_IDs)) {
					$updateArray[] = $temp_arr;

					$Grn_IDs[] = $device_row->grnreport_id;
				}

			}
		} catch(Exception $e) {
			$error = "Exception: " . $e->getMessage();
            GOTO ERROR;
		}
		
		if(count($updateArray) == 0) {
			$msg = "Please fill the CSV File";
			GOTO ERROR;
		}
		

		/** Get KRA Data for Triage Achievement to update in DB */
		
		// $this->load->model('KRA_Model', 'kra_model');

		// $kra_data = $this->kra_model->get_KraData_movingToRfs($Grn_IDs);
		// if (!$kra_data['status']) {
		// 	$msg = $kra_data['message'];
		// 	GOTO ERROR;
		// }
		// // echo print_r($kra_data['data']['kra_triage_achv']);exit;
		
		$this->db->trans_start();
		

		// if (count($kra_data['data']['kra_triage_achv']) > 0) {
		// 	$this->db->update_batch('tbl_kra_triage_targets', $kra_data['data']['kra_triage_achv'], 'id');
		// 	if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
		// }

		// if (count($kra_data['data']['kra_ff_arr']) > 0) {
		// 	$this->db->update_batch('tbl_kra_ff_devices', $kra_data['data']['kra_ff_arr'], 'id');
		// 	if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }
		// }

		$this->db->update_batch('tbl_grnreport', $updateArray, 'nhdin');
		if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }


		$this->db->trans_complete();

		echo json_encode([
			"status" => true,
			'message' => count($updateArray) . ' Device(s) status changed to "RFS"'
		]);
		die;
		

        ERROR:
		$this->db->trans_rollback();
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ]);
        die;
	}

	
	/** Bulk Update Status to CIP */
	public function bulkUpdateStatusTo_CIP() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);

		/** */
		$stock_type_arr = array();
		
		$updateArray = array();
		$wh_status_arr = ['IN_STOCK', 'FAULTED', 'RFS'];
		// $wh_status_arr = ['IN_STOCK', 'FAULTED', 'DISPLAY_CHECK_DONE', 'RFS'];

		$Grn_IDs = [];
		$warehouse_arr = array("DELHI","NOIDA");
		foreach($data as $i => $obj) {
			$device = strtoupper(trim($obj->deviceid));
			$device_row = $this->db->select('grnreport_id, stock_type, status, cleaning_status, is_copydisplay, warehouse, device_sub_category')->where('nhdin', $device)->get('tbl_grnreport')->row();
			
			if (!isset($device_row)) {
				$msg = $device . ' device is invalid at row: ' . ($i + 1);
				GOTO ERROR;
			}
			$crnt_status = $device_row->status;
			$device_sub_category = $device_row->device_sub_category;
			if($device_sub_category == "ASIS"){
			
				$device_sub_category = "STANDARD";	
			}
			// $category = $device_row->stock_type;
			
			if(!in_array($crnt_status, $wh_status_arr)) {
				$msg = $device . ' device status is neither of "' . implode(', ', $wh_status_arr) . '"';
				GOTO ERROR;
			}
			if($device_row->stock_type == 'NEW') {
				$msg = $device . ' device category is "NEW" which can\'t be allocated to CIP';
				GOTO ERROR;
			}

			if(in_array($device_row->warehouse, $warehouse_arr)) {
				$msg = $device . ' is a ' . $device_row->warehouse. ' device';
				GOTO ERROR;
			}
			/** For Prexo Devices */
			if (in_array($device_row->stock_type, EXEMPT_CATEGORY)) {
				// if ( (!isset($device_row->cleaning_status) || $device_row->cleaning_status < 0) ) {
				// 	$msg = $device . ' device "CLEANING" is not done';
				// 	GOTO ERROR;
				// }
				// if ( (!isset($device_row->is_copydisplay) || $device_row->is_copydisplay < 0) ) {
				// 	$msg = $device . ' device "DISPLAY_CHECK" is not done';
				// 	GOTO ERROR;
				// }
			}
			
			if (empty($stock_type_arr[$device_row->stock_type])) {
				$stock_type_arr[$device_row->stock_type] = 1;
			} else{
				$stock_type_arr[$device_row->stock_type]++;
			}
			
			$temp_arr = array(
				'nhdin'=> $device,
				'status' => 'CIP',
				'is_p2p' => 'NO',
				'device_sub_category' => $device_sub_category,
				'issued_date' => date("Y-m-d H:i:s"),
				'user_id' => $this->session->userdata('user_id')
			);

			if (isset($obj->issued_category) && $obj->issued_category != 'NA') {
				$temp_arr['issued_category'] = $obj->issued_category;
			}

			if (!in_array($device_row->grnreport_id, $Grn_IDs)) {
				$updateArray[] = $temp_arr;

				$Grn_IDs[] = $device_row->grnreport_id;
			}
		}
		
		if(count($updateArray) == 0) {
			$msg = "Please fill Data";
			GOTO ERROR;
		}
		
		$this->db->update_batch('tbl_grnreport', $updateArray, 'nhdin');
		if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }

		// $this->cliq_api->postCertificationImage($stock_type_arr);

		echo json_encode([
			"status" => true,
			'message' => count($updateArray) . ' Device(s) status changed to "CIP"'
		]);
		exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ]);
        exit;
	}
	
	//Update Sale Type
	public function updateDeviceSaleType(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		
		$updateArray = array();
		$warehouse_arr = array("DELHI","NOIDA");
		for($x = 0; $x < sizeof($data); $x++){
			//$stock_type = $this->db->select('stock_type')->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row()->stock_type;
			//$where = "bundle_id is  NOT NULL";
			//$bundle_id = $this->db->select('bundle_id')->where($where)->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row()->bundle_id;
			$device_row = $this->db->select('bundle_id, warehouse')->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row();
			$bundle_id = $device_row->bundle_id;
			$warehouse = $device_row->warehouse;
			try{

				$saletype = $data[$x]['saletype'];
				if($saletype != 'OFFLINE' && $saletype != 'ONLINE' && $saletype != 'DEALERAPP'){
					http_response_code(500);
					echo json_encode(array("status"=>"Invalid Sale Type-".$saletype));
					die;
				}
				if(in_array($warehouse, $warehouse_arr)){
					http_response_code(500);
					echo json_encode(array("status"=>$data[$x]['deviceid']." is a ".$warehouse." device"));
					die;
				}
				if($saletype == 'ONLINE'){
				    if((int)$bundle_id > 0){
				        http_response_code(500);
					    echo json_encode(array("status"=>$data[$x]['deviceid']." is bundle device"));
					    die;
				    }
				}
				
				// if($saletype == 'OFFLINE'){
				// 	if(in_array($stock_type, TAXABLE_CATEGORY)){
				// 		$invoice_type = 'TAXABLE';
				// 	}else{
				// 		$invoice_type = 'EXEMPT';
				// 	}
					$updateArray[] = array(
						'nhdin'=>$data[$x]['deviceid'],
						'saletype' =>$saletype,
						'bin_number' =>$data[$x]['bin_number'],
						'remark'=> 'UPDATE SALE TYPE '.$saletype, 
						'user_id' => $this->session->userdata('user_id'),
					  );
				// }else{
				// 	$invoice_type = 'TAXABLE';
				// 	$updateArray[] = array(
				// 		'nhdin'=>$data[$x]['deviceid'],
				// 		'saletype' =>$saletype,
				// 		'bin_number' =>$data[$x]['bin_number'],
				// 		'remark'=> 'UPDATE SALE TYPE '.$saletype, 
				// 		'user_id' => $this->session->userdata('user_id'),
				// 		'invoice_type' => $invoice_type
				// 	  );
				// }

				
				
			}catch(Exception $e) { 
				echo "\n Exception Caught", $e->getMessage(); 
			}	
		}      
		
		if(sizeof($updateArray)>0){
			$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	public function updateDevicebac(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
			try{
				$updateArray[] = array(
				  'nhdin'=>$data[$x]['deviceid'],
			   	  'bac' =>$data[$x]['bac'],
				  'remark'=> 'UPDATE BAC '.$data[$x]['bac'], 
				  'user_id' => $this->session->userdata('user_id')
				);
				
			}catch(Exception $e) { 
				echo "\n Exception Caught", $e->getMessage(); 
			}	
		}      
		
		if(sizeof($updateArray)>0){
			$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	
	//Bulk Update BIN Number
	public function bulkUpdateBINNumber(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		$updateArray = array();

		for($x = 0; $x < sizeof($data); $x++){
				$status = $this->db->select('status')->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row()->status;
				if($status == 'IN_STOCK' || $status == 'FAULTED' || $status == 'CERTIFIED'){
					$updateArray[] = array(
						'nhdin'=> strtoupper(trim($data[$x]['deviceid'])),
						'status' => 'RFS',
						'bin_number'=> $data[$x]['bin'],
						'remark'=> 'BULK BIN UPDATE '.$data[$x]['bin'], 
				        'user_id' => $this->session->userdata('user_id')
					);
				}
		}      
		
		try{
			if(sizeof($updateArray)>0){
				 $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
			}	 
		}catch(Exception $e) { 
				echo "\n Exception Caught", $e->getMessage(); 
		}
		
		echo json_encode(array("status"=>"success"));
		die;		
	}

	//Bulk Update BIN Number without RFS //i.e, All Devices
	public function bulkUpdateBINNumberAllDevices(){
		$request = file_get_contents("php://input");  
		$data = json_decode($request,true);
		$updateArray = array();
		$status = $this->db->select('status')->where('nhdin',$data[$x]['deviceid'])->get('tbl_grnreport')->row()->status;
					
		for($x = 0; $x < sizeof($data); $x++){
			$updateArray[] = array(
				'nhdin'=> $data[$x]['deviceid'],
				//'status' => 'RFS',
				'bin_number'=> $data[$x]['bin'],
				'remark'=> 'BULK BIN UPDATE '.$data[$x]['bin'], 
				'user_id' => $this->session->userdata('user_id')
			);
		}      
		
		try{
			if(sizeof($updateArray)>0){
				 $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
			}	 
		}catch(Exception $e) { 
				echo "\n Exception Caught", $e->getMessage(); 
		}
		
		echo json_encode(array("status"=>"success"));
		die;		
	}
	public function bulkUpdateStatusToCIP(){
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
		$updateArray = array();
		$status_arr = ['IN_STOCK','FAULTED','RFS'];
		for($x = 0; $x < sizeof($data); $x++){
			try{
				$device = $this->db->select('status, stock_type')->where('nhdin',$data[$x])->get('tbl_grnreport')->row();
			
				if(in_array($device->status,$status_arr) && $device->stock_type != 'NEW'){
					$updateArray[] = array(
						'nhdin'=>$data[$x],
						'status' => 'CIP',
						'issued_date' => date("Y-m-d H:i:s")
					);
				}

				
			}catch(Exception $e) { 
				echo "\n Exception Caught", $e->getMessage(); 
			}	
		}      
		
		if(sizeof($updateArray)>0){
				 $this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
		}	 
		
		echo json_encode(array("status"=>"success"));
		die;		
	}

	public function changedDevicesList($devices = array()){

		if(empty($data)){
			return false;
		}

		$data['devices'] = $devices;
		$data['active'] = 4;
		$data['title'] = "CERTIFICATION DEPARTMENT"; //Page title 
   
        $data['subview'] = $this->load->view('admin/certification_department/manage_certification', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}

	public function getDeviceVariantChangeList(){

		$record_status =  $this->input->get('record_status');
        if($record_status == ''){
            $record_status = 'NEW';
        }

        $result = array();
        $result = $this->db->where('record_status', $record_status)->get('tbl_device_variant_change')->result_array();
        
        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        foreach($result as $rowValue){
                
			 $rows[] = array(
				 			"device_variant_change_id" => $rowValue["device_variant_change_id"],
							"old_ram" => $rowValue['old_ram'],
							"old_rom" => $rowValue['old_rom'],
							"old_color" => $rowValue['old_color'],
							"new_color" => $rowValue['color'],
							'nhdin'=> $rowValue['nhdin'],
							'new_ram'=>$rowValue['new_ram'],
							'new_rom'=>$rowValue['new_rom'],
							'imei1_no'=>$rowValue['imei1_no'],
							'imei2_no'=>$rowValue['imei2_no'],
							'record_status'=>$rowValue['record_status'],
						);
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
	}

	public function updateDeviceVariantChange(){

		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		
		$result = $this->db->where('device_variant_change_id', $data['device_variant_change_id'])->get('tbl_device_variant_change')->row();

		//Check Status of the Stocktransfer Order
		if($result->record_status != 'NEW'){
			$json['status'] = 0;
			echo json_encode($json);
			die;
		}

		$device_status = $this->db->select('status')->where('nhdin', $result->nhdin)->get('tbl_grnreport')->row()->status;
		if($device_status != 'CIP'){
			$json['status'] = 3;
			echo json_encode($json);
			die;
		}

		if(strpos($data['new_ram'], " ") !== false || strpos($data['new_rom'], " ")!== false){
			$json['status'] = 2;
			echo json_encode($json);
			die;
		}
		if($data['new_ram'] != $result->old_ram || $data['new_rom'] != $result->old_rom){
			$record_changed = true;
		}
		$nhmod = $this->db->select('nhmod')->where('nhdin', $result->nhdin)->get('tbl_grnreport')->row()->nhmod;
		$sku = $this->Common_model->getSKU($nhmod,$data["new_ram"],$data["new_rom"],$result->color);

		$updateArray = array(
			'nhdin'=> strtoupper(trim($result->nhdin)),
			'status' => $result->status,
			'color'=>$result->color,
			'ram'=>$data["new_ram"],
			'rom'=>$data["new_rom"],
			'imei1_no'=>$result->imei1_no,
			'imei2_no'=>$result->imei2_no,						
			'certification_grade'=>$result->certification_grade,
			'sku'=>$sku,
			//'checked_by'=>$result->remarks,
			'checked_by'=>$result->checked_by,
			'certified_date' => date("Y-m-d H:i:s"),
		);

		$this->db->where('nhdin', $result->nhdin);
		$this->db->update('tbl_grnreport',$updateArray);
		
		$error = $this->db->error();
		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			die;
		}
		
		$deviceVariantArray = array(
								'device_variant_change_id' => $data['device_variant_change_id'],
								'record_status' => 'CERTIFIED',
								'last_updated_by' => $this->session->userdata('user_id'),

							);
		$this->db->where('device_variant_change_id', $data['device_variant_change_id']);
		$this->db->update('tbl_device_variant_change', $deviceVariantArray);
		
		$error = $this->db->error();
		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			die;
		}
		/*
		if($record_changed){
			$to_array = $this->db->where('module_name', 'DEVICE VARIANT CHANGE')->get('tbl_mailing_list')->result_array();
			foreach($to_array as $rowValue){
				$to[] = $rowValue['email_address'];
			}
			if(count($to)<= 0){
				return false;
			}

			$mail = '<p>Hi,</p>
					<p>This mail is to inform you that RAM/ROM value changed for device nhdin <strong>'.$result->nhdin.'</strong>
					 from <strong>'.$result->old_ram.'-'.$result->old_rom.'</strong> to <strong>'.$data["new_ram"].'-'.$data["new_rom"].'</strong></p>
					<br>
					<p>Thanks &amp; Regards,</p>
					<p><br></p>
					<p>This mail is an automated reply. Please don&apos;t reply to this mail.</p>';
			$this->mail->sendEmail($to,'Notification: Variant Changed For :'.$result->nhdin, $mail);
		}
	*/
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function deleteDeviceVariantChange()
	{
		$device_variant_id = $this->input->get('device_variant_change_id');

		if((int) $device_variant_id <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->where('device_variant_change_id', $device_variant_id);
		$this->db->delete('tbl_device_variant_change');

		$error = $this->db->error;

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}
	
	public function getCertDueDevices()
	{
		/*$where_arr = array(
			"DATEDIFF(CURDATE(),DATE(issued_date)) >" => 7,
			"status" => "RFS",
			"stock_type"=> "OPEN BOX",
			"saletype !="=>"AMAZON"
		);
		$count = $this->db->select('count(grnreport_id) as count')->where($where_arr)->get('tbl_grnreport')->row()->count;
		*/
		$data = array(
			"nhdin" => 1,
			"entry_pass"=> "k",
			"invoice_date"=>date("y-m-d")
		);
		$this->db->insert('demo', $data);
		print $count." RFS Devices need to be recertified.";exit;
	}
}