<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Bundles extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();
    }
	
public function checkInvoice()
    {
	
	$year = ( date('m') > 3) ? date('y') : date('y') - 1;
	echo $year; exit;
	$curreny_year = date("y");
        $next_year = $curreny_year + 1;
        $string = substr("HYD", 0, 1);
	$series = "SL".$string.$curreny_year.$next_year;
            $res = $this->db->from('tbl_invoice AS inv')
                            ->join('tbl_salesorder AS so', 'so.salesorder_id = inv.salesorder_id AND so.module_type = 1', 'INNER')
                            ->like('invoice_code',$series)
                            ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                            ->get()->row_array();
            
            $next_number=$res['max']+1;
            if($res['max']==null) $next_number=1;
            $invoice_code=$series.'-'.$next_number;
	    echo $invoice_code; exit;	
}
    public function manage_bundles($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'BUNDLES';
        $data['subview'] = $this->load->view('admin/bundles/manage_bundles', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function addBundle()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $deviceId_arr = [];
        foreach ($data['items'] as $key => $val) {
            $tdid = strtoupper($val['device_id']);
            $deviceId_arr[] = $tdid;
            unset($tdid);
        }
        $tdCount = count($deviceId_arr);
        $givenCount = $data['bundle_quantity'];
        if ($tdCount != $givenCount) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Quantity and Device Quantity does not match.'
            );
            echo json_encode($response);
            exit;
        }
        $remainder = fmod($tdCount,10);
        if($remainder  != 0){
            $response = array(
                'status' => 0,
                'message' => 'you can not create complete bundles with '.$tdCount
            );
            echo json_encode($response);
            exit;
        }
        $bundle_data = array_chunk($data['items'], 10);
        foreach($bundle_data as $bundle_item){
           
       //Next no in the series for bundle no (BNDL-XXXX)
        
        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(bundle_no,"-",-1) as UNSIGNED)) as max')->from('tbl_dealer_bundle')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $header_arr = array(
            "bundle_no" => "BNDL-" . $next_number,
            //"type" => $data['bundle_type'],
            "type" => $bundle_item[0]['bundle_type'],
            "status" => 'PENDING',
            "quantity" => 10,
            "category" => $data['bundle_category'],
            "sub_category" => $data['bundle_sub_category'],
            "created_by" => $this->session->userdata('user_id'),
            "updated_by" => $this->session->userdata('user_id'),
            "created_date" => date('Y-m-d H:i:s'),
            "updated_date" => date('Y-m-d H:i:s')
        );
        //echo "<pre>"; print_r($header_arr); echo "</pre>"; exit;
        $item_arr = [];
        $nhdin_arr = [];
        $price_arr = [];
        $mop_arr = [];
        $valid_nhdin = [];
        $items_grades = [];
        $items_brands = [];
        $items_remarks = [];
	$allowStockType = array("PREXO", "BUY BACK", "BUYBACK","PRELOVED");
        foreach ($bundle_item as $rowValue) {
            $device_id = strtoupper($rowValue['device_id']);
            $nhdin_arr[] = $device_id;
            $items_remarks[$device_id] = $rowValue['remark'];
            $mop_arr[$device_id] = $rowValue['mop'];
            unset($device_id);
        }
        
        // if (count($nhdin_arr) != $data['bundle_quantity']) {
        //     $response = array(
        //         'status' => 0,
        //         'message' => 'Bundle Quantity and Device Quantity does not match.'
        //     );
        //     echo json_encode($response);
        //     exit;
        // }

        $grn_result = $this->db->where_in('nhdin', $nhdin_arr)->get('tbl_grnreport')->result_array();
        //echo "<pre>"; print_r($grn_result); echo "</pre>"; exit;
        $total_amount = 0;
        $total_mop = 0;
        $grnreport_ids = [];
	
        foreach ($grn_result as $rowValue) {
            if ($rowValue['status'] != 'RFS') {
                $json_arr['status'] = 0;
                $json_arr['message'] = $rowValue['nhdin'] . ' not in RFS status';
                echo json_encode($json_arr);
                exit;
            }

	    if ($rowValue['warehouse'] != 'HYDERABAD') {
                $json_arr['status'] = 0;
                $json_arr['message'] = $rowValue['nhdin'] . ' is a '. $rowValue['warehouse'] . ' device';
                echo json_encode($json_arr);
                exit;
            }

            if ($rowValue['saletype'] != 'OFFLINE') {
                $json_arr['status'] = 0;
                $json_arr['message'] = $rowValue['nhdin'] . ' not an OFFLINE device';
                echo json_encode($json_arr);
                exit;
            }
            
            if ((int)$rowValue['mrp'] <= 0) {
                $json_arr['status'] = 0;
                $json_arr['message'] = 'Price is not set for ' . $rowValue['nhdin'];
                echo json_encode($json_arr);
                exit;
            }
	    
            if(in_array($rowValue['stock_type'], $allowStockType ) == false){

		if ($rowValue['stock_type'] != $data['bundle_category']) {
                $json_arr['status'] = 0;
                $json_arr['message'] = $rowValue['nhdin'] . ' not in ' . $data['bundle_category'] . ' category';
                echo json_encode($json_arr);
                exit;
            	}
		
	    }
            
           
            // if ($rowValue['device_sub_category'] != $data['bundle_sub_category']) {
            //     $json_arr['status'] = 0;
            //     $json_arr['message'] = $rowValue['nhdin'] . ' not in ' . $data['bundle_sub_category'] . ' sub category';
            //     echo json_encode($json_arr);
            //     exit;
            // }
	    
	    $checkSalesReturn = $this->db->get_where('tbl_salesreturn_item', array("device_id" => $rowValue['grnreport_id']))->num_rows();
	    if($checkSalesReturn < 1){
	    	if ($rowValue['bundle_id'] > 0) {
                	$json_arr['status'] = 0;
                	$json_arr['message'] = $rowValue['nhdin'] . ' already in another bundle';
                	echo json_encode($json_arr);
                	exit;
            	}
	    }
            
            $valid_nhdin[] = $rowValue['nhdin'];
            $item_arr[] = array(
                "grnreport_id" => $rowValue['grnreport_id'],
                "price" => $rowValue['mrp'],
                "mop" => $mop_arr[strtoupper($rowValue['nhdin'])],
                "grade" => $rowValue['certification_grade'],
                "remark" => $items_remarks[strtoupper($rowValue['nhdin'])],
            );

            $total_amount += $rowValue['mrp'];
            $total_mop += $mop_arr[strtoupper($rowValue['nhdin'])];
            $items_grades[] = $rowValue['certification_grade'];
            $items_brands[] = $rowValue['product_brand'];
            $grnreport_ids[] = $rowValue['grnreport_id'];
        }
        $diff_arr = array_diff($nhdin_arr, $valid_nhdin);
        if (count($diff_arr) > 0) {
            $json_arr['status'] = 0;
            $json_arr['message'] = implode(',', $diff_arr) . ' is/are not valid device ids';
            echo json_encode($json_arr);
            exit;
        }

        $status_arr = ["DRAFT", "FINANCE_PENDING", "FINANCE_APPROVED", "INVOICED"];

        $this->db->join('tbl_salesorder', 'tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id', 'Left');
        $old_so = $this->db->where_in('tbl_salesorder_item.grnreport_id', $grnreport_ids)->where_in('tbl_salesorder.status', $status_arr)->get('tbl_salesorder_item')->result_array();
        
        if (!empty($old_so)) {
            $json['status'] = 0;
            $json['message'] = 'Some of the device ids are already in sales order';
            echo json_encode($json);
            die;
        }

        // Type Validations
       /* $valid = $this->typeValidations($data['bundle_type'],  $items_grades, $items_brands);
        if ($valid == false) {
            $json_arr['status'] = 0;
            $json_arr['message'] = 'Bundle type and device grade compositions does not match';
            echo json_encode($json_arr);
            exit;
        }
        */

        $header_arr['amount'] = $total_amount;
        $header_arr['mop'] = $total_mop;

        $this->db->trans_start();

        $this->db->insert('tbl_dealer_bundle', $header_arr);
        $bundle_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if ($error['code'] != 0) {
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }

        $update_grn_arr = [];

        foreach ($item_arr as $key => $rowValue) {
            $item_arr[$key]['bundle_id'] = $bundle_id;
            $update_grn_arr[] = array(
                "grnreport_id" => $rowValue['grnreport_id'],
                "bundle_id" => $bundle_id
            );
        }
        $this->db->insert_batch('tbl_dealer_bundle_item', $item_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }
        $this->db->update_batch('tbl_grnreport', $update_grn_arr, 'grnreport_id');
        $this->db->trans_complete();
       }
        
        $json_arr['status'] = 1;
        $json_arr['message'] = 'Bundle Created Successfully';
        echo json_encode($json_arr);
        exit;
    }
    public function getBundlesList()
    {
        $status = $this->input->get('status');

        $this->db->where('status', $status);
        $this->db->order_by('bundle_id', 'DESC');

        $result = $this->db->get('tbl_dealer_bundle')->result_array();
        $result_arr = [];

        foreach ($result as $rowValue) {
            $result_arr[] = array(
                'bundle_id' => $rowValue['bundle_id'],
                'bundle_no' => $rowValue['bundle_no'],
                'type' => $rowValue['type'],
                'quantity' => $rowValue['quantity'],
                'amount' => $rowValue['amount'],
                'category' => $rowValue['category'],
                'sub_category' => $rowValue['sub_category'],
                'status' => $rowValue['status'],
                'created_by' => $rowValue['created_by'],
                'created_date' => $rowValue['created_date'],
                'updated_by' => $rowValue['updated_by'],
                'updated_date' => $rowValue['updated_date'],
            );
        }

        $response = array(
            'status' => 1,
            'message' => 'Bundle List',
            'data' => $result_arr
        );
        echo json_encode($response);
        exit;
    }

    public function getBundleItems()
    {
        $bundle_id = $this->input->get('bundle_id');

        if (empty($bundle_id)) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Id is required',
                'data' => []
            );
            echo json_encode($response);
            exit;
        }

        $this->db->where('tbl_dealer_bundle_item.bundle_id', $bundle_id);
        $result = $this->db->select('tbl_dealer_bundle_item.*, tbl_grnreport.nhdin, tbl_grnreport.device_name, tbl_grnreport.SKU, tbl_grnreport.stock_type, tbl_grnreport.device_sub_category')
            ->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_dealer_bundle_item.grnreport_id')
            ->get('tbl_dealer_bundle_item')->result_array();

        $result_arr = [];
        foreach ($result as $rowValue) {
            $result_arr[] = array(
                'bundle_item_id' => $rowValue['item_id'],
                'bundle_id' => $rowValue['bundle_id'],
                'grnreport_id' => $rowValue['grnreport_id'],
                'nhdin' => $rowValue['nhdin'],
                'device_name' => $rowValue['device_name'],
                'sku' => $rowValue['SKU'],
                'category' => $rowValue['stock_type'],
                'sub_category' => $rowValue['device_sub_category'],
                'mop' => $rowValue['mop'],
                'price' => $rowValue['price'],
                'grade' => $rowValue['grade'],
                'remark' => ($rowValue['remark'] === null) ? '' : $rowValue['remark'],
            );
        }

        $response = array(
            'status' => 1,
            'message' => 'Bundle Items',
            'data' => $result_arr
        );
        echo json_encode($response);
        exit;
    }

    public function checkDeviceId()
    {
        $device_id = $this->input->get('device_id');
        $bundle_id = $this->input->get('bundle_id');
        if (empty($device_id)) {
            $response = array(
                'status' => 0,
                'message' => 'Device Id is required',
            );
            echo json_encode($response);
            exit;
        }

        $this->db->where('nhdin', $device_id)->where('bundle_id', $bundle_id);
        $result = $this->db->get('tbl_grnreport')->row_array();
        
        if (empty($result)) {
            $response = array(
                'status' => 0,
                'message' => 'Device Id does not exist',
            );
            echo json_encode($response);
            exit;
        }

        $data = array(
            "nhdin" => $result['nhdin'],
            "device_name" => $result['device_name'],
            "sku" => $result['SKU'],
            "category" => $result['stock_type'],
            "sub_category" => $result['device_sub_category'],
            "price" => $result['mrp'],
            "grade" => $result['certification_grade'],
        );

        $response = array(
            'status' => 1,
            'message' => 'Device is Valid',
            'data' => $data
        );
        echo json_encode($response);
        exit;
    }

    public function getBundleHeader()
    {
        $bundle_id = $this->input->get('bundle_id');

        if (empty($bundle_id)) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Id is required',
                'data' => []
            );
            echo json_encode($response);
            exit;
        }

        if ($bundle_id < 0) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Id is required',
            );
            echo json_encode($response);
            exit;
        }
        $record = [];
        $this->db->where('bundle_id', $bundle_id);
        $result = $this->db->get('tbl_dealer_bundle')->row_array();
        $record[] = array(
            'bundle_id' => $result['bundle_id'],
            'bundle_no' => $result['bundle_no'],
            'type' => $result['type'],
            'quantity' => $result['quantity'],
            'amount' => $result['amount'],
            'category' => $result['category'],
            'sub_category' => $result['sub_category'],
            'status' => $result['status'],
            'created_by' => $result['created_by'],
            'created_date' => $result['created_date'],
            'updated_by' => $result['updated_by'],
            'updated_date' => $result['updated_date'],
        );

        $response = array(
            'status' => 1,
            'message' => 'Bundle Form',
            'data' => $record
        );
        echo json_encode($response);
        exit;
    }

    public function updateBundleForm($bundle_id)
    {
        if ($bundle_id <= 0) {
            $data['active'] = 1;
        } else {
            $data['active'] = 3;
            $data['update_bundle_id'] = $bundle_id;
        }
        $data['title'] = 'UPDATE BUNDLE';
        $data['subview'] = $this->load->view('admin/bundles/manage_bundles', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function editBundleForm($bundle_id)
    {
        if ($bundle_id <= 0) {
            $data['active'] = 1;
        } else {
            $data['active'] = 4;
            $data['edit_bundle_id'] = $bundle_id;
        }
        $data['title'] = 'EDIT BUNDLE';
        $data['subview'] = $this->load->view('admin/bundles/manage_bundles', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function updateBundle()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $bundle_id = $data['bundle_id'];
        $items = array_map('strtoupper', $data['items']);

        if ($bundle_id <= 0) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Id is required',
            );
            echo json_encode($response);
            exit;
        }

        $remarks = $data['remarks'];

        if (empty($bundle_id)) {
            $response = array(
                'status' => 0,
                'message' => 'Bundle Id is required',
            );
            echo json_encode($response);
            exit;
        }

        $this->db->where('bundle_id', $bundle_id);
        $result = $this->db->get('tbl_dealer_bundle')->row_array();
        if ($result['status'] != 'PENDING') {
            $response = array(
                'status' => 0,
                'message' => 'Bundle is already packed',
            );
            echo json_encode($response);
            exit;
        }

        $item_result = $this->db->select('nhdin')->where('tbl_dealer_bundle_item.bundle_id', $bundle_id)
            ->where('tbl_grnreport.bundle_id', $bundle_id)
            ->join('tbl_grnreport', 'tbl_grnreport.grnreport_id=tbl_dealer_bundle_item.grnreport_id')
            ->get('tbl_dealer_bundle_item')
            ->result_array();

        foreach ($item_result as $item) {
            $nhdin[] = strtoupper($item['nhdin']);
        }

        $diff = array_diff($nhdin, $items);

        if (!empty($diff)) {
            $response = array(
                'status' => 0,
                'message' => 'Not All Devices are packed',
            );
            echo json_encode($response);
            exit;
        }

        $diff = array_diff($items, $nhdin);

        if (!empty($diff)) {
            $response = array(
                'status' => 0,
                'message' => 'Extra Devices are packed',
            );
            echo json_encode($response);
            exit;
        }

        $this->db->trans_start();

        $update_arr = array(
            "status" => 'ACTIVE',
            "updated_by" => $this->session->userdata('user_id'),

        );

        $this->db->where('bundle_id', $bundle_id);
        $this->db->update('tbl_dealer_bundle', $update_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }

        if (!empty($remarks)) {
            $remarks_arr = array(
                "reference_id" => $bundle_id,
                "reference_type" => 'bundle',
                "remark" => $remarks,
                "user_id" => $this->session->userdata('user_id'),
                "date" => date('Y-m-d H:i:s')
            );
            $this->db->insert('tbl_remark', $remarks_arr);
        }

        $this->db->trans_complete();

        $json_arr['status'] = 1;
        $json_arr['message'] = 'Bundle Approved';
        echo json_encode($json_arr);
        exit;
    }

    public function typeValidations($type = '', $items_grades = array(), $items_brands = array())
    {
        if (empty($type) || empty($items_grades) || empty($items_brands)) {
            return false;
        }

        $grade_count = array_count_values($items_grades);
        $items_brands = array_map('strtolower', $items_brands);
        $brand_count = array_count_values($items_brands);
        if ($type == '1A') {
            if ($grade_count['SG-A'] == 5 && $grade_count['SG-B'] == 5) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '1B') {
            if ($grade_count['SG-A'] == 4 && $grade_count['SG-B'] == 6) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '1C') {
            if ($grade_count['SG-A'] == 2 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 5) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '1D') {
            if ($grade_count['SG-D'] == 10) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '1E') {
            if ($grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 7) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '1F') {
            if ($grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 5 && $grade_count['SG-D'] == 2) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2A') {
            if ($brand_count['xiaomi'] == 10 && $grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2B') {
            if ($brand_count['samsung'] == 10 && $grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2C') {
            if ($brand_count['realme'] == 10 && $grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2D') {
            if ($brand_count['oppo'] == 10 && $grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2E') {
            if ($brand_count['vivo'] == 10 && $grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }

        if ($type == '2F') {
            if ($grade_count['SG-A'] == 3 && $grade_count['SG-B'] == 3 && $grade_count['SG-C'] == 4) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function getPDFData()
    {
        $bundle_id = $this->input->get('bundle_id');

        if(empty($bundle_id)){
            $response = array(
                'status' => 0,
                'message' => 'Bundle ID is required',
            );
            echo json_encode($response);
            exit;
        }

        $result = $this->db->select('bundle_id, bundle_no, type, status, created_date')
            ->where('bundle_id', $bundle_id)
            ->get('tbl_dealer_bundle')
            ->row();
        
        if(empty($result)){
            $response = array(
                'status' => 0,
                'message' => 'Bundle not found',
            );
            echo json_encode($response);
            exit;
        }

        $bundle_items = $this->db->select('tbl_grnreport.nhdin, price, device_name, ram, rom, color,tbl_dealer_bundle_item.mop as mop,tbl_dealer_bundle_item.price as price') // added mrp as mop in the place of mop
            ->where('tbl_dealer_bundle_item.bundle_id', $bundle_id)
            ->join('tbl_grnreport', 'tbl_grnreport.grnreport_id=tbl_dealer_bundle_item.grnreport_id')
            ->get('tbl_dealer_bundle_item')
            ->result();
        $sno = 1;
        $items = array();
        foreach ($bundle_items as $item) {
            $items[] = array(
                'sno' => $sno,
                'nhdin' => $item->nhdin,
                'price' => $item->price,
                'mop' => $item->mop,
                'device_name' => $item->device_name,
                'ram' => $item->ram,
                'rom' => $item->rom,
                'color' => $item->color,
            );
            $sno++;
        }

        $data = array(
            "bundle_id" => $result->bundle_id,
            "bundle_no" => $result->bundle_no,
            "bundle_type" => $result->type,
            "bundle_date" => date("d-m-Y", strtotime($result->created_date)),
            "items" => $items
        );

        $json['status'] = 1;
        $json['message'] = 'Success';
        $json['result'] = $data;

        echo json_encode($json);
        exit;
    }

    public function getBundleInfoByDeviceId()
    {
        $device_id = $this->input->get('device_id');

        if(empty($device_id)){
            $response = array(
                'status' => 0,
                'message' => 'Device ID is required',
            );
            echo json_encode($response);
            exit;
        }

        $result = $this->db->select('tbl_dealer_bundle.bundle_id, tbl_dealer_bundle.bundle_no, tbl_dealer_bundle.status')
                            ->where('tbl_grnreport.nhdin', $device_id)
                            ->join('tbl_dealer_bundle', 'tbl_dealer_bundle.bundle_id=tbl_grnreport.bundle_id')
                            ->get('tbl_grnreport')
                            ->row();
        
        if(empty($result)){
            $response = array(
                'status' => 0,
                'message' => 'Device not found',
            );
            echo json_encode($response);
            exit;
        }

        $data = array(
            "bundle_id" => $result->bundle_id,
            "bundle_no" => $result->bundle_no,
            "status" => $result->status,
        );

        $json['status'] = 1;
        $json['message'] = 'Success';
        $json['result'] = $data;
        echo json_encode($json);
        exit;
    }

    function getBundleData(){
        $status = $this->input->get('status');

        if(empty($status)){
            $response = array(
                'status' => 0,
                'message' => 'Status not found',
            );
            echo json_encode($response);
            exit; 
        }

        if($status === 'ALL'){
            $this->db->where('bundle_status !=', 'CANCELLED');
        }else{
            $this->db->where('bundle_status', $status);
        }

        $queryResult = $this->db->get('BUNDLE_DEVICE_WISE_VIEW')->result_array();
        $csv_header = 'Bundle No,Bundle Type,Bundle Status,Device Id,Device Name,RAM, ROM,Certification Grade, Remark, Device Status,IMEI1 No,IMEI2 No,WSN No,BIN No,MRP,MOP';
        $csv_data = '';
        $csv_data .= $csv_header . "\n";
        foreach ($queryResult as $key => $value) {
            $csv_data .= $value['bundle_no'] . ",";
            $csv_data .= $value['bundle_type'] . ",";
            $csv_data .= $value['bundle_status'] . ",";
            $csv_data .= $value['device_id'] . ",";
            $csv_data .= $value['device_name'] . ",";
            $csv_data .= $value['ram'] . ",";
	    $csv_data .= $value['rom'] . ",";
	    $csv_data .= $value['certification_grade'] . ",";
	    $csv_data .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['remark']) . ",";
	    $csv_data .= $value['device_status'] . ",";
            $csv_data .= $value['imei1_no'] . ",";
            $csv_data .= $value['imei2_no'] . ",";
            $csv_data .= $value['wsn_no'] . ",";
            $csv_data .= trim($value['bin_number']) . ",";
            $csv_data .= $value['mrp'] . ",";
            $csv_data .= $value['mop'] . "\n";
        }
        
        $filename = 'bundle_data_' . date('Y-m-d') . '.csv';
        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=$filename");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $csv_data;
        exit;
    }
    public function bulkUpdateBundleDeviceRemark()
    {
        
        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
       
        $td_data = $data['td_data'];
        
        foreach ($td_data as $key => $device_data) {
           
            $this->db->trans_start();
            $grnreport_id = $this->db->get_where('tbl_grnreport', array("nhdin" => $device_data['device_id']))->row()->grnreport_id;
            $bundle_data = $this->db->get_where('tbl_dealer_bundle', array("bundle_no" => $device_data['bundle_no']))->row();
            if($bundle_data->status != "ACTIVE"){
                $json['status'] = 0;
                $json['msg'] = $device_data['bundle_no']. " Is not In ACTIVE STATUS";
                echo json_encode($json);
                exit;
            }
            $bundle_id = $bundle_data->bundle_id;
	    $update_arr = array(
            	"remark" => $device_data['remark']
         	);

        	$this->db->where('bundle_id', $bundle_id);
		$this->db->where('grnreport_id', $grnreport_id);
		$this->db->update('tbl_dealer_bundle_item', $update_arr);
	//print_r($this->db->last_query());
	}
	 //exit;
        $error = $this->db->error();
        if ($error['code'] != 0) {
            //$this->db->trans_rollback();
            $json['status'] = 0;
            $json['msg'] = "Failed to update remark";
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
}
