<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Bulk_status_exp extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();  
 	
		/*load model*/
    }

    public function manage_bulkstatus($id = NULL,$activeId=NULL)
    {  
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		
		$userCond="tbl_account_details.user_id!='0'";
		
		if($this->session->userdata('user_type')!='1')
		{
			$userCond="tbl_account_details.location='".$this->session->userdata('userlocationValue')."'";
		}
		
		$engCond="(tbl_account_details.designations_id='13' or tbl_account_details.designations_id='20' or tbl_account_details.designations_id='34' )";
		
		if($this->session->userdata('user_type')=='1')
		{
			 
			$data['eng_user']=$this->db->select('tbl_users.*')->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
        }
		else
		{
			$data['eng_user']=$this->db->select('tbl_users.*')->where($userCond)->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
		}
		
		$data['excelResult']=array();
		
		$data['title'] = "Bulk Status"; //Page title   
		
        $data['subview'] = $this->load->view('admin/bulk_status_exp/manage_bulkstatus', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }
	
	public function getDeviceDetailsByStatus(){
		$module_type = $_POST['module_type'];
		$status = $_POST['status'];

		$query = $this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age')
					->where('module_type', $module_type)
					->where('status', $status);
		
		if(isset($_POST['saletype'])){
			$query->where('saletype', $_POST['saletype']);
		}

		$result = $query->get('tbl_grnreport')->result_array();
		
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;		
	}
	
	public function getDeviceDetailsByAge(){
		
		$result = $this->db->select('tbl_grnreport.*, DATEDIFF(CURDATE(),grn_inwarddate) as age')
							->where('module_type', 2)
							->where('status!= "SOLD"')
							->order_by('age', 'DESC')
							->get('tbl_grnreport')->result_array();
		
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;		
	}
	
	public function downloadDeviceDetailsByStatus(){
		$module_type = $this->input->post('module_type');
		$status = $this->input->post('status');
		$stock_type = $this->input->post('stock_type');
		$saletype = $this->input->post('saletype');

		$query = $this->db->from('tbl_grnreport')
		                ->select('nhdin,stock_type,device_sub_category,product_brand,device_name,SKU,certification_grade,saletype,status,bin_number,batch_no, DATEDIFF(CURDATE(), grn_inwarddate) as age')
		                ->where('module_type', $module_type)
		                ->where('status', $status);

		if(!empty($stock_type)){
			$stock_type = str_replace('_', ' ',$stock_type);
			$query->where('stock_type', $stock_type);
		}
		if(!empty($saletype)){
			$query->where('saletype', $saletype);
		}

		$result = $query->get()->result_array();

		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		die;		
	}

	
	/** Bulk Change SaleType */
	public function bulk_change_SaleType(){
		$request = file_get_contents("php://input", true);
		$data = json_decode($request);
		
		$updateArray = array();
		$wh_status_arr = ['IN_STOCK', 'RFS'];
		$wh_saletype_arr = ['OFFLINE'];

		$new_saleType = $data->sale_type;
		if ($new_saleType == 'OFFLINE') {
			$wh_saletype_arr = ['EXPORT'];
		}

		$Grn_IDs = [];

		try {
			foreach($data->devices as $i => $obj) {
				$device = strtoupper(trim($obj->deviceid));
				$device_row = $this->db->select('grnreport_id, saletype, status')->where('nhdin', $device)->get('tbl_grnreport')->row();
				
				if (!isset($device_row)) {
					$msg = $device . ' device is invalid at row: ' . ($i + 1);
					GOTO ERROR;
				}
				$crnt_status = $device_row->status;
				$crnt_saletype = $device_row->saletype;
				
				if(!in_array($crnt_status, $wh_status_arr)) {
					$msg = $device . ' device status is neither in "' . implode(', ', $wh_status_arr) . '"';
					GOTO ERROR;
				}
				if(!in_array($crnt_saletype, $wh_saletype_arr)) {
					$msg = $device . ' device SaleType is neither in "' . implode(', ', $wh_saletype_arr) . '"';
					GOTO ERROR;
				}

				$wh_so_status = ["DRAFT", "FINANCE_PENDING", "FINANCE_APPROVED", "INVOICED"];
				$old_so = $this->db->from('tbl_salesorder_item AS soi')
						->join('tbl_salesorder AS so', 'so.salesorder_id = soi.salesorder_id','Left')
						->where('soi.grnreport_id', $device_row->grnreport_id)
						->where_in('so.status', $wh_so_status)
						->select('so.salesorder_code')
						->get()->row();

				//if(!empty($old_so)) {
					//$msg = 'Device '. $device_row->grnreport_id ." already sold under the SO ". $old_so->salesorder_code;
					//GOTO ERROR;
				//}
				
				$temp_arr = array(
					'nhdin'=> $device,
					'saletype' => $new_saleType,
					'remark'=> 'Bulk SaleType Changed to ' . $new_saleType, 
					'user_id' => $this->session->userdata('user_id')
				);

				$temp_arr['module_type'] = ($new_saleType == 'EXPORT')? 2 : 1;

				if (!in_array($device_row->grnreport_id, $Grn_IDs)) {
					$updateArray[] = $temp_arr;
					
					$Grn_IDs[] = $device_row->grnreport_id;
				}

			}
		} catch(Exception $e) {
			$error = "Exception: " . $e->getMessage();
            GOTO ERROR;
		}
		
		if(count($updateArray) == 0) {
			$msg = "Please fill the CSV File";
			GOTO ERROR;
		}
		
		
		$this->db->trans_start();
		

		$this->db->update_batch('tbl_grnreport', $updateArray, 'nhdin');
		if ($this->db->error()['code'] != 0) { $error = $this->db->error(); GOTO ERROR; }


		$this->db->trans_complete();

		echo json_encode([
			"status" => true,
			'message' => count($updateArray) . ' Device(s) SaleType changed to "'. $new_saleType .'"'
		]);
		die;
		

        ERROR:
		$this->db->trans_rollback();
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ]);
        die;
	}

} 

