<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Bulk_status extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();  
 	
		/*load model*/
    }

    public function manage_bulkstatus($id = NULL,$activeId=NULL)
    {  
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		
		$userCond="tbl_account_details.user_id!='0'";
		
		if($this->session->userdata('user_type')!='1')
		{
			$userCond="tbl_account_details.location='".$this->session->userdata('userlocationValue')."'";
		}
		
		$engCond="(tbl_account_details.designations_id='13' or tbl_account_details.designations_id='20' or tbl_account_details.designations_id='34' )";
		
		if($this->session->userdata('user_type')=='1')
		{
			 
			$data['eng_user']=$this->db->select('tbl_users.*')->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
        }
		else
		{
			$data['eng_user']=$this->db->select('tbl_users.*')->where($userCond)->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
		}
		
		$data['excelResult']=array();
		
		$data['title'] = "Bulk Status"; //Page title   
		
        $data['subview'] = $this->load->view('admin/bulk_status/manage_bulkstatus', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function manage_inventory( $active = 0)
	{

		if (!empty($active)) 
		{
            if (is_numeric($active)) {
                $data['active'] = $active; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }

		$data['title'] = "Manage Inventory"; //Page title   
		
        $data['subview'] = $this->load->view('admin/bulk_status/manage_inventory', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}

	 
	public function create_status()
	{   
	
		$this->load->model('Stamphistory_model');
		
		$locName=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
	
		$data=$this->input->post();
		 
		$nhdin=$this->input->post('nhdin');
		  
		$error=0;
		  
		  /*===check all error===*/
		  
		if(!empty($nhdin) && $nhdin[0]!='')
		{ 	
			$e=0;
			
			$duplicateNhdin=array();
			
			foreach($nhdin as $nhdinValue)
			{ 
				$stampValue='';
				
				$stampValue=$data['update_status'][$e];
			  
			   /*==CHECK SALE CHANNEL CONDITION==*/
			  
				$saleChannelError=0;
					
				$salesChannel=$data['sale_channel'][$e];
				
				if($salesChannel!='EBAY' && $salesChannel!='UDAAN' && $salesChannel!='YNEW WEB' && $salesChannel!='YNEW APP' && $salesChannel!='SHOP CLUES' && $salesChannel!='FLIPKART' && $salesChannel!='AMAZON' && $salesChannel!='SNAPDEAL' && $salesChannel!='BUY BACK' && $salesChannel!='OFFLINE' && $salesChannel!='2GUD')
				{
					$saleChannelError=1;
				}
				
				
				/*==CHECK SELLING MODE CONDITION==*/
					
				$sellingModeError=0;
				
				$sellingMode=$data['selling_mode'][$e];
				
				if($sellingMode!='ASIS' && $sellingMode!='POWER ON' && $sellingMode!='FULL QC')
				{
					$sellingModeError=1;
				}
				
				/*==CHECK CATEGORY CONDITION==*/
					
				$categoryError=0;
				
				$categoryValue=$data['category'][$e];
				
				if($categoryValue!='A' && $categoryValue!='B' && $categoryValue!='C' && $categoryValue!='FF' && $categoryValue!='SFF')
				{
					$categoryError=1;
				} 
				
				/*==CHECK BLANK NHDIN==*/
				
				if($nhdinValue=='')
				{
					$error++;
				}
				else
				{
					/*==CHECK DUPLICATE  NHDIN==*/
					
					if(in_array($nhdinValue,$duplicateNhdin))
					{
						$error++;
					}
					else
					{
						
						$duplicateNhdin[]=$nhdinValue;
							
					}	
				}
				 
				$recivedStore=$this->db->where(array('nhdin'=>$nhdinValue,'recived_store'=>'1'))->get('tbl_grnreport')->row(); 
				
				$returnToOrigin=$this->db->where(array('nhdin'=>$nhdinValue,'update_status'=>'RETURNED TO ORIGIN'))->get('tbl_bulkstatus')->row();
				
				$rfsStamp=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_readyforsale')->row();
				
				$salesReturn=$this->db->where(array('nhdin'=>$nhdinValue,'update_status'=>'SALES RETURN'))->get('tbl_bulkstatus')->row();
				
				$assInspection=$this->db->where(array('nhdin'=>$nhdinValue,'update_status'=>'ASS INSPECTION'))->get('tbl_bulkstatus')->row();
 
				$recivedAssesStore=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_recivedasses_stores')->row();
				
				$checkRepairedOk=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1','device_pass_status'=>'REPAIRED OK'))->get('tbl_recivedasses_stores')->row();
				
				$checkPfp=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1','device_pass_status'=>'PFP'))->get('tbl_recivedasses_stores')->row();
				
				$checkRwr=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1','device_pass_status'=>'RWR'))->get('tbl_recivedasses_stores')->row();
				
				$checkBer=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1','device_pass_status'=>'BER'))->get('tbl_recivedasses_stores')->row();
					
				$outQc=$this->db->where(array('nhdin'=>$nhdinValue,'purpose'=>'OUTQC'))->get('trc_engassessment')->row();
				
				$preloveStamp=$this->Common_model->getRowResult('stamp_id','tbl_prelove',array('nhdin'=>$nhdinValue,'status'=>'1'));
				
				$outQcPass=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_outqcpass_salesstamp')->row();
				
				$outQcPassFinance=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_outqcpass_finance')->row();
				
				$soldStamp=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_soldstamp')->row();
				
				$assInspectionCom=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_ass_inpectioncompleted')->row();
				
				$onHold=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_onhold')->row();
				
				$movedToAmazon=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_moved_toamazon')->row();
				
				$intransaiOutbondSold=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_intransitoutbondsold')->row();
				
				$assDispacth=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_ass_dispatched')->row();
				
				$certificationFail=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_certification_fail')->row();
				
				$certificationPass=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_certification_pass')->row();
				
				$returnWarehouseByTriage=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_returntowarehousetriage')->row();
				
				$returnWarehouseByCerti=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->get('tbl_returntowarehousecertification')->row();
				 
				/*==CHECK TRC CONDITION==*/
				
				if($stampValue=='TRC')
				{
					if(empty($certificationFail) && empty($returnWarehouseByTriage))
					{
						$error++; 
					} 
				}
				
				/*==CHECK CERTIFICATION DEPARTMENT CONDITION==*/
				
				if($stampValue=='CERTIFICATION DEPARTMENT')
				{
					if(empty($recivedStore) && empty($recivedAssesStore) && empty($rfsStamp) && empty($returnWarehouseByCerti))
					{
						$error++; 
					} 
				} 
				
				/*==CHECK RFS CONDITION==*/
				
				
				if($stampValue=='READY FOR SALE')
				{  
			
					$chkAssFail=$this->db->where(array('update_status'=>'ass_fail','nhdin'=>$nhdinValue,'status'=>'0','receivedassstore_status'=>'1'))->get('tbl_receivedassess_ass')->row();
					
					if((empty($chkAssFail) && empty($recivedStore) && empty($certificationPass) && empty($returnToOrigin) && empty($recivedAssesStore) && empty($salesReturn) && empty($outQcPassFinance) && empty($assInspection) && empty($outQcPass) && empty($onHold) && empty($movedToAmazon)) || !empty($rfsStamp))
					{
						$error++; 
					}
				}
				
				/*==CHECK DISMANTLINK CONDITION==*/
				
				if($stampValue=='DISMANTLING DEVICES')
				{  
			 
					if(empty($recivedStore))
					{
						$error++; 
					}
				}
 
				/*==CHECK OUT QC CONDITION==*/
			
				if($stampValue=='OUT QC')
				{ 
					if(!empty($outQc) || $data['engineer_name'][$e]=='' || empty($rfsStamp) || $data['sale_channel'][$e]=='')
					{
						$error++; 
					}		
				}
 				
				/*==CHECK ORDER ID CONDITION==*/
					
				if($data['sale_channel'][$e]!='OFFLINE' && $data['sale_channel'][$e]!='' )
				{
					if($data['order_id'][$e]=='')
					{
						$error++;
					}
				}
				
				/*==CHECK ASS CONDITION==*/
				
				if($stampValue=='AFTER SALES SERVICE')
				{  					
					if((empty($intransaiOutbondSold) && empty($assDispacth)) || $data['engineer_name'][$e]=='')
					{
						$error++; 
					}
				} 
 			
				/*==CHECK L1 ASSESSMENT CONDITION==*/
				
				if($stampValue=='L1 ASSESSMENT')
				{ 
					if(empty($rfsStamp) || $data['sale_channel'][$e]=='')
					{
						$error++; 
					}
				}
				
				
				/*==CHECK OUT QC PASS SALES CONDITION==*/
				
				if($stampValue=='OUT QC PASS - SALES' )
				{  
					if((empty($rfsStamp) && empty($onHold) && empty($preloveStamp) && empty($movedToAmazon)) || !empty($outQcPass) || $data['nhdin'][$e]=='' ||  $data['selling_mode'][$e]=='' || $data['category'][$e]=='' || $data['remark'][$e]=='' || $data['sale_channel'][$e]=='' || ($data['sale_channel'][$e]!='OFFLINE' && $data['order_id'][$e]==''))
					{
						$error++; 
					}
				}
				
				/*==CHECK PRELOVE condition==*/
				
				if($stampValue=='PRELOVE' )
				{  
					if(empty($rfsStamp) && empty($certificationPass) && empty($recivedStore))
					{
						$error++; 
					}
				}
				 
				
				
				/*==CHECK OUT QC PASS FINANCE CONDITION==*/
				
				if($stampValue=='OUT QC PASS - FINANCE')
				{ 
					if(!empty($outQcPassFinance) || empty($outQcPass) || $data['nhdin'][$e]=='' || $data['sale_channel'][$e]=='' || $data['selling_mode'][$e]=='' || $data['category'][$e]=='' || $data['remark'][$e]=='' || $data['nhsp'][$e]=='' || ($data['sale_channel'][$e]!='OFFLINE' && $data['order_id'][$e]==''))
					{
						$error++; 
					}
				}
				
				/*==CHECK IN TRANSIT OUTBOUND SOLD CONDITION==*/
				
				if($stampValue=='IN TRANSIT OUTBOUND SOLD')
				{ 
					if(empty($soldStamp))
					{ 
						$error++; 
					}
				}
				
				/*==CHECK RETURN TO ORIGIN CONDITION==*/
				
				if($stampValue=='RETURNED TO ORIGIN')
				{ 
			
					$soldResult=$this->db->where('tbl_soldstamp.nhdin',$data['nhdin'][$e])->order_by('tbl_soldstamp.stamp_id','desc')->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_soldstamp.invoice_id')->get('tbl_soldstamp')->row();
					
					$getLastStampStatus=$this->Stamphistory_model->getNhdinLastStampStatus($data['nhdin'][$e]); 
					
					if($getLastStampStatus!='IN TRANSIT OUTBOUND SOLD' || $data['nhdin'][$e]==''|| empty($soldResult))
					{
						$error++; 
					}
				}
			
				/*==CHECK SALES RETURN CONDITION==*/
				
				if($stampValue=='SALES RETURN')
				{ 
					$soldResult=$this->db->where('tbl_soldstamp.nhdin',$data['nhdin'][$e])->order_by('tbl_soldstamp.stamp_id','desc')->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_soldstamp.invoice_id')->get('tbl_soldstamp')->row();
					
					$getLastStampStatus=$this->Stamphistory_model->getNhdinLastStampStatus($data['nhdin'][$e]); 
					
					if($getLastStampStatus!='IN TRANSIT OUTBOUND SOLD' || $data['nhdin'][$e]=='')
					{
						$error++; 
					}
				}
					 
				/*==CHECK CONDITION OF ASS INSPECTION - COMPLETED==*/ 
				
				if($stampValue=='ASS INSPECTION - COMPLETED')
				{  
			
					$cond="(update_status='ass_pass' or update_status='ass_rejected')";
					
					$receivedAssessAss=$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'0','receivedassstore_status'=>'1'))->where($cond)->get('tbl_receivedassess_ass')->row();
						
					if(empty($receivedAssessAss))
					{
						$error++;
					}
				} 
			 
				/*==CHECK CONDITION OF ASS DISPATCHED==*/
				
				if($stampValue=='ASS DISPATCHED')
				{   
					if(empty($assInspectionCom))
					{
						$error++;
					}
				}
			
				/*==CHECK CONDITION OF ON HOLD==*/
				
				if($stampValue=='ON HOLD')
				{   
					if(empty($rfsStamp) || $data['remark'][$e]=='')
					{
						$error++;
					}
				}
				
				/*==CHECK CONDITION OF MOVED TO AMAZON==*/
				
				if($stampValue=='MOVED TO AMAZON')
				{   
					if(empty($rfsStamp))
					{
						$error++;
					}
				}
				
				
				/*==CHECK CONDITION FOR TRIAGE TO WAREHOUSE==*/
				
				if($stampValue=='TRIAGE TO WAREHOUSE')
				{   
					if(empty($checkRepairedOk) && empty($checkRwr) && empty($checkPfp) && empty($checkBer))
					{
						$error++;
					}
				}
				 
			$e++;
			
			}
		} 
 
		if(!empty($nhdin) && $nhdin[0]!='')
		{
			if($error=='0')
			{		 
				$i=0;
				 
				foreach($nhdin as $nhdin)
				{  
					
					$orderStatusResult=array
					(
						'uploadstatus_userid'=>$this->session->userdata('user_id'),
						'nhdin'=>$nhdin,
						'selling_mode'=>$data['selling_mode'][$i],
						'order_id'=>$data['order_id'][$i],
						'sale_channel'=>$data['sale_channel'][$i],
						'invoice_no'=>$data['invoice_no'][$i],
						'remark'=>$data['remark'][$i],
						'nhsp'=>$data['nhsp'][$i],
						'category'=>$data['category'][$i],
						'update_status'=>$data['update_status'][$i],
						'engineer_name'=>$data['engineer_name'][$i],
					);
					
					$insertId=0; 
					
					if($data['update_status'][$i]=='SALES RETURN' || $data['update_status'][$i]=='RETURNED TO ORIGIN')
					{
						$soldResult=$this->db->where('nhdin',$nhdin)->order_by('stamp_id','DESC')->get('tbl_soldstamp')->row_array();
						
						if(!empty($soldResult))
						{
							$orderStatusResult['selling_mode']=$soldResult['selling_mode'];
							
							$orderStatusResult['order_id']=$soldResult['order_id'];
							
							$orderStatusResult['sale_channel']=$soldResult['sale_channel'];
							
							$orderStatusResult['invoice_no']=$soldResult['invoice_no'];
							
							$orderStatusResult['nhsp']=$soldResult['nhsp'];
							
							$orderStatusResult['category']=$soldResult['category'];
						}
					}
					
					$this->db->insert('tbl_bulkstatus',$orderStatusResult);	
				 
					$insertId=$this->db->insert_id();				
					 
					/*==create trc data==*/
					
					if($data['update_status'][$i]=='TRC')
					{			
						
						if(!empty($returnWarehouseByTriage))
						{
							$this->Common_model->insertTrcAssessmentData($insertId,$nhdin,$returnWarehouseByTriage->remark);
							
							$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->update('tbl_returntowarehousetriage',array('status'=>'0'));
						}
						else
						{
							$certificationFail=$this->Common_model->getRowResult('remark','tbl_certification_fail',array('nhdin'=>$nhdin,'status'=>'1'));
						
							if(!empty($certificationFail))
							{ 
								$this->Common_model->insertTrcAssessmentData($insertId,$nhdin,$certificationFail['remark']);
								
								$this->db->where(array('nhdin'=>$nhdinValue,'status'=>'1'))->update('tbl_certification_fail',array('status'=>'0'));
							}
						}						
					}
					
					if($data['update_status'][$i]=='CERTIFICATION DEPARTMENT' )
					{	
				
						$this->Common_model->insertcertiDeptData($insertId,$nhdin);	
						
						// remove stamp from certification department
						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_returntowarehousecertification',array('status'=>'0'));
						
					} 
						
					/*==create trc data==*/
					
					if($data['update_status'][$i]=='READY FOR SALE')
					{	
						$this->Common_model->insertReadyForSaleData($nhdin,$insertId,'0','0');
 					
					}	
						
					/*==create DISMAMTLING DEVICES==*/
					
					if($data['update_status'][$i]=='DISMANTLING DEVICES')
					{	
						$this->Common_model->insertDismantlingData($nhdin,$insertId);
 					
					}			
					
					// REMOVE NHDIN FROM RECIVED STORE 
					
					$this->db->where(array('nhdin'=>$nhdin,'recived_store'=>'1'))->update('tbl_grnreport',array('recived_store'=>'2'));
					
					// REMOVE NHDIN FROM APPROVED CERTIFICATION 
					
					$this->db->where(array('nhdin'=>$nhdin,'recived_store'=>'1'))->update('tbl_grnreport',array('recived_store'=>'2'));
					
					// REMOVE NHDIN FROM RECIVED ASSESSMENT STORE 
					
					$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_certification_pass',array('status'=>'0'));
 	
					
					// REMOVE NHDIN FROM READY FOR SALE

					if($data['update_status'][$i]!='READY FOR SALE')
					{						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_readyforsale',array('status'=>'0'));					
					}	
					
					// REMOVE NHDIN FROM PRELOVE

					if($data['update_status'][$i]!='PRELOVE')
					{						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_prelove',array('status'=>'0'));					
					}	
					
					// REMOVE NHDIN FROM READY OUT QC PASS SALES==*/

					if($data['update_status'][$i]!='OUT QC PASS - SALES')
					{						
												 
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_outqcpass_salesstamp',array('status'=>'0'));
					
					}
					
					if($data['update_status'][$i]!='ON HOLD')
					{	
						// REMOVE NHDIN FROM HOLD STAMP
					
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_onhold',array('status'=>'0'));
						
					}
					
					if($data['update_status'][$i]!='OUT QC PASS - FINANCE')
					{	
						
						// REMOVE NHDIN FROM OUT QC PASS - FINANCE
					
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_outqcpass_finance',array('status'=>'0'));
						
					}	
					
					
					if($data['update_status'][$i]!='MOVED TO AMAZON')
					{	
						
						// REMOVE NHDIN FROM MOVED TO AMAZON
					
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_moved_toamazon',array('status'=>'0'));
						
					}	
					
		 
					if($data['update_status'][$i]=='OUT QC')
					{
						$this->db->insert('trc_engassessment',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'nhdin'=>$nhdin,'eng_id'=>$data['engineer_name'][$i],'purpose'=>'OUTQC','current_status'=>'OUT QC','imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin)));
						
						/*==Add entry in out qc===*/
							
						$this->db->insert('tbl_outqcstamp',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'nhdin'=>$nhdin,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),'engineer_id'=>$data['engineer_name'][$i]));
							
					}
			 
					/*==work stamp on L1 ASSESSMENT==*/
					
					if($data['update_status'][$i]=='L1 ASSESSMENT')
					{ 
						$this->Common_model->insertStampData('tbl_l1assessment',$nhdin,$insertId,'',$data['remark'][$i]);						 
					}
			
					/*==work stamp on prelove ==*/ 
					
					if($data['update_status'][$i]=='PRELOVE')
					{ 						 
						$this->Common_model->insertData('tbl_prelove',array('user_id'=>$this->session->userdata('user_id'),'eng_id'=>$data['engineer_name'][$i],'nhdin'=>$nhdin,'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),'remark'=>$data['remark'][$i])); 					
					}
			
			
					/*==work stamp on OUT QC PASS - SALES==*/ 
					
					if($data['update_status'][$i]=='OUT QC PASS - SALES')
					{ 
						$this->Common_model->insetOutQcpassSalesData($nhdin,$data['engineer_name'][$i],$insertId); 
					
					}
			
					/*==work stamp on OUT QC PASS - FINANCE==*/ 
					
					if($data['update_status'][$i]=='OUT QC PASS - FINANCE')
					{ 
						 
						$this->db->insert('tbl_outqcpass_finance',array('user_id'=>$this->session->userdata('user_id'),'eng_id'=>$data['engineer_name'][$i],'nhdin'=>$nhdin,'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),'remark'=>$data['remark'][$i]));
 					
					}
			
					/*==work stamp on IN TRANSIT OUTBOUND SOLD==*/ 
					
					if($data['update_status'][$i]=='IN TRANSIT OUTBOUND SOLD')
					{ 
						
						$soldId=$this->db->select('stamp_id')->where(array('nhdin'=>$nhdin,'status'=>'1'))->get('tbl_soldstamp')->row()->stamp_id;
						 
						$this->Common_model->insertOutbondSoldData($nhdin,$insertId,$soldId);
 
						// REMOVE NHDIN FROM SOLD STAMP
					
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_soldstamp',array('status'=>'0'));
					
					}
			
					/*==work stamp on RETURNED TO ORIGIN==*/ 
					
					if($data['update_status'][$i]=='RETURNED TO ORIGIN')
					{ 
						
						$soldId=$this->db->select('sold_id')->where(array('nhdin'=>$nhdin,'status'=>'1'))->order_by('stamp_id','desc')->get('tbl_intransitoutbondsold')->row()->sold_id;
						
						$this->db->insert('tbl_returntoorigin',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>$nhdin,'bulkstatus_id'=>$insertId,'sold_id'=>$soldId,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin)));
 				 	 
						/*==ADD DATA IN RFS TABLE==*/
						
						$this->Common_model->insertReadyForSaleData($nhdin,$insertId,'1','0');
				 	
					}
					
					/*==work stamp on SALES RETURN==*/ 
					
					if($data['update_status'][$i]=='SALES RETURN')
					{ 
						
						$this->Common_model->insertSalesReturn($insertId,$nhdin); 
 				 	 
						/*==ADD DATA IN RFS TABLE==*/
						
						$this->Common_model->insertReadyForSaleData($nhdin,$insertId,'0','1');
					 
					}
					
					/*==work stamp on AFTER SALES SERVICE==*/ 
					
					if($data['update_status'][$i]=='AFTER SALES SERVICE')
					{
						$this->Common_model->insertAssInspectionData($nhdin,$insertId,$data['engineer_name'][$i]); 
					
						/*===ADD STAMP IN ENG ASSESSMENT==*/
						
						$this->db->insert('trc_engassessment',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'nhdin'=>$nhdin,'eng_id'=>$data['engineer_name'][$i],'purpose'=>'ASS','current_status'=>'ASS','nhdin'=>$nhdin,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin)));
						
						/*===REMOVE STAMP FROM OUTBOND SOLD AND ASS DISPATCH==*/
						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_intransitoutbondsold',array('status'=>'0'));
						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_ass_dispatched',array('status'=>'0'));
					}
					
					/*==work stamp on ASS INSPECTION - COMPLETED==*/ 
					
					if($data['update_status'][$i]=='ASS INSPECTION - COMPLETED')
					{
						$soldId=$this->db->select('sold_id')->where(array('nhdin'=>$nhdin,'status'=>'0','receivedassstore_status'=>'1'))->order_by('stamp_id','desc')->get('tbl_receivedassess_ass')->row()->sold_id;
						
						$this->Common_model->insertAssInspecCompleted($nhdin,$insertId,$data['engineer_name'][$i]);
  	
					}
					
					/*==work stamp on ASS DISPATCHED==*/ 
					
					if($data['update_status'][$i]=='ASS DISPATCHED')
					{
						
						$this->Common_model->insertDispatchData($nhdin,$insertId,$data['remark'][$i]); 
						 
						/*==REMOVE NHDIN FROM ASS INSPECTION COMPLETED==*/
						
						$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_ass_inpectioncompleted',array('status'=>'0'));
					}
					
					/*==CHECK CONDITION OF ON HOLD==*/
					
					if($data['update_status'][$i]=='ON HOLD')
					{ 
						$this->Common_model->insertHoldStampData($nhdin,$insertId,$data['remark'][$i]); 
					}
					
					/*==CHECK CONDITION OF MOVED TO AMAZON==*/
					
					if($data['update_status'][$i]=='MOVED TO AMAZON')
					{ 
						$this->db->insert('tbl_moved_toamazon',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>$nhdin,'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin)));
					}
					
					
					// REMOVE NHDIN FROM RECIVED ASSESSMENT STORE 
					
					$this->db->where(array('nhdin'=>$nhdin,'status'=>'0','receivedassstore_status'=>'1'))->update('tbl_receivedassess_ass',array('status'=>'0','receivedassstore_status'=>'0'));
					
					 
					if($data['update_status'][$i]=='TRIAGE TO WAREHOUSE')
					{  
						$assessmentResult=$this->Common_model->getRowResult('*','tbl_recivedasses_stores',array('status'=>'1','nhdin'=>$nhdin));
						
						if(!empty($assessmentResult))
						{
							$this->Common_model->insertData('tbl_comtriageto_warehouse',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>$nhdin,'bulkstatus_id'=>$insertId,'imei_no'=>$assessmentResult['imei_no'],'nhmod'=>$assessmentResult['nhmod'],'product_type'=>$assessmentResult['product_type'],'product_name'=>$assessmentResult['product_name'],'eng_id'=>$assessmentResult['eng_id'],'remark'=>$assessmentResult['remark'],'other_remark'=>$assessmentResult['other_remark'],'bin_number'=>$assessmentResult['bin_number'],'warehouse'=>$assessmentResult['warehouse'],'device_pass_status'=>$assessmentResult['device_pass_status']));
							
							// remove stamp from assessment stores
							
							$this->db->where(array('nhdin'=>$nhdin,'status'=>'1'))->update('tbl_recivedasses_stores',array('status'=>'0')); 
						}
						
					} 
					
					$i++; 
				}
				 
				$type="success";
				
				$msg="ORDER STATUS IMPORT SUCCESSFULLY.";  
			}
			else
			{
				$type="error";
				
				$msg="SOME ERROR FOUND.PLEASE CHECK ALL DATA.";   
			}
		}
		else
		{
			$type="error";
				
			$msg="DATA NOT FOUND.PLEASE UPLOAD AGAIN.";    
		}
		 
		$this->session->set_userdata($type,$msg); 
		
		header("location:".base_url()."admin/Bulk_status/manage_bulkstatus"); 
		
		die;
	}	 
	
	public function addTableRow()
	{  
		$sNo=$_POST['sNo'];
		
		$userCond="tbl_account_details.user_id!='0'";
	
		$userCond="tbl_account_details.location='".$this->session->userdata('userlocationValue')."'";
 
		$engCond="(tbl_account_details.designations_id='13' or tbl_account_details.designations_id='20' or tbl_account_details.designations_id='34' )";
		
		if($this->session->userdata('user_type')!='1')
		{
			$eng_user=$this->db->select('tbl_users.*')->where($userCond)->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
		}
		else
		{
			$eng_user=$this->db->select('tbl_users.*')->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
		}
 
		$html='
			<tr id="tableIdr'.$sNo.'">
				<td><input placeholder="INWARDID" class="form-control commonrequired'.$sNo.' nhdin'.$sNo.'"  name="nhdin[]" value="" type="text"></td>
				<td>
					<select  onchange="checkOrderIdRequired('.$sNo.')" class="form-control saleschannel'.$sNo.' commonrequired'.$sNo.'"  name="sale_channel[]" id="stock_type"> 
						<option value="">CHOOSE SALES CHANNEL</option>
						<option   value="EBAY">EBAY</option>
						<option  value="UDAAN">UDAAN</option> 
						<option  value="YNEW WEB">YNEW WEB</option> 
						<option  value="YNEW APP">YNEW APP</option> 
						<option  value="SHOP CLUES">SHOP CLUES</option> 
						<option  value="FLIPKART">FLIPKART</option> 
						<option  value="AMAZON">AMAZON</option> 
						<option  value="SNAPDEAL">SNAPDEAL</option> 
						<option  value="2GUD">2GUD</option> 
						<option  value="OFFLINE">OFFLINE</option> 
						<option  value="BUY BACK">BUY BACK</option> 
						<option  value="QUIKR">QUIKR</option> 
					 </select>	
				</td>
				<td><input placeholder="ORDER ID" class="form-control commonrequired'.$sNo.' order_id'.$sNo.'"  name="order_id[]" value="" type="text"></td>
				<td>
					<select class="form-control selling_mode'.$sNo.' commonrequired'.$sNo.' "  name="selling_mode[]" id="selling_mode'.$sNo.'"> 
						<option value="">CHOOSE SELLING MODE</option>
						<option  value="ASIS">ASIS</option>
						<option  value="POWER ON">POWER ON</option> 
						<option  value="FULL QC">FULL QC</option>  
					 </select>
				</td>
				<td>   
					<select class="form-control category'.$sNo.' commonrequired'.$sNo.' "  name="category[]" id="category'.$sNo.'" >
						<option value="">Choose GRADE</option>
						<option value="A">A</option>
						<option value="B">B</option> 
						<option value="C">C</option> 
						<option value="FF">FF</option> 
						<option value="SFF">SFF</option> 
						<option value="ASIS">ASIS</option> 
						<option value="UNCERTIFIED">UNCERTIFIED</option> 
						<option value="PL-A">PL-A</option> 
						<option value="PL-B">PL-B</option> 
						<option value="PL-C">PL-C</option> 
						<option value="NFF-A">NFF-A</option> 
						<option value="NFF-A2">NFF-A2</option> 
						<option value="NFF-C">NFF-C</option> 
						<option value="NFF-B">NFF-B</option> 
					 </select>	
					 
				</td>
				<td><input placeholder="INVOICE NUMBER" class="form-control commonrequired'.$sNo.' invoice_no'.$sNo.'"  name="invoice_no[]" value="" type="text"></td>
				<td>
					<select name="engineer_name[]"  class="form-control commonrequired'.$sNo.' engineer_name'.$sNo.'"> 
						<option value="">PLEASE SELECT ENGINEER NAME</option>
						';
						
						foreach($eng_user as $eng_userValue)
						{
							$html.='<option value="'.$eng_userValue->user_id.'">'.strtoupper($eng_userValue->username).'</option>';
						}
						
						$html.='
					</select>
				</td>
				<td><input placeholder="SLYSP" class="form-control commonrequired'.$sNo.' nhsp'.$sNo.'"  name="nhsp[]" value="" type="text"></td>
				 <td>
					<select class="form-control updatestatus'.$sNo.'"  required name="update_status[]" onchange="setRequiredStatus('."'".$sNo."'".')" >
							<option value="">CHOOSE UPDATE STATUS</option>
							<option value="SALES RETURN">SALES RETURN</option> 
							<option value="IN TRANSIT OUTBOUND SOLD">IN TRANSIT OUTBOUND SOLD</option> 
							<option value="TRC">TRIAGE</option> 
							<option value="PRELOVE">PRELOVE</option>
							<option value="OUT QC PASS - SALES">OUT QC PASS - SALES</option>   
							<option value="OUT QC PASS - FINANCE">OUT QC PASS - FINANCE</option>   
							 <option value="READY FOR SALE">READY FOR SALE</option>   
							<option value="SPARE PART REQUIREMENT">SPARE PART REQUIREMENT</option>  
							<option value="CERTIFICATION DEPARTMENT">CERTIFICATION DEPARTMENT</option>  					
							<option value="TRIAGE TO WAREHOUSE">TRIAGE TO WAREHOUSE</option>  					
							<option value="DISMANTLING DEVICES">DISMANTLING DEVICES</option>  					
					 </select>
				</td>
				 <td><input placeholder="REMARK" class="form-control commonrequired'.$sNo.' remark'.$sNo.'"  name="remark[]" value="" type="text"></td>

				 <td><a onclick="deleteRow('.$sNo.')" class="dt-button btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	
	public function uploadStatuByExcel()
	{
		
		$this->load->model('Stamphistory_model');
		
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
				
			    /*===check all error===*/
				  
			    $error=0; 
				
				$stampValue=$this->input->post('update_status');
				
				$locName=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
				
				$duplicateNhdin=array();
				
				for($i=2;$i<=$arrayCount;$i++)
				{  
					
					$invoiceResult[]=array(
						'sale_channel'=>trim($allDataInSheet[$i]["B"]),
						'order_id'=>trim($allDataInSheet[$i]["C"]), 
						'nhdin'=>trim($allDataInSheet[$i]["A"]),  
						'selling_mode'=>trim($allDataInSheet[$i]["D"]),
						'category'=>trim($allDataInSheet[$i]["E"]), 
						'invoice_no'=>trim($allDataInSheet[$i]["F"]), 						
						'engineer_name'=>trim($allDataInSheet[$i]["G"]), 						
						'nhsp'=>trim($allDataInSheet[$i]["H"]), 						
						'remark'=>trim($allDataInSheet[$i]["I"]), 						
					);
					 
					/*==CHECK SALES CHANNEL CONDITION==*/
					
					$saleChannelError=0;
					
					$salesChannel=trim($allDataInSheet[$i]["B"]);
					
					if($salesChannel!='EBAY' && $salesChannel!='UDAAN' && $salesChannel!='YNEW WEB' && $salesChannel!='YNEW APP' && $salesChannel!='SHOP CLUES' && $salesChannel!='FLIPKART' && $salesChannel!='AMAZON' && $salesChannel!='SNAPDEAL' && $salesChannel!='BUY BACK' && $salesChannel!='OFFLINE' && $salesChannel!='2GUD' && $salesChannel!='QUIKR')
					{
						$saleChannelError=1;
					}
					
					/*==CHECK SELLING MODE CONDITION==*/
					
					$sellingModeError=0;
					
					$sellingMode=trim($allDataInSheet[$i]["D"]);
					
					if($sellingMode!='ASIS' && $sellingMode!='POWER ON' && $sellingMode!='FULL QC')
					{
						$sellingModeError=1;
					}
					
					/*==CHECK CATEGORY CONDITION==*/
					
					$categoryError=0;
					
					$categoryValue=trim($allDataInSheet[$i]["E"]);
					
					if($categoryValue!='A' && $categoryValue!='B' && $categoryValue!='C' && $categoryValue!='FF' && $categoryValue!='SFF')
					{
						$categoryError=1;
					}
					 
					/*==CHECK BLANK NHDIN==*/
				
					if(trim($allDataInSheet[$i]["A"])=='')
					{
						$error++;				
						$msg = "Invalid TDID ROW".$i;	
					}
					else
					{
						
						/*==CHECK DUPLICATE  NHDIN==*/
						
						if(in_array(trim($allDataInSheet[$i]["A"]),$duplicateNhdin))
						{
							$error++;
							$msg = "Duplicate TDID ROW".$i;	
						}
						else
						{
							
							$duplicateNhdin[]=trim($allDataInSheet[$i]["A"]);
								
						}						
					}	
					
					$recivedStore=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'recived_store'=>'1'))->get('tbl_grnreport')->row();
					
					$returnToOrigin=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'update_status'=>'RETURNED TO ORIGIN'))->get('tbl_bulkstatus')->row();
					
					$rfsStamp=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_readyforsale')->row(); 
					
					$salesReturn=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'update_status'=>'SALES RETURN'))->get('tbl_bulkstatus')->row();
					
					$assInspection=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'update_status'=>'ASS INSPECTION'))->get('tbl_bulkstatus')->row();
	 
					$recivedAssesStore=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_recivedasses_stores')->row();
					
					$outQc=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'purpose'=>'OUTQC'))->get('trc_engassessment')->row();
					
					$preloveStamp=$this->Common_model->getRowResult('stamp_id','tbl_prelove',array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'));
					
					$outQcPass=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_outqcpass_salesstamp')->row();
				
					$outQcPassFinance=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_outqcpass_finance')->row();
								
					$assInEng=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"])))->get('trc_engassessment')->row();
					
					$userResult=$this->db->select('user_id')->where('username',trim($allDataInSheet[$i]["G"]))->get('tbl_users')->row();
					
					$soldStamp=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_soldstamp')->row();
					
					$assInspectionCom=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_ass_inpectioncompleted')->row();					
					
					$onHold=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_onhold')->row();
				
					$movedToAmazon=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_moved_toamazon')->row();
				
					/*==CHECK TRC CONDITION==*/
					
					if($stampValue=='TRC')
					{ 					 
						if(empty($recivedStore) && empty($recivedAssesStore) && empty($rfsStamp))
						{
							$error++; 
							$msg = "Invalid TRC Condition ROW".$i;	
						}
					}

					/*==CHECK RFS CONDITION==*/
				 
					if($stampValue=='READY FOR SALE')
					{ 
				
						$chkAssFail=$this->db->where(array('update_status'=>'ass_fail','status'=>'0','receivedassstore_status'=>'1','nhdin'=>trim($allDataInSheet[$i]["A"])))->get('tbl_receivedassess_ass')->row();
						
						if((empty($chkAssFail) && empty($recivedStore) && empty($returnToOrigin) && empty($recivedAssesStore) && empty($salesReturn) && empty($assInspection) && empty($outQcPass) && empty($outQcPassFinance) && empty($onHold) && empty($movedToAmazon)) || !empty($rfsStamp) )
						{
							$error++; 
							$msg = "Invalid RFS Condition ROW".$i;	
						}
					}
					
					/*==CHECK DISMANTLINK CONDITION==*/
				
					if($stampValue=='DISMANTLING DEVICES')
					{  
				 
						if(empty($recivedStore))
						{
							$error++; 
							$msg = "Invalid DISMANTLINK Condition ROW".$i;	
						}
					}
				
					/*==CHECK OUT QC CONDITION==*/
				
					if($stampValue=='OUT QC')
					{ 
						if(!empty($outQc) || empty($userResult) || empty($rfsStamp) || $saleChannelError=='1')
						{
							$error++; 
							$msg = "Invalid QC Condition ROW".$i;	
						}
					}
					
					
					/*==CHECK ORDER ID CONDITION==*/
					
					if(trim($allDataInSheet[$i]["B"])!='OFFLINE' && trim($allDataInSheet[$i]["B"])!='' )
					{
						if(trim($allDataInSheet[$i]["C"])=='')
						{
							$error++;
							$msg = "Invalid Order Id ROW".$i;
						}
					}

					/*==CHECK L1 ASSESSMENT CONDITION==*/
				
					if($stampValue=='L1 ASSESSMENT')
					{ 
						if(empty($rfsStamp))
						{
							$error++; 
							$msg = "Invalid L1 ASSESSMENT ROW".$i;
							
						}
					}
					
					/*==CHECK OUT QC PASS SALES CONDITION==*/
					
					if($stampValue=='OUT QC PASS - SALES' )
					{  
						if((empty($rfsStamp) && empty($onHold) && empty($movedToAmazon) && empty($preloveStamp)) || !empty($outQcPass) || trim($allDataInSheet[$i]["A"])=='' || trim($allDataInSheet[$i]["D"])=='' || trim($allDataInSheet[$i]["E"])=='' || trim($allDataInSheet[$i]["I"])=='' || trim($allDataInSheet[$i]["B"])=='' || $saleChannelError=='1' || $sellingModeError=='1' || $categoryError=='1' || ((trim($allDataInSheet[$i]["B"])!='OFFLINE') && trim($allDataInSheet[$i]["C"])==''))
						{
							$error++; 
							$msg = "Invalid QC PASS SALES CONDITION ROW#".$i;
						}
					}
					
					/*==CHECK FOR PRELOVE COND ==*/
					
					if($stampValue=='PRELOVE' )
					{  
						if(empty($rfsStamp))
						{
							$error++; 
							$msg = "Invalid PRELOVE CONDITION ROW#".$i;
						}
					}
					
					/*==CHECK OUT QC PASS SALES CONDITION==*/
					
					if($stampValue=='OUT QC PASS - FINANCE')
					{ 
						if(!empty($outQcPassFinance) || empty($outQcPass)  || trim($allDataInSheet[$i]["A"])=='' || trim($allDataInSheet[$i]["D"])=='' || trim($allDataInSheet[$i]["E"])=='' || trim($allDataInSheet[$i]["I"])=='' || trim($allDataInSheet[$i]["H"])=='' || trim($allDataInSheet[$i]["B"])=='' || $saleChannelError=='1' || $sellingModeError=='1' || $categoryError=='1' || ((trim($allDataInSheet[$i]["B"])!='OFFLINE') && trim($allDataInSheet[$i]["C"])==''))
						{
							$error++; 
							$msg = "Invalid OUT QC PASS SALES ROW#".$i;
						}
					}	
 
					/*==CHECK IN TRANSIT OUTBOUND SOLD CONDITION==*/
				
					if($stampValue=='IN TRANSIT OUTBOUND SOLD')
					{ 
						if(empty($soldStamp))
						{
							$error++; 
							$msg = "Invalid TRANSIT OUTBOUND SOLD CONDITION ROW#".$i;
						}
					} 
					
					/*==CHECK RETURN TO ORIGIN CONDITION==*/
				
					if($stampValue=='RETURNED TO ORIGIN')
					{ 
				
						$soldResult=$this->db->where('tbl_soldstamp.nhdin',trim($allDataInSheet[$i]["A"]))->order_by('tbl_soldstamp.stamp_id','desc')->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_soldstamp.invoice_id')->get('tbl_soldstamp')->row();
						
						$getLastStampStatus=$this->Stamphistory_model->getNhdinLastStampStatus(trim($allDataInSheet[$i]["A"])); 
						
						if($getLastStampStatus!='IN TRANSIT OUTBOUND SOLD' || trim($allDataInSheet[$i]["A"])=='' || empty($soldResult))
						{
							$error++; 
							$msg = "Invalid ORIGIN CONDITION ROW#".$i;
						}
					}
					
					/*==CHECK SALES RETURN CONDITION==*/
					
					if($stampValue=='SALES RETURN')
					{ 
						$getLastStampStatus=$this->Stamphistory_model->getNhdinLastStampStatus(trim($allDataInSheet[$i]["A"])); 
						
						if($getLastStampStatus!='IN TRANSIT OUTBOUND SOLD' || trim($allDataInSheet[$i]["A"])=='')
						{
							$error++; 
							$msg = "Invalid SALES RETURN ROW#".$i;
						}
					}
					
					/*==CHECK ASS CONDITION==*/
				
					if($stampValue=='AFTER SALES SERVICE')
					{ 
						$getLastStampStatus=$this->Stamphistory_model->getNhdinLastStampStatus(trim($allDataInSheet[$i]["A"])); 
						
						if($getLastStampStatus!='IN TRANSIT OUTBOUND SOLD' || empty($userResult))
						{
							$error++; 
							$msg = "Invalid ASS ROW#".$i;
						}
					} 

					/*==CHECK CONDITION OF ASS INSPECTION - COMPLETED==*/
				
					if($stampValue=='ASS INSPECTION - COMPLETED')
					{  
				
						$cond="(update_status='ass_pass' or update_status='ass_rejected')";
						
						$receivedAssessAss=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'0','receivedassstore_status'=>'1'))->where($cond)->get('tbl_receivedassess_ass')->row();
							
						if(empty($receivedAssessAss))
						{
							$error++;
							$msg = "Invalid ASS INSPECTION ROW#".$i;
						}
					}
 
					/*==CHECK CONDITION OF ASS DISPATCHED==*/
				
					if($stampValue=='ASS DISPATCHED' )
					{    
						if(empty($assInspectionCom))
						{
							$error++;
							$msg = "Invalid ASS DISPATCHED ROW#".$i;
						}
					}
					
					/*==CHECK CONDITION OF ON HOLD==*/
				
					if($stampValue=='ON HOLD')
					{   
						if(empty($rfsStamp) || trim($allDataInSheet[$i]["I"])=='')
						{
							$error++;
							$msg = "Invalid ON HOLD ROW#".$i;
						}
					}
					
					/*==CHECK CONDITION OF MOVED TO AMAZON==*/
				
					if($stampValue=='MOVED TO AMAZON')
					{   
						if(empty($rfsStamp))
						{
							$error++;
							$msg = "Invalid MOVED TO AMAZON ROW#".$i;
						}
					}
								
				} 


				/*===create status===*/

				if($error=='0')
				{
					for($i=2;$i<=$arrayCount;$i++)
					{  

						$orderResult=array(
							'selling_mode'=>trim($allDataInSheet[$i]["D"]),
							'sale_channel'=>trim($allDataInSheet[$i]["B"]),
							'engineer_name'=>trim($allDataInSheet[$i]["G"]),
							'update_status'=>$this->input->post('update_status'),
							'nhdin'=>trim($allDataInSheet[$i]["A"]), 
							'category'=>trim($allDataInSheet[$i]["E"]), 
							'order_id'=>trim($allDataInSheet[$i]["C"]), 
							'uploadstatus_userid'=>$this->session->userdata('user_id'),
							'invoice_no'=>trim($allDataInSheet[$i]["F"]),
							'nhsp'=>trim($allDataInSheet[$i]["H"]),
							'remark'=>trim($allDataInSheet[$i]["I"]),
							'import_by'=>'excel', 
						);
						
						$engId=0;
						
						$userResult=$this->db->select('user_id')->where('username',trim($allDataInSheet[$i]["G"]))->get('tbl_users')->row();
						
						if(!empty($userResult))
						{
							$engId=$userResult->user_id;
						}
						
						$insertId=0;
						
						if($this->input->post('update_status')=='SALES RETURN' || $this->input->post('update_status')=='RETURNED TO ORIGIN')
						{
							$soldResult=$this->db->where('nhdin',trim($allDataInSheet[$i]["A"]))->order_by('stamp_id','DESC')->get('tbl_soldstamp')->row_array();
							
							if(!empty($soldResult))
							{
								$orderResult['selling_mode']=$soldResult['selling_mode'];
								
								$orderResult['order_id']=$soldResult['order_id'];
								
								$orderResult['sale_channel']=$soldResult['sale_channel'];
								
								$orderResult['invoice_no']=$soldResult['invoice_no'];
								
								$orderResult['nhsp']=$soldResult['nhsp'];
								
								$orderResult['category']=$soldResult['category'];
							}
						}
					
						$this->db->insert('tbl_bulkstatus',$orderResult);
						
						$insertId=$this->db->insert_id();	 
						
						/*==create trc data==*/
				
						if($this->input->post('update_status')=='TRC' )
						{	
					
							$this->Common_model->insertTrcAssessmentData($insertId,trim($allDataInSheet[$i]["A"]));	
							
					  	} 
						
						/*==create CERTIFICATION DEPARTMENT data==*/
				
						if($this->input->post('update_status')=='CERTIFICATION DEPARTMENT' )
						{	
					
							$this->Common_model->insertcertiDeptData($insertId,trim($allDataInSheet[$i]["A"]));	
							
					  	} 
						
						/*==create ready for sale data data==*/
				
						if($this->input->post('update_status')=='READY FOR SALE' )
						{		
							$this->Common_model->insertReadyForSaleData(trim($allDataInSheet[$i]["A"]),$insertId,'0','0');
						}

						/*==create DISMAMTLING DEVICES==*/
					
						if($this->input->post('update_status')=='DISMANTLING DEVICES')
						{	
							$this->Common_model->insertDismantlingData(trim($allDataInSheet[$i]["A"]),$insertId);
						
						}							

						// REMOVE NHDIN FROM RECIVED STORE
						
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'recived_store'=>'1'))->update('tbl_grnreport',array('recived_store'=>'2'));

						// REMOVE NHDIN FROM RECIVED ASSESSMENT STORE 
					
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_recivedasses_stores',array('status'=>'0'));
					
						// REMOVE NHDIN FROM READY FOR SALE
						
						if($this->input->post('update_status')!='READY FOR SALE')
						{	
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"])))->update('tbl_readyforsale',array('status'=>'0'));
						}
						
						// REMOVE NHDIN FROM PRELOVE==*/

						if($this->input->post('update_status')!='PRELOVE')
						{						
													 
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_prelove',array('status'=>'0'));
						}	
						
						// REMOVE NHDIN FROM READY OUT QC PASS SALES==*/

						if($this->input->post('update_status')!='OUT QC PASS - SALES')
						{						
													 
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_outqcpass_salesstamp',array('status'=>'0'));
						}	
					 
						
						if($this->input->post('update_status')!='ON HOLD')
						{	
							// REMOVE NHDIN FROM HOLD STAMP
						
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_onhold',array('status'=>'0'));
							
						}
						
						if($this->input->post('update_status')!='OUT QC PASS - FINANCE')
						{	
							
							// REMOVE NHDIN FROM OUT QC PASS - FINANCE
						
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_outqcpass_finance',array('status'=>'0'));
							
						}
					
						if($this->input->post('update_status')!='MOVED TO AMAZON')
						{	
							
							// REMOVE NHDIN FROM MOVED TO AMAZON
						
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_moved_toamazon',array('status'=>'0'));
							
						}
					
						if($this->input->post('update_status')=='OUT QC')
						{
							$this->db->insert('trc_engassessment',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'eng_id'=>$engId,'nhdin'=>trim($allDataInSheet[$i]["A"]),'purpose'=>'OUTQC','current_status'=>'OUT QC','imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"]))));
							
							/*==Add entry in out qc===*/
							
							$this->db->insert('tbl_outqcstamp',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'nhdin'=>trim($allDataInSheet[$i]["A"]),'imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"])),'engineer_id'=>$engId));
							
						}
						
						/*==work stamp on L1 ASSESSMENT==*/
					
						if($this->input->post('update_status')=='L1 ASSESSMENT')
						{ 
							
							$this->Common_model->insertStampData('tbl_l1assessment',trim($allDataInSheet[$i]["A"]),$insertId,$engId,trim($allDataInSheet[$i]["I"]));
							 
						}
						
						if($this->input->post('update_status')=='OUT QC PASS - SALES')
						{ 
					
							$this->Common_model->insetOutQcpassSalesData(trim($allDataInSheet[$i]["A"]),$engId,$insertId); 
						
						}
			
						/*==work stamp on OUT QC PASS - FINANCE==*/ 
						
						if($this->input->post('update_status')=='OUT QC PASS - FINANCE')
						{ 
							$this->db->insert('tbl_outqcpass_finance',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>trim($allDataInSheet[$i]["A"]),'eng_id'=>$engId,'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"])),'remark'=>trim($allDataInSheet[$i]["I"])));
						
						}	
			
						/*==work stamp on PRELOVE==*/ 
						
						if($this->input->post('update_status')=='PRELOVE')
						{ 
					
							$this->Common_model->insertData('tbl_prelove',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>trim($allDataInSheet[$i]["A"]),'eng_id'=>$engId,'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"])),'remark'=>trim($allDataInSheet[$i]["I"]))); 
						
						}	

						/*==work stamp on IN TRANSIT OUTBOUND SOLD==*/ 
					
						if($this->input->post('update_status')=='IN TRANSIT OUTBOUND SOLD')
						{ 
							
							$soldId=$this->db->select('stamp_id')->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_soldstamp')->row()->stamp_id;
							 
							$this->Common_model->insertOutbondSoldData(trim($allDataInSheet[$i]["A"]),$insertId,$soldId);
							
							// REMOVE NHDIN FROM SOLD STAMP
						
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_soldstamp',array('status'=>'0'));
						
						}						
						
						/*==work stamp on RETURNED TO ORIGIN==*/ 
					
						if($this->input->post('update_status')=='RETURNED TO ORIGIN')
						{ 
							
							$soldId=$this->db->select('sold_id')->where(array('nhdin'=>$nhdin,'status'=>'1'))->order_by('stamp_id','desc')->get('tbl_intransitoutbondsold')->row()->sold_id;
						
							$this->db->insert('tbl_returntoorigin',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>trim($allDataInSheet[$i]["A"]),'bulkstatus_id'=>$insertId,'sold_id'=>$soldId,'imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"]))));
						 
							/*==ADD DATA IN RFS TABLE==*/
							
							$this->Common_model->insertReadyForSaleData(trim($allDataInSheet[$i]["A"]),$insertId,'1','0');
				 	
						}
						
						/*==work stamp on SALES RETURN==*/ 
						
						if($this->input->post('update_status')=='SALES RETURN')
						{ 
							
							$this->Common_model->insertSalesReturn($insertId,trim($allDataInSheet[$i]["A"])); 
						 
							/*==ADD DATA IN RFS TABLE==*/
							
							$this->Common_model->insertReadyForSaleData(trim($allDataInSheet[$i]["A"]),$insertId,'0','1');
						 
						}	

						/*==work stamp on AFTER SALES SERVICE==*/ 
					
						if($this->input->post('update_status')=='AFTER SALES SERVICE')
						{ 
							$this->Common_model->insertAssInspectionData(trim($allDataInSheet[$i]["A"]),$insertId,$engId);
							 
							/*===ADD STAMP IN ENG ASSESSMENT==*/
							
							$this->db->insert('trc_engassessment',array('user_id'=>$this->session->userdata('user_id'),'bulkstatus_id'=>$insertId,'nhdin'=>trim($allDataInSheet[$i]["A"]),'eng_id'=>$engId,'purpose'=>'ASS','current_status'=>'ASS','imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"]))));
						}
						
						
						/*==work stamp on ASS INSPECTION - COMPLETED==*/ 
						
						if($this->input->post('update_status')=='ASS INSPECTION - COMPLETED')
						{ 
							$this->Common_model->insertAssInspecCompleted(trim($allDataInSheet[$i]["A"]),$insertId,'');
					 	
						}
						
						/*==work stamp on ASS DISPATCHED==*/ 
					
						if($this->input->post('update_status')=='ASS DISPATCHED')
						{  
							$this->Common_model->insertDispatchData(trim($allDataInSheet[$i]["A"]),$insertId,trim($allDataInSheet[$i]["I"])); 
							 
							/*==REMOVE NHDIN FROM ASS INSPECTION COMPLETED==*/
						
							$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->update('tbl_ass_inpectioncompleted',array('status'=>'0'));
						}
						 
						
						/*==CHECK CONDITION OF ON HOLD==*/
						
						if($this->input->post('update_status')=='ON HOLD')
						{ 
							
							$this->Common_model->insertHoldStampData(trim($allDataInSheet[$i]["A"]),$insertId,trim($allDataInSheet[$i]["I"])); 
						}
						
						/*==CHECK CONDITION OF ON HOLD==*/
						
						if($this->input->post('update_status')=='MOVED TO AMAZON')
						{ 
							$this->db->insert('tbl_moved_toamazon',array('user_id'=>$this->session->userdata('user_id'),'nhdin'=>trim($allDataInSheet[$i]["A"]),'bulkstatus_id'=>$insertId,'imei_no'=>$this->Common_model->getDeviceImeiNo(trim($allDataInSheet[$i]["A"]))));
						}
						
						
					 
						// REMOVE NHDIN FROM RECIVED ASSESSMENT STORE 
					
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'0','receivedassstore_status'=>'1'))->update('tbl_receivedassess_ass',array('status'=>'0','receivedassstore_status'=>'0'));
					
					
					}
			
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="BULK STATUS UPLOADED SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);    
	}
	
	public function uploadStatuByExcelEnd()
	{
		
		$this->load->model('Stamphistory_model');
		
		$data['excelResult']=array();
		
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				
				$this->session->set_userdata('error','FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.');  
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
				
				/*===check all error===*/
				  
				$error=0; 
				
				$stampValue=$this->input->post('update_status');

				for($i=2;$i<=$arrayCount;$i++)
				{  
					$engId=0;
						
					$userResult=$this->db->select('user_id')->where('username',trim($allDataInSheet[$i]["G"]))->get('tbl_users')->row();
					
					if(!empty($userResult))
					{
						$engId=$userResult->user_id;
					}
						
					$bulkResult[]=array(
						'sale_channel'=>trim($allDataInSheet[$i]["B"]),
						'order_id'=>trim($allDataInSheet[$i]["C"]), 
						'nhdin'=>trim($allDataInSheet[$i]["A"]),  
						'selling_mode'=>trim($allDataInSheet[$i]["D"]),
						'category'=>trim($allDataInSheet[$i]["E"]), 
						'invoice_no'=>trim($allDataInSheet[$i]["F"]), 						
						'engineer_id'=>$engId, 						
						'nhsp'=>trim($allDataInSheet[$i]["H"]), 						
						'remark'=>trim($allDataInSheet[$i]["I"]), 						
						'stamp_value'=>$stampValue, 						
					);
					
					unlink($inputFileName);
				 
					$data['excelResult']=$bulkResult; 
				}
			}
		}
		else 
		{
			$this->session->set_userdata('error','NO FILE SELECTED.'); 
	 	}
 		
		$data['active'] = 1;
		
		$userCond="tbl_account_details.user_id!='0'";
		
		if($this->session->userdata('user_type')!='1')
		{
			$userCond="tbl_account_details.location='".$this->session->userdata('userlocationValue')."'";
		}
		
		$engCond="(tbl_account_details.designations_id='13' or tbl_account_details.designations_id='20' or tbl_account_details.designations_id='34' )";
		
		if($this->session->userdata('user_type')=='1')
		{
			 
			$data['eng_user']=$this->db->select('tbl_users.*')->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
        }
		else
		{
			$data['eng_user']=$this->db->select('tbl_users.*')->where($userCond)->where($engCond)->join('tbl_users','tbl_users.user_id=tbl_account_details.user_id')->get('tbl_account_details')->result();
		}
		 	
		$data['title'] = "Bulk Status"; //Page title   
		
        $data['subview'] = $this->load->view('admin/bulk_status/manage_bulkstatus', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	function senddispatchMail($order_code)
	{
		//open connection
		
		$ch = curl_init();		
		//$url="http://www.ynew.in/admin/senddispatchMail";
		$url = "";
		//set the url, number of POST vars, POST data
		
		curl_setopt($ch, CURLOPT_URL, $url);  

		//execute post
		 curl_exec($ch);

		//close connection
		curl_close($ch); 
	}

	public function updateDeviceCategorytoPreloved()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		foreach($data as $rowValue){
			$devices[] = array(
				"nhdin" => trim($rowValue['device_id']),
				"stock_type" => "PRELOVED"
			);
		}

		$this->db->update_batch('tbl_grnreport', $devices, 'nhdin');
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function updateDeviceCategorytoSeltrue_sg100()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
		$msg = '';
		foreach($data as $rowValue){
			$statusCheck = $this->db->select('status, device_sub_category, stock_type')->where('nhdin', trim($rowValue['device_id']))->get('tbl_grnreport')->row();
			if($statusCheck->status != 'RFS'){
				$msg = 'Error: Device '.$rowValue['device_id'].' is not in RFS ';
				break;
			}
			if($statusCheck->stock_type == 'NEW'){
				$msg = 'Error: Device '.$rowValue['device_id'].' is a NEW Device ';
				break;
			}
			//if($statusCheck->device_sub_category != 'STANDARD'){
				//$msg = 'Error: Device '.$rowValue['device_id'].' is not a STANDARD Device ';
				//break;
			//}
			if(trim(strtoupper($rowValue['device_sub_category'])) != 'SELTRUE' && trim(strtoupper($rowValue['device_sub_category'])) != 'SG100'){
				$msg = 'Error: '.$rowValue['device_sub_category'].' Not a correct Device Sub Category';
				break;
			}

			$devices[] = array(
				"nhdin" => trim(strtoupper($rowValue['device_id'])),
				"device_sub_category" => trim(strtoupper($rowValue['device_sub_category']))
			);
		}

		if($msg != ''){
			$json['status'] = 0;
			$json['err_msg'] = $msg;
			echo json_encode($json);
			exit;
		}
		$this->db->update_batch('tbl_grnreport',$devices, 'nhdin');
		$error = $this->db->error();
		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function updateSaletypetoSellerflex()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
		$msg = '';
		$device_ids = [];
		foreach($data as $rowValue){
			if(!empty($rowValue['device_id'])){
				$device_ids[] = trim($rowValue['device_id']);
			}
		}
		$statusCheck = $this->db->select('tbl_grnreport.nhdin as device_id, status, saletype, stock_type, mrp, tbl_ecom_devices.grnreport_id')
		->join('tbl_ecom_devices', 'tbl_ecom_devices.grnreport_id = tbl_grnreport.grnreport_id', 'Left')
		->where_in('nhdin',$device_ids)->get('tbl_grnreport')->result_array();
		
		foreach($statusCheck as $rowValue){
			
			if($rowValue['status'] != 'RFS'){
				$msg = 'Error: Device '.$rowValue['device_id'].' is not in RFS ';
				break;
			}
			if($rowValue['saletype'] != 'OFFLINE'){
				$msg = 'Error: Device '.$rowValue['device_id'].' is a not a OFFLINE Device ';
				break;
			}

			if($rowValue['mrp'] <= 0){
				$msg = 'Error: Price Not Set for Device '.$rowValue['device_id'];
				break;
			}

			if(empty($rowValue['grnreport_id'])){
				$msg = 'Error: Device '.$rowValue['device_id'].' is not Picked for Sellerflex ';
				break;
			}

			$devices[] = array(
				"nhdin" => trim(strtoupper($rowValue['device_id'])),
				"saletype" => "SELLERFLEX",
				"warehouse" => "TDWD",
				"invoice_type" => "TAXABLE",
				"remark" => "Device moved to SELLERFLEX"
			);
		}

		if($msg != ''){
			$json['status'] = 0;
			$json['message'] = $msg;
			echo json_encode($json);
			exit;
		}
		$this->db->update_batch('tbl_grnreport',$devices, 'nhdin');
		$error = $this->db->error();
		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function downloadInventoryAvailableReport()
    {

        $from_date_1 = $this->input->get('from_date');
        $to_date_1 = $this->input->get('to_date');
        if ($from_date_1 == '' || $to_date_1 == '') {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_date = str_replace('/', '-', $from_date_1);
        $to_date = str_replace('/', '-', $to_date_1);
        $csv_output = "S/NO, DEVICE ID, CATEGORY, PRODUCT BRAND, DEVICE NAME, COLOR, RAM, ROM, SKU, GRADE, STATUS, DATE";
        if ($from_date != '') {

            $this->db->where("DATE(LAST_UPDATED) >=", date("Y-m-d", strtotime($from_date)));
        }
        if ($to_date != '') {

            $this->db->where("DATE(LAST_UPDATED) <=", date("Y-m-d", strtotime($to_date)));
        }
        $result = $this->db->select('*')->from('tbl_device_log')
		
		->get()->result();
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $report_data = array();
        $row_count = 1; 
        foreach ($result as $value) {

            $device_id = $value->device_id;
            $device_data = $this->db->select('*')->from('tbl_grnreport')->where('nhdin',$device_id)->get()->row();
            
            $report_data[] = array(

                "row_count" => $row_count,
                "device_id" => $value->device_id,
                "stock_type" => $device_data->stock_type,
                "product_brand" => $device_data->product_brand,
                "device_name" => $device_data->device_name,
                "color" => $device_data->color,
                "ram" => $device_data->ram,
                "rom" => $device_data->rom,
                "sku" => $device_data->SKU,
                "grade" => $device_data->certification_grade,
                "last_updated" => date("d-m-Y", strtotime($value->last_updated)),
		        "status" => str_replace('_', ' ', $device_data->status)
            );
            $row_count++;
        }
        //echo "<pre>"; print_r($report_data); echo "</pre>"; exit;
        $csv_output .= "\n";
        if (!empty($report_data)) {
            foreach ($report_data as $periodic_report) {

                $csv_output .= $periodic_report['row_count'] . ",";
                $csv_output .= $periodic_report['device_id'] . ",";
                $csv_output .= $periodic_report['stock_type'] . ",";
                $csv_output .= $periodic_report['product_brand'] . ",";
                $csv_output .= $periodic_report['device_name'] . ",";
                $csv_output .= $periodic_report['color'] . ",";
                $csv_output .= $periodic_report['ram'] . ",";
                $csv_output .= $periodic_report['rom'] . ",";
                $csv_output .= $periodic_report['sku'] . ",";
                $csv_output .= $periodic_report['grade'] . ",";
		        $csv_output .= $periodic_report['status'] . ",";
		        $csv_output .= $periodic_report['last_updated'] . ",";

                $csv_output .= "\n";
            }
        }
        if (empty($report_data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $filename = "inventory_available_report_from_".$from_date_1."_to_".$to_date_1;
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }

} 

