<?php
ini_set('max_execution_time', '3000');
/**
 * Description of client
 *
 * @author NaYeM
 */
class Bulk_order extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		/*load model*/
    }

	/** This is separate URL for EXPORTS */
    public function manage_order_exp($id = NULL, $activeId = NULL) {
		return $this->manage_order($id, $activeId, 2);
	}
	
    public function manage_order($id = NULL, $activeId=NULL, $module_type = 1) {
	 
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
        $data['module_type'] = $module_type;

		$data['device_actv_cond_data'] = $this->Common_model->getDevice_ActivationConditions_List();
		 
        $data['title'] = lang('manage_device'); //Page title
        $data['page'] = lang('device');
        $data['subview'] = $this->load->view('admin/bulk_order/manage_order', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }

	 
	public function create_order()
    { 
		$data=$this->input->post();  
		   
		$allOrderResult=array();$allGrnResult=array();$duplicateVendorId=array();$duplicateImei=array();
		
		if(!empty($data) && !empty($data['vendor_id']))
		{  
	 
			$createOrderRefNo=$this->Common_model->createOrderRefId();
				
			$i=0;
			
			$maxId=$this->db->select('MAX(grnreport_id) as grnreport_id')->get('tbl_grnreport')->row_array();
			
			if((int)$maxId['grnreport_id']<=24399)
			{
				$j='24399';
			}
			else
			{
				$j=(int)$maxId['grnreport_id'];
			}
					  
			$j=$j+1;
			
			/*===GET NHDIN WORK===*/
			
			$location=$this->input->post('location');
				 				
			$loc='HYD';
 
			/*==check vendor code exise in datatbase==*/
			
			$error=0;
			
			$errorSno=0;
			
			$vendorSno=0;
			
			foreach($data['vendor_id'] as $Key) 
			{
				
				$vendorCodeResult=$this->db->where('vendor_code',$data['vendor_id'][$vendorSno])->get('tbl_vendor')->row();
				
				$nhmodResult=$this->db->where('nhmod',$data['nhmod'][$vendorSno])->get('tbl_product_details')->row();
				
				if(empty($vendorCodeResult) || empty($nhmodResult))
				{
					$error++;
				}
				
				/*===CHECK IMEI NO==*/
				
				if($data['imei1'][$vendorSno]!='')
				{ 
						$value=preg_replace('/[^0-9]/', '', $data['imei1'][$vendorSno]);
						
						$imeiLength=strlen($value);
						
						if($imeiLength!='15')
						{
							$error++;
						}
						else
						{
							/*==check duplicate imei no with datatbase===*/
							
							// $imeiResult=array();
							
							// $imeiResult=$this->db->where('imei1',$data['imei1'][$vendorSno])->get('tbl_bulkorder')->row();
							
							// if(!empty($imeiResult))
							// {
								// $error++;
							// }
						}
						
						/*==CHECK DUPLICATE EXCEL IMEI NO==*/
						
						// if(in_array($data['imei1'][$vendorSno],$duplicateImei))
						// {
							// $error++;
						// }
						// else
						// {							
							// $duplicateImei[]=$data['imei1'][$vendorSno];								
						// }
				}
				else
				{
					// $error++;
				}
					

				
				// CHECK MODEL ID
						
				$nhmodResult=$this->Common_model->getRowResult('product_id','tbl_product_details',array('nhmod'=>$data['nhmod'][$vendorSno],'nhmod !='=>''));
				
				if(empty($nhmodResult))
				{
					$error++;
				}
			
			
				// CHECK OTHER VENDOR ID
					
				$otherVendorRsult=$this->Common_model->getRowResult('grnreport_id','tbl_grnreport',array('othervendor_id'=>$data['othervendor_id'][$vendorSno]));
				
				if(!empty($otherVendorRsult))
				{
					$error++;
				}
				
			
				// check duplicate other vendor id
					
				if($data['othervendor_id'][$vendorSno]=='')
				{
					$error++;
				}
				else
				{
					/*==CHECK DUPLICATE  OTHER VENDOR ID==*/
					
					if(in_array($data['othervendor_id'][$vendorSno],$duplicateVendorId))
					{
						$error++;
					}
					else
					{							
						$duplicateVendorId[]=$data['othervendor_id'][$vendorSno];								
					}	
				}

				/*==check vendor code exist in datatbase==*/ 
				
				
				// chk gatepass no
				
				$gatePassResult=$this->Common_model->getRowResult('admin_id','tbl_security_admin',array('gatepass_uniqueno'=>$data['entrypass_no'][$vendorSno]));
				
				if(empty($gatePassResult))
				{
					$error++;
					
				}
				
				$vendorSno++;
								
			}
 
			if($error=='0')
			{ 
		
				/*===create order id===*/
				   
				$maxId=$this->db->select('MAX(grnreport_id) as grnreport_id')->get('tbl_grnreport')->row_array();
				
				if((int)$maxId['grnreport_id']<=24399)
				{
					$j='24399';
				}
				else
				{
					$j=(int)$maxId['grnreport_id'];
				}
				
				$j=$j+1;
					
				foreach($data['vendor_id'] as $Key) 
				{ 
			
					$orderResult=array
					(
						'uploadorder_userid'=>$this->session->userdata('user_id'),
						'order_refno'=>$createOrderRefNo,
						'location'=>$this->input->post('location'),
						'invoice_type'=>$data['invoice_type'][$i],
						'vendor_id'=>$data['vendor_id'][$i],
						'source'=>$data['source_id'][$i],
						'nhmod'=>$data['nhmod'][$i],
						'nhdp'=>'0',
						'imei1'=>$data['imei1'][$i],
						'imei2'=>$data['imei2'][$i],
						'unit_price'=>$data['unitprice'][$i],
						'tax'=>$data['taxvalue'][$i],
						'stock_type'=>$data['select_stock_type'][$i],
						'stock_subtype'=>$data['stock_sub_type'][$i],
						'invoice_no'=>$data['invoice_no'][$i],
						'invoice_date'=>date("Y-m-d", strtotime($data['invoice_date'][$i])),
						'tax_type'=>$data['tax_type'][$i],
						'othervendor_id'=>$data['othervendor_id'][$i],
						'lot_number'=>$data['lot_number'][$i], 
					);
					
					$allOrderResult[]=$orderResult;
					 			 
					/*==Insert data in tbl_grnreport for create GRN REPORT===*/
							
					/*===create order id===*/
							 
					$mode=$data['select_stock_type'][$i];
							
					$stock_subtype=$data['stock_sub_type'][$i];
							  								
					$orderId=$this->Common_model->getOrderIdForNHDIN($mode,$stock_subtype);
									
					 
				 
					/*==Get vendor Name===*/
					
					$vendorCompany=''; $vendorState='';
					
					$vendorCompany=$this->Common_model->getVendorCompanyNameFormVendorCode($data['vendor_id'][$i]);
					
					$vendorState=$this->Common_model->getVendorStateFormVendorCode($data['vendor_id'][$i]);
 					
					$productResult=$this->db->select('tbl_device_type.name as typeName,tbl_device_type.type_id,tbl_device_type.nhdin_ext,tbl_device_brand.name as brandName,tbl_product_details.product_name')->where('tbl_product_details.nhmod',$data['nhmod'][$i])->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')->get('tbl_product_details')->row_array();
					
					$deviceName='';$typeName='';$brandName='';$typeId='0';$nhdinExt='A';
					
					if(!empty($productResult))
					{
						$deviceName=$productResult['product_name'];
						
						$typeName=$productResult['typeName'];
						
						$brandName=$productResult['brandName'];
						
						$typeId=$productResult['type_id'];
						
						$nhdinExt=$productResult['nhdin_ext'];
					}
					
					//create NHIDIN for device
					
					//create nhdin for new device
	 
					$nhdin=$this->Common_model->getNHDIN($orderId,$j,trim($allDataInSheet[$i]["C"]),$loc,$nhdinExt);
						
					$grnResult=array
					(				
						'uploadorder_userid'=>$this->session->userdata('user_id'),
						'order_refno'=>$createOrderRefNo,
						'vendor_code'=>$data['vendor_id'][$i],
						'invoice_date'=>date("Y-m-d", strtotime($data['invoice_date'][$i])),
						'invoice_no'=>$data['invoice_no'][$i],
						'invoice_type'=>$data['invoice_type'][$i],
						'vendor_name'=>$vendorCompany,
						'nhdin'=>$nhdin['kdin'],
						'device_name'=>$deviceName,
						'product_type'=>$typeName,
						'product_brand'=>$brandName,
						'nhmod'=>$data['nhmod'][$i],
						'imei1_no'=>$data['imei1'][$i],
						'imei2_no'=>$data['imei2'][$i],
						'unit_price'=>$data['unitprice'][$i],
						'tax'=>$data['taxvalue'][$i],
						'tax_type'=>$data['tax_type'][$i],
						'nhpp'=>$data['unitprice'][$i], 
						'nhdp'=>'0',
						'stock_type'=>$data['select_stock_type'][$i],
						'stock_subtype'=>$data['stock_sub_type'][$i],
						'othervendor_id'=>$data['othervendor_id'][$i],
						'lot_number'=>$data['lot_number'][$i],
						'entrypass_no'=>$data['entrypass_no'][$i],
						'warehouse'=>$this->input->post('location'),
					);
							
					$allGrnResult[]=$grnResult;
 
					$lastnhmod=$data['nhmod'][$i];		
					
					$i++;
					$j++;
				}
				
				if(!empty($allOrderResult))
				{
					//$this->db->insert_batch('tbl_bulkorder',$allOrderResult);
				}
		
				if(!empty($allGrnResult))
				{
					$this->db->insert_batch('tbl_grnreport',$allGrnResult);
				}
					
				/*===set message==*/
				  
				$type="success";
				
				$msg="INWARD DONE SUCCESSFULLY.";  
			}
			else
			{
				  $type="error";
				
				  $msg="SOME ERROR FOUND.PLEASE CHECK."; 
			}	 
				
		}
		else
		{
			/*===set message==*/ 
			
			$type="error";
				
			$msg="SOMETHING WRONG.PLEASE TRY AGAIN."; 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']); 
 	 
	}
	
   	
	public function addTableRow()
	{   
	
		$randomNo=substr(sha1(mt_rand()),30,10);
		$trId=rand();
		$html='
			<tr id="'.$trId.'">
				<td><input class="form-control" required name="vendor_id[]" placeholder="SUPPLIER CODE" value="" type="text"></td>
				<td>
					<select class="form-control" required name="source_id[]"   >
						<option value="">CHOOSE SOURCE Type</option>
						<option value="OFFLINE">OFFLINE</option>
						<option value="ONLINE">ONLINE</option>  
					 </select>	 
				</td>
				<td><input class="form-control" required name="nhmod[]" placeholder="MODEL ID" value="" type="text"></td> 
				<td><input class="form-control"  name="imei1[]" placeholder="IMEI 1" value="" type="text"></td>
				<td><input class="form-control"  name="imei2[]" placeholder="IMEI 2" value="" type="text"></td>
				<td><input class="form-control" required name="unitprice[]" onkeypress="return isNumberKey(event)" placeholder="UNIT PRICE" value="" type="text"></td>
				<td>
					<select class="form-control" required name="taxvalue[]"   >
						<option value="">CHOOSE TAX VALUE</option>
						<option value="0%">0 %</option>
						<option value="12%">12 %</option>
						<option value="18%">18 %</option>  
					 </select>
				 </td>
				<td>
					<select class="form-control" required name="select_stock_type[]" onchange="getSubType(this.value,this.id)" id="'.$randomNo.'" >
						<option value="">CHOOSE STOCK TYPE</option>
						<option value="PREXO">PREXO</option>
						<option value="OPEN BOX">OPEN BOX</option> 
						<option value="NEW">NEW</option>
						<option value="INSURANCE">INSURANCE</option> 
						<option value="BRAND REFURBISHED">BRAND REFURBISHED</option> 
						<option value="BUY BACK">BUY BACK</option> 
					 </select>
				 </td>
				<td>
					<select class="form-control" required name="stock_sub_type[]" id="stock_subtype'.$randomNo.'" >
						<option value="">CHOOSE STOCK SUB TYPE</option>
						<option value="CA">CA</option>
						<option value="REGULAR">REGULAR</option>  
					 </select>
				 </td>
				<td>
					<select class="form-control" required name="invoice_type[]" id="invoice_type">
						<option value="">CHOOSE INVOICE TYPE</option>
						<option value="TAXABLE">TAXABLE</option>
						<option value="EXEMPT">EXEMPT</option> 
					 </select>	
				 </td>
				 
				<td><input class="form-control" placeholder="INVOICE NUMBER" required name="invoice_no[]" value="" type="text"></td>
				<td><input class="form-control bulkorderDate" placeholder="YYYY-MM-DD" required name="invoice_date[]" value="" type="text"></td>
				<td><input class="form-control" readonly placeholder="TAX TYPE" required name="tax_type[]" value="GST" type="text"></td>
				<td><input class="form-control"  required placeholder="VENDOR DEVICE ID"  name="othervendor_id[]" value="" type="text"></td>
				<td><input class="form-control"   placeholder="LOT NUMBER"  name="lot_number[]" value="" type="text"></td>
				<td><input class="form-control"  required placeholder="ENTRY PASS NO"  name="entrypass_no[]" value="" type="text"></td> 
				<td><a onclick="deleteRow('.$trId.')" class="dt-button  btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	/** uploadOrderByExcel() no more required. 
	 * This Function is rewriting as upload_Inward_Devices() */
	public function uploadOrderByExcel()
	{
		$invalidVendorCode=array();$duplicateImei=array();$duplicateVendorId=array();$allOrderResult=array();$allGrnResult=array();
		
		$filesetcheck = isset($_FILES["excel_file"]);
			
		if (isset($_FILES["excel_file"])) 
		{ 
			
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx") 
			{ 
		
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.";  
			}
			else
			{ 
		 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				
			   /************************ YOUR DATABASE CONNECTION END HERE  ****************************/
			
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				//var_dump($objPHPExcel->getActiveSheet()->getStyle('O:O')->getNumberFormat());

				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		
		
					
				/*===GET ORDER REF. NO===*/
					
					
				$createOrderRefNo=$this->Common_model->createOrderRefId();
					
				/*===GET NHDIN WORK===*/
					 
				$location=$this->input->post('warehousList');

				if($location == 'HYD' || empty($location)){
					$location = 'HYDERABAD';
				}
				
				$batch_no = $this->input->post('batch_no');
				$module_type = $this->input->post('module_type');
					 
				$loc='HYD';
			
				/*==check vendor code exise in datatbase==*/
					
				$error=0; 
					
				for($d=2;$d<=$arrayCount;$d++)
				{ 
					
					$vendorCodeResult=$this->db->where('vendor_code',trim($allDataInSheet[$d]["A"]))->get('tbl_vendor')->row();
					
					$nhmodResult=$this->db->where('nhmod',trim($allDataInSheet[$d]["C"]))->get('tbl_product_details')->row();
										
					/*== CHECK VENDOR CODE ==*/
					if(empty($vendorCodeResult))
					{
						$error++;
						$msg = "Invalid Vendor Code - Row#".$d;
						break;
					} 
					
					if(empty($nhmodResult))
					{
					    $error++;
						$msg = "Invalid Device Model - Row#".$d;
						break;				
					}
									
					
					/*==CHECK SOURCE==*/
						
					if(trim($allDataInSheet[$d]["B"])=='OFFLINE' || trim($allDataInSheet[$d]["B"])=='ONLINE')
					{
											
					}
					else {
						$error++;
						$msg = "Invalid Source - Row#".$d;
						break;											
					}
					
					
					// CHECK MODEL ID
					 
					$nhmodResult=$this->Common_model->getRowResult('product_id','tbl_product_details',array('nhmod'=>trim($allDataInSheet[$d]["C"]),'nhmod !='=>''));
					 
					if(empty($nhmodResult))
					{
						$error++;
						$msg = "Invalid Device Model 2 - Row#".$d;
						break;	
					}
					
					// CHECK OTHER VENDOR ID
					
					$otherVendorRsult=$this->Common_model->getRowResult('grnreport_id','tbl_grnreport',array('othervendor_id'=>trim($allDataInSheet[$d]["Q"])));
					
					if(!empty($otherVendorRsult))
					{
						$error++;
						$msg = "Invalid Vendor Device Id - Row#".$d;
						break;	
					}
		
					// check duplicate other vendor id
			 
					if(trim($allDataInSheet[$d]["Q"])=='')
					{
						$error++;
						$msg = "Empty Vendor Device Id - Row#".$d;
						break;
					}
					else
					{
						/*==CHECK DUPLICATE  OTHER VENDOR ID==*/
						
						if(in_array(trim($allDataInSheet[$d]["Q"]),$duplicateVendorId))
						{
							$error++;
							$msg = "Duplicate Vendor Device Id - Row#".$d;
							break;
						}
						else
						{							
							$duplicateVendorId[]=trim($allDataInSheet[$d]["Q"]);								
						}	
					}
				
					/*==CHECK STOCK TYPE AND STOCK SUB TYPE==*/
						
					$stockType='';$stockSubType='';
					
					$stockType=strtoupper(trim($allDataInSheet[$d]["K"]));
					
					$stockSubType=strtoupper(trim($allDataInSheet[$d]["L"]));
					
					if($stockType=='PREXO')
					{
						if($stockSubType=='DAMAGE' || $stockSubType=='AOS' || $stockSubType=='OK' || $stockSubType=='GRADED' || $stockSubType=='AMAZON-BULK')
						{	
						}
						else
						{
							$error++;
							$msg = "PREXO-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='OPEN BOX')
					{
						if($stockSubType!='NTF' && $stockSubType!='CX' && $stockSubType!='TF')
						{	
							$error++;
							$msg = "OpenBox-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='BRAND REFURBISHED')
					{
						if($stockSubType!='NTF')
						{
							$error++;
							$msg = "BRAND REFURBISHED-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='BUY BACK')
					{
						if($stockSubType!='GOOD' && $stockSubType!='DAMAGE' && $stockSubType!='DEAD')
						{
							$error++;
						    $msg = "Buy Back -Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					else
					{
						// $error++;
					}	
					
					/*===CHECK IMEI NO==*/
				
					if(trim($allDataInSheet[$d]["G"])!='')
					{ 
							$value=preg_replace('/[^0-9]/', '', trim($allDataInSheet[$d]["G"]));
							
							$imeiLength=strlen($value);
							
							if($imeiLength < 15 && $nhmodResult->type_id == 2)
							{
								$error++;
								$msg = "Invalid IMEI Length - Row#".$d;
								break;
							}
							else
							{
								/*==check duplicate imei no with datatbase===*/
								
								// $imeiResult=array();
								
								// $imeiResult=$this->db->where('imei1',$allDataInSheet[$d]["D"])->get('tbl_bulkorder')->row();
								
								// if(!empty($imeiResult))
								// {
									// $error++;
								// }
							}
							
							
							/*==CHECK DUPLICATE EXCEL IMEI NO==*/
						
							// if(in_array(trim($allDataInSheet[$d]["D"]),$duplicateImei))
							// {
								// $error++;
							// }
							// else
							// {							
								// $duplicateImei[]=trim($allDataInSheet[$d]["D"]);								
							// }	
							
					}
					else
					{
						// $error++;
					}	
					
					/*==CHECK UNIT PRICE==*/
						
					if(trim($allDataInSheet[$d]["I"])=='')
					{	
						$error++;				
						$msg = "Invalid Unit Price - Row#".$d;
						break;
					} 	
					
					/*==CHECK INVOICE NO==*/
						
					if(trim($allDataInSheet[$d]["N"])=='')
					{	
						$error++;	
						$msg = "Invalid Invoice Number - Row#".$d;
						break;						
					} 
					
					
					/*==CHECK INVOICE DATE==*/
						
					if(trim($allDataInSheet[$d]["O"])=='')
					{	
						$error++;				
						$msg = "Invalid Invoice Date - Row#".$d;
						break;
					}
					
					/*==CHECK TAX TYPE==*/
						
					if(trim($allDataInSheet[$d]["P"])!='GST')
					{	
						$error++;			
						$msg = "Invalid Tax Type - Row#".$d;
						break;							
					} 
					
					/*==CHECK TAX ==*/
						
					if(trim($allDataInSheet[$d]["J"])=='' || (trim($allDataInSheet[$d]["J"])!='0' && trim($allDataInSheet[$d]["J"])!='12' && trim($allDataInSheet[$d]["J"])!='18'))
					{	
						$error++;		
						$msg = "Invalid Tax % - Row#".$d;
						break;					
					} 
					
					
					/*==CHECK INVOICE TYPE ==*/
					$invoiceType='';
					
					
					$invoiceType=strtoupper(trim($allDataInSheet[$d]["M"]));
					if(in_array($stockType, TAXABLE_CATEGORY)){
						if($invoiceType!='TAXABLE')
						{	
							$error++;
							$msg = "Invalid Tax Type - Row#".$d;
							break;
						} 
					}else if(in_array($stockType, EXEMPT_CATEGORY)){
						if($invoiceType!='EXEMPT')
						{	
							$error++;
							$msg = "Invalid Tax Type - Row#".$d;
							break;
						} 
					}else{
						$error++;
						$msg = "Invalid Category - Row#".$d;
						break;
					}
					
					
					// chk gatepass no
				
					$gatePassResult=$this->Common_model->getRowResult('admin_id','tbl_security_admin',array('gatepass_uniqueno'=>trim($allDataInSheet[$d]["S"])));
					
					if(empty($gatePassResult))
					{
						$error++;
						$msg = "Invalid Entrypass - Row#".$d;	
						break;
						
					} 
					
					$pr_grade = trim($allDataInSheet[$d]["Y"]); 
					$grade_result = $this->db->where(array('grade'=>trim($pr_grade),'type'=>'PROCUREMENT'))->get('tbl_grade')->row();
					if(empty($grade_result)){
						$msg="Invalid Procurement Grade - Row#".$d;	
					   	$error++;
						   break;
					}

					$rows = $this->db->where('color', trim($allDataInSheet[$d]["F"]))->get('tbl_colorcode')->num_rows();

					if($rows <= 0){
						$msg="Invalid Color ".$allDataInSheet[$d]["F"];	
					   	$error++;
						   break;
					}

					$grade_result = $this->db->where(array('value'=>trim($allDataInSheet[$d]["D"]),'type'=>'RAM'))->get('tbl_device_memory')->row();
					if(empty($grade_result)){
						$msg="Invalid RAM - #".$allDataInSheet[$d]["D"];	
					   	$error++;
						   break;
					}

					$grade_result = $this->db->where(array('value'=>trim($allDataInSheet[$d]["E"]),'type'=>'ROM'))->get('tbl_device_memory')->row();
					if(empty($grade_result)){
						$msg="Invalid ROM - #".$allDataInSheet[$d]["E"];	
					   	$error++;
						   break;
					}

					if(empty(trim($allDataInSheet[$d]["X"]))){
						$msg="Invalid BIN NUMBER For Row#".$d;	
						$error++;
						break;
					}
				} 
	
				if($error=='0')
				{
					/*===create order id===*/
				   
					$maxId=$this->db->select('MAX(grnreport_id) as grnreport_id')->get('tbl_grnreport')->row_array();
					
					/*if((int)$maxId['grnreport_id']<=24399)
					{
						$j='24399';
					}
					else
					{
						$j=(int)$maxId['grnreport_id'];
					}*/
					
					$j=(int)$maxId['grnreport_id'];
					$j=$j+1;
					
					for($i=2;$i<=$arrayCount;$i++)
					{ 
						$orderResult=array(
							'uploadorder_userid'=>$this->session->userdata('user_id'),
							'order_refno'=>$createOrderRefNo,
							'location'=>$this->input->post('location'),
							'invoice_type'=>trim($allDataInSheet[$i]["M"]),
							'vendor_id'=>trim($allDataInSheet[$i]["A"]),
							'source'=>trim($allDataInSheet[$i]["B"]),
							'nhmod'=>trim($allDataInSheet[$i]["C"]),
							'imei1'=>trim($allDataInSheet[$i]["G"]),
							'imei2'=>trim($allDataInSheet[$i]["H"]),
							'unit_price'=>trim($allDataInSheet[$i]["I"]),
							'tax'=>trim($allDataInSheet[$i]["J"]),
							'stock_type'=>trim($allDataInSheet[$i]["K"]),
							'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
							'invoice_no'=>trim($allDataInSheet[$i]["N"]),
							'invoice_date'=>date("Y-m-d", strtotime(trim($allDataInSheet[$i]["O"]))),
							'tax_type'=>trim($allDataInSheet[$i]["P"]),
							'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
							'lot_number'=>trim($allDataInSheet[$i]["R"]),
							'nhdp'=>'0',
							'insert_by'=>'Excel',
						);
						
						$allOrderResult[]=$orderResult;
															 
						/*==Insert data in tbl_grnreport for create GRN REPORT===*/
					
						/*==Get vendor Name===*/
						$vendorCompany='';$vendorState='';
						
						$vendorCompany=$this->Common_model->getVendorCompanyNameFormVendorCode($orderResult['vendor_id']);
										
						$vendorState=$this->Common_model->getVendorStateFormVendorCode($orderResult['vendor_id']);
						 
						$mode=strtoupper(trim($allDataInSheet[$i]["K"]));
					 
						$stockSubType=trim($allDataInSheet[$i]["L"]);
										
						$orderId=$this->Common_model->getOrderIdForNHDIN($mode,$stockSubType);
					 
						$invoice_date = $this->db->select('invoice_date')->where('invoice_no', trim($allDataInSheet[$i]["N"]))->get('tbl_security_admin')->row()->invoice_date;
					
						$invoiceDate=trim($allDataInSheet[$i]["O"]);
						
						$productResult=$this->db->select('tbl_device_type.name as typeName,tbl_device_type.type_id,tbl_device_type.nhdin_ext,tbl_device_brand.name as brandName,tbl_product_details.product_name')->where('tbl_product_details.nhmod',$orderResult['nhmod'])->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')->get('tbl_product_details')->row_array();
					

						$deviceName='';$typeName='';$brandName='';$typeId=0;$nhdinExt='A';
						
						if(!empty($productResult))
						{
							$deviceName=$productResult['product_name'];
							
							$typeName=$productResult['typeName'];
							
							$typeId=$productResult['type_id'];
							
							$brandName=$productResult['brandName'];
							
							$nhdinExt=$productResult['nhdin_ext'];
						}
					
						//create nhdin for new device
						
						$nhdin=$this->Common_model->getNHDIN($orderId,$j,trim($allDataInSheet[$i]["C"]),$loc,$nhdinExt);
						
						$modelid = $orderResult['nhmod'];
						$color=trim($allDataInSheet[$i]["F"]);
						$ram=trim($allDataInSheet[$i]["D"]);
						$rom=trim($allDataInSheet[$i]["E"]); 
						
						$sku = $this->Common_model->getSKU($modelid,$ram,$rom,$color); 	
						$procurement_grade = trim($allDataInSheet[$i]["Y"]); 
						
						$bac = trim($allDataInSheet[$i]["T"]).'-'.trim($allDataInSheet[$i]["U"]).'-'.trim($allDataInSheet[$i]["V"]);						
						
						$unit_price = trim($allDataInSheet[$i]["I"]);
						if(strtoupper($allDataInSheet[$i]["K"]) == 'PREXO' && !empty(trim($allDataInSheet[$i]["Z"]))){
							$up = $this->db->where('model_name', trim($allDataInSheet[$i]["Z"]))->get('tbl_prexo_ratecard')->row();
							if(!empty($up)){
								if($procurement_grade == 'B'){
									$unit_price = $up->b_grade;
								}
								if($procurement_grade == 'C'){
									$unit_price = $up->c_grade;
								}
								if($procurement_grade == 'D'){
									$unit_price = $up->d_grade;
								}
							}
						}

						$grnResult=array
						(
						
							'uploadorder_userid'=>$this->session->userdata('user_id'),
							'order_refno'=>$createOrderRefNo,
							'vendor_code'=>trim($allDataInSheet[$i]["A"]),
							'purchase_source'=>trim($allDataInSheet[$i]["B"]),
							'invoice_date'=>$invoice_date,
							'invoice_no'=>trim($allDataInSheet[$i]["N"]),
							'invoice_type'=>trim($allDataInSheet[$i]["M"]),
							'vendor_name'=>$vendorCompany,
							'nhdin'=>$nhdin['kdin'],
							'product_type'=>$typeName,
							'product_brand'=>$brandName,
							'device_name'=>$deviceName,
							'nhmod'=>$modelid,
							'imei1_no'=>trim($allDataInSheet[$i]["G"]),
							'imei2_no'=>trim($allDataInSheet[$i]["H"]),
							'unit_price'=>$unit_price,
							'tax'=>trim($allDataInSheet[$i]["J"]),
							'tax_type'=>trim($allDataInSheet[$i]["P"]),
							'nhpp'=>trim($allDataInSheet[$i]["I"]), 
							'nhdp'=>'0', 
							'stock_type'=>trim($allDataInSheet[$i]["K"]),
							'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
							'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
							'lot_number'=>trim($allDataInSheet[$i]["R"]),
							'batch_no' =>trim($batch_no),
							'color'=>$color,
							'ram'=>$ram,
							'rom'=>$rom,							
							'entrypass_no'=>trim($allDataInSheet[$i]["S"]),
							'remark'=>trim($allDataInSheet[$i]["W"]),
							'bin_number'=>trim($allDataInSheet[$i]["X"]),
							'certification_grade'=>trim($allDataInSheet[$i]["Y"]),							
							'procurement_grade'=>$procurement_grade,
							'warehouse'=>$location,
							'vendor_device_name' => trim($allDataInSheet[$i]["Z"]),
							'sku'=>$sku,
							'bac'=>$bac,
							'module_type'=> $module_type
						);

						if ($module_type == 2) {
							$grnResult['saletype'] = 'EXPORT';
						}
										
						$allGrnResult[]=$grnResult;
						 
						$lastnhmod=$orderResult['nhmod'];
						
						$j++;
					}
			
					if(!empty($allOrderResult))
					{
						//$this->db->insert_batch('tbl_bulkorder',$allOrderResult);
					}
			
					if(!empty($allGrnResult))
					{
						$this->db->insert_batch('tbl_grnreport',$allGrnResult);
					}
					
					unlink($inputFileName);
					
					$type="success";
				
				$msg="INWARD DONE SUCCESSFULLY.";   
				  
				}
				else
				{ 
					 /*===set message==*/
					
					
					$type="error";
				
					$this->session->set_userdata($type,$msg);  
					header("location:".$_SERVER['HTTP_REFERER']);  
					 
				}
			}
		}
		else 
		{
			
			$type="error";
				
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN. File Set : ".$filesetcheck.$error; 
			 
		}
		
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);  
	}

	/**
	 * Old Validations while uploading "Inward Devices" is separated
	 * And few validations moved to New Validations especially DB calls
	 */
	private function InwardDevices_OldValidations($allDataInSheet) {
		$error = 0;
		
		for($d = 2; $d <= count($allDataInSheet); $d++) {

			/*==CHECK SOURCE==*/
			if (!in_array(trim($allDataInSheet[$d]["B"]), ['OFFLINE', 'ONLINE'])) {
				$msg = "Invalid Source - Row#".$d;
				GOTO ERROR;										
			}
			
		
			/*==CHECK STOCK TYPE AND STOCK SUB TYPE==*/
			
			$stockType=strtoupper(trim($allDataInSheet[$d]["K"]));
			
			$stockSubType=strtoupper(trim($allDataInSheet[$d]["L"]));
			
			if($stockType=='PREXO')
			{
				if($stockSubType=='DAMAGE' || $stockSubType=='AOS' || $stockSubType=='OK' || $stockSubType=='GRADED' || $stockSubType=='AMAZON-BULK')
				{	
				}
				else
				{
					$msg = "PREXO-Invalid Stock Subtype - Row#".$d;
					GOTO ERROR;
				}
			}
			elseif($stockType=='OPEN BOX')
			{
				if($stockSubType!='NTF' && $stockSubType!='CX' && $stockSubType!='TF')
				{	
					$msg = "OpenBox-Invalid Stock Subtype - Row#".$d;
					GOTO ERROR;
				}
			}
			elseif($stockType=='BRAND REFURBISHED')
			{
				if($stockSubType!='NTF')
				{
					$error++;
					$msg = "BRAND REFURBISHED-Invalid Stock Subtype - Row#".$d;
					GOTO ERROR;
				}
			}
			elseif($stockType=='BUY BACK')
			{
				if($stockSubType!='GOOD' && $stockSubType!='DAMAGE' && $stockSubType!='DEAD')
				{
					$error++;
					$msg = "Buy Back -Invalid Stock Subtype - Row#".$d;
					GOTO ERROR;
				}
			}
			
			
			/*==CHECK UNIT PRICE==*/
				
			if(trim($allDataInSheet[$d]["I"])=='')
			{	
				$error++;				
				$msg = "Invalid Unit Price - Row#".$d;
				GOTO ERROR;
			} 	
			
			/*==CHECK INVOICE NO==*/
				
			if(trim($allDataInSheet[$d]["N"])=='')
			{	
				$error++;	
				$msg = "Invalid Invoice Number - Row#".$d;
				GOTO ERROR;						
			} 
			
			
			/*==CHECK INVOICE DATE==*/
				
			if(trim($allDataInSheet[$d]["O"])=='')
			{	
				$error++;				
				$msg = "Invalid Invoice Date - Row#".$d;
				GOTO ERROR;
			}
			
			/*==CHECK TAX TYPE==*/
				
			if(trim($allDataInSheet[$d]["P"])!='GST')
			{	
				$error++;			
				$msg = "Invalid Tax Type - Row#".$d;
				GOTO ERROR;							
			} 
			
			/*==CHECK TAX ==*/
				
			if(trim($allDataInSheet[$d]["J"])=='' || (trim($allDataInSheet[$d]["J"])!='0' && trim($allDataInSheet[$d]["J"])!='12' && trim($allDataInSheet[$d]["J"])!='18'))
			{	
				$error++;		
				$msg = "Invalid Tax % - Row#".$d;
				GOTO ERROR;					
			} 
			
			
			/*==CHECK INVOICE TYPE ==*/
			
			$invoiceType=strtoupper(trim($allDataInSheet[$d]["M"]));
			if(in_array($stockType, TAXABLE_CATEGORY)){
				if($invoiceType!='TAXABLE')
				{	
					$error++;
					$msg = "Invalid Tax Type - Row#".$d;
					GOTO ERROR;
				} 
			}else if(in_array($stockType, EXEMPT_CATEGORY)){
				if($invoiceType!='EXEMPT')
				{	
					$error++;
					$msg = "Invalid Tax Type - Row#".$d;
					GOTO ERROR;
				} 
			}else{
				$error++;
				$msg = "Invalid Category - Row#".$d;
				GOTO ERROR;
			}

			if(empty(trim($allDataInSheet[$d]["X"]))){
				$msg="Invalid BIN NUMBER For Row#".$d;	
				$error++;
				GOTO ERROR;
			}
		}

		return [
			'status' => true,
			'message' => ''
		];

		ERROR:
		return [
			'status' => false,
			'message' => isset($msg)? $msg : "Unable to perform your request"
		];
	}
	
	/** 
	 * Optimised "INWARD Devices" Upload functionality 
	 */
	public function upload_Inward_Devices() {
		$allOrderResult=array();
		$allGrnResult = array();
			
		if (!isset($_FILES["excel_file"])) {
			$msg="NO FILE SELECTED. PLEASE TRY AGAIN";
			GOTO ERROR;
		}	
		$file_extension = pathinfo($_FILES["excel_file"]["name"], PATHINFO_EXTENSION);
		if ($file_extension != "xlsx") {	
			$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.";  
			GOTO ERROR;
		}
		
		/** === Uploading the File to respective path === */

		$upload_File_Path = './assets/upload/';

		$this->load->library('upload');

		$config['file_name'] = 'inward_' . date('YmdHis') . '_' . rand(1111,9999);
		$config['upload_path']   = $upload_File_Path;
		$config['allowed_types'] = 'xlsx';
		$config['max_size']      = 8000;
		
		$this->upload->initialize($config);
		$upload_status = $this->upload->do_upload('excel_file');

		if (!$upload_status) {
			$msg = $this->upload->display_errors('<p>', '</p>');
			GOTO ERROR;
		}
		$uploaded_data = $this->upload->data();
					
		$uploaded_File_Path =  $upload_File_Path . $uploaded_data['file_name'];
		
		
		/** === Extracting the Excel Data to 2 Dimentional Array === */

		require_once 'assets/ExcelClasses/PHPExcel.php';
		include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
		
		$objPHPExcel = PHPExcel_IOFactory::load($uploaded_File_Path);
		//var_dump($objPHPExcel->getActiveSheet()->getStyle('O:O')->getNumberFormat());

		$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
		$arrayCount = count($allDataInSheet);
		// echo json_encode($allDataInSheet);exit;
		

		/** === Fetching Input Request Data === */
		
		$location = $this->input->post('warehousList');
		$batch_no = $this->input->post('batch_no');
		$post_stock_type = $this->input->post('stock_type');
		$module_type = $this->input->post('module_type');
		if($location == 'HYD' || empty($location)) {
			$location = 'HYDERABAD';
		}		
		$loc = 'HYD';
	

		/** === START:: Old - VALIDATAIONS (Removed few things especially DB calls) === */

		$old_validations = $this->InwardDevices_OldValidations($allDataInSheet);

		if (!$old_validations['status']) {
			$msg = $old_validations['message'];
			GOTO ERROR;
		}
		
		/** === END:: Old - VALIDATAIONS (Removed few things especially DB calls) === */


		/** 
		 * ====================== START:: New - VALIDATAIONS (OUTSIDE LOOP) ====================== 
		 * ==============================  AND PROCESSING OF DATA ==============================
		 */


		/** To Fetch the list of few columns for validations */
		$gatepass_arr = [];
		$procur_grade_arr = [];
		$device_names_arr = [];
		$vendor_device_ids_arr = [];
		foreach($allDataInSheet as $i => $inward_row) {
			if ($i > 1) {
				
				/** Gate Pass */
				if (trim($inward_row['S']) == '') {
					$msg = 'Invalid Gate Pass at row: ' . $i;
					GOTO ERROR;
				}
				if (!in_array(trim($inward_row['S']), $gatepass_arr)) {
					$gatepass_arr[] = trim($inward_row['S']);
				}
				
				/** Procurement Grade */
				if (trim($inward_row['Y']) == '') {
					$msg = 'Invalid Procurement Grade at row: ' . $i;
					GOTO ERROR;
				}
				if (!in_array(trim($inward_row['Y']), $procur_grade_arr)) {
					$procur_grade_arr[] = trim($inward_row['Y']);
				}

				/** Device Names */
				if (!in_array(trim($inward_row['Z']), $device_names_arr)) {
					$device_names_arr[] = trim($inward_row['Z']);
				}

				/** Vendor Device ID */
				if (trim($inward_row['Q']) == '') {
					$msg = 'Invalid Vendor Device ID at row: ' . $i;
					GOTO ERROR;
				}
				if (!in_array(trim($inward_row['Q']), $vendor_device_ids_arr)) {
					$vendor_device_ids_arr[] = trim($inward_row['Q']);
				} else {
					$msg = 'Duplicate Vendor Device ID at row: ' . $i;
					GOTO ERROR;
				}
			}
		}
		
		/** GatePass Validity */
		$rs = $this->db->where_in('gatepass_uniqueno', $gatepass_arr)->select('gatepass_uniqueno')->get('tbl_security_admin')->result_Object();
		$existing_gatepass_arr = [];
		foreach($rs as $obj) {
			$existing_gatepass_arr[] = $obj->gatepass_uniqueno;
		}
		$non_exist_gatepass_arr = array_diff($gatepass_arr, $existing_gatepass_arr);
		if (count($non_exist_gatepass_arr) > 0) {
			$msg = 'Invalid GatePass(s) Found: ' . implode(',', $non_exist_gatepass_arr);
			GOTO ERROR;
		}
		
		/** Procurement Grade Validity */
		$rs = $this->db->where('type', 'PROCUREMENT')->select('grade')->get('tbl_grade')->result_Object();
		$existing_p_grade_arr = [];
		foreach($rs as $obj) {
			$existing_p_grade_arr[] = $obj->grade;
		}
		$non_exist_p_grade_arr = array_diff($procur_grade_arr, $existing_p_grade_arr);
		if (count($non_exist_p_grade_arr) > 0) {
			$msg = 'Invalid Procurement Grade(s) Found: ' . implode(',', $non_exist_p_grade_arr);
			GOTO ERROR;
		}

		
		/** Fetching UnitPrices at once from the tbl_prexo_ratecard table */
		$rs = $this->db->where_in('model_name', $device_names_arr)->get('tbl_prexo_ratecard')->result_Object();
		$price_card_arr = [];
		foreach($rs as $price_card) {
			$price_card_arr[$price_card->model_name] = $price_card;
		}
		
		/** To check Existence of VENDOR DEVICE IDs in "tbl_grnreport" table */
		$rs_othervendor_id = $this->db->where_in('othervendor_id', $vendor_device_ids_arr)->select('othervendor_id')->get('tbl_grnreport')->result_Object();
		$othervendor_id_arr = [];
		foreach($rs_othervendor_id as $obj) {
			$othervendor_id_arr[] = $obj->othervendor_id;
		}
		if (count($othervendor_id_arr) > 0) {
			if (count($othervendor_id_arr) > 10) {
				$msg = 'Most of the Vendor Device IDs already exist. One of them is :'. $othervendor_id_arr[0];
			} else {
				$msg = implode(',', $othervendor_id_arr) . ' these Vendor Device IDs already exist';
			}
			GOTO ERROR;
		}
				
		/** 
		 * ====================== END:: New - VALIDATAIONS (OUTSIDE LOOP) ====================== 
		 * ==============================  AND PROCESSING OF DATA ==============================
		 */



		/** === Get Max GRN_Report_ID === */
		$max_id = $this->db->select('MAX(grnreport_id) as max_id')->get('tbl_grnreport')->row()->max_id;
		$new_grn_id = isset($max_id)? (int) $max_id + 1 : 1;
		
		
		/** To Fetch the list of Color Codes at once */
		$ColorCodes_List = $this->Common_model->getColorCodes_List();
		$DeviceRAM_List = $this->Common_model->getDeviceMemory_List_for('RAM');
		$DeviceROM_List = $this->Common_model->getDeviceMemory_List_for('ROM');
		
		$ColorCodes_List = array_change_key_case($ColorCodes_List, CASE_LOWER);

		/** Defining the arrays to store respective info 
		 * to avoid duplicate DB calls if info already got fetched. */
		$vendor_comp_arr = [];
		$invoice_date_arr = [];
		$Model_IDs_arr = [];
		
		
		/** =========
		 * By the time I reviewed this code, INSERT query for $allOrderResult array into "tbl_bulkorder" table (at the End of this Function) is commented. 
		 * So, I commented following $allOrderResult array and also Fetching of $createOrderRefNo DB Call
		 * As it is of no use of declaring these things.
		 =========*/

		// $createOrderRefNo = $this->Common_model->createOrderRefId();

		for($i = 2; $i <= $arrayCount; $i++) {

			// $allOrderResult[] = array(
			// 	'uploadorder_userid'=>$this->session->userdata('user_id'),
			// 	'order_refno'=>$createOrderRefNo,
			// 	'location'=>$this->input->post('location'),
			// 	'invoice_type'=>trim($allDataInSheet[$i]["M"]),
			// 	'vendor_id'=>trim($allDataInSheet[$i]["A"]),
			// 	'source'=>trim($allDataInSheet[$i]["B"]),
			// 	'nhmod'=>trim($allDataInSheet[$i]["C"]),
			// 	'imei1'=>trim($allDataInSheet[$i]["G"]),
			// 	'imei2'=>trim($allDataInSheet[$i]["H"]),
			// 	'unit_price'=>trim($allDataInSheet[$i]["I"]),
			// 	'tax'=>trim($allDataInSheet[$i]["J"]),
			// 	'stock_type'=>trim($allDataInSheet[$i]["K"]),
			// 	'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
			// 	'invoice_no'=>trim($allDataInSheet[$i]["N"]),
			// 	'invoice_date'=>date("Y-m-d", strtotime(trim($allDataInSheet[$i]["O"]))),
			// 	'tax_type'=>trim($allDataInSheet[$i]["P"]),
			// 	'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
			// 	'lot_number'=>trim($allDataInSheet[$i]["R"]),
			// 	'nhdp'=>'0',
			// 	'insert_by'=>'Excel',
			// );
			
					
			
			/** 
			 * =========== START:: New - VALIDATAIONS (INSIDE LOOP) =========== 
			 * ===================  AND PROCESSING OF DATA ===================
			 */


			/** === Get vendor Company Details === */
			$vendor_id = trim($allDataInSheet[$i]["A"]);

			if (!isset($vendor_comp_arr[$vendor_id])) {
				$vendor_comp_arr[$vendor_id] = $this->db->where('vendor_code', $vendor_id)->select('company')->get('tbl_vendor')->row()->company;
			}
			if (!isset($vendor_comp_arr[$vendor_id])) {
				$msg = 'Invalid Supplier at row: ' . $i;
				GOTO ERROR;
			}
			// $vendorState = $this->Common_model->getVendorStateFormVendorCode($vendor_id);

			
			/** === Get Invoice Date === */
			$invoice_no = trim($allDataInSheet[$i]["N"]);
			
			if (!isset($invoice_date_arr[$invoice_no])) {
				$invoice_date_arr[$invoice_no] = $this->db->select('invoice_date')->where('invoice_no', $invoice_no)->get('tbl_security_admin')->row()->invoice_date;
			}
			if (!isset($invoice_date_arr[$invoice_no])) {
				$msg = 'Invalid Invoice No. at row: ' . $i;
				GOTO ERROR;
			}

			
			/** === Get Device Model Info. === */
			$model_id = trim($allDataInSheet[$i]["C"]);
			
			if (!isset($Model_IDs_arr[$model_id])) {
				$Model_IDs_arr[$model_id] = $this->db->select('tbl_device_type.name as typeName,tbl_device_type.type_id,tbl_device_type.nhdin_ext,tbl_device_brand.name as brandName,tbl_product_details.product_name')
										->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')
										->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')
										->where('tbl_product_details.nhmod', $model_id)
										->get('tbl_product_details')
										->row_array();
			}
			$productResult = $Model_IDs_arr[$model_id];

			if (!isset($productResult)) {
				$msg = "Please check Product Model at row: " . $i;
				GOTO ERROR;
			}
			// $deviceName='';$typeName='';$brandName='';$typeId=0;$nhdinExt='A';
			
			$deviceName = $productResult['product_name'];
			$typeName = $productResult['typeName'];
			$typeId = $productResult['type_id'];
			$brandName = $productResult['brandName'];
			$nhdinExt = $productResult['nhdin_ext'];
				
			if(trim($allDataInSheet[$i]["G"]) != 'NA') { 
				$imei1_value = preg_replace('/[^0-9]/', '', trim($allDataInSheet[$i]["G"]));
				
				if(strlen($imei1_value) < 15 && $productResult['type_id'] == 2) {
					$msg = "Invalid IMEI Length at row:" . $i;
					GOTO ERROR;
				}	
			}
		
			/** === GENERATE nhdin for new device === */
			
			// $mode = strtoupper(trim($allDataInSheet[$i]["K"]));
			// $stockSubType = trim($allDataInSheet[$i]["L"]);
			// $orderId = $this->Common_model->getOrderIdForNHDIN($mode,$stockSubType);

			$orderId = null; // getNHDIN() function not using ORDER_ID anymore. Developer who worked on this function didn't remove this parameter.
			$nhdin = $this->Common_model->getNHDIN($orderId, $new_grn_id, $model_id, $loc, $nhdinExt);
			

			/** === Generating SKU === */

			$color = trim($allDataInSheet[$i]["F"]);
			$ram = trim($allDataInSheet[$i]["D"]);
			$rom = trim($allDataInSheet[$i]["E"]); 
			
			if (!isset($ColorCodes_List[strtolower($color)])) {
				$msg = "Invalid Color at row: " . $i;
				GOTO ERROR;
			}
			if (!in_array($ram, $DeviceRAM_List)) {
				$msg = 'Invalid RAM at row: ' . $i;
				GOTO ERROR;
			}
			if (!in_array($rom, $DeviceROM_List)) {
				$msg = 'Invalid ROM at row: ' . $i;
				GOTO ERROR;
			}

			$color_code = $ColorCodes_List[strtolower($color)];
			$sku = $this->Common_model->getSKU($model_id,$ram,$rom,$color, $color_code);

			
			/** === Box-Adapter-Charger Availability === */
			
			$bac = trim($allDataInSheet[$i]["T"]).'-'.trim($allDataInSheet[$i]["U"]).'-'.trim($allDataInSheet[$i]["V"]);						
			
			
			/** === Setting Unit Price based on Type of Device === */

			$unit_price = trim($allDataInSheet[$i]["I"]);
			$procurement_grade = trim($allDataInSheet[$i]["Y"]); 
			$device_name = trim($allDataInSheet[$i]["Z"]);
			$stock_type = trim($allDataInSheet[$i]["K"]);

			if ($post_stock_type == "PREXO") {
				if($post_stock_type != $stock_type){
					$msg = 'This is not PREXO device at row: ' . $i;
					GOTO ERROR;
				}
				$is_p2p = "YES";
				$device_sub_category = "ASIS";
				
			} elseif($post_stock_type == "BUYBACK"){
				if($post_stock_type != $stock_type){
					$msg = 'This is not BUYBACK device at row: ' . $i;
					GOTO ERROR;
				}
				$is_p2p = "NO";
				$device_sub_category = "ASIS";
			}else{
				$is_p2p = "NO";
				$device_sub_category = "STANDARD";
			}

			if(strtoupper($stock_type) == 'PREXO' && isset($price_card_arr[$device_name])){
				if(in_array(strtolower($procurement_grade), ['b', 'c', 'd'])) {
					$unit_price = $price_card_arr[$device_name]->{ strtolower($procurement_grade) . '_grade'};
				}
			}
				
			
			/** 
			 * =============== Preparing Array for GRN REPORT =============== 
			 */

			$device_condition = null;
			if (isset($allDataInSheet[$i]["AA"]) && (trim($allDataInSheet[$i]["AA"]) != 'NA')) {
				$device_condition = trim($allDataInSheet[$i]["AA"]);
			}

			$grnResult = array(
				'uploadorder_userid'=>$this->session->userdata('user_id'),
				// 'order_refno'=>$createOrderRefNo,
				'vendor_code'=>trim($allDataInSheet[$i]["A"]),
				'purchase_source'=>trim($allDataInSheet[$i]["B"]),
				'invoice_date'=> $invoice_date_arr[$invoice_no],
				'invoice_no'=>trim($allDataInSheet[$i]["N"]),
				'invoice_type'=>trim($allDataInSheet[$i]["M"]),
				'vendor_name'=> $vendor_comp_arr[$vendor_id],
				'nhdin'=>$nhdin['kdin'],
				'product_type'=>$typeName,
				'product_brand'=>$brandName,
				'device_name'=>$deviceName,
				'nhmod'=>$model_id,
				'imei1_no'=>trim($allDataInSheet[$i]["G"]),
				'imei2_no'=>trim($allDataInSheet[$i]["H"]),
				'unit_price'=>$unit_price,
				'tax'=>trim($allDataInSheet[$i]["J"]),
				'tax_type'=>trim($allDataInSheet[$i]["P"]),
				'nhpp'=>trim($allDataInSheet[$i]["I"]), 
				'nhdp'=>'0', 
				'stock_type'=> $stock_type,
				'device_sub_category'=> $device_sub_category,
				'is_p2p'=> $is_p2p,
				'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
				'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
				'lot_number'=>trim($allDataInSheet[$i]["R"]),
				'batch_no' =>trim($batch_no),
				'color'=>$color,
				'ram'=>$ram,
				'rom'=>$rom,							
				'entrypass_no'=>trim($allDataInSheet[$i]["S"]),
				'remark'=>trim($allDataInSheet[$i]["W"]),
				'bin_number'=>trim($allDataInSheet[$i]["X"]),
				'certification_grade'=>trim($allDataInSheet[$i]["Y"]),							
				'procurement_grade'=>$procurement_grade,
				'warehouse'=>$location,
				'vendor_device_name' => $device_name,
				'sku'=>$sku,
				'bac'=>$bac,
				'module_type'=> $module_type,
				'device_condition' => $device_condition
			);
			
			if ($module_type == 2) {
				$grnResult['saletype'] = 'EXPORT';  // By Default SaleType is "OFFLINE"
			}
			
			$allGrnResult[] = $grnResult;
			
			$new_grn_id++;
		}
		// echo json_encode($allGrnResult);exit;

		if(count($allGrnResult) == 0) {
			$msg = "Please fill Excel File";
			GOTO ERROR;
		}

		// if(!empty($allOrderResult)) {
			//$this->db->insert_batch('tbl_bulkorder',$allOrderResult);
		// }

		$this->db->insert_batch('tbl_grnreport', $allGrnResult);
		if ($this->db->error()['code'] != 0) { GOTO ERROR; }
		
		unlink($uploaded_File_Path);

		
		/** RESPONSE - SUCCESS */
		$type="success";
		$msg="INWARD done Successfully";
		$this->session->set_userdata($type, $msg);  
		header("location:".$_SERVER['HTTP_REFERER']);
		exit;


		/** RESPONSE - ERROR */
		ERROR:
		// unlink($uploaded_File_Path);
		$type="error";
		$message = isset($msg)? $msg : "Unable to perform your request";
		$this->session->set_userdata($type, $message);  
		header("location:".$_SERVER['HTTP_REFERER']);
	}

	public function getColorList()
	{
		$result = $this->db->get('tbl_colorcode')->result_array();

		foreach($result as $rowValue)
		{
			$records[] = array(
							"color" => $rowValue['color'],
							"color_group" => $rowValue['color_group'],
							"color_code" => $rowValue['color_code'],
					);
		}

		$json['data'] = $records;
		echo json_encode($json);
		exit;
	}

	public function getColorGroupCode()
	{
		$result = $this->db->group_by('color_group')->get('tbl_colorcode')->result_array();

		foreach($result as $rowValue){

			$records[] = array(
							"color_group_code" => $rowValue['color_group'].'-'.$rowValue['color_code']
					);
		}

		$json['result'] = $records;
		echo json_encode($json);
		exit;
	}

	public function addNewColor()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data) || empty($data['color'])){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$color_group_arr = explode('-', $data['color_group']);
		$color_group = $color_group_arr[0];
		$color_code = $color_group_arr[1];

		if(empty($color_group) || empty($color_code)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$record = array(
					"color" => strtoupper($data['color']),
					"color_group" => strtoupper($color_group),
					"color_code" => strtoupper($color_code),
				);
		$rows = $this->db->where('color', $data['color'])->get('tbl_colorcode')->num_rows();

		if($rows > 0){
			$json['status'] = 2;
			echo json_encode($json);
			exit;
		}

		$this->db->insert('tbl_colorcode', $record);
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}

	public function addNewMemory()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data) || empty($data['memory_type']) || empty($data['memory_value'])){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		if(strpos($data['memory_value'], ' ') !== false || strpos($data['memory_value'], '.0') !== false){
			$json['status'] = 3;
			echo json_encode($json);
			exit;
		}

		$record = array(
					"type" => strtoupper($data['memory_type']),
					"value" => strtoupper($data['memory_value']),
				);

		$rows = $this->db->where($record)->get('tbl_device_memory')->num_rows();

		if($rows > 0){
			$json['status'] = 2;
			echo json_encode($json);
			exit;
		}

		$this->db->insert('tbl_device_memory', $record);
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}
	
	public function uploadOrderByExcelNEW()
	{
		$invalidVendorCode=array();$duplicateImei=array();$duplicateVendorId=array();$allOrderResult=array();$allGrnResult=array();
		
		//$filesetcheck = isset($_FILES["excel_file"]);
			
		if (true) 
		{ 
			/*
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx") 
			{ 
		
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.";  
			}
			else
			{ 
		    */
				require_once 'assets/ExcelClasses/PHPExcel.php';
				/*
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				*/
			/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
			
				$inputFileName =  './assets/upload/excel_file6331.xlsx';
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				//var_dump($objPHPExcel->getActiveSheet()->getStyle('O:O')->getNumberFormat());

				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		
		
					
				/*===GET ORDER REF. NO===*/
					
					
				$createOrderRefNo=$this->Common_model->createOrderRefId();
					
				/*===GET NHDIN WORK===*/
					 
				$location=$this->input->post('warehousList');

				if($location == 'HYD' || empty($location)){
					$location = 'HYDERABAD';
				}
				
				$batch_no = $this->input->post('batch_no');
					 
				$loc='HYD';
			
				/*==check vendor code exise in datatbase==*/
					
				$error=0; 
					
				for($d=2;$d<=$arrayCount;$d++)
				{ 
					
					$vendorCodeResult=$this->db->where('vendor_code',trim($allDataInSheet[$d]["A"]))->get('tbl_vendor')->row();
					
					$nhmodResult=$this->db->where('nhmod',trim($allDataInSheet[$d]["C"]))->get('tbl_product_details')->row();
										
					/*== CHECK VENDOR CODE ==*/
					if(empty($vendorCodeResult))
					{
						$error++;
						$msg = "Invalid Vendor Code - Row#".$d;
						break;
					} 
					
					if(empty($nhmodResult))
					{
					    $error++;
						$msg = "Invalid Device Model - Row#".$d;
						break;				
					}
									
					
					/*==CHECK SOURCE==*/
						
					if(trim($allDataInSheet[$d]["B"])=='OFFLINE' || trim($allDataInSheet[$d]["B"])=='ONLINE')
					{
											
					}
					else {
						$error++;
						$msg = "Invalid Source - Row#".$d;
						break;											
					}
					
					
					// CHECK MODEL ID
					 
					$nhmodResult=$this->Common_model->getRowResult('product_id','tbl_product_details',array('nhmod'=>trim($allDataInSheet[$d]["C"]),'nhmod !='=>''));
					 
					if(empty($nhmodResult))
					{
						$error++;
						$msg = "Invalid Device Model 2 - Row#".$d;
						break;	
					}
					
					// CHECK OTHER VENDOR ID
					
					$otherVendorRsult=$this->Common_model->getRowResult('grnreport_id','tbl_grnreport',array('othervendor_id'=>trim($allDataInSheet[$d]["Q"])));
					
					if(!empty($otherVendorRsult))
					{
						$error++;
						$msg = "Invalid Vendor Device Id - Row#".$d;
						break;	
					}
		
					// check duplicate other vendor id
			 
					if(trim($allDataInSheet[$d]["Q"])=='')
					{
						$error++;
						$msg = "Empty Vendor Device Id - Row#".$d;
						break;
					}
					else
					{
						/*==CHECK DUPLICATE  OTHER VENDOR ID==*/
						
						if(in_array(trim($allDataInSheet[$d]["Q"]),$duplicateVendorId))
						{
							$error++;
							$msg = "Duplicate Vendor Device Id - Row#".$d;
							break;
						}
						else
						{							
							$duplicateVendorId[]=trim($allDataInSheet[$d]["Q"]);								
						}	
					}
				
					/*==CHECK STOCK TYPE AND STOCK SUB TYPE==*/
						
					$stockType='';$stockSubType='';
					
					$stockType=strtoupper(trim($allDataInSheet[$d]["K"]));
					
					$stockSubType=strtoupper(trim($allDataInSheet[$d]["L"]));
					
					if($stockType=='PREXO')
					{
						if($stockSubType=='DAMAGE' || $stockSubType=='AOS' || $stockSubType=='OK' || $stockSubType=='GRADED' || $stockSubType=='AMAZON-BULK')
						{	
						}
						else
						{
							$error++;
							$msg = "PREXO-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='OPEN BOX')
					{
						if($stockSubType!='NTF' && $stockSubType!='CX' && $stockSubType!='TF')
						{	
							$error++;
							$msg = "OpenBox-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='BRAND REFURBISHED')
					{
						if($stockSubType!='NTF')
						{
							$error++;
							$msg = "BRAND REFURBISHED-Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					elseif($stockType=='BUY BACK')
					{
						if($stockSubType!='GOOD' && $stockSubType!='DAMAGE' && $stockSubType!='DEAD')
						{
							$error++;
						    $msg = "Buy Back -Invalid Stock Subtype - Row#".$d;
							break;
						}
					}
					else
					{
						// $error++;
					}	
					
					/*===CHECK IMEI NO==*/
				
					if(trim($allDataInSheet[$d]["G"])!='')
					{ 
							$value=preg_replace('/[^0-9]/', '', trim($allDataInSheet[$d]["G"]));
							
							$imeiLength=strlen($value);
							
							if($imeiLength < 15 && $nhmodResult->type_id == 2)
							{
								$error++;
								$msg = "Invalid IMEI Length - Row#".$d;
								break;
							}
							else
							{
								/*==check duplicate imei no with datatbase===*/
								
								// $imeiResult=array();
								
								// $imeiResult=$this->db->where('imei1',$allDataInSheet[$d]["D"])->get('tbl_bulkorder')->row();
								
								// if(!empty($imeiResult))
								// {
									// $error++;
								// }
							}
							
							
							/*==CHECK DUPLICATE EXCEL IMEI NO==*/
						
							// if(in_array(trim($allDataInSheet[$d]["D"]),$duplicateImei))
							// {
								// $error++;
							// }
							// else
							// {							
								// $duplicateImei[]=trim($allDataInSheet[$d]["D"]);								
							// }	
							
					}
					else
					{
						// $error++;
					}	
					
					/*==CHECK UNIT PRICE==*/
						
					if(trim($allDataInSheet[$d]["I"])=='')
					{	
						$error++;				
						$msg = "Invalid Unit Price - Row#".$d;
						break;
					} 	
					
					/*==CHECK INVOICE NO==*/
						
					if(trim($allDataInSheet[$d]["N"])=='')
					{	
						$error++;	
						$msg = "Invalid Invoice Number - Row#".$d;
						break;						
					} 
					
					
					/*==CHECK INVOICE DATE==*/
						
					if(trim($allDataInSheet[$d]["O"])=='')
					{	
						$error++;				
						$msg = "Invalid Invoice Date - Row#".$d;
						break;
					}
					
					/*==CHECK TAX TYPE==*/
						
					if(trim($allDataInSheet[$d]["P"])!='GST')
					{	
						$error++;			
						$msg = "Invalid Tax Type - Row#".$d;
						break;							
					} 
					
					/*==CHECK TAX ==*/
						
					if(trim($allDataInSheet[$d]["J"])=='' || (trim($allDataInSheet[$d]["J"])!='0' && trim($allDataInSheet[$d]["J"])!='12' && trim($allDataInSheet[$d]["J"])!='18'))
					{	
						$error++;		
						$msg = "Invalid Tax % - Row#".$d;
						break;					
					} 
					
					
					/*==CHECK INVOICE TYPE ==*/
					$invoiceType='';
					
					
					$invoiceType=strtoupper(trim($allDataInSheet[$d]["M"]));
					if(in_array($stockType, TAXABLE_CATEGORY)){
						if($invoiceType!='TAXABLE')
						{	
							$error++;
							$msg = "Invalid Tax Type - Row#".$d;
							break;
						} 
					}else if(in_array($stockType, EXEMPT_CATEGORY)){
						if($invoiceType!='EXEMPT')
						{	
							$error++;
							$msg = "Invalid Tax Type - Row#".$d;
							break;
						} 
					}else{
						$error++;
						$msg = "Invalid Category - Row#".$d;
						break;
					}
					
					
					// chk gatepass no
				
					$gatePassResult=$this->Common_model->getRowResult('admin_id','tbl_security_admin',array('gatepass_uniqueno'=>trim($allDataInSheet[$d]["S"])));
					
					if(empty($gatePassResult))
					{
						$error++;
						$msg = "Invalid Entrypass - Row#".$d;	
						break;
						
					} 
					
					$pr_grade = trim($allDataInSheet[$d]["Y"]); 
					$grade_result = $this->db->where(array('grade'=>trim($pr_grade),'type'=>'PROCUREMENT'))->get('tbl_grade')->row();
					if(empty($grade_result)){
						$msg="Invalid Procurement Grade - Row#".$d;	
					   	$error++;
						   break;
					}

					$rows = $this->db->where('color', trim($allDataInSheet[$d]["F"]))->get('tbl_colorcode')->num_rows();

					if($rows <= 0){
						$msg="Invalid Color ".$allDataInSheet[$d]["F"];	
					   	$error++;
						   break;
					}

					$grade_result = $this->db->where(array('value'=>trim($allDataInSheet[$d]["D"]),'type'=>'RAM'))->get('tbl_device_memory')->row();
					if(empty($grade_result)){
						$msg="Invalid RAM - #".$allDataInSheet[$d]["D"];	
					   	$error++;
						   break;
					}

					$grade_result = $this->db->where(array('value'=>trim($allDataInSheet[$d]["E"]),'type'=>'ROM'))->get('tbl_device_memory')->row();
					if(empty($grade_result)){
						$msg="Invalid ROM - #".$allDataInSheet[$d]["E"];	
					   	$error++;
						   break;
					}

					if(empty(trim($allDataInSheet[$d]["X"]))){
						$msg="Invalid BIN NUMBER For Row#".$d;	
						$error++;
						break;
					}
				} 
	
				if($error=='0')
				{
					/*===create order id===*/
				   
					$maxId=$this->db->select('MAX(grnreport_id) as grnreport_id')->get('tbl_grnreport')->row_array();
					
					/*if((int)$maxId['grnreport_id']<=24399)
					{
						$j='24399';
					}
					else
					{
						$j=(int)$maxId['grnreport_id'];
					}*/
					
					$j=(int)$maxId['grnreport_id'];
					$j=$j+1;
					
					for($i=2;$i<=$arrayCount;$i++)
					{ 
						$orderResult=array(
							'uploadorder_userid'=>$this->session->userdata('user_id'),
							'order_refno'=>$createOrderRefNo,
							'location'=>$this->input->post('location'),
							'invoice_type'=>trim($allDataInSheet[$i]["M"]),
							'vendor_id'=>trim($allDataInSheet[$i]["A"]),
							'source'=>trim($allDataInSheet[$i]["B"]),
							'nhmod'=>trim($allDataInSheet[$i]["C"]),
							'imei1'=>trim($allDataInSheet[$i]["G"]),
							'imei2'=>trim($allDataInSheet[$i]["H"]),
							'unit_price'=>trim($allDataInSheet[$i]["I"]),
							'tax'=>trim($allDataInSheet[$i]["J"]),
							'stock_type'=>trim($allDataInSheet[$i]["K"]),
							'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
							'invoice_no'=>trim($allDataInSheet[$i]["N"]),
							'invoice_date'=>date("Y-m-d", strtotime(trim($allDataInSheet[$i]["O"]))),
							'tax_type'=>trim($allDataInSheet[$i]["P"]),
							'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
							'lot_number'=>trim($allDataInSheet[$i]["R"]),
							'nhdp'=>'0',
							'insert_by'=>'Excel',
						);
						
						$allOrderResult[]=$orderResult;
															 
						/*==Insert data in tbl_grnreport for create GRN REPORT===*/
					
						/*==Get vendor Name===*/
						$vendorCompany='';$vendorState='';
						
						$vendorCompany=$this->Common_model->getVendorCompanyNameFormVendorCode($orderResult['vendor_id']);
										
						$vendorState=$this->Common_model->getVendorStateFormVendorCode($orderResult['vendor_id']);
						 
						$mode=strtoupper(trim($allDataInSheet[$i]["K"]));
					 
						$stockSubType=trim($allDataInSheet[$i]["L"]);
										
						$orderId=$this->Common_model->getOrderIdForNHDIN($mode,$stockSubType);
					 
						$invoice_date = $this->db->select('invoice_date')->where('invoice_no', trim($allDataInSheet[$i]["N"]))->get('tbl_security_admin')->row()->invoice_date;
					
						$invoiceDate=trim($allDataInSheet[$i]["O"]);
						
						$productResult=$this->db->select('tbl_device_type.name as typeName,tbl_device_type.type_id,tbl_device_type.nhdin_ext,tbl_device_brand.name as brandName,tbl_product_details.product_name')->where('tbl_product_details.nhmod',$orderResult['nhmod'])->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')->get('tbl_product_details')->row_array();
					

						$deviceName='';$typeName='';$brandName='';$typeId=0;$nhdinExt='A';
						
						if(!empty($productResult))
						{
							$deviceName=$productResult['product_name'];
							
							$typeName=$productResult['typeName'];
							
							$typeId=$productResult['type_id'];
							
							$brandName=$productResult['brandName'];
							
							$nhdinExt=$productResult['nhdin_ext'];
						}
					
						//create nhdin for new device
						
						$nhdin=$this->Common_model->getNHDIN($orderId,$j,trim($allDataInSheet[$i]["C"]),$loc,$nhdinExt);
						
						$modelid = $orderResult['nhmod'];
						$color=trim($allDataInSheet[$i]["F"]);
						$ram=trim($allDataInSheet[$i]["D"]);
						$rom=trim($allDataInSheet[$i]["E"]); 
						
						$sku = $this->Common_model->getSKU($modelid,$ram,$rom,$color); 	
						$procurement_grade = trim($allDataInSheet[$i]["Y"]); 
						
						$bac = trim($allDataInSheet[$i]["T"]).'-'.trim($allDataInSheet[$i]["U"]).'-'.trim($allDataInSheet[$i]["V"]);						
						
						$unit_price = trim($allDataInSheet[$i]["I"]);
						if(strtoupper($allDataInSheet[$i]["K"]) == 'PREXO' && !empty(trim($allDataInSheet[$i]["Z"]))){
							$up = $this->db->where('model_name', trim($allDataInSheet[$i]["Z"]))->get('tbl_prexo_ratecard')->row();
							if(!empty($up)){
								if($procurement_grade == 'B'){
									$unit_price = $up->b_grade;
								}
								if($procurement_grade == 'C'){
									$unit_price = $up->c_grade;
								}
								if($procurement_grade == 'D'){
									$unit_price = $up->d_grade;
								}
							}
						}

						$grnResult=array
						(
						
							'uploadorder_userid'=>$this->session->userdata('user_id'),
							'order_refno'=>$createOrderRefNo,
							'vendor_code'=>trim($allDataInSheet[$i]["A"]),
							'purchase_source'=>trim($allDataInSheet[$i]["B"]),
							'invoice_date'=>$invoice_date,
							'invoice_no'=>trim($allDataInSheet[$i]["N"]),
							'invoice_type'=>trim($allDataInSheet[$i]["M"]),
							'vendor_name'=>$vendorCompany,
							'nhdin'=>$nhdin['kdin'],
							'product_type'=>$typeName,
							'product_brand'=>$brandName,
							'device_name'=>$deviceName,
							'nhmod'=>$modelid,
							'imei1_no'=>trim($allDataInSheet[$i]["G"]),
							'imei2_no'=>trim($allDataInSheet[$i]["H"]),
							'unit_price'=>$unit_price,
							'tax'=>trim($allDataInSheet[$i]["J"]),
							'tax_type'=>trim($allDataInSheet[$i]["P"]),
							'nhpp'=>trim($allDataInSheet[$i]["I"]), 
							'nhdp'=>'0', 
							'stock_type'=>trim($allDataInSheet[$i]["K"]),
							'stock_subtype'=>trim($allDataInSheet[$i]["L"]),
							'othervendor_id'=>trim($allDataInSheet[$i]["Q"]),
							'lot_number'=>trim($allDataInSheet[$i]["R"]),
							'batch_no' =>trim($batch_no),
							'color'=>$color,
							'ram'=>$ram,
							'rom'=>$rom,							
							'entrypass_no'=>trim($allDataInSheet[$i]["S"]),
							'remark'=>trim($allDataInSheet[$i]["W"]),
							'bin_number'=>trim($allDataInSheet[$i]["X"]),
							'certification_grade'=>trim($allDataInSheet[$i]["Y"]),							
							'procurement_grade'=>$procurement_grade,
							'warehouse'=>$location,
							'vendor_device_name' => trim($allDataInSheet[$i]["Z"]),
							'sku'=>$sku,
							'bac'=>$bac
						);
										
						$allGrnResult[]=$grnResult;
						 
						$lastnhmod=$orderResult['nhmod'];
						
						$j++;
					}
			
					if(!empty($allOrderResult))
					{
						//$this->db->insert_batch('tbl_bulkorder',$allOrderResult);
					}
			
					if(!empty($allGrnResult))
					{
						$this->db->insert_batch('tbl_grnreport',$allGrnResult);
					}
					
					unlink($inputFileName);
					
					$type="success";
				
				$msg="INWARD DONE SUCCESSFULLY.";   
				  
				}
				else
				{ 
					 /*===set message==*/
					
					
					$type="error";
				
					$this->session->set_userdata($type,$msg);  
					header("location:".$_SERVER['HTTP_REFERER']);  
					 
				}
			//}
		}
		else 
		{
			
			$type="error";
				
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN."; 
			 
		}
		
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);  
	}
	
	public function bulkRemarkSubmit()
    {
        
        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
       
        $td_data = $data['td_data'];
	$this->db->trans_start();
        foreach ($td_data as $key => $device_data) {
           
		$imei1_no = trim($device_data['remark']);
		//$this->db->where('nhdin',$device_data['device_id'])->update('tbl_grnreport', array("remark" => $device_data['remark']));
		$this->db->where('nhdin',$device_data['device_id'])->update('tbl_grnreport', array("imei1_no" => $imei1_no));
        }
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    public function generateQRCode()
    {
        $base_url = base_url(); ;
        require_once 'application/libraries/phpqrcode/qrlib.php';
        $path = 'uploads/sku_qrcode/';
        $data = json_decode(file_get_contents('php://input'), true);
        $sku = $data['sku'];
        $qrcode = $path.time().".png";
        QRcode::png($sku, $qrcode);
        $result['status']=1;
        $result['qr_code']=$base_url.$qrcode;
	echo json_encode($result); die;
    }

    
}