<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AuditorReports extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('admin_model');
    }

    public function manage_auditor_reports($active = 0)
    {
        $data['title'] = 'Auditor Reports';
        $data['page_header'] = 'Auditor Reports';
        if ($active > 1) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }
        $data['subview'] = $this->load->view('admin/auditor_reports/manage_auditor_reports', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getpandlreport()
    {
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        $where_sales = array(
            'DATE(CREATION_DATE)>=' => $from_date,
            'DATE(CREATION_DATE) <=' => $to_date,
        );
        if ($from_date == '' || $to_date == '') {
            echo "Please select date range";
            exit;
        } else {
            $this->db->where($where_sales);
        }
        $sales = $this->db->where('status !=', 'VOID')->get('INVOICE_PNL_REPORT_VIEW')->result_array();
        $income_month = array();
        $expense_month = array();

        foreach ($sales as $key => $value) {
            $month = date('M', strtotime($value['CREATION_DATE']));
            $year = date('y', strtotime($value['CREATION_DATE']));
            $taxable_amount = $value['taxable_amount'];
            $exempt_amount = $value['exempt_amount'];
            $unit_price = $value['unit_price'];
            $my = $month . '-' . $year;
            //Discount, Freight, Insurance
            if (empty($inv_det[$value['invoice_id']]['disc_fr_ins'])) {
                $inv_det[$value['invoice_id']]['disc_fr_ins'] = ($value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount']) / 1.18;
               // $income_month[$my]['taxable_sales'] += $inv_det[$value['invoice_id']]['disc_fr_ins'];
            }

            $income_month[$my]['taxable_sales'] += $taxable_amount;
            $income_month[$my]['exempt_sales'] += $exempt_amount;
            $income_month[$my]['sale_qty'] += 1;

            $expense_month[$my]['cost'] += $unit_price;
            $expense_month[$my]['cost_qty'] += 1;
        }

        $where_cn = array(
            'DATE(returned_date)>=' => $from_date,
            'DATE(returned_date) <=' => $to_date,
        );
        $this->db->where($where_cn);
        $creditnotes = $this->db->where('status', 'CN_CREATED')->get('CREDITNOTE_ITEM_VIEW')->result_array();
        foreach ($creditnotes as $key => $value) {

            $month = date('M', strtotime($value['returned_date']));
            $year = date('y', strtotime($value['returned_date']));
            $my = $month . '-' . $year;
            $taxable_amount = $value['taxable_amount'];
            $exempt_amount = $value['exempt_amount'];
            $total_amount = $value['price'];
            $unit_price = $value['unit_price'];

            $income_month[$my]['taxable_credit_note'] += $taxable_amount;
            $income_month[$my]['exempt_sales'] -= $exempt_amount;
            $income_month[$my]['cn_quantity'] += 1;
            $expense_month[$my]['cost'] -= $unit_price;
            $expense_month[$my]['cost_qty'] -= 1;
        }

        //Stocktransfer
        $where_st = array(
            'DATE(stocktransfer_date)>=' => $from_date,
            'DATE(stocktransfer_date) <=' => $to_date,
        );
        $this->db->where($where_st);
        $stocktransfers = $this->db->where('status !=', 'CANCELLED')->where('st_type', 'OUTWARD')->get('STN_PNL_REPORT_VIEW')->result_array();

        $stn_cost = 0;
        $stn_qty = 0;
        foreach ($stocktransfers as $key => $value) {
            $unit_price = $value['unit_price'];
            $stn_cost += $unit_price;
            $stn_qty += 1;
        }

        //Stocktransfer
        $this->db->where($where_st);
        $stocktransfers = $this->db->where('status !=', 'CANCELLED')->where('st_type', 'INWARD')->get('STN_PNL_REPORT_VIEW')->result_array();

        $stn_cost = 0;
        $stn_qty = 0;
        foreach ($stocktransfers as $key => $value) {
            $unit_price = $value['unit_price'];
            $stn_cost -= $unit_price;
            $stn_qty -= 1;
        }
        $avg_stn_cost = $stn_cost / $stn_qty;

        $where_fba = array(
            'DATE(sale_date)>=' => $from_date,
            'DATE(sale_date) <=' => $to_date,
        );
        $this->db->where($where_fba);
        $fbas = $this->db->where('status!=', 'CANCELLED')->get('FF_ITEM_VIEW')->result_array();

        foreach ($fbas as $key => $value) {

            if (date('d-m-Y', strtotime($value['source_invoice_date'])) != '01-01-1970') {
                $month = date('M', strtotime($value['source_invoice_date']));
                $year = date('y', strtotime($value['source_invoice_date']));
            } else {
                $month = date('M', strtotime($value['sale_date']));
                $year = date('y', strtotime($value['sale_date']));
            }
            $my = $month . '-' . $year;
            $taxable_amount = $value['taxable_amount'];

            $income_month[$my]['fba_sales'] += $taxable_amount;
            $income_month[$my]['fba_quantity'] += 1;
            $expense_month[$my]['cost'] += $avg_stn_cost;
            $expense_month[$my]['cost_qty'] += 1;
        }

        $where_fb_cn = array(
            'DATE(returned_date)>=' => $from_date,
            'DATE(returned_date) <=' => $to_date,
        );
        $this->db->where($where_fb_cn);
        $fbacns = $this->db->where('status', 'CN_CREATED')->get('FF_ITEM_VIEW')->result_array();
        foreach ($fbacns as $key => $value) {
            $month = date('M', strtotime($value['returned_date']));
            $year = date('y', strtotime($value['returned_date']));
            $my = $month . '-' . $year;
            $taxable_amount = $value['taxable_amount'];

            $income_month[$my]['fba_credit_note'] += $taxable_amount;
            $income_month[$my]['fba_cn_quantity'] += 1;
            $expense_month[$my]['cost'] -= $avg_stn_cost;
            $expense_month[$my]['cost_qty'] -= 1;
        }

        //Spare and Service Sales
        $where_serv = array(
            'DATE(invoice_date)>=' => $from_date,
            'DATE(invoice_date) <=' => $to_date,
        );
        $this->db->where($where_serv);
        $servs = $this->db->where('jobsheet_status', 'INVOICED')->get('INVOICED_SPARE_DATA_VIEW')->result_array();
        foreach ($servs as $key => $value) {
            $month = date('M', strtotime($value['invoice_date']));
            $year = date('y', strtotime($value['invoice_date']));
            $my = $month . '-' . $year;
            $taxable_amount = $value['selling_price'] / 1.18;
            $unit_price = $value['cost_price'];

            $income_month[$my]['service_sales'] += $taxable_amount;
            $income_month[$my]['service_sales_qty'] += 1;
            $expense_month[$my]['spare_cost'] += $unit_price;
        }
        uksort($income_month, function ($a1, $a2) {
            $a1 = '01-' . $a1;
            $a2 = '01-' . $a2;
            $time1 = strtotime($a1);
            $time2 = strtotime($a2);

            return $time1 - $time2;
        });
        //Excel
        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();

        $objSheet->setTitle('P&L Report');
        $objSheet->setCellValue('A1', 'P&L Report');
        $objSheet->mergeCells('A1:F1');
        $objSheet->getStyle('A1')->getFont()->setSize(16);
        $objSheet->getStyle('A1')->getFont()->setBold(true);
        $objSheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objSheet->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        //$objSheet->getStyle('A1')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_WHITE);

        $objSheet->setCellValue('A3', 'Particulars');
        $objSheet->mergeCells('A3:A4');
        $objSheet->getStyle('A3')->getFont()->setBold(true);
        $objSheet->getStyle('A3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objSheet->getStyle('A3')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

        $objSheet->setCellValue('A5', 'Direct Income');
        $objSheet->getStyle('A5')->getFont()->setBold(true);

        $objSheet->setCellValue('A6', 'Offline Sales');
        $objSheet->setCellValue('A7', 'Offline Credit Notes');
        $objSheet->setCellValue('A8', 'FBA Sales');
        $objSheet->setCellValue('A9', 'FBA Credit Notes');
        $objSheet->setCellValue('A10', 'Export Sales');
        $objSheet->setCellValue('A11', 'Exempt Sales');
        $objSheet->setCellValue('A12', 'Sale of Services & Spares');

        $objSheet->setCellValue('A14', 'Indirect Income');
        $objSheet->getStyle('A14')->getFont()->setBold(true);
        $objSheet->setCellValue('A15', 'Discount Received');
        $objSheet->setCellValue('A16', 'Foreign Exchange Fluctuations');

        $objSheet->setCellValue('A18', 'Direct Expenses');
        $objSheet->getStyle('A18')->getFont()->setBold(true);
        $objSheet->setCellValue('A19', 'Cost of Goods Sold');
        $objSheet->setCellValue('A20', 'Less: Discount By Flipkart');
        $objSheet->setCellValue('A21', 'Spares Cost');
        $objSheet->setCellValue('A22', 'Marketplace Charges');

        $objSheet->setCellValue('A24', 'Gross Profit');
        $objSheet->getStyle('A24')->getFont()->setBold(true);

        $objSheet->setCellValue('A26', 'Indirect Expenses');
        $objSheet->getStyle('A26')->getFont()->setBold(true);
        $objSheet->setCellValue('A27', 'Employee Benefit Expenses');
        $objSheet->setCellValue('A28', 'Adminsitrative Expenses');
        $objSheet->setCellValue('A29', 'Selling & Distribution Expenses');
        $objSheet->setCellValue('A30', 'Consultant Expenses');
        $objSheet->setCellValue('A31', 'Other Expenses');
        $objSheet->setCellValue('A32', 'Interest Expenses');

        $objSheet->setCellValue('A34', 'Net Profit');
        $objSheet->getStyle('A34')->getFont()->setBold(true);

        //Content
        $column = 'B';
        $row = 3;

        foreach ($income_month as $key => $value) {
            $row = 3;
            $field = $column . $row;
            $start_column = $column;
            $columnNumber = PHPExcel_Cell::columnIndexFromString($column);
            $endcolumn = PHPExcel_Cell::stringFromColumnIndex($columnNumber + 2);
            $end_field = $endcolumn . $row;

            //First Columns
            $objSheet->setCellValue($field, $key);
            $objSheet->getStyle($field)->getFont()->setBold(true);
            $objSheet->getStyle($field)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            //1st row
            $row++;
            $objSheet->setCellValue($column . $row, 'Qty');
            $column++;
            $objSheet->SetCellValue($column . $row, 'Amount');
            $column++;
            $objSheet->SetCellValue($column . $row, '% on Total Income');
            $objSheet->mergeCells($field . ':' . $column . ($row - 1));

            //Direct Income Row 
            $row++;
            $direct_income_row = $row;

            //2nd row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, $value['sale_qty']);
            $column++;
            $objSheet->setCellValue($column . $row, $value['taxable_sales']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);

            //3rd row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, '-' . $value['cn_quantity']);
            $column++;
            $objSheet->setCellValue($column . $row, '-' . $value['taxable_credit_note']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);

            //4th row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, $value['fba_quantity']);
            $column++;
            $objSheet->setCellValue($column . $row, $value['fba_sales']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);

            //5th row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, '-' . $value['fba_cn_quantity']);
            $column++;
            $objSheet->setCellValue($column . $row, '-' . $value['fba_credit_note']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);

            //Export Row
            $column = $start_column;
            $row++;

            //Exempt row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, '');
            $column++;
            $objSheet->setCellValue($column . $row, $value['exempt_sales']);
            $column++;
            $objSheet->setCellValue($column . $row, '');

            //Spares row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, $value['service_sales_qty']);
            $column++;
            $objSheet->setCellValue($column . $row, $value['service_sales']);
            $column++;
            $objSheet->setCellValue($column . $row, '');

            $row++;

            //Indirect Income row
            $column = $start_column;
            $row++;

            //Discount Received row
            $column = $start_column;
            $row++;

            //FE Fluctuations row
            $column = $start_column;
            $row++;

            //Empty Rows
            $row++;

            //Total Income Row
            $row++;

            //Empty Rows

            //Direct Expenses Row
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, $expense_month[$key]['cost_qty']);
            $column++;
            $objSheet->setCellValue($column . $row, $expense_month[$key]['cost']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);

            //Empty Row
            $row++;

            //Spare Cost
            $column = $start_column;
            $row++;
            $objSheet->setCellValue($column . $row, '');
            $column++;
            $objSheet->setCellValue($column . $row, $expense_month[$key]['spare_cost']);
            $column++;
            $objSheet->setCellValue($column . $row, 0);
            $column++;
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'PnL_Report_' . date('Y-m-d') . '.xlsx';

        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    public function getTopCustomers()
    {
        //Period
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if ($from_date == '' || $to_date == '') {
            print "Please select a date range";
            die;
        }
        //Where array
        $where = array(
            "DATE(CREATION_DATE) >= " => $from_date,
            "DATE(CREATION_DATE) <= " => $to_date
        );


        if ($from_date != '' && $to_date != '') {
            $this->db->where($where);
        }
        //Invoice Report
        $invoices = $this->db->where('status !=', 'VOID')->select('vendor_name, vendor_code, vendor_id, total_amount, qty, CREATION_DATE')
            ->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        //Get Customerwise Total Amount
        $customer_total_amount = array();
        $monthly_customer_total_amount = array();
        foreach ($invoices as $key => $value) {
            $my = date('M', strtotime($value['CREATION_DATE'])) . '-' . date('y', strtotime($value['CREATION_DATE']));
            $customer_total_amount[$value['vendor_id']]['vendor_code'] = $value['vendor_code'];
            $customer_total_amount[$value['vendor_id']]['vendor_name'] = $value['vendor_name'];
            $customer_total_amount[$value['vendor_id']]['total_amount'] += $value['total_amount'];
            $customer_total_amount[$value['vendor_id']]['qty'] += $value['qty'];
            //Monthly Customer Total Amount
            $monthly_customer_total_amount[$my][$value['vendor_id']]['vendor_code'] = $value['vendor_code'];
            $monthly_customer_total_amount[$my][$value['vendor_id']]['vendor_name'] = $value['vendor_name'];
            $monthly_customer_total_amount[$my][$value['vendor_id']]['total_amount'] += $value['total_amount'];
            $monthly_customer_total_amount[$my][$value['vendor_id']]['qty'] += $value['qty'];
        }

        //Sort Customerwise Total Amount and Monthly Customer Total Amount
        usort($customer_total_amount, function ($a, $b) {
            return $b['total_amount'] - $a['total_amount'];
        });

        foreach ($monthly_customer_total_amount as $key => $value) {
            usort($value, function ($a, $b) {
                return $b['total_amount'] - $a['total_amount'];
            });
            $monthly_customer_total_amount[$key] = $value;
        }

        //Get Top 10 Customers and Remaining Customer Amount Total
        $top_customers = array();
        $remaining_customer_amount = 0;
        $total_amount = 0;
        $i = 0;
        foreach ($customer_total_amount as $key => $value) {
            if ($i < 10) {
                $top_customers[] = $value;
            } else {
                $remaining_customer_amount += $value['total_amount'];
            }
            $total_amount += $value['total_amount'];
            $i++;
        }

        //Get Top 10 Monthly Customers and Remaining Customer Amount Total
        $top_monthly_customers = array();
        $remaining_monthly_customer_amount = array();
        $monthly_total_amount = array();
        foreach ($monthly_customer_total_amount as $key => $value) {
            $i = 0;
            foreach ($value as $k => $v) {

                if ($i < 10) {
                    $top_monthly_customers[$key][] = $v;
                } else {
                    $remaining_monthly_customer_amount[$key] += $v['total_amount'];
                }
                $monthly_total_amount[$key] += $v['total_amount'];
                $i++;
            }
        }
        //CSV Headers
        $headers_arr = [];
        $headers_arr[] = 'Customer Name | Code';
        $headers_arr[] = 'Total Amount';
        $headers_arr[] = '% of Total Amount';
        foreach ($monthly_customer_total_amount as $key => $value) {
            $headers_arr[] = 'Vendor Name | Code';
            $headers_arr[] = $key;
            $headers_arr[] = '% of Total Amount';
        }

        //CSV Data
        $data_arr = [];
        foreach ($top_customers as $key => $value) {
            $data1 = [];
            $data1 = array(
                $value['vendor_name'] . ' | ' . $value['vendor_code'],
                $value['total_amount'],
                round(($value['total_amount'] / $total_amount) * 100, 2) . '%'
            );
            $data3 = [];
            foreach ($top_monthly_customers as $k => $v) {
                if (isset($v[$key])) {
                    $data2 = array(
                        $v[$key]['vendor_name'] . ' | ' . $v[$key]['vendor_code'],
                        $v[$key]['total_amount'],
                        round(($v[$key]['total_amount'] / $monthly_total_amount[$k]) * 100, 2) . '%'
                    );
                } else {
                    $data2 = array(
                        '',
                        '',
                        ''
                    );
                }
                $data3 = array_merge($data3, $data2);
            }
            $data_arr[] = array_merge($data1, $data3);
        }
        //Remaining Customer Amount
        $data1 = [];
        $data1 = array(
            'Remaining Customer Amount',
            $remaining_customer_amount,
            round(($remaining_customer_amount / $total_amount) * 100, 2) . '%'
        );

        //Remaining Customer Amount Monthly
        $data3 = [];
        foreach ($monthly_customer_total_amount as $key => $value) {
            $data2 = array(
                'Remaining Customer Amount',
                $remaining_monthly_customer_amount[$key],
                round(($remaining_monthly_customer_amount[$key] / $monthly_total_amount[$key]) * 100, 2) . '%'
            );
            $data3 = array_merge($data3, $data2);
        }

        $data_arr[] = array_merge($data1, $data3);

        // Create CSV file from $headers_arr and $data_arr force download it
        $file_name = 'Customerwise_Total_Amount_' . date('d-m-Y') . '.csv';
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . $file_name);
        $csv_file = fopen('php://output', 'w');
        fputcsv($csv_file, $headers_arr);
        foreach ($data_arr as $row) {
            fputcsv($csv_file, $row);
        }
        fclose($csv_file);
        //download it
        //delete it
        unlink($csv_file);
        exit;
    }

    public function getTopVendors()
    {
        //Period
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if ($from_date == '' || $to_date == '') {
            print "Please Select From Date and To Date";
            exit;
        }

        //Where array - invoice_date
        $where = array(
            "DATE(invoice_date) >= " => $from_date,
            "DATE(invoice_date) <= " => $to_date
        );
        //If Where Condition
        if ($from_date != '' && $to_date != '') {
            $this->db->where($where);
        }
        //Invoice Report from tbl_security_admin table
        $invoices = $this->db->select('vendor_name, vendor_code, invoice_value, invoice_qty, invoice_date')
            ->get('PURCHASE_EXPORT_REPORT_VIEW')->result_array();
        // get Vendorwise Total Amount
        $vendor_amount = array();
        $monthly_vendor_amount = array();
        foreach ($invoices as $key => $value) {
            $month = date('M', strtotime($value['invoice_date']));
            $year = date('y', strtotime($value['invoice_date']));
            $my = $month . '-' . $year;
            $vendor_amount[$value['vendor_code']]['vendor_name'] = $value['vendor_name'];
            $vendor_amount[$value['vendor_code']]['vendor_code'] = $value['vendor_code'];
            $vendor_amount[$value['vendor_code']]['total_amount'] += $value['invoice_value'];
            $vendor_amount[$value['vendor_code']]['qty'] += $value['invoice_qty'];
            $vendor_amount[$value['vendor_code']]['no_invoices'] += 1;
            //Monthwise Details
            //if there was $value['vendor_code'] in $monthly_vendor_amount[$my][] then add the qty and total_amount or add new array element
            if (isset($monthly_vendor_amount[$my][$value['vendor_code']])) {
                $monthly_vendor_amount[$my][$value['vendor_code']]['qty'] += $value['invoice_qty'];
                $monthly_vendor_amount[$my][$value['vendor_code']]['total_amount'] += $value['invoice_value'];
            } else {
                $monthly_vendor_amount[$my][$value['vendor_code']]['vendor_name'] = $value['vendor_name'];
                $monthly_vendor_amount[$my][$value['vendor_code']]['vendor_code'] = $value['vendor_code'];
                $monthly_vendor_amount[$my][$value['vendor_code']]['qty'] = $value['invoice_qty'];
                $monthly_vendor_amount[$my][$value['vendor_code']]['total_amount'] = $value['invoice_value'];
            }
        }

        //Sort Vendorwise Amount
        usort($vendor_amount, function ($a, $b) {
            return $b['total_amount'] - $a['total_amount'];
        });

        //Sort Monthly Vendorwise Amount
        foreach ($monthly_vendor_amount as $key => $value) {

            usort($value, function ($a, $b) {
                return $b['total_amount'] - $a['total_amount'];
            });
            $monthly_vendor_amount[$key] = $value;
        }

        uksort($monthly_vendor_amount, function ($a, $b) {
            $a = strtotime('01-' . $a);
            $b = strtotime('01-' . $b);
            return $a - $b;
        });
        //get Top 10 Vendors and sum of the total amount of reamining vendors
        $top_vendors = array_slice($vendor_amount, 0, 10);
        $remaining_vendors = array_slice($vendor_amount, 10);
        $remaining_vendors_total_amount = 0;
        foreach ($remaining_vendors as $key => $value) {
            $remaining_vendors_total_amount += $value['total_amount'];
        }
        //Total Amount
        $total_amount = 0;
        foreach ($vendor_amount as $key => $value) {
            $total_amount += $value['total_amount'];
        }
        $top_vendors_monthly = array();
        $monthly_remaining_vendors_total_amount = [];
        foreach ($monthly_vendor_amount as $key => $value) {
            //get Top 10 Vendors and sum of the total amount of reamining vendors_monthly
            $i = 0;
            $monthly_total_amount_a = 0;
            foreach ($value as $key1 => $value1) {
                if ($i < 10) {
                    $top_vendors_monthly[$key][$key1] = $value1;
                } else {
                    $monthly_remaining_vendors_total_amount[$key] += $value1['total_amount'];
                }
                $i++;
                $monthly_total_amount_a += $value1['total_amount'];
            }
            $monthly_total_amount[$key] = $monthly_total_amount_a;
        }
        $headers_arr = [];
        $headers_arr[] = 'Vendor Name | Code';
        $headers_arr[] = 'Total Amount';
        $headers_arr[] = '% of Total Amount';
        foreach ($monthly_vendor_amount as $key => $value) {
            $headers_arr[] = 'Vendor Name | Code';
            $headers_arr[] = $key;
            $headers_arr[] = '% of Total Amount';
        }

        $data = [];
        foreach ($top_vendors as $key => $value) {
            $data1 = [
                $value['vendor_name'] . ' | ' . $value['vendor_code'],
                $value['total_amount'],
                round(($value['total_amount'] / $total_amount) * 100, 2) . '%'
            ];
            $data3 = [];
            foreach ($top_vendors_monthly as $key2 => $value2) {
                if (!empty($value2[$key])) {
                    $data2 = [
                        $value2[$key]['vendor_name'] . ' | ' . $value2[$key]['vendor_code'],
                        $value2[$key]['total_amount'],
                        round(($value2[$key]['total_amount'] / $monthly_total_amount[$key2]) * 100, 2) . '%'
                    ];
                } else {
                    $data2 = [
                        '',
                        '',
                        ''
                    ];
                }
                $data3 = array_merge($data3, $data2);
            }
            $data[] = array_merge($data1, $data3);
        }
        $data1 = [];
        $data1 = [
            'Remaining Vendors',
            $remaining_vendors_total_amount,
            round(($remaining_vendors_total_amount / $total_amount) * 100, 2) . '%'
        ];
        $data2 = [];
        $data3 = [];
        foreach ($top_vendors_monthly as $key => $value) {
            $data3 = [
                'Remaining Vendors',
                $monthly_remaining_vendors_total_amount[$key],
                round(($monthly_remaining_vendors_total_amount[$key] / $monthly_total_amount[$key]) * 100, 2) . '%'
            ];
            $data2 = array_merge($data2, $data3);
        }
        $data[] = array_merge($data1, $data2);

        //Create a csv file from $header_arr and $data and force download it and destroy it later
        $csv_file = fopen('php://output', 'w');
        $csv_file_name = 'Top_10_Vendors_' . date('Y-m-d') . '.csv';
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename="' . $csv_file_name . '";');
        fputcsv($csv_file, $headers_arr);
        foreach ($data as $key => $value) {
            fputcsv($csv_file, $value);
        }
        fclose($csv_file);
        unlink($csv_file);
        die;
    }


    //Stock Aging Report
    public function getStockAging()
    {
        // get Devices Details from tbl_grnreport
        $devices = $this->db->select('nhdin as device_id, device_name, product_brand, grnreport_id, stock_type as category, status, stock_type, invoice_date')
            ->where_not_in('status ', ['LOST', 'RTV', 'FFC'])
            ->get('tbl_grnreport')->result_array();

        #get Stock Age
        $stock_age = array();
        foreach ($devices as $key => $value) {
            $stock_age[$value['grnreport_id']]['device_id'] = $value['device_id'];
            $stock_age[$value['grnreport_id']]['device_name'] = $value['device_name'];
            $stock_age[$value['grnreport_id']]['product_brand'] = $value['product_brand'];
            $stock_age[$value['grnreport_id']]['category'] = $value['category'];
            $stock_age[$value['grnreport_id']]['status'] = $value['status'];
            $stock_age[$value['grnreport_id']]['stock_type'] = $value['stock_type'];
            $stock_age[$value['grnreport_id']]['invoice_date'] = $value['invoice_date'];
            // difference between current date and invoice date
            $stock_age[$value['grnreport_id']]['stock_age'] = date_diff(date_create(date('Y-m-d')), date_create($value['invoice_date']))->days;
        }

        //SOld Devices
        $sold_result = $this->db->where_in('status', ['INVOICED', 'SHIPPED', 'PACKED'])
            ->get('INVOICE_PNL_REPORT_VIEW')->result_array();
        //Get Age
        foreach ($sold_result as $key => $value) {
            $stock_age[$value['grnreport_id']]['sold_date'] = $value['CREATION_DATE'];
            //Difference between purchase date and sold date
            $stock_age[$value['grnreport_id']]['stock_age'] = date_diff(date_create($value['CREATION_DATE']), date_create($value['purchase_date']))->days;
        }

        //Return Count
        $return_result = $this->db->where_in('status', ['CN_CREATED'])
            ->get('CREDITNOTE_ITEM_VIEW')->result_array();
        //Get Age
        foreach ($return_result as $key => $value) {
            $stock_age[$value['grnreport_id']]['return_count'] = +1;
        }

        //Create a csv file for #stock_age and force download it
        $csv_file = fopen('php://output', 'w');
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename="Stock_Aging_Report_' . date('Y-m-d') . '.csv"');
        fputcsv($csv_file, array('Device ID', 'Device Name', 'Product Brand', 'Category', 'Status', 'Stock Type', 'Invoice Date', 'Stock Age', 'Return Count'));
        foreach ($stock_age as $key => $value) {
            fputcsv($csv_file, array($value['device_id'], $value['device_name'], $value['product_brand'], $value['category'], $value['status'], $value['stock_type'], $value['invoice_date'], $value['stock_age'], $value['return_count']));
        }
        fclose($csv_file);
        unlink($csv_file);
        die;
    }

    //Stock Movement Report
    public function getStockMovement()
    {
        //Get from and to date
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if(empty($from_date) || empty($to_date)){
            print 'Please select from and to date';
            exit;
        }

        //Get Opening Stock for the start of the month
        $valuation_date = date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
        if ($valuation_date == '' || $valuation_date == '1970-01-01' || $valuation_date == '0000-00-00') {
            http_response_code(500);
            die('Valuation Date is required');
        }

        $purchased_inventory = $this->db->select('nhdin, status')->where('DATE(grn_inwarddate)<=', $valuation_date)->where('status != "RTV"')->get('tbl_grnreport')->result_array();
        $sold_inventory = $this->db->select('device_id as nhdin, CREATION_DATE')->where('DATE(CREATION_DATE)<=', $valuation_date)->where('status != "VOID"')->get('INVOICE_ITEM_AUDIT_VIEW')->result_array();
        $where_st_out = array(
            "DATE(stocktransfer_date)<=" => $valuation_date,
            "st_type" => "OUTWARD"
        );
        $stock_outward_inventory = $this->db->select('nhdin, stocktransfer_date')->where($where_st_out)->get('STN_INVENTORY_VIEW')->result_array();

        $where_st_in = array(
            "DATE(received_date)<=" => $valuation_date,
            "st_type" => "INWARD"
        );

        $stock_inward_inventory = $this->db->select('nhdin, received_date')->where($where_st_in)->get('STN_INVENTORY_VIEW')->result_array();

        $return_inventory = $this->db->select('device_id as nhdin, returned_date, reason_for_return, product_condition')->where('status not in ("CANCELLED", "VOID", "LOST IN TRANSIT")')->where('DATE(returned_date)<=', $valuation_date)->get('SALESRETURN_EXPORT_VIEW')->result_array();
        $purchase_return = $this->db->select('creation_date, nhdin')->join('tbl_purchase_return', 'tbl_purchase_return.purchase_return_id = PURCHASE_RETURN_ITEM_VIEW.purchase_return_id', 'Left')->where('tbl_purchase_return.creation_date<=', $valuation_date)->get('PURCHASE_RETURN_ITEM_VIEW')->result_array();
        $effective_inventory = array();
        $total_inventory = array();
        $lost_inventory = array();
        foreach ($purchased_inventory as $key => $rowValue) {
            $effective_inventory[] = $rowValue['nhdin'];
            $total_inventory[] = $rowValue['nhdin'];
            if ($rowValue['status'] == 'LOST') {
                $lost_inventory[] = $rowValue['nhdin'];
            }
        }
        $sold_date = array();
        foreach ($sold_inventory as $key => $rowValue) {
            $sold_ids[] = $rowValue['nhdin'];
            if (empty($sold_date[$rowValue['nhdin']])) {
                $sold_date[$rowValue['nhdin']] = $rowValue['CREATION_DATE'];
            } else {
                if (strtotime($rowValue['CREATION_DATE']) > strtotime($sold_date[$rowValue['nhdin']])) {
                    $sold_date[$rowValue['nhdin']] = $rowValue['CREATION_DATE'];
                }
            }
        }

        $effective_inventory = array_diff($effective_inventory, $sold_ids);
        $stocktransfer_date = array();
        foreach ($stock_outward_inventory as $key => $rowValue) {
            $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
            if (empty($stocktransfer_date[$rowValue['nhdin']])) {
                $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
            } else {

                if (strtotime($rowValue['stocktransfer_date']) > strtotime($stocktransfer_date[$rowValue['nhdin']])) {
                    $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
                }
            }
            $stocktransfer_out_ids[] = $rowValue['nhdin'];
        }
        $effective_inventory = array_diff($effective_inventory, $stocktransfer_out_ids);

        $purchase_return_ids = array();
        $purchase_return_date = array();
        foreach ($purchase_return as $key => $rowValue) {
            $purchase_return_ids[] = $rowValue['nhdin'];
            $purchase_return_date[$rowValue['nhdin']] = $rowValue['creation_date'];
        }

        // Stock Transfer Inward
        $inward_count = 0;

        foreach ($stock_inward_inventory as $key => $rowValue) {

            if (!empty($sold_date[$rowValue['nhdin']])) {

                if (strtotime($sold_date[$rowValue['nhdin']]) > strtotime($rowValue['received_date'])) {
                    continue;
                }
            }
            if (!empty($purchase_return_date[$rowValue['nhdin']])) {
                if (strtotime($purchase_return_date[$rowValue['nhdin']]) > strtotime($rowValue['received_date'])) {
                    continue;
                }
            }

            if ($stocktransfer_date[$rowValue['nhdin']] < $rowValue['received_date']) {
                $effective_inventory[] = $rowValue['nhdin'];
                $total_inventory[] = $rowValue['nhdin'];
                $inward_count++;
            }
        }

        //Return Devices
        $condition_arr = ["LOST IN TRANSIT", "MODEL MISMATCH", "DIFFERENT ITEM", "EMPTY/TRASH", "FAKE/DUMMY"];
        foreach ($return_inventory as $key => $rowValue) {

            if (!empty($sold_date[$rowValue['nhdin']])) {
                // if (in_array($rowValue['reason_for_return'], $condition_arr)) {
                //     continue;
                // }

                if (in_array($rowValue['product_condition'], $condition_arr)) {
                    if (in_array($rowValue['nhdin'], $lost_inventory)) {
                        continue;
                    }
                }

                if (!empty($stocktransfer_date[$rowValue['nhdin']])) {
                    if (strtotime($stocktransfer_date[$rowValue['nhdin']]) > strtotime($rowValue['returned_date'])) {
                        continue;
                    }
                }

                if (!empty($purchase_return_date[$rowValue['nhdin']])) {
                    if (strtotime($purchase_return_date[$rowValue['nhdin']]) > strtotime($rowValue['returned_date'])) {
                        continue;
                    }
                }

                if (strtotime($sold_date[$rowValue['nhdin']]) < strtotime($rowValue['returned_date'])) {
                    $effective_inventory[] = $rowValue['nhdin'];
                }
            }
        }
        $opening_inventory = array_unique($effective_inventory);

        $start_date = date('Y-m-d', strtotime($from_date));
        $end_date = date('Y-m-d', strtotime($to_date));

        //Get Start date of the month between start date and end date
        $start_date_arr = array();
        while (strtotime($start_date) <= strtotime($end_date)) {
            $start_date_arr[] = $start_date;
            $start_date = date("Y-m-01", strtotime("+1 month", strtotime($start_date)));
        }

        //Get Purchases from start date to -1 next start date
        $purchases = array();
        $sales = array();
        $stock_inward = array();
        $stock_outward = array();
        $return_devices = array();

        foreach ($start_date_arr as $key => $rowValue) {
            $purchases[$rowValue] = $this->getPurchases($rowValue);
            $sales[$rowValue] = $this->getSales($rowValue);
            $stock_inward[$rowValue] = $this->getStocktransferInward($rowValue);
            $stock_outward[$rowValue] = $this->getStocktransferOutward($rowValue);
            $return_devices[$rowValue] = $this->getSalesReturns($rowValue);
        }

        //Get Closing Inventory openin inventory - sales + purchases + stock transfer inward - stock transfer outward + return devices
        // Closing stock becomes opening stock for next month
        $closing_inventory = array();
        $opening_inventory_arr = array();
        foreach ($start_date_arr as $key => $rowValue) {
            //Get Closing Inventory
            if ($key == 0) {
                $opening_inventory_arr[$rowValue] = $opening_inventory;
            } else {
                $opening_inventory_arr[$rowValue] = $closing_inventory[$thiskey];
            }

            //opening inventory + purchases
            $closing_inventory[$rowValue] = array_merge($opening_inventory_arr[$rowValue], $purchases[$rowValue]);
            //Closing inventory + stock transfer inward
            $closing_inventory[$rowValue] = array_merge($closing_inventory[$rowValue], $stock_inward[$rowValue]);
            //Closing inventory + return devices
            $closing_inventory[$rowValue] = array_merge($closing_inventory[$rowValue], $return_devices[$rowValue]);
            //Closing inventory - stock transfer outward
            $closing_inventory[$rowValue] = array_diff($closing_inventory[$rowValue], $stock_outward[$rowValue]);
            //Closing inventory - sales
            $closing_inventory[$rowValue] = array_diff($closing_inventory[$rowValue], $sales[$rowValue]);

            $thiskey = $rowValue;
        }
        //get Price for opening Inventory
        $opening_inventory_price = array();
        foreach ($opening_inventory_arr as $key => $rowValue) {
            if (empty($rowValue)) {
                $opening_inventory_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $opening_inventory_price
            foreach ($result->get()->result_array() as $row) {
                $opening_inventory_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }

        //get Price for closing Inventory
        $closing_inventory_price = array();
        foreach ($closing_inventory as $key => $rowValue) {
            if (empty($rowValue)) {
                $closing_inventory_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $closing_inventory_price
            foreach ($result->get()->result_array() as $row) {
                $closing_inventory_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }

        //get Price for sales
        $sales_price = array();
        foreach ($sales as $key => $rowValue) {
            if (empty($rowValue)) {
                $sales_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $sales_price
            foreach ($result->get()->result_array() as $row) {
                $sales_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }
        //get Price for purchases
        $purchases_price = array();
        foreach ($purchases as $key => $rowValue) {
            if (empty($rowValue)) {
                $purchases_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $purchases_price
            foreach ($result->get()->result_array() as $row) {
                $purchases_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }

        //get Price for stock transfer inward
        $stock_inward_price = array();
        foreach ($stock_inward as $key => $rowValue) {
            if (empty($rowValue)) {
                $stock_inward_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $stock_inward_price
            foreach ($result->get()->result_array() as $row) {
                $stock_inward_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }

        //get Price for stock transfer outward
        $stock_outward_price = array();
        foreach ($stock_outward as $key => $rowValue) {
            if (empty($rowValue)) {
                $stock_outward_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $stock_outward_price
            foreach ($result->get()->result_array() as $row) {
                $stock_outward_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }

        //get Price for return devices
        $return_devices_price = array();
        foreach ($return_devices as $key => $rowValue) {
            if (empty($rowValue)) {
                $return_devices_price[$key] = array();
                continue;
            }
            $result = $this->db->select('nhdin, unit_price, unit_price_tax,stock_type')
                ->from('tbl_grnreport')->where_in('nhdin', $rowValue);
            //add this to $return_devices_price
            foreach ($result->get()->result_array() as $row) {
                $return_devices_price[$key][] = array(
                    'nhdin' => $row['nhdin'],
                    'unit_price' => $row['unit_price'] + $row['unit_price_tax'],
                    'stock_type' => $row['stock_type']
                );
            }
        }
        //Create Excel Workbook using php excel library
        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        //Loop through $start_date_arr
        foreach ($start_date_arr as $key => $rowValue) {
            //Create a sheet for each element
            $objPHPExcel->createSheet();
            $objPHPExcel->setActiveSheetIndex($key);
            $current_sheet = $objPHPExcel->getActiveSheet();
            $current_sheet->setTitle($rowValue, false);
            $current_sheet->getStyle('A1:H1')->getFont()->setBold(true);
            $current_sheet->getStyle('A1:H1')->getFont()->setSize(12);

            //Add Header Particulars, Month, value
            $current_sheet->setCellValue('A1', 'Particulars');
            $current_sheet->setCellValue('B1', 'DeviceID');
            $current_sheet->setCellValue('C1', 'Value');
            $current_sheet->setCellValue('D1', 'Category');

            //Add Opening Inventory
            $row_count = 2;
            $k = 0;
            $opening_inventory_insrt = array();
            foreach ($opening_inventory_price[$rowValue] as $row) {
                if ($k == 0) {
                    $opening_inventory_insrt[] = ['Opening Inventory', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $opening_inventory_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }
                $k = 1;
            }

            $current_sheet->fromArray($opening_inventory_insrt, NULL, 'A' . $row_count);
            $row_count = $row_count + count($opening_inventory_insrt);

            //Add Purchases
            $k = 0;
            $purchaes_insrt = array();
            foreach ($purchases_price[$rowValue] as $row) {
                if ($k == 0) {
                    $purchaes_insrt[] = ['Purchases', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $purchaes_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }

                $k = 1;
            }

            $current_sheet->fromArray($purchaes_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($purchaes_insrt);

            //Add Stock Inward
            $k = 0;
            $stock_inward_insrt = array();
            foreach ($stock_inward_price[$rowValue] as $row) {
                if ($k == 0) {
                    $stock_inward_insrt[] = ['Stock Inward', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $stock_inward_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }
                $k = 1;
            }

            $current_sheet->fromArray($stock_inward_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($stock_inward_insrt);
            //Add Return Devices
            $k = 0;
            $return_devices_insrt = array();
            foreach ($return_devices_price[$rowValue] as $row) {
                if ($k == 0) {
                    $return_devices_insrt[] = ['Return Devices', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $return_devices_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }
                $k = 1;
            }

            $current_sheet->fromArray($return_devices_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($return_devices_insrt);

            //Add Sales
            $k = 0;
            $sales_insrt = array();
            foreach ($sales_price[$rowValue] as $row) {

                if ($k == 0) {
                    $sales_insrt[] = ['Sales', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $sales_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }
                $k = 1;
            }

            $current_sheet->fromArray($sales_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($sales_insrt);

            //Add Stock Outward
            $k = 0;
            $stock_outward_insrt = array();

            foreach ($stock_outward_price[$rowValue] as $row) {
                if ($k == 0) {
                    $stock_outward_insrt[] = ['Stock Outward', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $stock_outward_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }
                $k = 1;
            }

            $current_sheet->fromArray($stock_outward_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($stock_outward_insrt);

            //Add Closing Inventory
            $k = 0;
            $closing_inventory_insrt = array();
            foreach ($closing_inventory_price[$rowValue] as $row) {
                if ($k == 0) {
                    $closing_inventory_insrt[] = ['Closing Inventory', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                } else {
                    $closing_inventory_insrt[] = ['', $row['nhdin'], $row['unit_price'],$row['stock_type']];
                }

                $k = 1;
            }

            $current_sheet->fromArray($closing_inventory_insrt, null, 'A' . $row_count);
            $row_count = $row_count + count($closing_inventory_insrt);
            //Add Column Width 30 From A to D
            $current_sheet->getColumnDimension('A')->setWidth(30);
            $current_sheet->getColumnDimension('B')->setWidth(30);
            $current_sheet->getColumnDimension('C')->setWidth(30);
            $current_sheet->getColumnDimension('D')->setWidth(30);
        }
        //Force Download the Excel File $objPHPExcel and delete the file from server Exel 2007
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $filename = "Inventory_Report_" . date('d-m-Y') . ".xlsx";
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    private function getPurchases($date)
    {
        $start_date = date('Y-m-d', strtotime($date));
        $end_date = date('Y-m-t', strtotime($date));
        $purchases = array();

        //Get Purchase Result from tbl_grnreport where condition on grn_inwarddate
        $purchase_result = $this->db->select('nhdin')->where('DATE(grn_inwarddate) >=', $start_date)
            ->where('DATE(grn_inwarddate) <=', $end_date)
            ->get('tbl_grnreport')->result_array();
        foreach ($purchase_result as $key => $rowValue) {
            $purchases[] = $rowValue['nhdin'];
        }
        return $purchases;
    }

    private function getSales($date)
    {
        $start_date = date('Y-m-d', strtotime($date));
        $end_date = date('Y-m-t', strtotime($date));
        $sales = array();

        //Get Sales Result from tbl_salesreport where condition on sales_date
        $sales_result = $this->db->select('device_id as nhdin')
            ->where('DATE(CREATION_DATE) >=', $start_date)
            ->where('DATE(CREATION_DATE) <=', $end_date)
            ->get('INVOICE_ITEM_AUDIT_VIEW')->result_array();
        foreach ($sales_result as $key => $rowValue) {
            $sales[] = $rowValue['nhdin'];
        }
        return $sales;
    }

    private function getStocktransferOutward($date)
    {
        $start_date = date('Y-m-d', strtotime($date));
        $end_date = date('Y-m-t', strtotime($date));
        $stocktransfer_outward = array();

        //Get Stocktransfer Outward Result from tbl_stocktransfer_outward where condition on stocktransfer_outward_date
        $stocktransfer_outward_result = $this->db->select('nhdin')
            ->where('DATE(stocktransfer_date) >=', $start_date)
            ->where('DATE(stocktransfer_date) <=', $end_date)
            ->where('st_type', 'OUTWARD')
            ->get('STN_INVENTORY_VIEW')->result_array();
        foreach ($stocktransfer_outward_result as $key => $rowValue) {
            $stocktransfer_outward[] = $rowValue['nhdin'];
        }
        return $stocktransfer_outward;
    }

    private function getStocktransferInward($date)
    {
        $start_date = date('Y-m-d', strtotime($date));
        $end_date = date('Y-m-t', strtotime($date));
        $stocktransfer_inward = array();

        //Get Stocktransfer Inward Result from tbl_stocktransfer_inward where condition on stocktransfer_inward_date
        $stocktransfer_inward_result = $this->db->select('nhdin')
            ->where('DATE(stocktransfer_date) >=', $start_date)
            ->where('DATE(stocktransfer_date) <=', $end_date)
            ->where('st_type', 'INWARD')
            ->get('STN_INVENTORY_VIEW')->result_array();
        foreach ($stocktransfer_inward_result as $key => $rowValue) {
            $stocktransfer_inward[] = $rowValue['nhdin'];
        }
        return $stocktransfer_inward;
    }

    private function getSalesReturns($date)
    {
        $start_date = date('Y-m-d', strtotime($date));
        $end_date = date('Y-m-t', strtotime($date));
        $sales_return = array();

        //Get Sales Return Result from tbl_purchase_return where condition on return_date
        $sales_return_result = $this->db->select('device_id as nhdin')
            ->where('DATE(returned_date) >=', $start_date)
            ->where('DATE(returned_date) <=', $end_date)
            ->where('status not in ("CANCELLED", "VOID", "LOST IN TRANSIT")')
            ->get('SALESRETURN_EXPORT_VIEW')->result_array();
        foreach ($sales_return_result as $key => $rowValue) {
            $sales_return[] = $rowValue['nhdin'];
        }
        return $sales_return;
    }
}
