<?php

class Assets_dealerapp extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();
        // load upload
        $this->load->library('upload');
    }

    public function manage_assets_dealerapp($active = 0)
    {
        $data['active'] = 1;

        if ($active > 0) {
            $data['active'] = $active;
        }

        $data['title'] = 'DEALER APP ASSETS';
        $data['subview'] = $this->load->view('admin/assets_dealerapp/manage_assets_dealerapp', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function uploadOpenBoxImages()
    {
        // Get Uploaded Images Data
        $data['all_images'] = array();
        $files = $_FILES;
        $file_count = count($_FILES['userfile']['name']);
        $config = array();
        $config['upload_path'] = './assets/images/openbox/';
        $config['allowed_types'] = 'jpg';
        $config['max_size'] = '0';
        $config['overwrite'] = TRUE;

        $models_list = $this->db->select('nhmod')->get('tbl_product_details')->result_array();
        $models_list = array_column($models_list, 'nhmod');

        for ($i = 0; $i < $file_count; $i++) {
            if (strpos($files['userfile']['name'][$i], '.jpg') !== false) {
                $image_name_arr[] = str_replace('.jpg', '', $files['userfile']['name'][$i]);
            } else {
                echo json_encode(array("status" => 0, "message" => "Invalid File Type " . $files['userfile']['name'][$i]));
                exit;
            }
        }

        foreach ($image_name_arr as $image_name) {
           if (!in_array($image_name, $models_list)) {
                echo json_encode(array("status" => 0, "message" => "Invalid Model Name " . $image_name));
                exit;
            }
        }

        for ($i = 0; $i < $file_count; $i++) {
            try {
                $_FILES['userfile']['name'] = $files['userfile']['name'][$i];
                $_FILES['userfile']['type'] = $files['userfile']['type'][$i];
                $_FILES['userfile']['tmp_name'] = $files['userfile']['tmp_name'][$i];
                $_FILES['userfile']['error'] = $files['userfile']['error'][$i];
                $_FILES['userfile']['size'] = $files['userfile']['size'][$i];
                $this->upload->initialize($config);
                $this->upload->do_upload();
            } catch (Exception $e) {
                echo json_encode(array("status" => 0, "message" => $e->getMessage()));
                exit;
            }

            $data['all_images'][] = $this->upload->data();
        }
        $data['all_images'] = array_filter($data['all_images']);
        $data['all_images'] = array_values($data['all_images']);

        $json['status'] = 1;
        $json['message'] = count($data['all_images']) . " Images Uploaded Successfully";
        echo json_encode($json);
        exit;
    }

    public function openboxImagesList()
    {
        // get all images from ./assets/images/openbox/
        $image_name_arr = array();
        $dir = './assets/images/openbox/';
        $files = scandir($dir);
        $result = array();

        foreach ($files as $file) {
            if (strpos($file, '.jpg') !== false) {
                $image_name_arr[] = str_replace('.jpg', '', $file);
            }
        }

        if(empty($image_name_arr)){
            $json['data'] = $result;
            echo json_encode($json);
            exit;
        }

        $model_list = $this->db->select('nhmod, product_name')
            ->where_in('nhmod', $image_name_arr)
            ->get('tbl_product_details')->result_array();

        foreach ($model_list as $model) {
            $result[] = array(
                'image_name' => $model['nhmod'],
                'product_name' => $model['product_name']
            );
        }

        $json['data'] = $result;
        unset($result);
        unset($model_list);
        unset($image_name_arr);
        echo json_encode($json);
        exit;
    }

    public function deleteOpenBoxImage()
    {
        $image_name = $this->input->post('image_name');
        $image_path = './assets/images/openbox/' . $image_name . '.jpg';
        
        if (file_exists($image_path)) {
            unlink($image_path);
        }
        
        $json['status'] = 1;
        $json['message'] = "Image Deleted Successfully";
        echo json_encode($json);
        exit;
    }
}
