<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Analytics extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function manage_analytics($active = 0)
    {
        $data['active'] = 1;
        if (in_array($this->session->userdata('department_id'), [2]) || in_array($this->session->userdata('user_id'), [24, 28, 39, 49])) {
            $data['active'] = 17;
            $data['active'] = 21;
            $data['active'] = 1;
            // $data['active'] = 0;
        }
        if ($active > 0) {
            $data['active'] = $active;
        }

        if (in_array($data['active'], [21, 210])) {
            /** Record Access Log */
            $Res = $this->save_Dashboard_AccessLog();

            if ($Res['status']) {
                $data['access_log_id'] = $Res['access_log_id'];
            }
        }

        $data['title'] = 'ANALYTICS';
        $data['subview'] = $this->load->view('admin/analytics/manage_analytics', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getSalesorderDetails()
    {
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');
        $saletype = $this->input->get('saletype');

        $this->db->select('count(tbl_salesorder.salesorder_id) as count, sum(soi.quantity) as quantity, status');
        $this->db->join('(SELECT sum(quantity) as quantity, salesorder_id FROM tbl_salesorder_item GROUP BY salesorder_id) as soi', 'soi.salesorder_id= tbl_salesorder.salesorder_id', 'Left');

        if (!empty($from_date) && !empty($to_date)) {
            $this->db->where("DATE(tbl_salesorder.LAST_UPDATE_DATE) >=", $from_date);
            $this->db->where("DATE(tbl_salesorder.LAST_UPDATE_DATE) <=", $to_date);
        }
        if ($saletype == 'offline') {
            $this->db->where("tbl_salesorder.sales_channel", "OFFLINE");
        }
        if ($saletype == 'online') {
            $this->db->where("tbl_salesorder.sales_channel !=", "OFFLINE");
        }

        $result = $this->db->group_by('status')->get('tbl_salesorder')->result_array();
        if (empty($result)) {
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        $status = $this->db->select('name')->where('type', 'SO_STATUS')->order_by('value')->get('tbl_dropdown')->result_array();
        // Get All Status
        foreach ($status as $rowValue) {
            $status_existing[] = $rowValue['name'];
        }

        // Sort the Statuses as per dropdown table
        foreach ($status as $status_val) {

            $k = 0; // To check items for the status exists or not

            foreach ($result as $recordValue) {

                if ($status_val['name'] == $recordValue['status']) {

                    $records_sort[] = array(

                        "status" => str_replace('_', ' ', $recordValue['status']),
                        "count" => $recordValue['count'],
                        "quantity" => $recordValue['quantity']
                    );
                    $k = 1;  // Items found for given status
                }
            }
            if ($k != 1) {    // item doesn't exists for this status so count = 0
                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $status_val['name']),
                    "count" => 0,
                    "quantity" => 0
                );
            }
        }
        // For new Statuses
        foreach ($result as $recordValue) {

            if (!in_array($recordValue['status'], $status_existing)) {

                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $recordValue['status']),
                    "count" => $recordValue['count'],
                    "quantity" => $recordValue['quantity']
                );
            }
        }

        $json['status'] = 1;
        $json['result'] = $records_sort;
        echo json_encode($json);
        die;
    }

    public function getInvoiceDetails()
    {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');
        $saletype = $this->input->get('saletype');

        $this->db->select('count(tbl_invoice.invoice_id) as count, tbl_invoice.status, sum(ii.quantity) as quantity');
        $this->db->join('(SELECT count(invoice_item_id) as quantity, invoice_id FROM tbl_invoice_item GROUP BY invoice_id) as ii', 'ii.invoice_id= tbl_invoice.invoice_id', 'Left');

        if (!empty($from_date) && !empty($to_date)) {
            $this->db->where("DATE(tbl_invoice.CREATION_DATE) >=", $from_date);
            $this->db->where("DATE(tbl_invoice.CREATION_DATE) <=", $to_date);
        }
        if ($saletype == 'offline') {
            $this->db->where("tbl_invoice.sales_channel", "OFFLINE");
        }
        if ($saletype == 'online') {
            $this->db->where("tbl_invoice.sales_channel !=", "OFFLINE");
        }
        $result = $this->db->group_by('tbl_invoice.status')->get('tbl_invoice')->result_array();
        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        $status = $this->db->select('name')->where('type', 'INVOICE_STATUS')->get('tbl_dropdown')->result_array();

        // Get All Status
        foreach ($status as $rowValue) {
            $status_existing[] = $rowValue['name'];
        }

        // Sort the Statuses as per dropdown table
        foreach ($status as $status_val) {
            $k = 0; // To check items for the status exists or not

            foreach ($result as $recordValue) {

                if ($status_val['name'] == $recordValue['status']) {

                    $records_sort[] = array(

                        "status" => str_replace('_', ' ', $recordValue['status']),
                        "count" => $recordValue['count'],
                        "quantity" => $recordValue['quantity']
                    );
                    $k = 1;  // Items found for given status
                }
            }

            if ($k != 1) {    // item doesn't exists for this status so count = 0

                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $status_val['name']),
                    "count" => 0,
                    "quantity" => 0
                );
            }
        }

        // For new Statuses

        foreach ($result as $recordValue) {

            if (!in_array($recordValue['status'], $status_existing)) {

                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $recordValue['status']),
                    "count" => $recordValue['count'],
                    "quantity" => $recordValue['quantity']
                );
            }
        }

        $json['status'] = 1;
        $json['result'] = $records_sort;
        echo json_encode($json);
        die;
    }

    public function getSalesreturnDetails()
    {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        $this->db->select('count(tbl_salesreturn.salesreturn_id) as count, tbl_salesreturn.status, sum(sri.quantity) as quantity');
        $this->db->join('(SELECT count(salesreturnitem_id) as quantity, salesreturn_id FROM tbl_salesreturn_item GROUP BY salesreturn_id) as sri', 'sri.salesreturn_id= tbl_salesreturn.salesreturn_id', 'Left');

        if (!empty($from_date) && !empty($to_date)) {
            $this->db->where("DATE(tbl_salesreturn.created_date) >=", $from_date);
            $this->db->where("DATE(tbl_salesreturn.created_date) <=", $to_date);
        }

        $result = $this->db->group_by('tbl_salesreturn.status')->get('tbl_salesreturn')->result_array();
        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        $status = $this->db->select('name')->where('type', 'SR_STATUS')->get('tbl_dropdown')->result_array();

        // Get All Status
        foreach ($status as $rowValue) {

            $status_existing[] = $rowValue['name'];
        }

        // Sort the Statuses as per dropdown table
        foreach ($status as $status_val) {
            $k = 0; // To check items for the status exists or not
            foreach ($result as $recordValue) {

                if ($status_val['name'] == $recordValue['status']) {
                    if (empty($recordValue['quantity'])) {
                        $quantity = 0;
                    } else {
                        $quantity = $recordValue['quantity'];
                    }
                    $records_sort[] = array(

                        "status" => str_replace('_', ' ', $recordValue['status']),
                        "count" => $recordValue['count'],
                        "quantity" => $quantity
                    );
                    $k = 1;  // Items found for given status
                }
            }

            if ($k != 1) {    // item doesn't exists for this status so count = 0

                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $status_val['name']),
                    "count" => 0,
                    "quantity" => 0
                );
            }
        }
        // For new Statuses
        foreach ($result as $recordValue) {

            if (!in_array($recordValue['status'], $status_existing)) {

                if (empty($recordValue['quantity'])) {
                    $quantity = 0;
                } else {
                    $quantity = $recordValue['quantity'];
                }
                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $recordValue['status']),
                    "count" => $recordValue['count'],
                    "quantity" => $quantity
                );
            }
        }

        $json['status'] = 1;
        $json['result'] = $records_sort;
        echo json_encode($json);
        die;
    }

    public function getClaimsDetails()
    {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        $this->db->select('count(claims_id) as count, status, sum(sri.quantity) as quantity');
        $this->db->join('(SELECT count(salesreturnitem_id) as quantity, salesreturn_id FROM tbl_salesreturn_item GROUP BY salesreturn_id) as sri', 'sri.salesreturn_id= tbl_claims.salesreturn_id', 'Left');

        if (!empty($from_date) && !empty($to_date)) {
            $this->db->where("DATE(CREATION_DATE) >=", $from_date);
            $this->db->where("DATE(CREATION_DATE) <=", $to_date);
        }

        $result = $this->db->group_by('tbl_claims.status')->get('tbl_claims')->result_array();
        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        $status = $this->db->select('name')->where('type', 'CLAIMS_STATUS')->get('tbl_dropdown')->result_array();

        // Get All Status
        foreach ($status as $rowValue) {
            $status_existing[] = $rowValue['name'];
        }

        // Sort the Statuses as per dropdown table
        foreach ($status as $status_val) {
            $k = 0; // To check items for the status exists or not
            foreach ($result as $recordValue) {

                if ($status_val['name'] == $recordValue['status']) {
                    $records_sort[] = array(

                        "status" => str_replace('_', ' ', $recordValue['status']),
                        "count" => $recordValue['count'],
                        "quantity" => $recordValue['quantity']
                    );
                    $k = 1; // Items found for given status
                }
            }

            if ($k != 1) {    // item doesn't exists for this status so count = 0
                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $status_val['name']),
                    "count" => 0,
                    "quantity" => 0
                );
            }
        }

        // For new Statuses not exixts in dropdown table
        foreach ($result as $recordValue) {

            if (!in_array($recordValue['status'], $status_existing)) {

                $records_sort[] = array(

                    "status" => str_replace('_', ' ', $recordValue['status']),
                    "count" => $recordValue['count'],
                    "quantity" => $recordValue['quantity']
                );
            }
        }

        $json['status'] = 1;
        $json['result'] = $records_sort;
        echo json_encode($json);
        die;
    }

    public function getDevicesDetails_status()
    {

        $result = $this->db->select('COUNT(IF(saletype = "OFFLINE", 1, NULL)) AS "OFFLINE",COUNT(IF(saletype = "ONLINE", 1, NULL)) AS "ONLINE", COUNT(IF(saletype != "ONLINE" AND saletype != "OFFLINE", 1, NULL)) AS "OTHER", status')->group_by('status')->get('tbl_grnreport')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }


        foreach ($result as $rowValue) {

            $records[] = array(

                "status" => str_replace('_', ' ', $rowValue['status']),
                "offline_count" => $rowValue['OFFLINE'],
                "online_count" => $rowValue['ONLINE'],
                "other_count" => $rowValue['OTHER'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        die;
    }

    public function getDevicesDetails_category()
    {

        $sold = $this->input->get('sold');

        $this->db->select('COUNT(IF(saletype = "OFFLINE", 1, NULL)) AS "OFFLINE",COUNT(IF(saletype = "ONLINE", 1, NULL)) AS "ONLINE",COUNT(IF(saletype != "ONLINE" AND saletype != "OFFLINE", 1, NULL)) AS "OTHER", stock_type');
        // for inventory
        if ($sold == 'no_sold') {

            $this->db->where('status !=', 'SOLD');
        }
        // for only sold devices
        if ($sold == 'sold') {

            $this->db->where('status', 'SOLD');
        }

        $result = $this->db->group_by('stock_type')->get('tbl_grnreport')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        foreach ($result as $rowValue) {

            $records[] = array(

                "category" => $rowValue['stock_type'],
                "offline_count" => $rowValue['OFFLINE'],
                "online_count" => $rowValue['ONLINE'],
                "other_count" => $rowValue['OTHER'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        die;
    }

    public function getDevicesDetails_status_category()
    {

        $category = $this->input->get('category');

        $status = $this->input->get('status');


        $this->db->select('COUNT(IF(saletype = "OFFLINE", 1, NULL)) AS "OFFLINE",COUNT(IF(saletype = "ONLINE", 1, NULL)) AS "ONLINE", COUNT(IF(saletype != "ONLINE" AND saletype != "OFFLINE", 1, NULL)) AS "OTHER", stock_type,status');

        if (!empty($category)) {

            $this->db->where('stock_type', $category);
        }

        if (!empty($status)) {

            $this->db->where('status', $status);
        }

        $result = $this->db->group_by('status,stock_type')->get('tbl_grnreport')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }


        foreach ($result as $recordValue) {

            $records_sort[] = array(

                "category" => $recordValue['stock_type'],
                "status" => str_replace('_', ' ', $recordValue['status']),
                "offline_count" => $recordValue['OFFLINE'],
                "online_count" => $recordValue['ONLINE'],
                "other_count" => $recordValue['OTHER'],
            );
        }

        array_multisort(array_column($records_sort, "category"), SORT_ASC, array_column($records_sort, "status"), SORT_ASC, $records_sort);

        $json['status'] = 1;
        $json['result'] = $records_sort;
        echo json_encode($json);
        die;
    }

    public function getPurchaseDetails()
    {

        $start_date = $this->db->select('value')->where('config_key', 'insight_purchase_start_date')->get('tbl_config')->row()->value;

        $this->db->select('invoice_date, invoice_no, count(nhdin) as count');
        $this->db->where("DATE(invoice_date) >=", $start_date);
        $result = $this->db->group_by('invoice_no')->order_by('invoice_date', 'DESC')->get('tbl_grnreport')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        foreach ($result as $rowValue) {

            $records[] = array(

                "date" => date("d-m-Y", strtotime($rowValue['invoice_date'])),
                "invoice_no" => $rowValue['invoice_no'],
                "count" => $rowValue['count'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        die;
    }

    public function getClaimRequired()
    {
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        $this->db->select('count(salesreturn_id) as count');
        $this->db->where("claim_required !=", "NO");

        if (!empty($from_date) && !empty($to_date)) {
            $this->db->where("DATE(created_date) >=", $from_date);
            $this->db->where("DATE(created_date) <=", $to_date);
        }
        $result = $this->db->get('tbl_salesreturn')->row();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }


        $records = array(
            "count" => $result->count
        );

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        die;
    }

    public function getPurchaseDetails_vendor()
    {

        $name = $this->input->get('name');

        $start_date = $this->db->select('value')->where('config_key', 'insight_purchase_start_date')->get('tbl_config')->row()->value;

        $where = array(
            "name" => $name,
            "DATE(invoice_date) >=" => $start_date
        );
        $this->db->where($where);
        $result = $this->db->order_by('invoice_date', 'DESC')->get('PURCHASE_VENDOR_WISE_LIST')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        foreach ($result as $rowValue) {

            $records[] = array(

                "invoice_date" => date("d-m-Y", strtotime($rowValue['invoice_date'])),
                "vendor_name" => $rowValue['vendor_name'],
                "invoice_quantity" => $rowValue['invoice_quantity'],
                "inward_quantity" => $rowValue['inward_quantity'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        die;
    }

    public function getDeviceStockList()
    {

        $result1 = $this->db->get('tbl_analytics_variant_list')->result_array();
        if (empty($result1)) {
            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        foreach ($result1 as $rowValue) {
            $variants[] = $rowValue['variant'];
        }
        $result = $this->db->where_in('variant', $variants)->order_by('total_stock', 'desc')->get('DEVICEWISE_STOCK_LIST_VIEW')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }
        foreach ($result as $rowValue) {

            $records[] = array(

                "device_name" => $rowValue['device_name'],
                "device_name_ram_rom" => $rowValue['device_name'] . ' - ' . $rowValue['ram'] . ' - ' . $rowValue['rom'],
                "variant" => $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'],
                "rfs" => $rowValue['rfs'],
                "sold" => $rowValue['sold'],
                "inward" => $rowValue['inward'],
                "in_stock" => $rowValue['in_stock'],
                "cip" => $rowValue['cip'],
                "certified" => $rowValue['certified'],
                "faulted" => $rowValue['faulted'],
                "ber" => $rowValue['ber'],
                "triage" => $rowValue['triage'],
                "hold" => $rowValue['hold'],
                "service" => $rowValue['service'],
                "return" => $rowValue['return'],
                "lost" => $rowValue['lost'],
                "total_stock" => $rowValue['total_stock'],
                "other_stock" => $rowValue['total_stock'] - $rowValue['rfs'] - $rowValue['sold'] - $rowValue['in_stock'] - $rowValue['faulted']
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function getVariantList()
    {

        $this->db->select('device_name, nhmod, ram, rom')->where('stock_type', 'OPEN BOX')->group_by('nhmod, ram, rom');
        $result = $this->db->order_by('device_name')->get('tbl_grnreport')->result_array();
        $variants = array();

        if (!empty($result)) {
            foreach ($result as $rowValue) {
                $variants[] = array(
                    "variant" => $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'],
                    "name" => $rowValue['device_name'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom']
                );
            }
        }

        $json['result'] = $variants;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function addVariantForStockOverview()
    {

        $variant = $this->input->get('variant');
        if (empty($variant)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $check = $this->db->where('variant', $variant)->get('tbl_analytics_variant_list')->num_rows();
        if ($check > 0) {
            $json['status'] = 2; // Variant Already Exists
            echo json_encode($json);
            exit;
        }
        $variant_arr = array("variant" => $variant);

        $result = $this->db->insert('tbl_analytics_variant_list', $variant_arr);

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function removeVariantForStockOverview()
    {

        $variant = $this->input->get('variant');
        if (empty($variant)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $variant_arr = array("variant" => $variant);

        $result = $this->db->delete('tbl_analytics_variant_list', $variant_arr);

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getDaywiseStock()
    {


        $result = $this->db->order_by('date', 'desc')->get('tbl_daily_stock_overview')->result_array();

        if (empty($result)) {
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }
        foreach ($result as $rowValue) {

            $records[] = array(
                "date" => date("d-m-Y", strtotime($rowValue["date"])),
                "variant" => $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'],
                "rfs" => $rowValue['rfs'],
                "sold" => $rowValue['sold'],
                "inward" => $rowValue['inward'],
                "in_stock" => $rowValue['in_stock'],
                "cip" => $rowValue['cip'],
                "certified" => $rowValue['certified'],
                "faulted" => $rowValue['faulted'],
                "ber" => $rowValue['ber'],
                "triage" => $rowValue['triage'],
                "hold" => $rowValue['hold'],
                "service" => $rowValue['service'],
                "return" => $rowValue['return'],
                "lost" => $rowValue['lost'],
                "rtv" => $rowValue['rtv'],
                "for_service" => $rowValue['for_service'],
                "in_service" => $rowValue['in_service'],
                "total_stock" => $rowValue['total'],
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function getVariantSaletype()
    {
        $variant = $this->input->get('variant');

        if (empty($variant)) {
            $json['result'] = array();
            echo json_encode($json);
            exit;
        }
        $result = $this->db->where_in('variant', $variant)->order_by('total_stock', 'desc')->get('ANALYTICS_VARIANT_DETAIL_VIEW')->result_array();

        if (empty($result)) {

            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }
        $rfs = 0;
        $sold = 0;
        $in_stock = 0;
        $hold = 0;
        $faulted = 0;
        $total_stock = 0;

        foreach ($result as $rowValue) {
            if ($rowValue['saletype'] == 'ONLINE') {
                $online = array(
                    "saletype" => $rowValue['saletype'],
                    "rfs" => $rowValue['rfs'],
                    "sold" => $rowValue['sold'],
                    "in_stock" => $rowValue['in_stock'],
                    "hold" => $rowValue['hold'],
                    "faulted" => $rowValue['faulted'],
                    "total_stock" => $rowValue['total_stock'],
                    "other_stock" => $rowValue['total_stock'] - $rowValue['rfs'] - $rowValue['sold'] - $rowValue['in_stock'] - $rowValue['faulted'] - $rowValue['hold']
                );
            } elseif ($rowValue['saletype'] == 'OFFLINE') {
                $offline = array(
                    "saletype" => $rowValue['saletype'],
                    "rfs" => $rowValue['rfs'],
                    "sold" => $rowValue['sold'],
                    "in_stock" => $rowValue['in_stock'],
                    "hold" => $rowValue['hold'],
                    "faulted" => $rowValue['faulted'],
                    "total_stock" => $rowValue['total_stock'],
                    "other_stock" => $rowValue['total_stock'] - $rowValue['rfs'] - $rowValue['sold'] - $rowValue['in_stock'] - $rowValue['faulted'] - $rowValue['hold']
                );
            } else {
                $rfs += $rowValue['rfs'];
                $sold += $rowValue['sold'];
                $in_stock += $rowValue['in_stock'];
                $hold += $rowValue['hold'];
                $faulted += $rowValue['faulted'];
                $total_stock += $rowValue['total_stock'];
            }
        }

        $other = array(
            "saletype" => 'OTHER',
            "rfs" => $rfs,
            "sold" => $sold,
            "in_stock" => $in_stock,
            "hold" => $hold,
            "faulted" => $faulted,
            "total_stock" => $total_stock,
            "other_stock" => $total_stock - $rfs - $sold - $in_stock - $faulted - $hold
        );

        $json['status'] = 1;
        $json['online'] = $online;
        $json['offline'] = $offline;
        $json['other'] = $other;
        echo json_encode($json);
        die;
    }

    public function daywiseStockMovements()
    {
        $result = $this->db->order_by('date', 'desc')->get('DAILY_STOCK_MOVEMENTS')->result_array();

        if (empty($result)) {
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }
        foreach ($result as $rowValue) {

            $records[] = array(
                "date" => date("d-m-Y", strtotime($rowValue["date"])),
                "rfs" => $rowValue['rfs'],
                "sold" => $rowValue['sold'],
                "inward" => $rowValue['inward'],
                "in_stock" => $rowValue['in_stock'],
                "cip" => $rowValue['cip'],
                "certified" => $rowValue['certified'],
                "faulted" => $rowValue['faulted'],
                "ber" => $rowValue['ber'],
                "triage" => $rowValue['triage'],
                "hold" => $rowValue['hold'],
                "service" => $rowValue['service'],
                "return" => $rowValue['return'],
                "lost" => $rowValue['lost'],
                "rtv" => $rowValue['rtv'],
                "for_service" => $rowValue['for_service'],
                "in_service" => $rowValue['in_service'],
                "total_stock" => $rowValue['total'],
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function daywiseTransactions()
    {

        $result = $this->db->order_by('date', 'desc')->get('DAILY_TRANSACTION_VIEW')->result_array();

        if (empty($result)) {
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }
        foreach ($result as $rowValue) {

            $records[] = array(
                "date" => date("d-m-Y", strtotime($rowValue["date"])),
                "salesorders" => $rowValue['salesorders'],
                "invoices" => $rowValue['invoices'],
                "returns" => $rowValue['returns'],
                "claims" => $rowValue['claims'],
                "inward" => $rowValue['inward']
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function batchWiseDetails()
    {
        $statusList = ['IN_STOCK','INWARD', 'CIP', 'CERTIFIED', 'RFS', 'FAULTED', 'TRIAGE', 'BER', 'SOLD', 'FFC', 'IN_SERVICE', 'FOR_SERVICE', 'RTV', 'RETURN', 'HOLD', 'LOST'];

        // $this->db->where_in('saletype', array("ONLINE", "OFFLINE"));
        $this->db->select('batch_no, status, count(grnreport_id) as count, grn_inwarddate, stock_type, product_type');
        $this->db->group_by('batch_no, status');
        $result = $this->db->order_by('grn_inwarddate', 'desc')->get('tbl_grnreport')->result_array();

        if (empty($result)) {
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            die;
        }

        $batchDetails = array();
        $records = array();

        foreach ($result as $rowValue) {
            $batchNo = $rowValue['batch_no'];

            if($batchNo == null || $batchNo == 'null') $batch_no = 'NA';

            $batchDetails[$batchNo][$rowValue['status']] = $rowValue['count'];
            if(empty($batchDetails[$batchNo['grn_inwarddate']])){
                $batchDetails[$batchNo]['grn_inwarddate'] = date('d-m-Y', strtotime($rowValue['grn_inwarddate']));
		$batchDetails[$batchNo]['stock_type'] = $rowValue['stock_type'];
		$batchDetails[$batchNo]['product_type'] = $rowValue['product_type'];
            }
        }

        foreach($batchDetails as $batch => $statusCount){
            $total = 0;
            $recordRow['batch_no'] = $batch;
            $recordRow['grndate'] = $statusCount['grn_inwarddate'];
	    $recordRow['stock_type'] = $statusCount['stock_type'];
	    $recordRow['product_type'] = $statusCount['product_type'];
            foreach($statusList as $status){
                if(empty($statusCount[$status])){
                    $recordRow[$status] = 0; 
                }else{
                    $recordRow[$status] = $statusCount[$status]; 
                }
                $total += $statusCount[$status];
            }
            
            $recordRow['total'] = $total;
            $records[] = $recordRow;
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function getSalesData()
    {
        $period = $this->input->get('period');
        $sales_type = $this->input->get('sales_type');
        $records = [];

        $where_year = array(
            "DATE(CREATION_DATE) >= " => '2020-04-01',
        );

        $column = ["April", "May", "June", "July", "August", "September", "October", "November", "December", "January", "February", "March"];
        $this->db->where($where_year)->where('status in("INVOICED","SHIPPED", "PACKED","PART_RETURN")');

        $this->db->select('if(sales_channel = "OFFLINE", "OFFLINE", "ONLINE") as saletype, category, sum(price) as total_amount, sum(qty) as total_quantity, MONTHNAME(CREATION_DATE) as month, YEAR(CREATION_DATE) AS year');

        if ($sales_type == 'category') {
            $this->db->group_by('category, MONTH(CREATION_DATE), YEAR(CREATION_DATE)');
        } elseif ($sales_type == 'saletype') {
            $this->db->group_by('saletype, MONTH(CREATION_DATE), YEAR(CREATION_DATE)');
        } else {
            $this->db->group_by('MONTH(CREATION_DATE), YEAR(CREATION_DATE)');
        }
        $result = $this->db->get('INVOICE_EXPORT_VIEW')->result_array();
        //print $this->db->last_query();exit;
        foreach ($result as $rowValue) {
            $month = $rowValue['month'] . '-' . $rowValue['year'];
            if ($sales_type == 'category') {

                $records[$rowValue['category']][$month] = array(
                    "month" => $rowValue['month'],
                    "sales_type" => $rowValue['category'],
                    "sales_value" => $rowValue['total_amount'] / 100000,
                    "sales_units" => $rowValue['total_quantity']
                );
            } elseif ($sales_type == 'saletype') {

                $records[$rowValue['saletype']][$month] = array(
                    "month" => $rowValue['month'],
                    "sales_type" => $rowValue['saletype'],
                    "sales_value" => $rowValue['total_amount'] / 100000,
                    "sales_units" => $rowValue['total_quantity']
                );
            } else {
                $records['overall'][$month] = array(
                    "month" => $rowValue['month'],
                    "sales_type" => "overall",
                    "sales_value" => $rowValue['total_amount'] / 100000,
                    "sales_units" => $rowValue['total_quantity']
                );
            }
        }

        $where_ff_year = array(
            "DATE(sale_date) >= " => '2020-04-01',
        );

        $this->db->where($where_ff_year);
        $this->db->where('status in ("FINANCE_PENDING", "FINANCE_APPROVED")');
        $this->db->select('category, sum(price) as total_amount, count(*) as total_quantity, MONTHNAME(sale_date) as month, YEAR(sale_date) as year');
        if ($sales_type == 'category') {
            $this->db->group_by('category, MONTH(sale_date), YEAR(sale_date)');
        } else {
            $this->db->group_by('MONTH(sale_date), YEAR(sale_date)');
        }
        $this->db->join('tbl_ecom_invoice_item', 'tbl_ecom_invoice_item.ecom_invoice_id = tbl_ecom_invoice.ecom_invoice_id', 'Left');
        $ff_result = $this->db->get('tbl_ecom_invoice')->result_array();
        //print $this->db->last_query();exit;

        foreach ($ff_result as $rowValue) {
            $month = $rowValue['month'] . '-' . $rowValue['year'];
            if ($sales_type == 'category') {
                if (empty($records[$rowValue['category']][$month])) {
                    $records[$rowValue['category']][$month] = array(
                        "month" => $rowValue['month'],
                        "sales_type" => $rowValue['category'],
                        "sales_value" => $rowValue['total_amount'] / 100000,
                        "sales_units" => $rowValue['total_quantity']
                    );
                } else {
                    $sales_val = $records[$rowValue['category']][$month]["sales_value"] + $rowValue['total_amount'] / 100000;
                    $sales_units = $records[$rowValue['category']][$month]["sales_units"] + $rowValue['total_quantity'];
                    $records[$rowValue['category']][$month]["sales_value"] = $sales_val;
                    $records[$rowValue['category']][$month]["sales_units"] = $sales_units;
                }
            } elseif ($sales_type == 'saletype') {

                $records["FULFILLMENT"][$month] = array(
                    "month" => $rowValue['month'],
                    "sales_type" => "FULFILLMENT",
                    "sales_value" => $rowValue['total_amount'] / 100000,
                    "sales_units" => $rowValue['total_quantity']
                );
            } else {
                if (empty($records['overall'][$month])) {
                    $records['overall'][$month] = array(
                        "month" => $rowValue['month'],
                        "sales_type" => "overall",
                        "sales_value" => $rowValue['total_amount'] / 100000,
                        "sales_units" => $rowValue['total_quantity']
                    );
                } else {

                    $sales_val = $records['overall'][$month]["sales_value"] + $rowValue['total_amount'] / 100000;
                    $sales_units = $records['overall'][$month]["sales_units"] + $rowValue['total_quantity'];

                    $records['overall'][$month]["sales_value"] = $sales_val;
                    $records['overall'][$month]["sales_units"] = $sales_units;
                }
            }
        }

        $json['status'] = 1;
        $json['rows'] = $records;
        $json['columns'] = $column;
        echo json_encode($json);
        exit;
    }

    public function getPurchaseData()
    {
        $purchase_type = $this->input->get('purchase_type');
        $records = [];

        $where_year = array(
            "DATE(invoice_date) >= " => '2020-04-01',
            // "DATE(grn_inwarddate) <= " => '2021-03-31'
        );

        $column = ["April", "May", "June", "July", "August", "September", "October", "November", "December", "January", "February", "March"];

        $this->db->where($where_year);

        $this->db->select(' saletype, stock_type, sum(unit_price + unit_price_tax) as total_amount, count(grnreport_id) as total_quantity, MONTHNAME(invoice_date) as month,YEAR(invoice_date) as year');

        if ($purchase_type == 'category') {
            $this->db->group_by('stock_type, MONTH(invoice_date), YEAR(invoice_date)');
        } elseif ($purchase_type == 'saletype') {
            $this->db->group_by('saletype, MONTH(invoice_date), YEAR(invoice_date)');
        } else {
            $this->db->group_by('MONTH(invoice_date), YEAR(invoice_date)');
        }
        $result = $this->db->get('tbl_grnreport')->result_array();
        //print $this->db->last_query();exit;
        foreach ($result as $rowValue) {
            $month = $rowValue['month'] . '-' . $rowValue['year'];
            if ($purchase_type == 'category') {

                $records[$rowValue['stock_type']][$month] = array(
                    "month" => $rowValue['month'],
                    "purchase_type" => $rowValue['stock_type'],
                    "purchase_value" => $rowValue['total_amount'] / 100000,
                    "purchase_units" => $rowValue['total_quantity']
                );
            } elseif ($purchase_type == 'saletype') {

                $records[$rowValue['saletype']][$month] = array(
                    "month" => $rowValue['month'],
                    "purchase_type" => $rowValue['saletype'],
                    "purchase_value" => $rowValue['total_amount'] / 100000,
                    "purchase_units" => $rowValue['total_quantity']
                );
            } else {
                $records['overall'][$month] = array(
                    "month" => $rowValue['month'],
                    "purchase_type" => "overall",
                    "purchase_value" => $rowValue['total_amount'] / 100000,
                    "purchase_units" => $rowValue['total_quantity']
                );
            }
        }

        $json['status'] = 1;
        $json['rows'] = $records;
        $json['columns'] = $column;
        echo json_encode($json);
        exit;
    }

    public function getSalesDashboardSummary()
    {

        $sales_type = $this->input->get('sales_type');
        $records = [];

        $today_sales_value = 0;
        $week_sales_value = 0;
        $month_sales_value = 0;
        $total_sales_value = 0;
        $today_sales_qty = 0;
        $week_sales_qty = 0;
        $month_sales_qty = 0;
        $total_sales_qty = 0;

        $week_chart_sales_amount = [];
        $month_chart_sales_amount = [];
        $ytd_chart_sales_amount = [];
        $week_chart_sales_qty = [];
        $month_chart_sales_qty = [];
        $ytd_chart_sales_qty = [];

        $yesterday_sales_value = 0;
        $last_month_sales_value = 0;
        $last_week_sales_value = 0;

        $where_year = array(
            "DATE(CREATION_DATE) >= " => '2022-04-01',
        );

        $this->db->where($where_year)->where('status in("INVOICED","SHIPPED", "PACKED","PART_RETURN")');

        $this->db->select('sum(price) as total_amount, sum(qty) as total_quantity, MONTH(CREATION_DATE) as _month, WEEK(CREATION_DATE) AS _week, DATE(CREATION_DATE) AS _date');

        $this->db->group_by('DATE(CREATION_DATE)');

        $result = $this->db->get('INVOICE_EXPORT_VIEW')->result_array();
        //print $this->db->last_query();exit;
        foreach ($result as $rowValue) {

            $day = date("l", strtotime($rowValue['_date']));
            $date = date("d", strtotime($rowValue['_date']));
            $total_sales_value += $rowValue['total_amount'];
            $total_sales_qty += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d")) {
                $today_sales_value = $rowValue['total_amount'];
                $today_sales_qty = $rowValue['total_quantity'];
            }
            if ($rowValue['_week'] == date("W")) {
                $week_sales_value += $rowValue['total_amount'];
                $week_sales_qty += $rowValue['total_quantity'];
                $week_chart_sales_amount[$day] += $rowValue['total_amount'];
                $week_chart_sales_qty[$day] += $rowValue['total_quantity'];
            }
            if ($rowValue['_month'] == date("m")) {
                $month_sales_value += $rowValue['total_amount'];
                $month_sales_qty += $rowValue['total_quantity'];
                $month_chart_sales_amount[$date] += $rowValue['total_amount'];
                $month_chart_sales_qty[$date] += $rowValue['total_quantity'];
            }
            $ytd_chart_sales_amount[$rowValue['_month']] += $rowValue['total_amount'];
            $ytd_chart_sales_qty[$rowValue['_month']] += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d", strtotime("-1 days"))) {
                $yesterday_sales_value = $rowValue['total_amount'];
            }
            if ($rowValue['_week'] == date("W") - 1) {
                $last_week_sales_value += $rowValue['total_amount'];
            }
            if ($rowValue['_month'] == date("m") - 1) {
                $last_month_sales_value += $rowValue['total_amount'];
            }
        }

        $where_ff_year = array(
            "DATE(sale_date) >= " => '2022-04-01',
        );

        $this->db->where($where_ff_year);
        $this->db->where('status in ("FINANCE_PENDING", "FINANCE_APPROVED")');
        $this->db->select(' sum(price) as total_amount, count(*) as total_quantity, MONTH(sale_date) as _month, WEEK(sale_date) as _week, DATE(sale_date) as _date');

        $this->db->group_by('DATE(sale_date)');

        $this->db->join('tbl_ecom_invoice_item', 'tbl_ecom_invoice_item.ecom_invoice_id = tbl_ecom_invoice.ecom_invoice_id', 'Left');
        $ff_result = $this->db->get('tbl_ecom_invoice')->result_array();

        foreach ($ff_result as $rowValue) {

            $day = date("l", strtotime($rowValue['_date']));
            $date = date("d", strtotime($rowValue['_date']));
            $total_sales_value += $rowValue['total_amount'];
            $total_sales_qty += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d")) {
                $today_sales_value += $rowValue['total_amount'];
                $today_sales_qty += $rowValue['total_quantity'];
            }
            if ($rowValue['_week'] == date("W")) {
                $week_sales_value += $rowValue['total_amount'];
                $week_sales_qty += $rowValue['total_quantity'];
                $week_chart_sales_amount[$day] += $rowValue['total_amount'];
                $week_chart_sales_qty[$day] += $rowValue['total_quantity'];
            }
            if ($rowValue['_month'] == date("m")) {
                $month_sales_value += $rowValue['total_amount'];
                $month_sales_qty += $rowValue['total_quantity'];
                $month_chart_sales_amount[$date] += $rowValue['total_amount'];
                $month_chart_sales_qty[$date] += $rowValue['total_quantity'];
            }
            $ytd_chart_sales_amount[$rowValue['_month']] += $rowValue['total_amount'];
            $ytd_chart_sales_qty[$rowValue['_month']] += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d", strtotime("-1 days"))) {
                $yesterday_sales_value += $rowValue['total_amount'];
            }
            if ($rowValue['_week'] == date("W") - 1) {
                $last_week_sales_value += $rowValue['total_amount'];
            }
            if ($rowValue['_month'] == date("m") - 1) {
                $last_month_sales_value += $rowValue['total_amount'];
            }
        }

        $records = array(
            "today_value" => sprintf("%.2f", $today_sales_value / 100000),
            "week_value" => sprintf("%.2f", $week_sales_value / 100000),
            "month_value" => sprintf("%.2f", $month_sales_value / 100000),
            "year_value" => sprintf("%.2f", $total_sales_value / 100000),
            "today_qty" => $today_sales_qty,
            "week_qty" => $week_sales_qty,
            "month_qty" => $month_sales_qty,
            "year_qty" => $total_sales_qty,
            "yesterday_value" => sprintf("%.2f", $yesterday_sales_value / 100000),
            "last_week_value" => sprintf("%.2f", $last_week_sales_value / 100000),
            "last_month_value" => sprintf("%.2f", $last_month_sales_value / 100000),
        );

        $json['charts'] = array(
            "week_chart_sales_amount" => $week_chart_sales_amount,
            "week_chart_sales_qty" => $week_chart_sales_qty,
            "month_chart_sales_amount" => $month_chart_sales_amount,
            "month_chart_sales_qty" => $month_chart_sales_qty,
            "year_chart_sales_amount" => $ytd_chart_sales_amount,
            "year_chart_sales_qty" => $ytd_chart_sales_qty,

        );

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getPurchaseDashboardSummary()
    {
        $purchase_type = $this->input->get('purchase_type');
        $records = [];

        $today_purchase_value = 0;
        $week_purchase_value = 0;
        $month_purchase_value = 0;
        $total_purchase_value = 0;
        $today_purchase_qty = 0;
        $week_purchase_qty = 0;
        $month_purchase_qty = 0;
        $total_purchase_qty = 0;

        $yesterday_purchase_value = 0;
        $last_week_purchase_value = 0;
        $last_month_purchase_value = 0;

        $week_chart_purchase_amount = [];
        $month_chart_purchase_amount = [];
        $ytd_chart_purchase_amount = [];
        $week_chart_purchase_qty = [];
        $month_chart_purchase_qty = [];
        $ytd_chart_purchase_qty = [];

        $where_year = array(
            "DATE(invoice_date) >= " => '2022-04-01',
        );

        $this->db->where($where_year);
        $this->db->select('sum(unit_price + unit_price_tax) as total_amount, count(grnreport_id) as total_quantity, MONTH(invoice_date) as _month,WEEK(invoice_date) as _week, DATE(invoice_date) as _date');
        $this->db->group_by('DATE(invoice_date)');
        $result = $this->db->get('tbl_grnreport')->result_array();
        //print $this->db->last_query();exit;
        foreach ($result as $rowValue) {

            $day = date("l", strtotime($rowValue['_date']));
            $date = date("d", strtotime($rowValue['_date']));
            $total_purchase_value += $rowValue['total_amount'];
            $total_purchase_qty += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d")) {
                $today_purchase_value += $rowValue['total_amount'];
                $today_purchase_qty += $rowValue['total_quantity'];
            }
            if ($rowValue['_week'] == date("W")) {
                $week_purchase_value += $rowValue['total_amount'];
                $week_purchase_qty += $rowValue['total_quantity'];
                $week_chart_purchase_amount[$day] += $rowValue['total_amount'];
                $week_chart_purchase_qty[$day] += $rowValue['total_quantity'];
            }
            if ($rowValue['_month'] == date("m")) {
                $month_purchase_value += $rowValue['total_amount'];
                $month_purchase_qty += $rowValue['total_quantity'];
                $month_chart_purchase_amount[$date] += $rowValue['total_amount'];
                $month_chart_purchase_qty[$date] += $rowValue['total_quantity'];
            }
            $ytd_chart_purchase_amount[$rowValue['_month']] += $rowValue['total_amount'];
            $ytd_chart_purchase_qty[$rowValue['_month']] += $rowValue['total_quantity'];

            if ($rowValue['_date'] == date("Y-m-d", strtotime("-1 days"))) {
                $yesterday_purchase_value += $rowValue['total_amount'];
            }
            if ($rowValue['_week'] == date("W") - 1) {
                $last_week_purchase_value += $rowValue['total_amount'];
            }
            if ($rowValue['_month'] == date("m") - 1) {
                $last_month_purchase_value += $rowValue['total_amount'];
            }
        }
        $records = array(
            "today_value" => sprintf("%.2f", $today_purchase_value / 100000),
            "week_value" => sprintf("%.2f", $week_purchase_value / 100000),
            "month_value" => sprintf("%.2f", $month_purchase_value / 100000),
            "year_value" => sprintf("%.2f", $total_purchase_value / 100000),
            "today_qty" => $today_purchase_qty,
            "week_qty" => $week_purchase_qty,
            "month_qty" => $month_purchase_qty,
            "year_qty" => $total_purchase_qty,

            "yesterday_value" => sprintf("%.2f", $yesterday_purchase_value / 100000),
            "last_week_value" => sprintf("%.2f", $last_week_purchase_value / 100000),
            "last_month_value" => sprintf("%.2f", $last_month_purchase_value / 100000),
        );

        $json['charts'] = array(
            "week_chart_purchase_amount" => $week_chart_purchase_amount,
            "week_chart_purchase_qty" => $week_chart_purchase_qty,
            "month_chart_purchase_amount" => $month_chart_purchase_amount,
            "month_chart_purchase_qty" => $month_chart_purchase_qty,
            "year_chart_purchase_amount" => $ytd_chart_purchase_amount,
            "year_chart_purchase_qty" => $ytd_chart_purchase_qty,

        );

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function createStatsImage() {
		$data = $this->input->post('data');
		$src = $this->input->post('src');
        $img_about = '';

        $this->load->library('cliq_api');

        if ($src == 'certf') {
            $Res = $this->cliq_api->create_Dashboard_Certf_Image($data);
            $img_about = 'Certification Stats';
        }

        if (!isset($Res) || !isset($Res['img_locn'])) {
            GOTO ERROR;
        }
        
        echo json_encode([
            'status' => true,
            'message' => 'Stats Image created successfully',
            'img_locn' => $Res['img_locn'],
            'img_about' => $img_about
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => 'Something wrong'
        ]);
        exit;
    }

    public function sendStatsToCliqBot() {
		$img_locn = $this->input->post('img_locn');
		$img_about = $this->input->post('img_about');

        $this->load->library('cliq_api');

        $Res = $this->cliq_api->send_Image_to_CliqBot($img_locn, $img_about);
        
        echo json_encode([
            'status' => true,
            'message' => 'Image posted in Cliq Bot'
        ]);
        exit;

    }
    public function Save(){
        // $data = $_REQUEST('base64data');
        $image = explode('base64', $data);
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $image = explode('base64', $data);
        file_put_contents('assets/dashboard/erp_dashboard.png', base64_decode($image[1]));
        $this->cliq_api->postDashboardImage();
    }

    public function save_Dashboard_AccessLog() {
        $past_time = date('Y-m-d H:i:s', time() - (5*60));  /** 5min before time */
        $where_arr = [
            'user_id' => $this->session->userdata('user_id'),
            'access_end_date >' => $past_time,
        ];
        $access_id = $this->db->where($where_arr)->order_by('access_id', 'desc')->limit(1)->get('tbl_dashboard_access_log')->row()->access_id;

        if (empty($access_id)) {
            $ins = [
                'user_id' => $this->session->userdata('user_id'),
                'access_st_date' => date("Y-m-d H:i:s"),
                'access_end_date' => date("Y-m-d H:i:s"),
                'created_date' => date("Y-m-d H:i:s")
            ];
            $ins = $this->db->insert('tbl_dashboard_access_log', $ins);
            if ($this->db->error()['code'] != 0) {
                $msg = "Error in Creating Access Log";
                GOTO ERROR;
            }
            $access_id = $this->db->insert_id();

            if (empty($access_id)) {
                $msg = 'Error in Creating Access Log';
                GOTO ERROR;
            }
            $msg = 'Access Log Created Successfully';
        } else {
            $msg = 'Existing Access Log ID is fetched';
        }

        return [
            'status' => true,
            'message' => isset($msg)? $msg : 'Access Log Created Successfully',
            'access_log_id' => $access_id
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something Wrong'
        ];
    }

    public function update_Dashboard_AccessLog() {
        $request = file_get_contents('php://input', true);
		$req_obj = json_decode($request);

        $crnt_dt = date("Y-m-d H:i:s");

        $where_arr = [
            'access_id' => $req_obj->access_log_id,
            'user_id' => $this->session->userdata('user_id'),
        ];
        $data = [
            'access_end_date' => $crnt_dt,
            'updated_date' => $crnt_dt
        ];
        $ins = $this->db->where($where_arr)->update('tbl_dashboard_access_log', $data);
        if ($this->db->error()['code'] != 0) {
            $msg = "Error in updating Access Log";
            GOTO ERROR;
        }

        echo json_encode([
            'status' => true,
            'message' => 'Access Log Updated Successfully',
            'access_log_id' => $req_obj->access_log_id,
            'access_updated_date' => $crnt_dt
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something Wrong'
        ]);
        exit;
    }

    public function update_DashboardCards_AccessLog() {
        $request = file_get_contents('php://input', true);
		$req_obj = json_decode($request);

        // $crnt_dt = date("Y-m-d H:i:s");

        $access_id = $req_obj->access_log_id;
        $card_id = $req_obj->card_id;
        $from_date = $req_obj->from_date;
        $to_date = $req_obj->to_date;
        $card_access_type = $req_obj->card_access_type;


        $range_column = ($card_access_type == 'reports')? 'reports_date_range' : 'searches_date_range';
        $new_range = $from_date .':'. $to_date;

        $where_arr = [
            'access_id' => $access_id,
            'user_id' => $this->session->userdata('user_id'),
        ];
        $rs = $this->db->where($where_arr)->get('tbl_dashboard_access_log')->result_array();
        if (count($rs) == 0) {
            $msg = 'Invalid Access ID';
            GOTO ERROR;
        }

        $card_where_arr = [
            'access_id' => $access_id,
            'card_id' => $card_id,
        ];
        $rs = $this->db->where($card_where_arr)->get('tbl_dashboard_cards_access')->result_array();
        if (count($rs) == 0) {
            $data = [
                'access_id' => $access_id,
                'card_id' => $card_id,
                $range_column => $new_range,
                'created_date' => date("Y-m-d H:i:s"),
            ];

            $save_status = $this->db->insert('tbl_dashboard_cards_access', $data);

        } else {
            $range_arr = [];
            if (isset($rs[0][$range_column])) {
                $range_arr = explode(',', $rs[0][$range_column]);
            }
            if (in_array($new_range, $range_arr)) {
                $msg = 'Date Range added successfully';
                GOTO RESPONSE;
            } else {
                $range_arr[] = $new_range;
            }

            $data = [
                // 'access_id' => $access_id,
                // 'card_id' => $card_id,
                $range_column => implode(',', $range_arr),
                'updated_date' => date("Y-m-d H:i:s"),
            ];

            $save_status = $this->db->where($card_where_arr)->update('tbl_dashboard_cards_access', $data);
        }

        if ($this->db->error()['code'] != 0) {
            $msg = "Error in updating Card Access Log";
            GOTO ERROR;
        }

        RESPONSE:
        echo json_encode([
            'status' => true,
            'message' => 'Card-Access Log Updated Successfully',
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something Wrong'
        ]);
        exit;
    }

    public function get_Dashboard_AccessLog() {

        $last_fewdays = 7;

        $sub_query = '(
                SELECT user_id, COUNT(access_id) AS last_fewdays_accessed_cnt, 
                SUM(TIMESTAMPDIFF(SECOND, access_st_date, access_end_date)) AS last_fewdays_accessed_duration
                FROM tbl_dashboard_access_log
                WHERE access_st_date >= date_add(curdate(), interval -'. $last_fewdays .' day)
                GROUP BY user_id
            ) AS log2';

        $rs = $this->db->from('tbl_dashboard_access_log AS log')
                 ->join('tbl_users AS u', 'u.user_id = log.user_id')
                 ->join('tbl_account_details AS ad', 'ad.user_id = log.user_id')
                 ->join($sub_query, 'log2.user_id = log.user_id', 'LEFT')
                 ->where('log.access_id IN (SELECT MAX(access_id) AS access_id FROM tbl_dashboard_access_log GROUP BY user_id)')
                 ->select('log.access_id, log.user_id, u.username, ad.fullname, log.access_st_date AS last_accessed_on, TIMESTAMPDIFF(SECOND, log.access_st_date, log.access_end_date) as last_accessed_duration')
                 ->select('IF (log2.last_fewdays_accessed_cnt IS NULL, 0, log2.last_fewdays_accessed_cnt) AS last_fewdays_accessed_cnt')
                 ->select('IF (log2.last_fewdays_accessed_duration IS NULL, 0, log2.last_fewdays_accessed_duration) AS last_fewdays_accessed_duration')
                 ->get()->result_array();
                //  ->get_compiled_select();
                //  echo $rs; exit;
        
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($rs),"recordsFiltered"=>count($rs),"data"=>$rs));
		exit;
    }



    public function get_PurchaseCatgWise_Data() {
        $request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);


        /** Fetching Invoice Qty and Invoice Value */

        $sql = "SELECT 
                    v.stock_type,
                    SUM(v.invoice_qty) AS invoice_qty,
                    SUM(v.invoice_value) AS invoice_value,
                    SUM(v.short_devices) AS short_devices
                FROM
                    (SELECT 
                        sa.admin_id,
                        sa.invoice_no,
                        sa.invoice_date,
                        sa.invoice_qty,
                        sa.invoice_value,
                        sa.short_devices,
                        d.stock_type
                    FROM
                        tbl_security_admin AS sa
                    INNER JOIN tbl_vendor AS v ON v.vendor_id = sa.supplier_id
                    INNER JOIN (SELECT 
                        d.invoice_no, d.vendor_code, d.invoice_date, d.stock_type
                    FROM tbl_grnreport AS d
                    GROUP BY d.invoice_no , d.vendor_code
                        ) AS d ON (d.invoice_no = sa.invoice_no AND d.vendor_code = v.vendor_code)
                    WHERE
                        sa.status != 'INWARD_CANCEL'
                    GROUP BY sa.admin_id) AS v
                WHERE
                    v.invoice_date >= '". $request_obj->start_date ."'
                        AND v.invoice_date <= '". $request_obj->end_date ."'
                GROUP BY v.stock_type";

        
        $rs = $this->db->query($sql)->result_array();

        $Res_inv = [];
        foreach($rs as $obj) {
            if (in_array($obj['stock_type'], ['BUYBACK', 'BUY BACK'])) {
                $obj['stock_type'] = 'BUY BACK';
            }
            if (isset($Res_inv[$obj['stock_type']])) {
                $temp = $Res_inv[$obj['stock_type']];

                // $temp['stock_type'] = $obj['stock_type'];
                $temp['invoice_qty'] = (int) $temp['invoice_qty'] + (int) $obj['invoice_qty'];
                $temp['invoice_value'] = (int) $temp['invoice_value'] + (int) $obj['invoice_value'];

                $temp['inward_qty'] = 0;
                $temp['inward_value'] = 0;

                $Res_inv[$obj['stock_type']] = $temp;
            } else {
                $Res_inv[$obj['stock_type']] = $obj;
            }
        }



        /** Fetching Inward Qty and Inward Value */


        $where_cond = " d.invoice_date >= '". $request_obj->start_date ."' AND d.invoice_date <= '". $request_obj->end_date ."' ";
        $where_cond .= " AND d.status != 'INWARD_CANCEL' ";

        if ($request_obj->status == 'RTV') {
            $where_cond .= " AND  d.status = 'RTV'";
        } else {
            $where_cond .= " AND  d.status != 'RTV'";
        }

        $sql = "SELECT v.category AS stock_type, SUM(v.invoice_qty) AS invoice_qty, SUM(v.invoice_value) AS invoice_value, SUM(v.inward_qty) AS inward_qty, SUM(v.inward_value) AS inward_value
                FROM ( SELECT d.category, d.invoice_qty, d.invoice_value, COUNT(d.device_id) AS inward_qty, (SUM(d.unit_price) + SUM(d.unit_price_tax)) AS inward_value
                FROM PURCHASE_ITEM_WISE_EXPORT_VIEW AS d
                WHERE 
                 $where_cond
                GROUP BY d.invoice_no, d.vendor_code
                ) AS v
                GROUP BY v.category";

        // $sql = "SELECT v.stock_type, SUM(v.invoice_qty) AS invoice_qty, SUM(v.invoice_value) AS invoice_value, 
        //         SUM(v.inward_qty) AS inward_qty, SUM(v.inward_value) AS inward_value
        // FROM (
        // SELECT 
        //     sa.admin_id,
        //     sa.invoice_no,
        //     sa.invoice_date,
        //     sa.invoice_qty,
        //     sa.invoice_value,
        //     d.stock_type, 
        //     d.inward_qty,
        //     d.inward_value
        // FROM
        //     tbl_security_admin AS sa
        // INNER JOIN 
        //     tbl_vendor AS v  ON  v.vendor_id = sa.supplier_id	 
        // INNER JOIN 
        // (
        //     SELECT d.invoice_no, d.vendor_code, d.invoice_date, d.stock_type, 
        //         COUNT(d.grnreport_id) AS inward_qty,
        //         (SUM(d.unit_price) + SUM(d.unit_price_tax)) AS inward_value
        //     FROM tbl_grnreport  AS  d
        //     WHERE d.grnreport_id is not null $where_cond
        //     GROUP BY d.invoice_no, d.vendor_code
        // ) AS d  ON  ( d.invoice_no = sa.invoice_no  AND d.vendor_code = v.vendor_code )
        // WHERE sa.invoice_date >= '". $request_obj->start_date ."' AND sa.invoice_date <= '". $request_obj->end_date ."'
        // GROUP BY sa.admin_id
        // ) AS v
        // GROUP BY v.stock_type";

        $rs = $this->db->query($sql)->result_array();

        $Res = [];
        foreach($rs as $obj) {
            if (in_array($obj['stock_type'], ['BUYBACK', 'BUY BACK'])) {
                $obj['stock_type'] = 'BUY BACK';
            }
            if (isset($Res[$obj['stock_type']])) {
                $temp = $Res[$obj['stock_type']];

                $temp['inward_qty'] = (int) $temp['inward_qty'] + (int) $obj['inward_qty'];
                $temp['inward_value'] = (int) $temp['inward_value'] + (int) $obj['inward_value'];

                $Res[$obj['stock_type']] = $temp;
            } else {
                $Res[$obj['stock_type']] = $obj;
            }
        }
        
        /** Merging Invoice Qty & Values with Inward Qty & Values */

        foreach($Res_inv as $catg => $obj) {
            $Res_inv[$catg]['inward_qty'] = isset($Res[$catg]['inward_qty'])? $Res[$catg]['inward_qty'] : 0;
            $Res_inv[$catg]['inward_value'] = isset($Res[$catg]['inward_value'])? $Res[$catg]['inward_value'] : 0;
        }

        echo json_encode($Res_inv);
        exit;
    }
    
	public function getAmazon_Returns() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$data = [];
		
		/** AMAZON-FBA (API) RETURNS*/
		$rs = $this->db->from('tbl_amazon_fba_returns AS rt')
					->join('tbl_amazon_orders_data AS ord', 'ord.amazon_order_id = rt.amazon_order_id AND ord.asin = rt.asin', 'INNER')
					->where('date(rt.return_date) >=', $request_obj->start_date)
					->where('date(rt.return_date) <=', $request_obj->end_date)
					->select('COUNT(DISTINCT rt.amazon_order_id) AS total_invoices, SUM(rt.quantity) AS total_qty, SUM(ord.item_price / ord.quantity * rt.quantity) AS total_amount')
					->get()->result_array();
					// ->get_compiled_select();echo $rs; exit;
                    
		if (count($rs) == 0) {
			GOTO ERROR;
		}
		$data['FBA'] = [
            'is_api_data' => true,
			'total_invoices' => (int) $rs[0]['total_invoices'],
			'total_qty' => (int) $rs[0]['total_qty'],
			'total_amount' => (int) $rs[0]['total_amount'],
		];

        /** AMAZON-SELLERFLEX (ERP) RETURNS  &&&  OFFLINE (ERP) RETURNS  */

        $rs = $this->db->from('tbl_salesreturn_item AS sri')
              ->join('tbl_salesreturn AS sr', 'sr.salesreturn_id = sri.salesreturn_id')
              ->join('tbl_invoice_item AS ini', 'ini.invoice_item_id = sri.invoice_item_id')
              ->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id')
              ->join('tbl_grnreport AS d', 'd.grnreport_id = sri.device_id')
              ->where_not_in('sr.status', ['VOID', 'CANCEL', 'CANCELLED', '--LOST_IN_TRANSIT'])
            //   ->where_in('inv.sales_channel', ['AMAZON', 'SELLERFLEX'])
              ->where('DATE(sr.last_modified) >=', $request_obj->start_date)
              ->where('DATE(sr.last_modified) <=', $request_obj->end_date)
              ->select('inv.sales_channel, count(DISTINCT inv.invoice_id) as invoice_cnt, count(DISTINCT sri.salesreturn_id) as return_cnt, count(DISTINCT sri.salesreturnitem_id) as qty_cnt, SUM(ini.price) AS return_value')
              ->group_by('inv.sales_channel')
              ->get()
              ->result_array();
        
        $data['SELLERFLEX'] = $data['OFFLINE'] = [
            'is_api_data' => false,
			'total_invoices' => 0,
			'total_qty' => 0,
			'total_amount' => 0,
		];

        foreach($rs as $obj) {
            if (in_array($obj['sales_channel'], ['OFFLINE', 'DEALERAPP'])) {
                $obj['sales_channel'] = 'OFFLINE';
            }

            if (isset($data[$obj['sales_channel']])) {
                $data[$obj['sales_channel']]['is_api_data'] = false;
                $data[$obj['sales_channel']]['total_invoices'] += (int) $obj['invoice_cnt'];
                $data[$obj['sales_channel']]['total_qty'] += (int) $obj['qty_cnt'];
                $data[$obj['sales_channel']]['total_amount'] += (float) $obj['return_value'];
            } else {
                $data[$obj['sales_channel']]['is_api_data'] = false;
                $data[$obj['sales_channel']]['total_invoices'] = (int) $obj['invoice_cnt'];
                $data[$obj['sales_channel']]['total_qty'] = (int) $obj['qty_cnt'];
                $data[$obj['sales_channel']]['total_amount'] = (float) $obj['return_value'];
            }
        }

		echo json_encode([
			'status' => true,
			'data' => $data
		]);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something wrong'
		]);
        exit;
	}
    
	public function getTriageStatistics() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$url = 'https://optimiage.sloyd.in/admin/Web_api/serviceEngineerData';

		$payload = [
			'from_date' => $request_obj->from_date,
			'to_date' => $request_obj->to_date,
		];

		/** START:: CURL Call */

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($req_data));
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $payload ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$server_output = curl_exec($ch);
		curl_close($ch);

		/** END:: CURL Call */

		echo($server_output);
		exit;
	}
    
	public function getTriage_Productivity_CatgWise() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$url = 'https://insightopti.sloyd.in/device-allocation/worksheet/allocation';

		$payload = [
			'start_date' => $request_obj->from_date,
			'end_date' => $request_obj->to_date,
		];

		/** START:: CURL Call */

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($req_data));
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $payload ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$server_output = curl_exec($ch);
		curl_close($ch);

		/** END:: CURL Call */

		echo($server_output);
		exit;
	}

	public function getTriage_SpareProcurement_CatgWise() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$url = 'https://insightopti.sloyd.in/procurement/spares/procurement-category';

		$payload = [
			'start_date' => $request_obj->from_date,
			'end_date' => $request_obj->to_date,
		];

		/** START:: CURL Call */

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($req_data));
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $payload ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$server_output = curl_exec($ch);
		curl_close($ch);

		/** END:: CURL Call */

		echo($server_output);
		exit;
	}

	public function getTriage_SpareReturns_CatgWise() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$url = 'https://insightopti.sloyd.in/procurement/spares/return';

		$payload = [
			'start_date' => $request_obj->from_date,
			'end_date' => $request_obj->to_date,
		];

		/** START:: CURL Call */

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($req_data));
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $payload ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$server_output = curl_exec($ch);
		curl_close($ch);

		/** END:: CURL Call */

		echo($server_output);
		exit;
	}

}
