<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Amazon extends Admin_Controller
{

    public function __construct() {
        parent::__construct(); 
		/*load model*/
		// $this->load->model('TaskEfficiency_model', 'taskefficiency_model');

		$this->load->library('Amazon_Api', 'amazon_api');
    }

    public function manage($activeId = 1) {
		$data['active'] = $activeId;
		
		$data['pageName'] = 'For IT';

        $data['title'] = "For IT"; //Page title 
        $data['subview'] = $this->load->view('admin/amazon/manage_view', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function generate_ReportOrderId() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
        $Res = $this->amazon_api->createReport($data);

		if (!$Res['status']) {
			$msg = $Res['message'];
			$err = $Res['error'];
			GOTO ERROR;
		}

		$reportId = $Res['reportId'];

		if (isset($Res['requested_date'])) {
			// $requested_date = $Res['requested_date'];
			GOTO RESPONSE;
		}
		
        $Res = $this->amazon_api->getReport($reportId);

		RESPONSE:
		echo json_encode($Res);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something went wrong',
			'error' => isset($err)? $err : '',
		]);
		exit;
	}

	public function fetch_generated_OrderReport() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
        $Res = $this->amazon_api->getReportDocument($data->reportId);

		if (!$Res['status']) {
			$msg = $Res['message'];
			$err = $Res['error'];
			GOTO ERROR;
		}

		
		RESPONSE:
		echo json_encode($Res);
		exit;
		
		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something went wrong',
			'error' => isset($err)? $err : '',
		]);
		exit;
	}

	public function fetch_OrderReport_Data() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);
		
        $Res = $this->amazon_api->getReport_Data($data->reportId);

		if (!$Res['status']) {
			$msg = $Res['message'];
			$err = $Res['error'];
			GOTO ERROR;
		}

		
		RESPONSE:
		echo json_encode($Res);
		exit;
		
		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something went wrong',
			'error' => isset($err)? $err : '',
		]);
		exit;
	}

	public function get_AmazonOrdersList() {
		$status = $_POST['status'];

		$is_added_inERP = 0;
		if ($status == 'YTA') {
			$is_added_inERP = 0;
		} else if ($status == 'DONE') {
			$is_added_inERP = 1;
		}

		$query = $this->db->from('tbl_amazon_orders_data')
					->where('item_status !=', 'Cancelled')
					->select('amazon_order_id, purchase_date, GROUP_CONCAT(asin ORDER BY package_index SEPARATOR ",") AS asins, GROUP_CONCAT(fnsku ORDER BY package_index SEPARATOR ",") AS fnskus, SUM(quantity) AS total_quantity, SUM(item_price) AS total_price, item_status, is_added_inERP');

		if ($status != 'ALL') {
			$query->where('is_added_inERP', $is_added_inERP);
		}

		$result = $query->group_by('amazon_order_id')->get()->result_array();
		
		echo json_encode(array("draw"=>1,"recordsTotal"=>count($result),"recordsFiltered"=>count($result),"data"=>$result));
		exit;
	}
}