<?php

use function PHPSTORM_META\type;

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Web_api extends MY_Controller
{
    public $view = "";

    public function __construct()
    {
        parent::__construct();  
		$this->load->model('stamphistory_model');
		$this->load->model('api_model');
    }
    
 
	public function getAllRfsProduct()
	{ 
 
		$cond="((stock_type='PREXO' and qc_status='QC PASS') OR stock_type='OPEN BOX')";
		
		$rfsResult=$this->db->where($cond)->where(array('productid_status'=>'1','fullqc_nhdpvalue >'=>'0.00','nhop_value >'=>'0.00','nhwp_value >'=>'0.00'))->group_by('product_id')->get('tbl_readyforsale')->result_array();

		if(!empty($rfsResult))
		{
			$json['status']='1';
			 
			foreach($rfsResult as $rfsResultValue)
			{
				$totalLotBuyingQty=0;$totalQty=0;$stock=0;
				
				$lotBuyingResult=$this->db->select('SUM(lotbuyingproduct_qty) as totalQty')->where(array('productid_status'=>'1','product_id'=>$rfsResultValue['product_id']))->get('tbl_readyforsale')->row_array();
				
				$productQtyResult=$this->db->select('COUNT(sale_id) as totalQty')->where(array('productid_status'=>'1','product_id'=>$rfsResultValue['product_id']))->get('tbl_readyforsale')->row_array();
 		
				if($lotBuyingResult['totalQty']!='')
				{
					$totalLotBuyingQty=$lotBuyingResult['totalQty'];
				}
				
				if($productQtyResult['totalQty']!='')
				{
					$totalQty=$productQtyResult['totalQty'];
				}
				
				$stock=$totalQty-$totalLotBuyingQty;
				
				if($stock<0)
				{
					$stock='0';
				}

				$json['result'][]=array( 
					'device_type'=>$rfsResultValue['device_type'], 
					'product_name'=>$rfsResultValue['product_name'],
					'product_id'=>$rfsResultValue['product_id'],
					'product_brand'=>$rfsResultValue['device_brand'],
					'nhdin'=>$rfsResultValue['nhdin'],
					'warehouse'=>$rfsResultValue['warehouse'],
					'stock_type'=>$rfsResultValue['stock_type'],
					'qty'=>$stock,
					'color'=>$rfsResultValue['color'],
					'ram'=>$rfsResultValue['ram'],
					'rom'=>$rfsResultValue['rom'],
					'front_camera'=>$rfsResultValue['front_camera'],
					'primary_camera'=>$rfsResultValue['primary_camera'],
					'display'=>$rfsResultValue['display'],
					'processor'=>$rfsResultValue['processor'],
					'sim_type'=>$rfsResultValue['sim_type'],
					'clock_speed'=>$rfsResultValue['clock_speed'],
					'os'=>$rfsResultValue['os'],
					'battery'=>$rfsResultValue['battery'],
					'weight'=>$rfsResultValue['weight'],
					'network_brand'=>$rfsResultValue['network_brand'],
					'network_type'=>$rfsResultValue['network_type'],
					'device_condition'=>$rfsResultValue['device_cond'],
					'device_category'=>$rfsResultValue['device_category'],
					'device_category2'=>$rfsResultValue['device_category2'],
					'nhpp'=>$rfsResultValue['nhpp'],		 
					'nhwp'=>$rfsResultValue['nhwp_value'],		 
					'nhdp'=>$rfsResultValue['fullqc_nhdpvalue'],		 
					'hotdeals_status'=>$rfsResultValue['hotdeals_status'],		 
					'newarrivals_status'=>$rfsResultValue['newarrivals_status'],		 
					'trending_status'=>$rfsResultValue['trending_status'],		 
					'bestselling4g_status'=>$rfsResultValue['bestselling4g_status'],		 
					'refurbshied_status'=>$rfsResultValue['refurbshied_status'],		 
					'unboxed_status'=>$rfsResultValue['unboxed_status'],		 
					'laptop_status'=>$rfsResultValue['laptop_status'],		 
					'macbook_status'=>$rfsResultValue['macbook_status'],			 
					'lotbuyingproduct_no'=>$rfsResultValue['lotbuyingproduct_no'],			 
					'lotbuyingproduct_qty'=>$rfsResultValue['lotbuyingproduct_qty'],			 
				);
			}			
		}
		else
		{
			$json['status']='0';
			$json['msg']='RFS Data Not Found';			
		}
		 
		echo json_encode($json);
		die;
	}
	
    public function printCreateInvoiceData($invoiceCode)
	{    
		$data['result']=$this->db->select('created_date,order_id,tax_type,invoice_code,address,mobile,gst,pincode,name,payment_mode,imei,sale_channel,nhdin,vendor_code,state,bill_type,nhsp,nhpp,hsn_code,product_name,invoice_refno')->where('invoice_code',$invoiceCode)->get('tbl_createinvoice')->result_array(); 
 
		if(!empty($data['result']))
		{  
			$this->load->view('admin/finance/pdf_html/invoice_html',$data);
		}
		else
		{
			set_message('error','INVOICE NOT FOUND.PLEASE CHECK.');
			
			redirect($_SERVER['HTTP_REFERER']);
		}
		
	} 
	
	public function chkRelatedInvoice($orderId)
	{
		$result=$this->db->select('invoice_code')->where('order_id',$orderId)->get('tbl_createinvoice')->row_array();
		
		if(!empty($result))
		{
			$json['status']='1';
			$json['invoice_code']=$result['invoice_code'];
		}
		else
		{
			$json['status']='0'; 
		}
		
		echo json_encode($json);
		die;
	}
	
	public function getLastStampStatus($nhdin)
	{
		$result=$this->stamphistory_model->getNhdinLastStampStatus($nhdin);
		$json['status']=$result;
		echo json_encode($json);
		die;
	}
	
	public function getStockResult($categoryId)
	{
		$cond='';
		
		if($categoryId=='1')
		{
			$cond="productid_status='1' and status='1' and stock_type='PREXO' and (device_type='Smartphone' or device_type='Feature Phone' or device_type='Mobile Accessories' or device_type='Other Phones' )";
		}
		else if($categoryId=='2')
		{
			$cond="productid_status='1' and status='1' and stock_type='OPEN BOX' and (device_type='Smartphone' or device_type='Feature Phone' or device_type='Mobile Accessories' or device_type='Other Phones' )";
		}
		else if($categoryId=='3')
		{
			$cond="productid_status='1' and status='1' and (device_type='laptop' or device_type='MacBook')";
		}
		
		$json['status']='0';
		$json['result']='';
		
	    if($cond!='')
		{
			$result=$this->db->select('SUM(sale_id) as total,ram,product_name,device_category,fullqc_nhdpvalue')->where($cond)->group_by('product_id')->get('tbl_readyforsale')->result_array();
			 
			if(!empty($result))
			{
				$product=array();
				
				$json['status']='1';
				
				foreach($result as $value)
				{
					$product[]=array(
						'name'=>$value['product_name'],
						'device_category'=>$value['device_category'],
						'ram'=>$value['ram'],
						'quantity'=>$value['total'],
						'price'=>$value['fullqc_nhdpvalue'],
					);
				}
				
				$json['result']=$product;
			}
		}
		
		echo json_encode($json);
		die;
	}

	public function getSalesreps(){
		$result=$this->api_model->getSalesreps();
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value)
				{
					$salesrep[]=array(
						'name'=>$value["fullname"],
						'sales_code'=>$value["sales_code"],
						'user_id'=>$value["user_id"],
						'department_id'=>$value["department_id"],
						'sales_area' => isset($value['sales_area'])? explode(',', $value['sales_area']): []
					);
				}
				$json['result']=$salesrep;
		}
		echo json_encode($json);
		die;
	}

	public function getProductBrand(){
		$result=$this->api_model->getProductBrand();
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value)
				{
					$brand[]=array(
						'name'=>$value["product_brand"]
					);
				}
				$json['result']=$brand;
		}
		echo json_encode($json);
		die;
	}

	public function getProductDetails(){
		$data=$this->input->get('brand_name');
		$result=$this->api_model->getProductDetails($data);
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value)
				{
					$brand[]=array(
						'product_name'=>$value["device_name"],
						'ram'=>$value["ram"],
						'rom'=>$value["rom"],
						'color'=>$value["color"],
						'color_code'=>$value["color_code"],
						'model_id'=>$value["nhmod"]
					);
				}
				$json['result']=$brand;
		}
		echo json_encode($json);
		die;
	}

	public function getstock(){
		$data=$this->input->get('product_name');
		$result=$this->api_model->getstock($data);
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value)
				{
					$brand[]=array(
						'stock'=>$value["stock"]
					);
				}
				$json['result']=$brand;
		}
		echo json_encode($json);
		die;
	}

	public function getsalesorderdetails(){
		$data=$this->input->get('salesorder_id');
		$result=$this->api_model->getsalesorderdetails($data);
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value){
					$salesorder[]=array(
						'product_name'=>$value["device_name"],
						'device_id'=>$value["nhdin"],
						'brand'=>$value["brand"],
						'ram'=>$value["ram"],
						'rom'=>$value["rom"],
						'model_id'=>$value["model_id"],
						'price'=>$value["sale_price"],
						'quantity'=>$value["quantity"],
						'amount'=>$value["amount"],
						'sku'=>$value["sku"],
						'category'=>$value['category'],
						'color'=>$value['color'],
						'grade'=>$value['grade'],
						'sales_terms'=>$value['sales_terms'],
						'remarks_finance'=>$value['remarks_finance'],
						'salesorder_item_id'=>$value["salesorder_item_id"]
					);
				}
				$json['result']=$salesorder;
		}
		echo json_encode($json);
		die;
	}

	public function getWarehouse(){
		$result=$this->api_model->getWarehouseList();
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value){
					$salesorder[]=array(
						'warehouse'=>$value["warehouse"],
						'location'=>$value["warehouse"],
						'short_code'=>$value["short_code"]
					);
				}
				$json['result']=$salesorder;
		}
		echo json_encode($json);
		die;
	}

	public function getGradewiseStock(){
		$input=$this->input->get();
		$modelid=$input['model_id'];
		$category=$input['category'];
		$variant=$input['variant'];
		$result=$this->api_model->gradewise_stock($modelid,$category,$variant);
		$json['status']='1';

		if(!empty($result)){
			$json['stock']=$result['stock'];
			$json['reserved']=$result['reserved'];
		}
		echo json_encode($json);
		die;
	}

	public function getRemarks(){
		$input = $this->input->get();
		$id=$input['id'];
		$type=$input['type'];
		$result=$this->api_model->getRemarks($id,$type);
		if(!empty($result)){
			$json["status"]=1;
			foreach($result as $value){
				$remarks[]=array(
					"remark"=>$value["remark"],
					"user_id"=>$value["user_id"],
					"username"=>$value["username"],
					"date"=>date("d-m-Y",strtotime($value["date"]))
				);
			}
			$json["remarks"]=$remarks;
		}else{
			$json["status"]=0;
		}

		echo json_encode($json);
		die;

	}

	public function getGradewiseStock_sku(){
		$sku=$this->input->get('sku');
		$category=$this->input->get('category');
		if($category!='' && $sku!=''){
			$result=$this->api_model->getcolor_sku($sku);
			if(!empty($result)){
				$skuVal=explode("-",$sku);
				$data["color"]=$result->color;
				$data["brand"]=$result->product_brand;
				$data["device_name"]=$result->device_name;
				$variant=$skuVal[1].'-'.$skuVal[2].'-'.$result->color;
				$result2=$this->api_model->gradewise_stock($skuVal[0],$category,$sku);
				if(!empty($result2)){
					$data['stock']=$result2['stock'];
					$data['reserved']=$result2['reserved'];
					$data["status"]=1;
				}
			}else{
				$data["status"]=0;
			}
		}else{
			$data["status"]=0;
		}
		echo json_encode($data);
		die;
	}

	public function getBulk_SkuGradewise_Stock() {
		$request = file_get_contents('php://input', true);
		$req_data = json_decode($request, true);
		
		$avble_stock = [];

		foreach($req_data as $k => $v) {
			$sku = $v['sku'];
			$category = $v['category'];
			$certf_grade = $v['grade'];
			
			$result = $this->api_model->getcolor_sku($sku);

			if (empty($result)) {
				$msg = "Something wrong with SKU: ". $sku ." ; Category: ". $category;
				GOTO ERROR;
			}

			$skuVal = explode("-",$sku);
			// $variant = $skuVal[1].'-'.$skuVal[2].'-'.$result->color;


			$rs_avblty = $this->api_model->SkuGrade_StockAvblty($skuVal[0],$category,$sku, $certf_grade);
			
			if (empty($rs_avblty)) {
				$msg = "Something wrong with SKU: ". $sku ." ; Category: ". $category;
				GOTO ERROR;
			}

			$temp_avble_stock = [];
			$temp_avble_stock['device_name'] = $result->device_name;
			$temp_avble_stock['brand'] = $result->product_brand;
			$temp_avble_stock['color'] = $result->color;
			$temp_avble_stock['avblty'] = $rs_avblty['avblty'];
			// $temp_avble_stock['avblty_details'] = $rs_avblty;


			$avble_stock[$sku][$category][$certf_grade] = $temp_avble_stock;
		}

		echo json_encode([
			'status' => true,
			'data' => $avble_stock
		]);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something went wrong'
		]);
		exit;
	}

	public function getVendorList(){
		$records = array();
		$type = $this->input->get('type');
		$used_type = $this->input->get('used_type');
		$alias = $this->input->get('alias');
		if(!empty($type)){
			$this->db->where('user_type', $type);
		}

		if(!empty($used_type)){
			$this->db->where('used_type', $used_type);
		}

		if(!empty($alias)){
			$this->db->where('alias', $alias);
		}

		$vendor = $this->db->select('vendor_id, company as vendor_name, vendor_code, used_type, user_type, business_role')->get('tbl_vendor')->result_array();
		foreach($vendor as $rowValue){
			$records[] = array(
				"vendor_id" => $rowValue['vendor_id'],
				"vendor_name" => $rowValue['vendor_name'],
				"vendor_code" => $rowValue['vendor_code'],
				"business_role" => $rowValue['business_role'],
				"used_type" => $rowValue['used_type'],
				"user_type" => $rowValue['user_type']
			);
		}
		$json['result'] = $records;
		
		echo json_encode($json);
		die;
	}

	public function getUserData($attribute){
		$attribute = trim($attribute);
		$value = '';
		if($attribute != ''){
			$value = $this->session->userdata($attribute);
		}
		$json['result'] = $value;

		echo json_encode($json);
		die;
	}

	public function getSalesordersByVendor($vendor_id = 0){

		if((int) $vendor_id <= 0){
			
			$json["result"] = array();
			echo json_encode($json);
			die;
		}
		
		$this->db->select('PAYMENT_SALESORDER_LIST_VIEW.*, tbl_invoice.invoice_code');
		$this->db->join('tbl_invoice', 'tbl_invoice.salesorder_id = PAYMENT_SALESORDER_LIST_VIEW.salesorder_id', 'Left');
		$this->db->where('PAYMENT_SALESORDER_LIST_VIEW.vendor_id', $vendor_id);
		$result = $this->db->group_by('PAYMENT_SALESORDER_LIST_VIEW.salesorder_id')->get('PAYMENT_SALESORDER_LIST_VIEW')->result_array();
		$rows = array();
		//print $this->db->last_query();
		
		$status_arr = ["CANCELED", "VOID","FINANCE_PENDING", "FINANCE_REJECTED", "WAREHOUSE_REJECTED","DRAFT"];
		if(!empty($result)){

			foreach($result as $rowValue){

				//SKIP if salesorder is in status_arr 
				if(in_array($rowValue['status'], $status_arr)){
					continue;
				}
				if(empty($rowValue['invoice_code'])){
					$invoice_code = '';
				}else{
					$invoice_code = $rowValue['invoice_code'];
				}

				$rows[] = array(
					"salesorder_id" => $rowValue["salesorder_id"],
					"salesorder_code" => $rowValue["salesorder_code"],
					"total_amount" => $rowValue["total_amount"],
					"status" => str_replace('_', ' ', $rowValue['status']),
					"invoice_no" => $invoice_code,
					"salesorder_date" => date("d-m-Y", strtotime($rowValue['CREATION_DATE']))
				);
			}
		}

		$json['result'] = $rows;
		
		echo json_encode($json);
		die;
	}

	public function getStatesList(){

		$result = $this->db->select('state_id, name, state_gst_id')->get('tbl_states')->result_array();

		$rows = array();

		if(!empty($result)){
			foreach($result as $rowValue){
				$rows[] = array(
							
							"state_id" => $rowValue["state_id"],
							"state_name" => $rowValue["name"],
							"state_gst_id" => $rowValue["state_gst_id"]
				);
			}
		}

		$json["result"] = $rows;

		echo json_encode($json);
		die;
	}

	public function getLocations(){
		
		$result = $this->db->get('tbl_location')->result_array();

		$rows = array();

		if(!empty($result)){
			foreach($result as $rowValue){
				$rows[] = array(
							
							"location_id" => $rowValue["location_id"],
							"city" => $rowValue["city"],
							"location_name" => $rowValue["location_name"]
				);
			}
		}

		$json["result"] = $rows;

		echo json_encode($json);
		die;
	}

	public function getSupplierList(){
		
		$result = $this->db->where('used_type','supplier')->get('tbl_vendor')->result_array();
		$rows = array();
		
		if(!empty($result)){

			foreach($result as $rowValue){
				$rows[] = array(
					"vendor_id" => $rowValue["vendor_id"],
					"company" => $rowValue["company"]
				);
			}
		}

		$json['result'] = $rows;
		
		echo json_encode($json);
		die;
	}
	
    
	public function getinvoicelist($vendor_id = 0)
	{    

		if((int) $vendor_id <= 0){
			
			$json["result"] = array();
			echo json_encode($json);
			die;
		}
		$start_date = $this->db->select('value')->where('config_key', 'insight_purchase_start_date')->get('tbl_config')->row()->value;
		$this->db->where("DATE(invoice_date) >=", $start_date);

		$result = $this->db->where('supplier_id', $vendor_id)->get('tbl_security_admin')->result_array();
		$rows = array();
		
		if(!empty($result)){

			foreach($result as $rowValue){
				$rows[] = array(
				    "admin_id"=> $rowValue["admin_id"],
					"invoice_no" => $rowValue["invoice_no"],
					"invoice_amount" => $rowValue["invoice_value"],
					"invoice_date" => date("d-m-Y", strtotime($rowValue["invoice_date"]))
			       
				);
			}
		}

		$json['result'] = $rows;
		
		echo json_encode($json);
		die;
	}

}