<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['default_controller'] = "login";
$route['404'] = "login/not_found";
$route['admin/mark_attendance'] = "admin/dashboard/mark_attendance";
$route['knowledgebase'] = "frontend/knowledgebase";
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
$route['admin/dashboard'] = "admin/Analytics/manage_analytics";


/*===INVOICE URL===*/

$route['admin/report/invoice-details'] = 'admin/Finance/invoice_details';

$route['admin/finance/create-invoice'] = 'admin/Finance/create_invoice';

$route['admin/finance/create-invoice-by-excel'] = 'admin/Finance/uploadInvoiceExcel/$1';

$route['admin/print-invoice/(:any)'] = 'admin/Finance/printCreateInvoiceData/$1';

$route['user/print-invoice/(:any)'] = 'Web_api/printCreateInvoiceData/$1';

$route['admin/ass-receipt/(:any)'] = 'admin/Ass_receipt/assReceipt/$1';

$route['admin/print-advancepayment-receipt/(:any)'] = 'admin/Finance/advancepaymentReciptHtml/$1';

$route['admin/print-credit-note/(:any)'] = 'admin/Finance/printCreditNoteData/$1';


/*===MODEL MISMATCH URL===*/

$route['admin/model-mismatch'] = 'admin/Trc/manage_modelmismatch';

/*===SALES REPORT URL===*/

$route['admin/finance/sales-report'] = 'admin/Sales_report/manage_assreceipt';

$route['admin/rfs/update-nhdp'] = 'admin/Rfs/manage_nhdp';

$route['admin/rfs/edit-product_details'] = 'admin/Rfs/manageEditProduct';


/*===SPARE PART DETAIL===*/ 
$route['admin/spare-part-detail'] = 'admin/Spareparts/manage_spareparts';
$route['admin/purchase-spare-part'] = 'admin/Spareparts/manage_purchaseparts';


/*===SECURITY OR SECURITY ADMIN===*/
$route['admin/security'] = 'admin/Security_admin/manage_securityadmin/0/1/normal';
$route['admin/security-admin'] = 'admin/Security_admin/manage_securityadmin/0/1/admin';

/*===PRELOVE MODEL===*/
$route['admin/prelove-model'] = 'admin/Prelovemodel/manage_prelovemodel';


/* End of file routes.php */

/* Location: ./application/config/routes.php */