const { create_sales_order,
        get_order_status,
        bundle_availability,
        get_invoice,
        get_invoice_items,
        payment_type,
        payment_accounts,
        get_order_info,
        get_total_orders

} = require("./order-service");

module.exports = {

    createSalesOrder: (req,res) => {
        
        const body = req.body; 
        var bundleData = body.bundle_data
        opebBoxData = body.open_box_data
        var vendor_id = body.vendor_id;
        if (vendor_id == "" || vendor_id == undefined) {
            return res.status(201).json({
                status:0,
                message: "Please provide vendor "
            })
          }
        if(bundleData.length == 0 && opebBoxData.length == 0){

            return res.status(201).json({
                status:0,
                message: "Your cart is empty ... !!"
            })
        }
        var result_array = []
             try{
           
                create_sales_order(body,(err, results) => {
                    if(err){
                        
                        if(err == 1){
                            return res.status(201).json({
                                status:0,
                                message: "Please Provide vendor id"
                            })
                        } else if(err == 2){
    
                            return res.status(201).json({
                                status:0,
                                message: results
                            })
                        } else if(err == 3){
    
                            return res.status(201).json({
                                status:0,
                                message: results
                            })
                        } else if(err == 4){
    
                            return res.status(201).json({
                                status:0,
                                message: "Something went wrong while creation of sales order"
                            })
                        }  else if(err == 5){
    
                            return res.status(201).json({
                                status:0,
                                message: results
                            })
                        }
                        else{
        
                            return res.status(500).json({
                                status:0,
                                message: err
                            })
                        }
                    }
                    result_array.push(results)
                    // return res.status(200).json({
                    //     status : 1,
                    //     message : "Your order Placed sucessfully",
                    //     data : results
                    // })
                })
            } catch (error) {
                return res.status(500).json({
                    status:0,
                    err: error
                })
            }
       
    },
    bundleAvailability: (req,res) => {
        
        const body = req.body; 
        try{
            bundle_availability(body,(err, results) => {
                if(err){
                    
                    if(err == 1){
                        return res.status(201).json({
                            status:0,
                            message: results
                        })
                       
                    } else if(err == 2){

                        return res.status(201).json({
                            status:0,
                            message: results
                        })
                    } else{
    
                        return res.status(500).json({
                            status:0,
                            message: err
                        })
                    }
                }
                return res.status(200).json({
                    status : 1,
                    message : results
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getOrderStatus: (req,res) => {
        
        var order_id = req.params.order_id;
        try{
            get_order_status(order_id,(err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            msg: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    order_status: results[0].status
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    paymentTypes: (req,res) => {

        try{
            payment_type(null, (err, results) => {
            
                if(err){
                    
                    if(err == 1){
                        res.status(404).json({
                            status:0,
                            message: "Results not found"
                        })
                        
                    } else{
                        return err;
                    }
                }
                return res.status(200).json({
                    status: 1,
                    data: results
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        } 
    },
    paymentAccounts: (req,res) => {

        try{
            payment_accounts(null, (err, results) => {
            
                if(err){
                    
                    if(err == 1){
                        res.status(404).json({
                            status:0,
                            message: "Results not found"
                        })
                        
                    } else{
                        return err;
                    }
                }
                return res.status(200).json({
                    status: 1,
                    data: results
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        } 
    },
    getOrderInfo: (req,res) => {
        
        var order_id = req.params.order_id;
        if (order_id == "" || order_id == undefined || order_id == 0 || order_id == 'NaN') {
           
            return res.status(200).json({
                status: 0,
                message: "Please provide valid vendor id" 
            });
          }
        try{
            get_order_info(order_id,(err, result) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            msg: result
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    data: result
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getTotalOrders: (req,res) => {
        
        var vendor_id = req.params.vendor_id;
        try{
            get_total_orders(vendor_id,(err, order_items) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            msg: "Need Vendor id "
                        })
                    } else if(err == 2){

                        return res.status(404).json({
                            status:0,
                            msg: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    total_orders: order_items.length,
                    order_items: order_items
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getInvoice: (req,res) => {
        
        const body = req.body; 

        var order_id = body.order_id
        
        if (order_id == "" || order_id == undefined || order_id == 'NaN' || order_id == 0) {
            
            return res.status(200).json({
                status: 0,
                message: "Order id required" 
            });
        }
        try{
            get_invoice(order_id,(err, results) => {
                if(err){
                    
                    if(err == 1){
                        return res.status(201).json({
                            status:0,
                            message: results
                        })
                       
                    } else{
    
                        return res.status(500).json({
                            status:0,
                            message: err
                        })
                    }
                }
                return res.status(200).json({
                    status : 1,
                    data : results
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getInvoiceItems: (req,res) => {
        
        const body = req.body; 

        var order_id = body.order_id
        
        if (order_id == "" || order_id == undefined || order_id == 'NaN' || order_id == 0) {
            
            return res.status(200).json({
                status: 0,
                message: "Order id required" 
            });
        }
        try{
            get_invoice_items(order_id,(err, results) => {
                if(err){
                    
                    if(err == 1){
                        return res.status(201).json({
                            status:0,
                            message: results
                        })
                       
                    } else{
    
                        return res.status(500).json({
                            status:0,
                            message: err
                        })
                    }
                }
                return res.status(200).json({
                    status : 1,
                    data : results
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },




    updateCartItem: (req,res) => {
        
        const body = req.body; 
        try{
            update_cart_item(body,(err, results) => {
                if(err){
                    
                    if(err == 1){
                        return res.status(201).json({
                            status:0,
                            message: "Both vendor id and SKU required"
                        })
                    } else if(err == 2) {

                        return res.status(404).json({
                            status:0,
                            message: "Results not found"
                        })
                    } else if(err == 3) {

                        return res.status(201).json({
                            status:0,
                            message: "Item is not deleted"
                        })
                    } 
                    else{
    
                        console.log(err)
                        return res.status(500).json({
                            status:0,
                            message: err
                        })
                    }
                } 
                if(results == true){
                    return res.status(200).json({
                        status : 1,
                        message : "You cart item is deleted" 
                    }) 
                }
                return res.status(200).json({
                    status : 1,
                    message : "Updated cart successfully" 
                })
            })
        } catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    deleteCartItem: (req,res,cb) => {

        var cart_id = req.params.cart_id;
        deleteCartItem(cart_id, (err, results) => {
           
            if(err){
                
                if(err == 1){
                    res.status(201).json({
                        status:0,
                        message: "Please Provide cart id"
                    })
                    cb(null, res) 
                } else if(err == 2){

                    res.status(201).json({
                        status:0,
                        message: "Record not found"
                    })
                    cb(null, res) 
                } else{
                    console.log(err)
                    return;
                }
            }
            return res.json({
                status: 1,
                message: "Cart item deleted successfully"
            })
        })
        
    },
    
    
}
