const connect_pool = require("./config/database");
const mysql = require('mysql2/promise');
const https = require('https');
require("dotenv").config({ path: "../.env" });
const db_conn = {
  port:process.env.DB_PORT,
  host:process.env.DB_HOST,
  user:process.env.DB_USER,
  password:process.env.DB_PASSWORD,
  database:process.env.DB_NAME
}
module.exports = {
  add_log: (request, response) => {
    var req = JSON.stringify(request);
    
    try {
      connect_pool.query(
        `INSERT into tbl_dealer_error_log(request,response)
        VALUES(?,?)`,
        [req,response]
      );
    } catch (e) {}

  },
  add_returns: async (body, callBack) => {

    var returnItems = body.return_items;
    var qr1 = "SELECT max(CAST(SUBSTRING(salesreturn_code,-1) as UNSIGNED)) as max from tbl_dealerapp_salesreturn";
    let qr2 = "INSERT INTO tbl_dealerapp_salesreturn (salesreturn_code,quantity, amount, discount,tcs_amount, order_id, vendor_id, salesreturn_to,status,created_by,updated_by) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    var qr3 = "INSERT into tbl_dealerapp_salesreturn_item (salesreturn_id,order_item_id, bundle_id, grnreport_id, reason_for_return) VALUES (?,?,?,?,?)";
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      //await connect_pool.beginTransaction()
      var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1,(row1_err, row1) => {
          
              if (row1_err){
                connection.rollback(); return callBack({status:0,message:row1_err});
              }
              res(row1);
          });
      });
      if(qr1_res[0].max == 0 || qr1_res[0].max == null){
        
        var salesreturn_code = "SR-DELR-1";
      }else{
       
        var index_no = qr1_res[0].max + 1
        var salesreturn_code = "SR-DELR-" + index_no;
      }
      var quantity = returnItems.length;
      var discount = body.discount;
      var bundle_quantity = body.bundle_quantity;
      var device_dis = discount / bundle_quantity * 10;
      var return_dis = device_dis * quantity;
      var discount_amount = parseFloat(return_dis).toFixed(2);
      var tcs_amount = body.tcs_amount;
      var device_tcs = tcs_amount / bundle_quantity * 10;
      var return_tcs = device_tcs * quantity;
      var return_tcs_amount = parseFloat(return_tcs).toFixed(2);
      var total_amount = 0;
      for (var i = 0; i < returnItems.length; i += 1) {
        var purchase_cost = returnItems[i].purchase_cost;
        total_amount += purchase_cost;
      }
      var amount = parseFloat(total_amount) - parseFloat(discount_amount); 
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,
          [salesreturn_code, quantity, amount, discount_amount,return_tcs_amount, body.order_id, body.vendor_id,body.salesreturn_to, "PENDING", body.vendor_id, body.vendor_id], 
          (result_err, results) => {
            
              if (result_err){
                connection.rollback(); return callBack({status:0, message:result_err});
              } 
              res(results);
          });
      });
      var salesreturn_id = qr2_res.insertId;
      if(salesreturn_id == null || salesreturn_id == ""){
        return callBack({status:0,message:"Failed to create sales return"})
      }
      for (var j = 0; j < returnItems.length; j += 1) {
        var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3,
          [salesreturn_id, returnItems[j].order_item_id, returnItems[j].bundle_id, returnItems[j].grnreport_id, returnItems[j].reason_for_return], 
          (result2_err, results_2) => {
              if (result2_err){ 
                connection.rollback(); return callBack({status:0, message:result2_err});
              }
              res(results_2);
          });
        });
      }
      connection.commit();
      connection.end();
      let res_obj = {
        "salesreturn_id" : salesreturn_id,
      }
      return callBack(null, res_obj)
    } catch (err) {
      //connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err})
      }
  },
  sales_returns:  async (vendor_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
    try {
      
      var qr1 = "SELECT * FROM tbl_dealerapp_salesreturn WHERE vendor_id = ?";
      var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [vendor_id],
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status: 0, message:result1_err});
            } 
            res(results_1);
        });
      });
      if(qr1_res.length == 0){
        return callBack({status:0, message:"No records found"})
      }
      await connection.commit();
      await connection.end();
      return callBack(null, qr1_res)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack({status : 0, message : err});
    }
  },
  sales_return_items:  async (salesreturn_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
    try {
      
      var qr1 = "SELECT * FROM DEALERAPP_SALES_RETURN_ITEM_LIST_VIEW WHERE salesreturn_id = ?";
      var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [salesreturn_id],
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status: 0, message:result1_err});
            } 
            res(results_1);
        });
      });
      if(qr1_res.length == 0){
        return callBack({status:0, message:"No records found"})
      }
      await connection.commit();
      await connection.end();
      return callBack(null, qr1_res)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack({status : 0, message : err});
    }
  },
  update_salesreturn:  async (body, callBack) => {
    
    var qr1 = "SELECT max(CAST(SUBSTRING(creditnote_code,-1) as UNSIGNED)) as max from tbl_dealerapp_salesreturn";
    var qr2 = "SELECT * FROM tbl_dealerapp_salesreturn_item WHERE salesreturn_id = ?";
    var qr3 = "UPDATE tbl_dealerapp_order_bundle_item SET return_status = ? WHERE order_item_id = ? AND bundle_id = ? AND grnreport_id = ?";
    var qr4 = "UPDATE tbl_dealerapp_salesreturn SET creditnote_code = ?, status = ?, updated_by = ?, valid = ? WHERE salesreturn_id = ?";
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,(row1_err, row1) => {
            
              if (row1_err){
                connection.rollback(); return callBack({status:0,message:row1_err});
              }
              res(row1);
          });
      });
      if(qr1_res[0].max == 0 || qr1_res[0].max == null){
        
        var creditnote_code = "CN-DELR-1";
      }else{
        
        var index_no = qr1_res[0].max + 1
        var creditnote_code = "CN-DELR-" + index_no;
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,[body.salesreturn_id],(row2_err, row2) => {
            
              if (row2_err){
                connection.rollback(); return callBack({status:0,message:row2_err});
              }
              res(row2);
          });
      });
      if(qr2_res.length < 1){
        return callBack({status:0,message:"No sales return items found"});
      }
      
      if(body.status == "APPROVED"){
        
        for (var i = 0; i < qr2_res.length; i += 1) {
          
          var qr3_res = await new Promise((res, rej) => {
            connect_pool.query(qr3, ["Y",qr2_res[i].order_item_id, qr2_res[i].bundle_id, qr2_res[i].grnreport_id],
              (result3_err, results_3) => {
              
                if (result3_err){
                  connection.rollback();
                  return callBack({status : 0, message:result3_err});
                } 
                res(results_3);
            });
          });
        }
      }
      if(body.status == "APPROVED"){
        var valid = "Y";
      } else{
        var valid = "N";
      }
      var qr4_res = await new Promise((res, rej) => {
        connect_pool.query(qr4, [creditnote_code, body.status, body.attached_vendor_id, body.salesreturn_id,valid],
          (result4_err, results_4) => {
            
              if (result4_err){
                connection.rollback();
                return callBack({status:0,message:result4_err});
              } 
              res(results_4);
        });
      });
      await connection.commit();
      await connection.end();
      
      return callBack(null, {status:1, message:"Your have created credit note sucussesfully"})
    }
    catch (err) {
      await connection.rollback()
      //connection.releaseConnection()
      return callBack({status : 0, message:err});
    }
  },
  returns_list:  async (vendor_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
    try {
      
      var qr1 = "SELECT * FROM tbl_dealerapp_salesreturn WHERE salesreturn_to = ?";
      var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [vendor_id],
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status: 0, message:result1_err});
            } 
            res(results_1);
        });
      });
      if(qr1_res.length == 0){
        return callBack({status:0, message:"No records found"})
      }
      await connection.commit();
      await connection.end();
      return callBack(null, qr1_res)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack({status : 0, message : err});
    }
  }



};
