const {
  add_log,
  add_returns,
  sales_returns,
  sales_return_items,
  update_salesreturn,
  returns_list


  
} = require("./salesreturn-service");

module.exports = {

  addReturnItems: (req, res) => {
    const body = req.body;
    const return_items = body.return_items;
    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    if (return_items.length == 0) {
      return res.status(201).json({
        status: 0,
        message: "Your return items are empty ... !!",
      });
    }
    
    try {
      add_returns(body, (err, results) => {
  
        if (err) {
          return res.status(500).json({ err });
        }
        return res.status(200).json({
          status: 1,
          message: "Your order Placed sucessfully",
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  
  },
  salesReturns: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
  
    if (vendor_id == "" || vendor_id == undefined) {
      return res.status(201).json({
        status: 0,
        message: "Please provide Vendor ",
      });
    }
    try {
      sales_returns(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json({ "status": 1,results });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  salesReturnItems: (req, res) => {
    const salesreturn_id = req.params.salesreturn_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(salesreturn_id, response)
      oldSend.apply(res, arguments);
    }
  
    if (salesreturn_id == "" || salesreturn_id == undefined) {
      return res.status(201).json({
        status: 0,
        message: "Please provide Sales retutn id ",
      });
    }
    try {
      sales_return_items(salesreturn_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json({ "status": 1,results });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  updateSalesReturn: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
  
    if (body.length < 1) {
      return res.status(201).json({
        status: 0,
        message: "Please provide sales return details ",
      });
    }
    try {
      update_salesreturn(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results );
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  returnsList: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
  
    if (vendor_id == "" || vendor_id == undefined) {
      return res.status(201).json({
        status: 0,
        message: "Please provide Vendor ",
      });
    }
    try {
      returns_list(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json({ "status": 1,results });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  }



};
