const e = require("express");
const pool = require("./config/database");

module.exports = {

  bundle_availability: (data, callBack) => {
    
    const bundle_data = data.bundle_id;
    
    // if (bundle_data.length < 1) {
    //   let msg = "Your cart is empty ... !!";
    //   return callBack(2, msg);
    // }
    
    var id_list = [];

    for (var i = 0; i < bundle_data.length; i++) {
      var bundle_id = bundle_data[i];
      id_list.push(bundle_id);
    }
    var bundle_ids = [id_list];
    
    pool.query(
      `SELECT status, bundle_no, quantity, amount, type from tbl_dealer_bundle WHERE bundle_id IN ?`,
      [(bundle_ids)],
      (check_err, check_data) => {
        if (check_err) {
          return callBack(check_err);
        }
        
        if (check_data.length < 1) {
          let data_msg = "No data available for selected bundles";
          return callBack(1, data_msg);
        }
        for (var j = 0; j < check_data.length; j++) {
        
            var bndl_status = check_data[j].status;
            //if (bndl_status == "INACTIVE" || bndl_status == "RESERVE") {
              if (bndl_status != "ACTIVE") {
                let msg = check_data[j].bundle_no + " is not available in IN-STOCK";
                return callBack(2, msg);
            }
        }
        let succ_msg = "You can proceed to payment for this bundles";
        return callBack(null, succ_msg)
      }
    )
  },
  create_sales_order: (data, callBack) => {
    var vendor_id = data.vendor_id;
    const bundle_data = data.bundle_data;
    const openbox_data = data.open_box_data;
    var orders_list = []
    var order_count = []
    var type_list = []
    var openbox_list = []
    if(openbox_data.length > 0){
      openbox_list.push("OPEN BOX")
      async function createOrder(openbox_data){

        var grnid_list = [];
        for (var i = 0; i < openbox_data.length; i++) {
          var grnreport_id = openbox_data[i].grnreport_id;
          grnid_list.push(grnreport_id);
        }
        var grnreport_ids = [grnid_list];
        pool.query(
          `SELECT status, saletype, device_name, nhdin, device_sub_category from tbl_grnreport WHERE grnreport_id IN ?`,
          [(grnreport_ids)],
          (grn_err, grn_data) => {
            if (grn_err) {
              return callBack(grn_err);
            }
            if (grn_data.length > 0) {
              
              for (var z = 0; z < grn_data.length; z++) {
            
                var device_name = grn_data[z].device_name;
                var device_status = grn_data[z].status;
                var sale_type = grn_data[z].saletype;
                device_id = grn_data[z].nhdin
                if (device_status != "RFS" || sale_type != 'OFFLINE') {
                  let msg = device_name + " is not availabe in IN-STOCk" ;
                  return callBack(2, msg);
                }
              }
            }
            pool.query(
              `SELECT status,device_name FROM SALESORDER_EXPORT_VIEW WHERE grnreport_id IN ?`,
              [(grnreport_ids)],
              (check_err, check_data) => {
                if (check_err) {
                  
                  return callBack(2, check_err);
                }
                if (check_data.length > 0) {
              
                  for (var y = 0; y < check_data.length; y++) {
                
                    var deviceName = check_data[y].device_name;
                    var status = check_data[y].status;
                    if (status == "FINANCE_PENDING" || status == "INVOICE_PENDING") {
                      let msg = deviceName + " is not availbe in IN-STOCk" ;
                      return callBack(2, msg);
                    }
                  }
                }
                pool.query(
                  `SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?`,
                  [vendor_id],
                  (tcs_err, total_amount) => {
                  if (tcs_err) {
                      return callBack(tcs_err)
                  }
                  var total_amount = total_amount[0].amount
                  var check_amount = 5000000
                  // var order_count = []
                  // var orders_list = []
                  pool.query(
                    `SELECT max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max from tbl_salesorder`,
                    (err_max, max_number) => {
                    if (err_max) {
                        return callBack(err_max);
                    }
                    var index_no = max_number[0].max + 1
                    pool.query(
                    `SELECT sum(mrp) as order_amount, sum(grnreport_id) as qnty  from tbl_grnreport WHERE grnreport_id IN ?`,
                    [(grnreport_ids)],
                    (type_err, type_data) => {
                      if (type_err) {
                        return callBack(type_err);
                      }
                      if (type_data.length < 1) {
                        return callBack(1);
                      }
                      var open_box_amount = type_data[0].order_amount
                      if(total_amount <= check_amount){

                        var final_amount = total_amount + open_box_amount
                        if(final_amount >= check_amount){

                        var tcs_percent = 0.1
                        let actual_amount = final_amount - check_amount
                        tcs_value = (tcs_percent*100)/actual_amount
                        } else{

                        var tcs_percent = 0
                        tcs_value = 0
                        }
                      } else{

                        var tcs_percent = 0.1
                        tcs_value = (tcs_percent*100)/open_box_amount
                      }
                      var next_number = index_no;
                      let sales_code = "SO-HYD-" + next_number;
                      
                      pool.query(
                          `INSERT into tbl_salesorder (salesorder_code,vendor_id, status, sales_channel, payment_mode, warehouse, discount_on_amount, discount_on_tax, discount_value, discount_amount, insurance_amount, insurance_value, freight_amount, tcs_percent, tcs_amount,device_sub_category)
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                          [
                          sales_code,
                          vendor_id,
                          "FINANCE_PENDING",
                          "DEALERAPP","prepaid","HYD",0,0,0,0,0,0,0,
                          tcs_percent,
                          tcs_value,
                          "OPEN BOX"
                          ],
                          (post_err, postData, affectedRows) => {
                          if (post_err) {
                              return callBack(post_err);
                          }
                          if (affectedRows < 1) {
                              return callBack(4);
                          }
                          const monthNames = ["January", "February", "March", "April", "May", "June",
                              "July", "August", "September", "October", "November", "December"
                          ];
                          var currentdate = new Date(); 
                          var datetime =  currentdate.getDate() + "-"
                                           + (currentdate.getMonth()+1)  + "-"
                                          //+ monthNames[currentdate.getMonth()] + "-"
                                          + currentdate.getFullYear();
                          pool.query(
                            `SELECT SUM(mrp) as pay_amount FROM tbl_grnreport WHERE grnreport_id IN ?`,
                            [grnreport_ids],
                            (amount_err, amountData) => {
                            if (amount_err) {
                                return callBack(amount_err);
                            }
                            var pay_amount = amountData[0].pay_amount
                            net_amount = pay_amount + tcs_value
                          
                          result_obj = {
                              salesorder_id: postData.insertId,
                              salesorder_code: sales_code,
                              order_amount: pay_amount,
                              tcs_percent: tcs_percent,
                              tcs_value: tcs_value,
                              net_payment:net_amount,
                              status: "PENDING",
                              //qnty: check_data[key_no].quantity,
                              quantity: type_data[0].qnty,
                              created_date :datetime
                          };
                          orders_list.push(result_obj);
                          pool.query(
                              `SELECT * FROM tbl_grnreport WHERE grnreport_id IN ?`,
                              [grnreport_ids],
                              (data_err, openData) => {
                              if (data_err) {
                                  return callBack(data_err);
                              }
                              
                              order_count.push(postData.insertId)
                              openData.forEach((grn_openbox_data) => {
                                
                                  pool.query(
                                  `INSERT into tbl_salesorder_item (salesorder_id, brand,device_name,color, ram,rom, sku, quantity, sale_price, amount, category, grade, grnreport_id)
                                  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                  [
                                      postData.insertId,
                                      grn_openbox_data.product_brand,
                                      grn_openbox_data.device_name,
                                      grn_openbox_data.color,
                                      grn_openbox_data.ram,
                                      grn_openbox_data.rom,
                                      grn_openbox_data.SKU,
                                      1,
                                      grn_openbox_data.mrp,
                                      grn_openbox_data.mrp,
                                      grn_openbox_data.device_sub_category,
                                      grn_openbox_data.certification_grade,
                                      grn_openbox_data.grnreport_id,
                                  ],
                                  (create_err, sendData, postRows) => {
                                    
                                      if (create_err) {
                                      return callBack(1,create_err);
                                      }
                                      if (postRows < 1) {
                                        return callBack(4);
                                      }
                                      
                                  }
                                )
                              })
                              // if (order_count.length == type_list.length) {
                              //   return callBack(null,orders_list)
                              // }
                          });
                        })
                          }
                      )}
                   )
                
              })
            })
              }
            )
          }
        )
      }
      var openBoxOrder =  createOrder(openbox_data)
    }
    // if (bundle_data.length < 1) {
    //   let msg = "Your cart is empty ... !!";
    //   return callBack(2, msg);
    // }
    if(bundle_data.length > 0){
      var id_list = [];

      for (var i = 0; i < bundle_data.length; i++) {
        var bundle_id = bundle_data[i].bundle_id;
        id_list.push(bundle_id);
      }
      var bundle_ids = [id_list];
      
      pool.query(
        `SELECT status, bundle_no, quantity, amount, type, sub_category from tbl_dealer_bundle WHERE bundle_id IN ?`,
        [(bundle_ids)],
        (check_err, check_data) => {
          if (check_err) {
            return callBack(check_err);
          }
          if (check_data.length < 1) {
            let data_msg = "No data available for selected bundles";
            return callBack(1, data_msg);
          }
          var bundle_sub_category = []
          // var type_list = [];
          var selected_qnty = 0;
          for (var j = 0; j < check_data.length; j++) {
          
              var device_sub_category = check_data[j].sub_category;
              bundle_sub_category.push(device_sub_category)
              var bndl_status = check_data[j].status
              selected_qnty+= check_data[j].quantity
              //if (bndl_status == "INACTIVE" || bndl_status == "RESERVE") {
                if (bndl_status != "ACTIVE") {
                  let msg = check_data[j].bundle_no + " is not available in IN-STOCK";
                  return callBack(2, msg);
              }
              if (type_list.indexOf(check_data[j].type) === -1)
              {
                  let type = check_data[j].type
                  type_list.push(type)
              }
          }
          pool.query(
            `SELECT status, saletype, device_name, nhdin from tbl_grnreport WHERE bundle_id IN ?`,
            [(bundle_ids)],
            (grn_err, grn_data) => {
              if (grn_err) {
                return callBack(grn_err);
              }
              if (grn_data.length > 0) {
                
                for (var g = 0; g < grn_data.length; g++) {
              
                  var device_name = grn_data[g].device_name;
                  var device_status = grn_data[g].status;
                  var sale_type = grn_data[g].saletype;
                  device_id = grn_data[g].nhdin
                  if (device_status != "RFS" || sale_type != 'OFFLINE') {
                    let msg = device_name + " is not availabecin IN-STOCK" ;
                    return callBack(2, msg);
                  }
                }
                pool.query(
                  `SELECT count(item_id) as qnty FROM tbl_dealer_bundle_item WHERE bundle_id IN ?`,
                  [bundle_ids],
                  (data_err, bundleData) => {
                  if (data_err) {
                      return callBack(data_err);
                  }
                  if (bundleData.lenght > 0) {
                      let err_bndl = "No items available in selected bundles";
                      return callBack(5, err_bndl);
                  }
                  if(bundleData[0].qnty != selected_qnty){
                      err_qnty = "Selected bundle items count mismatch with IN-STOCK availability ";
                      return callBack(5, err_qnty);
                  }
                  pool.query(
                      `SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?`,
                      [vendor_id],
                      (tcs_err, total_amount) => {
                      if (tcs_err) {
                          return callBack(tcs_err)
                      }
                      var total_amount = total_amount[0].amount
                      var check_amount = 5000000
                      var id_array = []
                      // var order_count = []
                      // var orders_list = []
                      pool.query(
                        `SELECT max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max from tbl_salesorder`,
                        (err_max, max_number) => {
                        if (err_max) {
                            return callBack(err_max);
                        }
                        var index_no = max_number[0].max + 1
                        type_list.forEach((value, key_no) => {

                      id_array.push(id_list[key_no]);
                      //var bundleId = id_list[key_no];
                      //bundleNo = check_data[key_no].bundle_no
                      var  bundle_type = type_list[key_no];
                      pool.query(
                        `SELECT sum(amount) as order_amount, sum(quantity) as qnty  from tbl_dealer_bundle WHERE bundle_id IN ? AND type = ?`,
                        [(bundle_ids), bundle_type],
                        (type_err, type_data) => {
                          if (type_err) {
                            return callBack(type_err);
                          }
                          if (type_data.length < 1) {
                            return callBack(1);
                          }
                          bundle_amount = type_data[0].order_amount
                          if(total_amount <= check_amount){

                            var final_amount = total_amount + bundle_amount
                            if(final_amount >= check_amount){
    
                            var tcs_percent = 0.1
                            let actual_amount = final_amount - check_amount
                            tcs_value = (tcs_percent*100)/actual_amount
                            } else{
    
                            var tcs_percent = 0
                            tcs_value = 0
                            }
                          } else{
    
                            var tcs_percent = 0.1
                            tcs_value = (tcs_percent*100)/bundle_amount
                          }
                          var next_number = index_no + key_no;
                          let sales_code = "SO-HYD-" + next_number;
                          
                          pool.query(
                              `INSERT into tbl_salesorder (salesorder_code,vendor_id, status, sales_channel, payment_mode, warehouse, discount_on_amount, discount_on_tax, discount_value, discount_amount, insurance_amount, insurance_value, freight_amount, tcs_percent, tcs_amount,device_sub_category)
                              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                              [
                              sales_code,
                              vendor_id,
                              "FINANCE_PENDING",
                              "DEALERAPP","prepaid","HYD",0,0,0,0,0,0,0,
                              tcs_percent,
                              tcs_value,
                              bundle_sub_category[key_no],
                              ],
                              (post_err, postData, affectedRows) => {
                              if (post_err) {
                                  return callBack(post_err);
                              }
                              if (affectedRows < 1) {
                                  return callBack(4);
                              }
                              const monthNames = ["January", "February", "March", "April", "May", "June",
                                  "July", "August", "September", "October", "November", "December"
                              ];
                              var currentdate = new Date(); 
                              var datetime =  currentdate.getDate() + "-"
                                              + (currentdate.getMonth()+1)  + "-"
                                              //+ monthNames[currentdate.getMonth()] + "-"
                                              + currentdate.getFullYear();
                              pool.query(
                                `SELECT SUM(amount) as pay_amount FROM tbl_dealer_bundle WHERE type = ? AND bundle_id IN ?`,
                                [bundle_type, bundle_ids],
                                (amount_err, amountData) => {
                                if (amount_err) {
                                    return callBack(amount_err);
                                }
                                var pay_amount = amountData[0].pay_amount
                                net_amount = pay_amount + tcs_value
                              
                              result_obj = {
                                  salesorder_id: postData.insertId,
                                  salesorder_code: sales_code,
                                  order_amount: pay_amount,
                                  tcs_percent: tcs_percent,
                                  tcs_value: tcs_value,
                                  net_payment:net_amount,
                                  status: "PENDING",
                                  //qnty: check_data[key_no].quantity,
                                  quantity: type_data[0].qnty,
                                  created_date :datetime
                              };
                              orders_list.push(result_obj);
                              pool.query(
                                  `SELECT * FROM DEALER_BUNDLE_LIST_VIEW WHERE type = ? AND bundle_id IN ?`,
                                  [bundle_type, bundle_ids],
                                  (data_err, bundleData) => {
                                  if (data_err) {
                                      return callBack(data_err);
                                  }
                                  order_count.push(postData.insertId)
                                  bundleData.forEach((bndl_data) => {
                                      pool.query(
                                      `INSERT into tbl_salesorder_item (salesorder_id, brand,device_name,color, ram,rom, sku, quantity, sale_price, amount, category, grade, grnreport_id)
                                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                      [
                                          postData.insertId,
                                          bndl_data.brand,
                                          bndl_data.device_name,
                                          bndl_data.color,
                                          bndl_data.ram,
                                          bndl_data.rom,
                                          bndl_data.sku,
                                          1,
                                          bndl_data.sale_price,
                                          bndl_data.sale_price,
                                          bndl_data.category,
                                          bndl_data.grade,
                                          bndl_data.grnreport_id,
                                      ],
                                      (create_err, sendData, postRows) => {
                                          if (create_err) {
                                          return create_err;
                                          }
                                          if (postRows < 1) {
                                            return callBack(4);
                                          }
                                          pool.query(
                                            `UPDATE tbl_dealer_bundle SET order_id = '${postData.insertId}', status = 'RESERVE' WHERE type = ? AND bundle_id IN ?`,
                                            [bundle_type, bundle_ids],
                                            (data_err, bundleData) => {
                                            if (data_err) {
                                                return callBack(data_err);
                                            }
                                          })
                                      }
                                    )
                                  })
                                  if (order_count.length == type_list.length + openbox_list.length) {
                                    return callBack(null,orders_list)
                                  }
                              });
                            })
                              }
                          )}
                      )
                    })
                  })
                })
              }
            )
          }
        }
      )
      });
    }
    
  },
  get_order_status: (order_id, callBack) => {
    if (order_id == "" || order_id == undefined) {
      return callBack(1);
    }
    pool.query(
      `SELECT status from tbl_salesorder WHERE salesorder_id = ?`,
      [order_id],
      (error, results) => {
        if (results.length < 1) {
          return callBack(1);
        }
        if (error) {
          return callBack(error);
        }
        return callBack(null, results);
      }
    );
  },
  
  get_order_info: (order_id, callBack) => {

    pool.query(
      `select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, status from tbl_dealer_bundle WHERE order_id = ?`,
      [order_id],
      (err, bundle_info) => {
        if (err) {
          return callBack(err);
        }
        if (bundle_info.length < 1) {
          
          var msg = "No bundles found ";
          return callBack(1, msg);
        }
        var bundle_type = bundle_info[0].type
        if(bundle_type == "1A"){

          grade_qnty = "SG-A(5) SG-B(5)" 
        } else if(bundle_type == "1B"){
            
            grade_qnty = "SG-A(4) SG-B(6)" 
        } else if(bundle_type == "1C"){
            
            grade_qnty = "SG-A(2) SG-B(3) SG-C(5)" 
        } else if(bundle_type == "1D"){
            
            grade_qnty = "SG-D(10)" 
        } else if(bundle_type == "1E"){
            
            grade_qnty = "SG-B(3) SG-C(7)" 
        } else if(bundle_type == "1F"){
            
            grade_qnty = "SG-B(3) SG-C(5) SG-D(2)" 
        } else if(bundle_type == "2A" || bundle_type == "2B" || bundle_type == "2C" || bundle_type == "2D" || bundle_type == "2E" || bundle_type == "2F"){
            
            grade_qnty = "SG-A(3) SG-B(3) SG-B(4)" 
        }
        pool.query(
          `select salesorder_code, status from tbl_salesorder WHERE salesorder_id = ? `,
           [order_id],
          (status_err, statusData) => {

              if(status_err){

                return callBack(status_err)
              }
              var orderStatus = statusData[0].status
              var order_status = orderStatus.replace('_', ' ');
              var salesorder_no = statusData[0].salesorder_code
              //var order_info = [{status : order_status, salesorder_no:salesorder_no}]
              const payment_info = []
              pool.query(
                `select payment_reference, receipt_no, amount, amount_paid, currency, created_date from tbl_dealer_payments WHERE order_id = ? `,
                [order_id],
                (payment_err, result) => {

                    if(payment_err){

                        return callBack(payment_err)
                    }
                    if(result.length < 1){

                        var pay_err = "No payments for this order ";
                        return callBack(1, pay_err);
                    }
                    var currentdate = result[0].created_date; 
                    var datetime =  currentdate.getDate() + "-"
                                    + (currentdate.getMonth()+1)  + "-"
                                    //+ monthNames[currentdate.getMonth()] + "-"
                                    + currentdate.getFullYear();
                    result[0].payment_date = datetime
                    result[0].salesorder_no = salesorder_no
                    result[0].status = order_status
                    bundle_info[0].grade_qnty = grade_qnty
                    delete result[0].created_date
                    payment_info.push(result[0])
                    const final_result = {bundle_info, payment_info}
                    return callBack(null, final_result);
              })
            }
        )
      }
    );
  },
  get_invoice: (order_id, callBack) => {

    pool.query(
      `SELECT  invoice_id,invoice_code, salesorder_code, saleschannel_ref_id, amount, insurance_amount, discount_amount, freight_amount, tcs_amount, tcs_percent, CREATION_DATE as invoice_date, payment_mode as payment_type, sales_channel, sales_code, vendor_name, vendor_code, company, address, city, state, state_id, pincode, pan_card, gst_no from PDF_INVOICE_HEADER_VIEW WHERE salesorder_id = ?`,
      [order_id],
      (invoice_error, invoiceData) => {

        if (invoice_error) {
          return callBack(invoice_error);
        }
        if(invoiceData.length < 1){

          let msg = "No invoice created"
          return callBack(1, msg)
        }
        var invoice_id = invoiceData[0].invoice_id
        var currentdate = invoiceData[0].invoice_date; 
        var datetime =  currentdate.getDate() + "-"
                        + (currentdate.getMonth()+1)  + "-"
                        //+ monthNames[currentdate.getMonth()] + "-"
                        + currentdate.getFullYear();
        delete invoiceData[0].invoice_date
        var place_of_supply = invoiceData[0].state_id+'-'+invoiceData[0].state
        invoiceData[0].invoice_date = datetime
        invoiceData[0].place_of_suplly = place_of_supply
        var number = invoiceData[0].amount
        function numberToWords(number) {  
          var digit = ['zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine'];  
          var elevenSeries = ['ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'];  
          var countingByTens = ['twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];  
          var shortScale = ['', 'thousand', 'million', 'billion', 'trillion'];  
    
          number = number.toString(); number = number.replace(/[\, ]/g, ''); if (number != parseFloat(number)) return 'not a number'; var x = number.indexOf('.'); if (x == -1) x = number.length; if (x > 15) return 'too big'; var n = number.split(''); var str = ''; var sk = 0; for (var i = 0; i < x; i++) { if ((x - i) % 3 == 2) { if (n[i] == '1') { str += elevenSeries[Number(n[i + 1])] + ' '; i++; sk = 1; } else if (n[i] != 0) { str += countingByTens[n[i] - 2] + ' '; sk = 1; } } else if (n[i] != 0) { str += digit[n[i]] + ' '; if ((x - i) % 3 == 0) str += 'hundred '; sk = 1; } if ((x - i) % 3 == 1) { if (sk) str += shortScale[(x - i - 1) / 3] + ' '; sk = 0; } } if (x != number.length) { var y = number.length; str += 'point '; for (var i = x + 1; i < y; i++) str += digit[n[i]] + ' '; } str = str.replace(/\number+/g, ' '); return str.trim() + ".";  
    
      } 
      var amount_words = numberToWords(number)
      invoiceData[0].amount_words = amount_words
      pool.query(
        `SELECT category as product_name, SUM(qty) as quantity, sum(total_amount) as price, sum(exempt_amount) as exempt_amount, sum(taxable_amount) as taxable_amount, sum(tax_amount) as tax_amount from INVOICE_EXPORT_REPORT_VIEW WHERE invoice_id = ?`,
        [invoice_id],
        (error, results) => {
  
          if (error) {
            return callBack(error);
          }
          results[0].tax_rate = '18%'
          results[0].tcs_percent = invoiceData[0].tcs_percent
          results[0].tcs_amount = invoiceData[0].tcs_amount
          var net_amount = invoiceData[0].amount + results[0].tcs_amount
          delete invoiceData[0].tcs_amount
          delete invoiceData[0].tcs_percent
          results[0].amount = invoiceData[0].amount
          results[0].amount_words = invoiceData[0].amount_words
          results[0].net_amount = net_amount
          delete invoiceData[0].amount
          delete invoiceData[0].amount_words
          result_obj = {
            invoice_header: invoiceData[0],
            invoice_item: results[0]
          }
          return callBack(null, result_obj)
        })
    })
  },
  get_invoice_items: (order_id, callBack) => {

    pool.query(
      `SELECT  invoice_id,company, invoice_code as invoice_number, CREATION_DATE from PDF_INVOICE_HEADER_VIEW WHERE salesorder_id = ?`,
      [order_id],
      (invoice_error, invoiceData) => {

        if (invoice_error) {
          return callBack(invoice_error);
        }
        if(invoiceData.length < 1){

          let msg = "No invoice created"
          return callBack(1, msg)
        }
        var invoice_id = invoiceData[0].invoice_id
        var date = invoiceData[0].CREATION_DATE; 
              var invoice_date =  date.getDate() + "-"
							+ (date.getMonth()+1)  + "-" 
              //+ monthNames[date.getMonth()] + "-"
							+ date.getFullYear();
        delete invoiceData[0].CREATION_DATE
        invoiceData[0].invoice_date = invoice_date
        pool.query(
          `SELECT grnreport_id, price from tbl_invoice_item WHERE invoice_id = ?`,
          [invoice_id],
          (sum_error, sumData) => {
    
            if (sum_error) {
              return callBack(sum_error);
            }
            var count = 0;
            var total_price = 0;
            const items_array = []
            sumData.forEach((element) => {
              count++
              total_price += element.price
              var genReportId = element.grnreport_id
              
            pool.query(
              `SELECT  device_name as product_name, SKU, imei1_no, stock_type, nhdin, unit_price from tbl_grnreport WHERE grnreport_id = ?`,
              [genReportId],
              (item_error, invoiceItems) => {
        
                if (item_error) {
                  return callBack(item_error);
                }
                invoiceData[0].total_quantity = sumData.length
                invoiceData[0].total_price = total_price
                delete invoiceData[0].invoice_id
                res = {
                  product_name: invoiceItems[0].product_name,
                  sku: invoiceItems[0].SKU,
                  imei: invoiceItems[0].imei1_no,
                  category: invoiceItems[0].stock_type,
                  device_id: invoiceItems.nhdin,
                  qty: 1,
                  price: invoiceItems[0].mrp,
                }
                items_array.push(res)
                result_obj = {
                  invoice_header: invoiceData[0],
                  invoice_items: items_array
                }
                if(items_array.length == count){
                  return callBack(null, result_obj)
                }

              })
              
            })
          }
        )
      })
  },
  get_total_orders: (vendor_id, callBack) => {
    if (vendor_id == "" || vendor_id == undefined) {
      return callBack(1);
    }
    var sales_channel = "DEALERAPP";
    var total_orders = [];
    pool.query(
      `SELECT * from tbl_salesorder WHERE vendor_id = ? AND sales_channel = ? ORDER BY salesorder_id DESC `,
      [vendor_id, sales_channel],
      (error, results) => {
        if (error) {
          return callBack(error);
        }
        if (results.length < 1) {
          return callBack(2);
        }
        var count = 0;
        results.forEach((element) => {
          let order_id = element.salesorder_id;
          count++;
          pool.query(
            `SELECT count(salesorder_item_id) as quantity, SUM(amount) as amount from tbl_salesorder_item WHERE salesorder_id = ? `,
            [order_id],
            (err, res) => {
              if (err) {
                return callBack(err);
              }
              if (res.length < 1) {
                return callBack(2);
              }
              var amount = res[0].amount
              var tcs_amount = element.tcs_amount
              var order_amount = amount + tcs_amount

              const monthNames = ["January", "February", "March", "April", "May", "June",
                "July", "August", "September", "October", "November", "December"
              ];
              let order_status = element.status
              let orderStatus = order_status.replace('_', ' ');
			        var date = element.CREATION_DATE; 
              var datetime =  date.getDate() + "-"
							+ (date.getMonth()+1)  + "-" 
              //+ monthNames[date.getMonth()] + "-"
							+ date.getFullYear();
              pool.query(
                `SELECT count(bundle_id) as bundle_quantity from tbl_dealer_bundle WHERE order_id = ? `,
                [order_id],
                (bndl_err, bndl_res) => {
                  if (bndl_err) {
                    return callBack(bndl_err);
                  }
                  if (bndl_res.length < 1) {
                    return callBack(2);
                  }
                result_obj = {
                  salesorder_id: element.salesorder_id,
                  salesorder_code: element.salesorder_code,
                  order_amount : order_amount,
                  status: orderStatus,
                  created_date: datetime,
                  // LAST_UPDATE_DATE: element.LAST_UPDATE_DATE,
                  // payment_mode: element.payment_mode,
                  //bndl_qnty: bndl_res[0].bundle_quantity,
                  quantity: bndl_res[0].bundle_quantity,
                };
                total_orders.push(result_obj);
                //return callBack(null, total_orders)
                if (total_orders.length == count) {
                  return callBack(null, total_orders);
                }
              })
            }
          );
        });
      }
    );
  },
  payment_type: (err, callBack) => {
    pool.query(
      `SELECT name from tbl_dropdown WHERE type = ?`,
      ["RECEIPT_TYPE"],
      (error, results) => {
        if (results.length < 1) {
          return callBack(1, null);
        }
        if (error) {
          return callBack(error, null);
        }
        return callBack(null, results);
      }
    );
  },
  payment_accounts: (err, callBack) => {
    pool.query(
      `SELECT name from tbl_dropdown WHERE type = ?`,
      ["BANK_ACCOUNTS"],
      (error, results) => {
        if (results.length < 1) {
          return callBack(1, null);
        }
        if (error) {
          return callBack(error, null);
        }
        return callBack(null, results);
      }
    );
  },
  update_cart_item: (data, callBack) => {
    if (data.SKU == "" || data.SKU == undefined) {
      return callBack(1);
    }
    if (data.vendor_id == "" || data.vendor_id == undefined) {
      return callBack(1);
    }
    pool.query(
      `SELECT * from tbl_dealerapp_cart WHERE vendor_id = ? AND SKU = ?`,
      [data.vendor_id, data.SKU],
      (errs, res, fields) => {
        if (errs) {
          return callBack(2);
        }
        let quantity = res[0].quantity;
        let unit_price = res[0].unit_price;
        let total_price = res[0].total_price;

        if (data.argument == "INC") {
          var update_qnty = quantity + 1;
          var update_total_price = total_price + unit_price;
        } else if (data.argument == "DEC") {
          if (res[0].quantity == 1) {
            pool.query(
              `DELETE from tbl_dealerapp_cart WHERE vendor_id = ? AND SKU = ?`,
              [data.vendor_id, data.SKU],
              (error, results, fields) => {
                if (error) {
                  return callBack(3);
                }
                // if(results.affectedRows < 1){
                //     return callBack(2)
                // }
                return callBack(null, true);
              }
            );
          }
          var update_qnty = quantity - 1;
          var update_total_price = total_price - unit_price;
        }
        pool.query(
          `UPDATE tbl_dealerapp_cart set quantity =? , total_price =?  WHERE vendor_id = ? AND SKU = ?`,
          [update_qnty, update_total_price, data.vendor_id, data.SKU],
          (final_err, resData) => {
            if (final_err) {
              return final_err;
            }
            return callBack(null, resData);
          }
        );
      }
    );
  },
  deleteCartItem: (cart_id, callBack) => {
    if (cart_id == "" || cart_id == undefined) {
      return callBack(1);
    }
    pool.query(
      `DELETE from tbl_dlr_cart WHERE cart_id = ?`,
      [cart_id],
      (error, results, fields) => {
        if (error) {
          return callBack(error);
        }
        if (results.affectedRows < 1) {
          return callBack(2);
        }
        return callBack(null, true);
      }
    );
  },
};
