//require('dotenv').config({path: '../.env'})
const pool = require("./config/database");
const request = require('request-promise');

const e = require("express");
module.exports = {

    get_devices:(data, callBack) => {

        let saletype = "DEALERAPP"
        let status = "RFS"
        pool.query(
            `select grnreport_id,product_brand, device_name, color,ram,rom, stock_type, device_sub_category, SUBSTRING(SKU, 1, LENGTH(SKU)-4) as SKU,stock_type, certification_grade,count(grnreport_id) as available_qnty from tbl_grnreport 
             where saletype = ? and status = ? GROUP BY device_name, ram, rom, certification_grade`,
            [saletype,status],
            (err, result) => {
                if(err){
                    return callBack(err)
                }
                if(result.length == 0){
                    return callBack (1)
                }
                return callBack (null, result)
            }
        );
    },
    get_bundle_types:(callBack) => {

        let type = "BUNDLE_TYPE"
       
        pool.query(
            `select name from tbl_dropdown WHERE type = ? GROUP BY name`,
            [type,],
            (err, result) => {
                if(err){
                    return callBack(err)
                }
                if(result.length == 0){
                    return callBack (1)
                }
                result_array = []
                result.forEach((element) => {
                    result_array.push(element.name)
                })
                if(result.length == result_array.length){

                    return callBack (null, result_array)
                }
            }
        );
    },
    get_devices_by_stocktype:(body_data, callBack) => {

        var vendor_id = body_data.vendor_id
        let saletype = "DEALERAPP"
        let status = "RFS"
        pool.query(
            `select grnreport_id, nhdin as device_id, product_brand, device_name, color,ram,rom,SKU,stock_type, device_sub_category, SUBSTRING(SKU, 1, LENGTH(SKU)-4) as SKU, mrp, stock_type, certification_grade from tbl_grnreport 
            where saletype = ? AND status = ? AND stock_type IN ("OPEN BOX","DEMO") GROUP BY device_name,ram, rom, certification_grade,device_sub_category`,
            [saletype,status],
            (err_msg, result) => {
                if(err_msg){
                    return callBack(1,err_msg)
                }
                if(result.length == 0){
                    var err_msg = "No results found"
                    return callBack (1,err_msg)
                }
                devices_list = []
                result.forEach((value, key_no) => {

                    var grnreport_id = value.grnreport_id;
                    pool.query(
                        `select * from tbl_dealer_cart WHERE bundle_id = ? AND vendor_id = ?`,
                        [grnreport_id, vendor_id],
                        (cart_err, cart_response) => {

                            if(cart_err){
                                return callBack(cart_err)
                            }
                            if(cart_response.length < 1){
                                var flag = 0
                            } else{
                                var flag = 1
                            }
                            result_obj = {
                                
                                grnreport_id: grnreport_id,
                                device_id: value.device_id,
                                product_brand: value.product_brand,
                                device_name: value.device_name,
                                color: value.color,
                                ram: value.ram,
                                rom: value.rom,
                                sku : value.sku,
                                device_sub_category :value.device_sub_category,
                                mrp :value.mrp,
                                certification_grade :value.certification_grade
                            };
                            result_obj.flag = flag
                            devices_list.push(result_obj);
                            if(devices_list.length == result.length){

                                return callBack (null, devices_list)
                            }
                        }
                    )
                })
            }
        );
    },
    get_bundles:(vendor_id,callBack) => {

        let status = "ACTIVE"
        pool.query(
            `select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, status from tbl_dealer_bundle WHERE status = ?`,
            [status],
            (err, result) => {
                if(err){
                    return callBack(err)
                }
                if(result.length == 0){
                    return callBack (1)
                }
                var bundle_ids = []
                var devices_list = []
                result.forEach((value, key_no) => {

                    var bundle_id = value.bundle_id;
                    var bundle_type = value.type;
                    var grade_qnty = ''
                    if(bundle_type == "1A"){
                        grade_qnty = "SG-A(5) SG-B(5)" 
                    } else if(bundle_type == "1B"){
                        
                        grade_qnty = "SG-A(4) SG-B(6)" 
                    } else if(bundle_type == "1C"){
                        
                        grade_qnty = "SG-A(2) SG-B(3) SG-C(5)" 
                    } else if(bundle_type == "1D"){
                        
                        grade_qnty = "SG-D(10)" 
                    } else if(bundle_type == "1E"){
                        
                        grade_qnty = "SG-B(3) SG-C(7)" 
                    } else if(bundle_type == "1F"){
                        
                        grade_qnty = "SG-B(3) SG-C(5) SG-D(2)" 
                    } else if(bundle_type == "2A" || bundle_type == "2B" || bundle_type == "2C" || bundle_type == "2D" || bundle_type == "2E" || bundle_type == "2F"){
                        
                        grade_qnty = "SG-A(3) SG-B(3) SG-B(4)" 
                    }
                    bundle_ids.push(bundle_id)
                    pool.query(
                        `select grade, count(item_id) as grade_qnty from tbl_dealer_bundle_item WHERE bundle_id = ? GROUP BY grade`,
                        [bundle_id],
                        (res_err, response) => {
                            if(res_err){
                                return callBack(res_err)
                            }
                            if(response.length < 1){
                                return callBack (1)
                            }
                            summary_grade = []
                            response.forEach((res, key) => {

                                summary_grade.push(response[key].grade+' - '+response[key].grade_qnty)
                            })
                            var diff = value.mop - value.amount
                            mop = value.mop
                            save_percent = parseInt((diff * 100)/mop);
                            let string = summary_grade.toString();
                            pool.query(
                                `select * from tbl_dealer_cart WHERE bundle_id = ? AND vendor_id = ?`,
                                [bundle_id, vendor_id],
                                (cart_err, cart_response) => {

                                    if(res_err){
                                        return callBack(cart_err)
                                    }
                                    if(cart_response.length < 1){
                                        var flag = 0
                                    } else{
                                        var flag = 1
                                    }
                                    result_obj = {
                                
                                        bundle_id: bundle_id,
                                        bundle_no: value.bundle_no,
                                        type: value.type,
                                        grade_qnty: grade_qnty,
                                        quantity: value.quantity,
                                        mop: value.mop,
                                        amount: value.amount,
                                        save : save_percent,
                                        category :value.category,
                                        sub_category :value.sub_category,
                                        status :value.status,
                                        grade_summary :string
        
                                    };
                                    result_obj.flag = flag
                                    devices_list.push(result_obj);
                                    if(devices_list.length == result.length){

                                        return callBack (null, devices_list)
                                    }
                            })
                            
                        }
                    );
                })
            }
        );
    },
    bundle_info:(bundle_id, callBack) => {

        pool.query(
            `select * from tbl_dealer_bundle_item WHERE bundle_id = ?`,
            [bundle_id],
            (err, result) => {
                if(err){
                    return callBack(err)
                }
                if(result.length == 0){
                    return callBack (1)
                }
                var bundle_data = [];
                result.forEach(element => {

                    //cart.push(element)
                    let grnreport_id = element.grnreport_id
                    pool.query(
                        `SELECT product_brand, device_name, SKU, color, ram, rom, stock_type, device_sub_category from tbl_grnreport WHERE grnreport_id = ?`,
                        [grnreport_id],
                        (err, row) => {
                            if(err){
                                return callBack(err)
                            }
                            if(row.length < 1){
                                return callBack(err)
                            }
                            result_obj = {
                                
                                product_brand : row[0].product_brand,
                                device_name : row[0].device_name,
                                sku : row[0].SKU,
                                ram : row[0].ram,
                                rom : row[0].rom,
                                color : row[0].color,
                                category : row[0].stock_type,
                                sub_categoty : row[0].device_sub_categoty,
                                grade : element.grade,
                                mop : element.mop,
                                price : element.price
                            };
                            bundle_data.push(result_obj)
                            if(bundle_data.length == result.length){
                                return callBack(null, bundle_data)
                            }
                        }
                    )
                })
            }
        )
    }

      
}
