var async = require("async");
require('dotenv').config({path: '../.env'})

const { 
    
    get_devices,
    get_devices_by_stocktype,
    get_bundles,
    get_bundle_types,
    bundle_info
} = require("./devices-service");
     
module.exports = {

    getDevices: (req,res) => {
        
        try{
            get_devices(token,(err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            mag: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
               return res.status(200).json({
                    status : 1,
                    data:results
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getDevicesByStockType: (req,res,cb) => {
        
        var body_data = req.body
        var stock_type = body_data.stock_type
        if(stock_type != "OPEN BOX"){

            return res.status(200).json({
                status:0,
                mag: "Please select Open Box"
            })
        }
        try{
            get_devices_by_stocktype(body_data,(err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            mag: results
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    data:results
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getBundles: (req,res,cb) => {
        
        var vendor_id = req.params.vendor_id;
        if(vendor_id == '' || vendor_id == 0 || vendor_id == undefined || vendor_id == 'NaN' ){

            return res.status(200).json({
                status: 0,
                message: "Please provide valid vendor id" 
            });
        }
        try{
            get_bundles(vendor_id,(err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            mag: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    data:results
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    bundleInfo: (req,res,cb) => {

        var bundle_id = req.params.bundle_id;
        try{
            bundle_info(bundle_id,(err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            mag: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    data:results
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
    getBundleTypes: (req,res,cb) => {
        
        try{
            get_bundle_types((err, results) => {
            
                if(err){
                    if(err == 1){

                        return res.status(404).json({
                            status:0,
                            mag: "No results found"
                        })
                    }
                    return res.status(500).json({
                        status:0,
                        err: err
                    })
                }
                return res.status(200).json({
                    status : 1,
                    data:results
                })
            })
        }catch (error) {
            return res.status(500).json({
                status:0,
                err: error
            })
        }
    },
   
}
