require("dotenv").config({ path: "../.env" });
const connect_pool = require("./config/database");
const request = require("request-promise");
const mysql = require('mysql2/promise');
const db_conn = {
  port:process.env.DB_PORT,
  host:process.env.DB_HOST,
  user:process.env.DB_USER,
  password:process.env.DB_PASSWORD,
  database:process.env.DB_NAME
}
require("dotenv").config({ path: "../.env" });
module.exports = {
  add_log: (request, response) => {
    var req = JSON.stringify(request);
    
    try {
      connect_pool.query(
        `INSERT into tbl_dealer_error_log(request,response)
        VALUES(?,?)`,
        [req,response]
      );
    } catch (e) {}

  },
  search_dealer: (data, callBack) => {
    var search_by = data.search_by;

    try {
      connect_pool.query(
        `select * from tbl_vendor where vendor_id = ? OR vendor_code = ? OR aadhar_no =? OR gst_no = ? OR pan_card = ?`,
        [search_by, search_by, search_by, search_by, search_by],
        (err, result) => {

          if (err) {
            return callBack(err);
          }

          if (result.length == 0) {
            return callBack(1);
          }

          return callBack(null, result);
        }
      );
    } catch (e) {
      return callBack(e); //"**Error ecounterd, staff not registerd**\nPlease contact system Administrator.")
    }

  },
  update_mobile: (body_data, callBack) => {
    var dealer_app = "Y";

    try {
      connect_pool.query(
        `UPDATE tbl_vendor set mobile=?, pin=?, dealer_app = ? where vendor_id = ?`,
        [body_data.mobile, body_data.pin, dealer_app, body_data.vendor_id],
        (err, row) => {

          if (err) {
            return callBack(err);
          }

          return callBack(null, row[0]);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  check_mobile: (body_data, callBack) => {

    try {
      connect_pool.query(
        `SELECT * from tbl_vendor WHERE mobile = ?`,
        [body_data.mobile],
        (err, row) => {

          if (err) {
            return callBack(err);
          }

          return callBack(null, row);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  update_pin: (body_data, callBack) => {
    var dealer_app = "Y";

    try {
      connect_pool.query(
        `UPDATE tbl_vendor SET pin=?, dealer_app = ? WHERE vendor_id = ?`,
        [body_data.pin, dealer_app, body_data.vendor_id],
        (err, row) => {

          if (err) {
            return callBack(err);
          }

          return callBack(null, row[0]);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  send_otp: (mobile, callBack) => {
    var otp = Math.floor(1000 + Math.random() * 9000);
    var string_otp = otp.toString() + process.env.OTPSECRET;
    let bufferObj = Buffer.from(string_otp, "utf8");
    let encode_otp = bufferObj.toString("base64");
    var d = new Date();
    var min = d.getMinutes();
    var added_min = min + 2;
    var datetime = d.getDate() + "-" + (d.getMonth() + 1) +  "-" + d.getFullYear() +  " " + d.getHours() + ":" + added_min + ":" +  d.getSeconds();
    var message = "Dear Customer, " + otp + " is the OTP for your login/registration at SelTrue App. In case you have not requested this, please contact us at it@sloyd.in - Sloyd";
    //var sms_url = `http://smslogin.mobi/v3/api.php?username=ynewotp&apikey=${process.env.APIKEY}&senderid=${process.env.SENDERID}&templateid=${process.env.TEMPLATEID}&mobile=${mobile}&message=${message}`;
    var sms_url = `http://smslogin.co/v3/api.php?username=Ynewdc&apikey=${process.env.APIKEY}&senderid=${process.env.SENDERID}&templateid=${process.env.TEMPLATEID}&mobile=${mobile}&message=${message}`;
    
    const options = {
      method: "GET",
      uri: sms_url,
    };

    request(options)
      .then(function (response) {

        function strToObj(response) {
          var obj = {};

          if (response && typeof response === "string") {
            var objStr = response.match(/\{(.)+\}/g);
            eval("obj =" + objStr);
          }

          return obj;
        }
        var obj_res = strToObj(response);

        if (obj_res.campid) {

          try {
            connect_pool.query(`INSERT into tbl_dealer_otp(mobile_no,otp,expiry_time) VALUES(?,?,?)`,
              [mobile, encode_otp, datetime],
              (err, row) => {

                if (err) {
                  return callBack(err);
                }
                return callBack(null, otp);
              }
            );
          } catch (e) {
            return callBack(e);
          }

        }
      })
      .catch((catch_err) => {
        return callBack(catch_err);
      });

  },
  verify_otp: (body, callBack) => {
    var otp = body.otp;
    var string_otp = otp.toString() + process.env.OTPSECRET;
    let bufferObj = Buffer.from(string_otp, "utf8");
    let encode_otp = bufferObj.toString("base64");

    try {
      connect_pool.query(
        `SELECT * FROM tbl_dealer_otp WHERE mobile_no = ? ORDER BY otp_id DESC`,
        [body.mobile],
        (otp_err, otpData) => {

          if (otp_err) {
            return callBack(otp_err);
          }

          if (otpData.length < 1) {
            let err_otp = "No otp available";
            return callBack(1, err_otp);
          }

          var stored_otp = otpData[0].otp;

          if (stored_otp != encode_otp) {
            let err_otp = "Please enter correct OTP";
            return callBack(1, err_otp);
          }

          var d = new Date();
          var dd = d.getDate();
          if(dd<10) 
          {
              dd='0'+dd;
          } 
          var mm = d.getMonth()+1; 
          if(mm<10) 
          {
              mm='0'+mm;
          } 
          var datetime = dd + "-" + mm + "-" + d.getFullYear() + " " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
          var expiry_date = otpData[0].expiry_time;
          
          if (datetime > expiry_date) {
            let expire_otp = "Your otp has expired";
            return callBack(1, expire_otp);
          }

          try {
            connect_pool.query(
              `DELETE FROM tbl_dealer_otp WHERE mobile_no = ?`,
              [body.mobile],
              (dlt_err, dltData) => {

                if (dlt_err) {
                  return callBack(dlt_err);
                }
                let suc_msg = "OTP is verified";
                return callBack(null, suc_msg);
              }
            );
          } catch (e) {
            return callBack(e);
          }

        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  create: (data, callBack) => {
    var gst = data.gst;
    var pan = data.pan;
    var dealer_app = "Y";
    var mobile_no = data.mobile;
    var user_type = "DEALER";
    var used_type = "buyer";
    var country = "INDIA";
    var dealer_status = "N";
    const regexExp = /^[6-9]\d{9}$/gi;

    if (!regexExp.test(mobile_no)) {
      let err_input = "Please enter valid mobile number";
      return callBack(1, err_input);
    }

    try {
      connect_pool.query(
        `SELECT * FROM tbl_vendor WHERE mobile = ? AND user_type = ?`,
        [mobile_no, user_type],
        (data_err, vendorData) => {

          if (data_err) {
            return callBack(data_err);
          }

          if (vendorData.length > 0) {
            let err_mobile = "Mobile number already exist";
            return callBack(1, err_mobile);
          }

          try {
            connect_pool.query(
              `SELECT state_id FROM tbl_states WHERE name = ? `,
              [data.state],
              (state_err, stateData) => {

                if (state_err) {
                  return callBack(state_err);
                }
                
                if (stateData.length < 1) {
                  let err_state = "State does not exist";
                  return callBack(1, err_state);
                }

                var state_id = stateData[0].state_id;
                try {
                  connect_pool.query(
                    `INSERT into tbl_vendor(company,name, used_type, user_type, country, state,city,address,pincode,aadhar_no,gst_no,pan_card,mobile,pin,dealer_app,upi_id)
                    VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                    [
                      data.company,
                      data.name,
                      used_type,
                      user_type,
                      country,
                      state_id,
                      data.city,
                      data.address,
                      data.postal_code,
                      data.aadhar,
                      gst,
                      pan,
                      data.mobile,
                      data.pin,
                      dealer_status,
                      data.upi_id
                    ],
                    (error, results) => {

                      if (error) {
                        return callBack(error);
                      }

                      var vendor_id = results.insertId;
                      var vendor_code = "SLYB-H-B2B-" + vendor_id;

                      try {
                        connect_pool.query(
                          `UPDATE tbl_vendor set vendor_code=? WHERE vendor_id = ?`,
                          [vendor_code, vendor_id],
                          (err, res) => {

                            if (err) {
                              return callBack(err);
                            }
                            data.vendor_code = vendor_code;
                            var message = "Thank you for connecting with SLOYD - SELTRUE, India's best refurbished smartphone brand. Please wait for a while till your registration request is approved.";
                            var sms_url = `http://smslogin.co/v3/api.php?username=Ynewdc&apikey=${process.env.APIKEY}&senderid=${process.env.SENDERID}&templateid=${process.env.REG_TEMPLATEID}&mobile=${mobile_no}&message=${message}`;
                            const options = {
                              method: "GET",
                              uri: sms_url,
                            };
                            request(options)
                            .then(function (response) {
                              //console.log(response)
                              function strToObj(response) {
                                var obj = {};

                                if (response && typeof response === "string") {
                                  var objStr = response.match(/\{(.)+\}/g);
                                  eval("obj =" + objStr);
                                }
                                return obj;
                              }
                              var obj_res = strToObj(response);

                              if (obj_res.campid) {
                                return callBack(null, data);
                              }
                            })
                            .catch((catch_err) => {
                              return callBack(catch_err);
                            });
                          }
                        );
                      } catch (e) {
                        return callBack(e);
                      }
                    }
                  );
                } catch (e) {
                  return callBack(e);
                }

              }
            );
          } catch (e) {
            return callBack(e);
          }

        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  getDealerByDealerPhone: async (data, callBack) => {
    var dealer_app = "Y";
    try {
      let qr1 = "SELECT * from tbl_vendor WHERE mobile = ? AND pin = ? AND dealer_app = ?";
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, [data.mobile, data.pin, dealer_app], (row1_err, row1) => {
              if (row1_err) return callBack(row1_err);
              res(row1);
          });
      });
      if (qr1_res.length < 1) {
        let err_report =  "Invalid mobile or pin";
        return callBack(1, err_report);
      }
      if(qr1_res[0].state <= 0 || isNaN(qr1_res[0].state)){
        let err_report =  "State not availabe";
        return callBack(1, err_report);
      }
      let qr2 = "SELECT name from tbl_states WHERE state_id = ?";
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, qr1_res[0].state, (row2_err, row2) => {
          if (row2_err) return rej(row2_err);
              res(row2);
          });
      });
      if(qr2_res.length <= 0){
        let err_report =  "State not availabe";
        return callBack(1, err_report);
      }
      if (qr2_res[0].name == undefined || qr2_res[0].name == "undefined") {
        let err_report =  "State not availabe";
        return callBack(1, err_report);
      }
      let active = "Y";
      let qr3 = "select attached_to_vendor,attached_vendor_upi from ATTACHED_VENDOR_CATEGORY_LIST_VIEW where vendor_id = ? AND active = ?";
      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3, [qr1_res[0].vendor_id, active], (row3_err, row3) => {
          if (row3_err) return rej(row3_err);
              res(row3);
          });
      });
      if(qr3_res.length > 0){
        var attached_vendor_id = qr3_res[0].attached_to_vendor;
      } else {
        var attached_vendor_id = "";
      }
      delete qr1_res[0].pin;
      qr1_res[0].state = qr2_res[0].name;
      qr1_res[0].attached_vendor_id = attached_vendor_id;
      qr1_res[0].attached_vendor_upi = qr3_res[0].attached_vendor_upi;
      return callBack(null, qr1_res[0]);
      
    } catch (err) {
      callBack(err)
    }
  },
  update_dealer: (data, callBack) => {
    var column_name = data.type;
    var column_val = data.update_val;
    var vendor_id = data.vendor_id;

    try {
      connect_pool.query(
        `UPDATE tbl_vendor SET ${column_name} = ? WHERE vendor_id = ?`,
        [column_val, vendor_id],
        (error, results, fields) => {

          if (error) {
            return callBack(1, error);
          }

          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  get_ApkVersion: (callBack) => {

    try {
      connect_pool.query(
        `SELECT build_no FROM tbl_dealer_apk_version ORDER by build_no DESC`,
        
        (error, results, fields) => {

          if (error) {
            return callBack(1, error);
          }

          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  update_ApkVersion: (data, callBack) => {
    var column_name = data.type;
    var column_val = data.update_val;
    var previous_build = data.previous_build;

    try {
      connect_pool.query(
        `UPDATE tbl_dealer_apk_version SET ${column_name} = ? WHERE build_no = ?`,
        [column_val, previous_build],
        (error, results, fields) => {

          if (error) {
            return callBack(1, error);
          }

          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  deleteDealer: (data, callBack) => {

    try {
      connect_pool.query(
        `DELETE from tbl_dlr_dealers where dealer_id = ?`,
        [data.dealer_id],
        (error, results) => {
            
          if (error) {
            return callBack(error);
          }

          return callBack(null, results[0]);
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  get_profile_info: async (vendor_id, callBack) => {
    try {
      let qr1 = "select * from DEALER_CATEGORY_LIST_VIEW where vendor_id = ?";
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, vendor_id, (row1_err, row1) => {
              if (row1_err) return callBack(row1_err);
              res(row1);
          });
      });
      let active = "Y";
      let qr2 = "select name,attached_to_vendor from ATTACHED_VENDOR_CATEGORY_LIST_VIEW where vendor_id = ? AND active = ?";
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, [vendor_id, active], (row2_err, row2) => {
          if (row2_err) return rej(row2_err);
              res(row2);
          });
      });
      if(qr2_res.length > 0){
        var attached_vendor_id = qr2_res[0].attached_to_vendor;
        var attched_vendor_name = qr2_res[0].name;
      } else {
        var attached_vendor_id = "";
        var attched_vendor_name = ""
      }
      let res_obj = {
        "vendor_name" : qr1_res[0].vendor_name,
        "vendor_code" : qr1_res[0].vendor_code,
        "mobile" : qr1_res[0].mobile,
        "email" : qr1_res[0].email,
        "pan_card" : qr1_res[0].pan_card,
        "aadhar_no" : qr1_res[0].aadhar_no,
        "gst_no" : qr1_res[0].gst_no,
        "address" : qr1_res[0].address,
        "city" : qr1_res[0].city,
        "state_name" : qr1_res[0].state_name,
        "pincode" : qr1_res[0].pincode,
        "category_name" : qr1_res[0].category_name,
        "upi_id" : qr1_res[0].upi_id,
        "category_id" : qr1_res[0].category_id,  // This is usefull for placing order (to send through req)
        "attched_vendor_id" : attached_vendor_id, // This is usefull for placing order (to send through req)
        "attched_vendor_name" : attched_vendor_name
      }
      return callBack(null, res_obj)
    } catch (err) {
      callBack(err)
    }
  },
  get_attached_list: async (attached_vendor_id, callBack) => {
    try {
      let active = "Y";
      let qr1 = "select * from ATTACHED_VENDOR_CATEGORY_LIST_VIEW where attached_to_vendor = ? AND active = ?";
      let qr2 = "select * from DEALER_CATEGORY_LIST_VIEW where vendor_id = ?";
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, [attached_vendor_id,active], (row1_err, row1) => {
              if (row1_err) return callBack(row1_err);
              res(row1);
          });
      });
      if(qr1_res.length < 1){
        return callBack("No results found")
      }

      var result_obj = [];
      for (var i = 0; i < qr1_res.length; i += 1) {
        var vendor_id =qr1_res[i].vendor_id;
        var qr2_res = await new Promise((res, rej) => {
          connect_pool.query(qr2, [vendor_id],
            (result2_err, results_2) => {
            
              if (result2_err){
               
                return callBack(result2_err);
              } 
              res(results_2);
          });
        });
        obj = {
          
          "vendor_id" : qr2_res[0].vendor_id,
          "vendor_name" : qr2_res[0].vendor_name, 
          "vendor_code" : qr2_res[0].vendor_code,
          "mobile" : qr2_res[0].mobile, 
          "email" : qr2_res[0].email, 
          "upi_id" : qr2_res[0].upi_id, 
          "category_name" : qr2_res[0].category_name,
          "dealer_type" : qr2_res[0].dealer_type, 
          "pan_card" : qr2_res[0].pan_card,
          "aadhar_no" : qr2_res[0].aadhar_no, 
          "gst_no" : qr2_res[0].gst_no, 
          "city" : qr2_res[0].city,
          "address" : qr2_res[0].address
        }
        result_obj.push(obj)
      };
      return callBack(null, result_obj)
    } catch (err) {
      callBack(err)
    }
  },
  sales_persons_list: async (vendor_id, callBack) => {

    var dealer_type = "SALES PERSON";
    var qr1 = "SELECT * FROM ATTACHED_DEALER_TYPE_LIST_VIEW WHERE attached_to_vendor = ? AND dealer_type = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id, dealer_type], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      var result_obj = [];
      for (var i = 0; i < qr1_res.length; i += 1) {
        
        obj = {
          
          "vendor_id" : qr1_res[i].vendor_id,
          "vendor_code" : qr1_res[i].vendor_code,
          "name" : qr1_res[i].name,
          "mobile" : qr1_res[i].mobile,
          "address" : qr1_res[i].address,
          "city" : qr1_res[i].city,
          "pincode" : qr1_res[i].pincode,
          "drop_down_item" : qr1_res[i].vendor_code + " / " + qr1_res[i].name + " - " + qr1_res[i].city
        }
        result_obj.push(obj)
      };
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : result_obj})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  available_dealers: async (vendor_id, callBack) => {

    var dealer_type = "DEALER";
    var qr1 = "SELECT * FROM ATTACHED_DEALER_TYPE_LIST_VIEW WHERE attached_to_vendor = ? AND dealer_type = ?"
    var qr2 = "SELECT * FROM tbl_dealerapp_sales_person WHERE vendor_id = ? AND active = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id, dealer_type], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      var result_obj = [];
      for (var i = 0; i < qr1_res.length; i += 1) {
        var vendorId = qr1_res[i].vendor_id;
        var qr2_res = await new Promise((res, rej) => {
          connect_pool.query(qr2,[vendorId, "Y"], 
            (qr2_err, qr2_results) => {
              
                if (qr2_err){
                  connection.rollback(); return callBack({status:0, message:qr2_err});
                } 
                res(qr2_results);
            });
        });
        if(qr2_res.length < 1){
          obj = {
          
            "vendor_id" : qr1_res[i].vendor_id,
            "vendor_code" : qr1_res[i].vendor_code,
            "name" : qr1_res[i].name,
            "mobile" : qr1_res[i].mobile,
            "address" : qr1_res[i].address,
            "city" : qr1_res[i].city,
            "pincode" : qr1_res[i].pincode,
            "drop_down_item" : qr1_res[i].vendor_code + " / " + qr1_res[i].name + " - " + qr1_res[i].city
          }
          result_obj.push(obj)
        }
      };
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : result_obj})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  tag_to_sales_person: async (body, callBack) => {

    var qr1 = "INSERT INTO tbl_dealerapp_sales_person (`distributor_id`,`sales_person_id`,`vendor_id`) VALUES (?,?,?)";
    var qr2 = "Select active FROM tbl_dealerapp_sales_person WHERE vendor_id = ? AND active = ?";
    var dist_id = body.distributor_id;
    var sales_person_id = body.sales_person_id;
    var dealer_ids = body.dealer_ids;
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      for (var i = 0; i < dealer_ids.length; i += 1) {
          var vendorId = dealer_ids[i];
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2,[vendorId, "Y"], 
              (qr2_err, qr2_results) => {
                
                  if (qr2_err){
                    connection.rollback(); return callBack({status:0, message:qr2_err});
                  } 
                  res(qr2_results);
              });
          });
          if(qr2_res.length > 1){
            if(qr2_res[0].active == "Y"){
              return callBack({status :0, message : "Some of the vendor is already tagged to sales person"})
            }
          }
          var qr1_res = await new Promise((res, rej) => {
            connect_pool.query(qr1,[dist_id,sales_person_id,vendorId], 
            (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
        });
      }
      connection.commit();
      connection.end();
      return callBack(null, {status :1, message : "You have added dealers to distributors successfully"})
      
        } catch (err) {
        connection.rollback();
        //connection.releaseConnection();
        return callBack({status:0, message:err});
      }
  },
  tagged_dealers: async (sales_person_id, callBack) => {

    var qr1 = "SELECT * FROM SALES_PERSON_DEALER_LIST_VIEW WHERE sales_person_id = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[sales_person_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : qr1_res})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
};
