const {
  searchDealer,
  updateDealerMobile,
  checkMobile,
  updatePIN,
  dealerLogin,
  createDealer,
  sendOtp,
  verifyOTP,
  refreshToken,
  updateDealer,
  updateApkVersion,
  getApkVersion,
  getProfileInfo,
  getAttachedList,
  getSalesPersons,
  getAvailableDealers,
  tagDealerToSalesPerson,
  taggedDealersList
} = require("./registration-controller");

const router = require("express").Router();
router.post("/searchById", searchDealer);
router.post("/updateMobile", updateDealerMobile);
router.post("/checkMobile", checkMobile);
router.post("/updatePIN", updatePIN);
router.post("/dealerLogin", dealerLogin);
router.post("/newDealer", createDealer);
router.post("/sendOTP", sendOtp);
router.post("/verifyOTP", verifyOTP);
router.post("/getAccessToken", refreshToken);
router.post("/updateDealer", updateDealer);
router.post("/updateApkVersion", updateApkVersion);
router.post("/getApkVersion", getApkVersion);
router.get("/getProfileInfo/:vendor_id", getProfileInfo);
router.get("/getAttachedList/:attached_vendor_id", getAttachedList);
router.get("/getSalesPersons/:vendor_id", getSalesPersons);
router.get("/getAvailableDealers/:vendor_id", getAvailableDealers);
router.post("/tagDealerToSalesPerson", tagDealerToSalesPerson);
router.get("/taggedDealersList/:sales_person_id", taggedDealersList);

module.exports = router;
