require("dotenv").config({ path: "../.env" });

const {
  add_log,
  search_dealer,
  update_mobile,
  check_mobile,
  update_pin,
  send_otp,
  verify_otp,
  update_dealer,
  create,
  deleteDealer,
  update_ApkVersion,
  getDealerByDealerPhone,
  get_ApkVersion,
  get_profile_info,
  get_attached_list,
  sales_persons_list,
  available_dealers,
  tag_to_sales_person,
  tagged_dealers
} = require("./registration-service");

const { sign } = require("jsonwebtoken");
const tokenList = {};

module.exports = {
  updateDealerMobile: (req, res) => {
    var vendor_id = req.body.vendor_id;
    var mobile = req.body.mobile;
    var pin = req.body.pin;

    if (vendor_id == "") {
      return res.status(200).json({
        status: 0,
        message: "Please provide vendor id ",
      });
    }

    if (mobile.length < 10 || mobile == "") {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid mobile number ",
      });
    }

    if (pin.length != 4) {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid PIN length",
      });
    }

    var body_data = req.body;

    try {
      update_mobile(body_data, (err, results) => {

        if (err) {
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        return res.status(200).json({
          status: 1,
          data: "Mobile and PIN updated successfully ",
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  checkMobile: (req, res, cb) => {
    var mobile = req.body.mobile;

    if (mobile.length < 10 || mobile == "") {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid mobile number ",
      });
    }

    var body_data = req.body;

    try {
      check_mobile(body_data, (err, results) => {

        if (err) {
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        if (results.length == 0) {
          return res.status(401).json({
            status: 0,
            message: "dealer not found",
          });
        }

        return res.status(200).json({
          status: 1,
          vendor_id: results[0]["vendor_id"],
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  updatePIN: (req, res) => {
    var vendor_id = req.body.vendor_id;
    var pin = req.body.pin;

    if (vendor_id == "") {
      return res.status(200).json({
        status: 0,
        message: "Please provide vendor id",
      });
    }

    if (pin.length != 4) {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid PIN length",
      });
    }

    var body_data = req.body;

    try {
      update_pin(body_data, (err, results) => {

        if (err) {
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        return res.status(200).json({
          status: 1,
          data: "PIN updated successfully",
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  searchDealer: (req, res) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if (body.search_by == "" || body.search_by == 0 || body.search_by == "NaN") {
      return res.status(200).json({
        status: 0,
        message: "Please provide either Vendor code, Adhar, GST or PAN number",
      });
    }
    
    try {
      search_dealer(body, (err, results) => {

        if (err) {
          if (err == 1) {
            return res.status(404).json({
              status: 0,
              massage: "No results found",
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        return res.status(201).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  sendOtp: (req, res) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    var mobile = body.mobile;
    const regexExp = /^[6-9]\d{9}$/gi;

    if (!regexExp.test(mobile)) {
      return res.status(200).json({
        status: 0,
        message: "Please enter valid mobile number",
      });
    }
    
    try {
      send_otp(mobile, (err, results) => {

        if (err) {
          if (err == 1) {
            return res.status(200).json({
              status: 0,
              message: "OTP not sent",
            });
          }
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }

        return res.status(200).json({
          status: 1,
          otp: results,
        });
      });

    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  verifyOTP: (req, res) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    var mobile = body.mobile;
    const regexExp = /^[6-9]\d{9}$/gi;

    if (!regexExp.test(mobile)) {
      return res.status(200).json({
        status: 0,
        message: "Please enter valid mobile number",
      });
    }

    var otp = body.otp;

    if (otp == "" || otp.length < 4 || otp == "NaN") {
      return res.status(200).json({
        status: 0,
        message: "Please enter 4-digits otp number",
      });
    }

    try {
      verify_otp(body, (err, results) => {

        if (err) {
          if (err == 1) {
            return res.status(200).json({
              status: 0,
              message: results,
            });
          }
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }

        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  createDealer: (req, res) => {
    const body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    var upi_id = body.upi_id;
    var upi_check = /^[\w.-]+@[\w.-]+$/.test(upi_id);
    if(upi_check == false){
      return res.status(200).json({
        status: 0,
        message: "Please provide Valid UPI Id",
      });
    }
    if (body.gst == "" || body.gst == "0" || body.gst == "NaN") {
      if (body.pan == "" || body.pan == "0" || body.pan == "NaN") {
        return res.status(200).json({
          status: 0,
          message: "Please provide GST number or PAN number",
        });
      }
    }

    var pan = body.pan;
    var gst = body.gst;
    var aadhar = body.aadhar;

    if (pan != "") {
      if (pan.length < 10 || pan.length > 10) {
        return res.status(201).json({
          status: 0,
          message: "PAN number lenght should be 10 digits",
        });
      }
    }

    if (body.gst != "") {
      if (gst.length < 15 || gst.length > 15) {
        return res.status(201).json({
          status: 0,
          message: "GST number lenght should be 15 digits",
        });
      }
    }

    if (body.aadhar != "") {
      if (aadhar.length < 12 || aadhar.length > 12) {
        return res.status(201).json({
          status: 0,
          message: "Aadhar number lenght should be 12 digits",
        });
      }
    }

    try {
      create(body, (err, results) => {

        if (err) {
          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: "You have registered successfully ",
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  dealerLogin: (req, res) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    try {
      getDealerByDealerPhone(body, (err, results) => {

        if (err) {
          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          }
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }

        if (results) {

          const input = {
            mobile: body.mobile,
            pin: body.pin,
          };

          const jsonwebtoken = sign(input, process.env.SECRET, {
            expiresIn: process.env.TOKENLIFE,
          });

          const refreshToken = sign(input, process.env.REFRESHTOKENSECRET, {
            expiresIn: process.env.REFRESHTOKENLIFE,
          });

          const response = {
            status: 1,
            message: "login successfully",
            data: results,
            accessToken: jsonwebtoken,
            refreshToken: refreshToken,
          };

          tokenList[refreshToken] = response;
          res.status(200).json(response);
        } else {
          return res.status(404).json({
            status: 0,
            data: "Results Not found",
          });
        }

      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  refreshToken: (req, res) => {
    const postData = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(postData, response)
      oldSend.apply(res, arguments);
    }

    if (postData.refreshToken && postData.refreshToken in tokenList) {

      const user = {
        mobile: postData.mobile,
      };

      const token = sign(user, process.env.SECRET, {
        expiresIn: process.env.TOKENLIFE,
      });

      const response = {
        token: token,
      };

      // update the token in the list
      tokenList[postData.refreshToken].token = token;
      res.status(200).json(response);
    } else {
      res.status(404).send("Invalid request");
    }

  },
  updateDealer: (req, res, cb) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if ( body.type == "" || body.update_val == "" || body.type == "NaN" || body.update_val == "NaN") {
      return res.status(201).json({
        status: 0,
        message: "Please give inputs",
      });
    }

    if (body.vendor_id == "" || body.vendor_id == "NaN") {
      return res.status(201).json({
        status: 0,
        message: "Vendor id required ",
      });
    }

    update_dealer(body, (err, results) => {

      if (err) {
        if (err == 1) {
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }
      }
      return res.status(200).json({
        status: 1,
        message: "Updated successfully",
        updated_val: body.update_val,
      });
    });

  },
  updateApkVersion: (req, res, cb) => {
    const body = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if ( body.type == "" || body.update_val == "" || body.type == "NaN" || body.update_val == "NaN") {
      return res.status(201).json({
        status: 0,
        message: "Please give inputs",
      });
    }

    update_ApkVersion(body, (err, results) => {
      if (err) {
        if (err == 1) {
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }
      }
      return res.status(200).json({
        status: 1,
        message: "Updated successfully",
        updated_val: body.update_val,
      });
    });

  },
  getApkVersion: (req, res, cb) => {
   
    var oldSend = res.send;
    res.send = function(response){
      add_log(response)
      oldSend.apply(res, arguments);
    }

    get_ApkVersion((err, results) => {
      if (err) {
        if (err == 1) {
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }
      }
      return res.status(200).json({
        status: 1,
        build_no:results[0]['build_no'],
      });
    });

  },
  deleteDealer: (req, res) => {
    const data = req.body;

    var oldSend = res.send;
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    deleteDealer(data, (err, results) => {

      if (err) {
        return res.status(500).json({
          status: 0,
          message: err,
        });
      }

      if (!results) {
        return res.status(404).json({
          status: 0,
          message: "Record not found",
        });
      }

      return res.status(200).json({
        status: 1,
        message: "Dealer deleted successfully",
      });
    });

  },

  getProfileInfo: (req, res) => {
    var vendor_id = req.params.vendor_id;

    var oldSend = res.send;
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }
    
    if (vendor_id == "" || vendor_id == "" || vendor_id == "NaN" || vendor_id == NaN) {
      return res.status(201).json({
        status: 0,
        message: "Vendor Id is required",
      });
    }
    get_profile_info(vendor_id, (err, results) => {
      
      if (err) {
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({
        status: 1,
        data: results
        
      });
    });
  },
  getAttachedList: (req, res) => {
    var attached_vendor_id = req.params.attached_vendor_id;

    var oldSend = res.send;
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }
    
    if (attached_vendor_id == "" || attached_vendor_id == "" || attached_vendor_id == "NaN" || attached_vendor_id == NaN) {
      return res.status(201).json({
        status: 0,
        message: "Vendor Id is required",
      });
    }
    get_attached_list(attached_vendor_id, (err, results) => {
      
      if (err) {
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({
        status: 1,
        data: results
        
      });
    });
  },
  getSalesPersons: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      sales_persons_list(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  getAvailableDealers: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      available_dealers(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  tagDealerToSalesPerson: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    try {
      tag_to_sales_person(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  taggedDealersList: (req, res) => {
    const sales_person_id = req.params.sales_persons_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(sales_person_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      tagged_dealers(sales_person_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  }
};
