require("dotenv").config({ path: "../.env" });
const connect_pool = require("./config/database");
const shortid = require("shortid");
const request = require("request-promise");
const mysql = require('mysql2/promise');
const db_conn = {
  port:process.env.DB_PORT,
  host:process.env.DB_HOST,
  user:process.env.DB_USER,
  password:process.env.DB_PASSWORD,
  database:process.env.DB_NAME
}
const monthNames = ["January", "February","March","April", "May","June","July", "August", "September", "October","November","December"];

module.exports = {
  add_log: (request, response) => {
    var req = JSON.stringify(request);
    
    try {
      connect_pool.query(
        `INSERT into tbl_dealer_error_log(request,response)
        VALUES(?,?)`,
        [req,response]
      );
    } catch (e) {}

  },
  create_payment: (data, callBack) => {
    
    var short_id = shortid.generate();
    receipt = "receipt_no_" + short_id;
    order_ids = data.order_id;
    net_payments = data.netPayment;
    insert_list = [];
    invoice_data = [];
    order_ids.forEach((key, val) => {
      
      insert_list.push(order_ids[val]);
      order_id = order_ids[val];
      net_payment = net_payments[val];
      try {
        
        connect_pool.query(
          `INSERT into tbl_dealer_payments(vendor_id,order_id,payment_reference,receipt_no,amount_paid,amount, currency)
                    VALUES(?,?,?,?,?,?,?)`,
          [
            data.vendor_id,
            order_id,
            data.razorpay_payment_id,
            receipt,
            net_payment,
            data.amount,
            data.currency,
          ],
          (data_err, paymentData) => {

            if (data_err) {
              return callBack(data_err);
            }
          }
        );
      } catch (e) {
        return callBack(e);
      }
      
      if (insert_list.length == order_ids.length) {
        
        try {
          connect_pool.query(
            `SELECT max(CAST(SUBSTRING_INDEX(receipt_no,"-",-1) as UNSIGNED)) as max from tbl_receipt`,
            (err_max, max_number) => {

              if (err_max) {
                return callBack(err_max);
              }
              var currentdate = new Date();
              var date = currentdate.getFullYear() +'-'+ (currentdate.getMonth() + 1) + "-" + currentdate.getDate();
              var index_no = max_number[0].max + 1;
              let receipt_no = "RCPT-" + index_no;
              
              try {
                connect_pool.query(
                  `INSERT into tbl_receipt(receipt_no,vendor_id,receipt_type,account_no,reference_no,received_amount,received_date)
                    VALUES(?,?,?,?,?,?,?)`,
                  [
                    receipt_no,
                    data.vendor_id,
                    "ONLINE",
                    "ICICI-4789",
                    data.razorpay_payment_id,
                    data.amount,
                    date,
                  ],
                  (post_err, receiptData) => {

                    if (post_err) {
                      return callBack(post_err);
                    }
                    
                    try {
                      connect_pool.query(
                        `DELETE from tbl_dealer_cart WHERE vendor_id = ?`,
                        [data.vendor_id],
                        (error, results) => {
          
                          if (error) {
                            return callBack(error);
                          }
                          try {
                            connect_pool.query(
                              `SELECT * from VENDOR_STATE_LIST_VIEW WHERE vendor_id = ?`,
                              [data.vendor_id],
                              (state_error, stateData) => {
                
                                if (state_error) {
                                  return callBack(state_error);
                                }
                                if (stateData[0].state_gst_id == 36) {
                                  var tax_type = 'CGST18';
                                } else {
                                    var tax_type = 'IGST18';
                                }
                                var grnidorder_list = [];
                                var total_amount = 0
                                try{
                                  connect_pool.query(
                                    `SELECT * from tbl_salesorder_item WHERE salesorder_id = ?`,
                                    [order_id],
                                    (order_error, salesOrderData) => {
                      
                                      if (order_error) {
                                        return callBack(order_error);
                                      }
                                      for (var i = 0; i < salesOrderData.length; i++) {
                                        var grn_id = salesOrderData[i].grnreport_id;
                                        grnidorder_list.push(grn_id);
                                        total_amount += salesOrderData[i].sale_price;
                                      }
                                      var grnreportids = [grnidorder_list];
                                      
                                      try {
                                        connect_pool.query(
                                          `SELECT * FROM tbl_grnreport WHERE grnreport_id IN ?`,
                                          [grnreportids],
                                          (data_err, grnData) => {
    
                                            if (data_err) {
                                              return callBack(5, data_err);
                                            }

                                            var margin = 0;
                                            var exempt = 0;
                                            var taxable = 0;
                                            var tax = 0;
                                            var margin_perc = 0;
                                            
                                            var total_tax = 0;
                                            var rows = [];
                                            for (var j = 0; i < grnData.length; j++) {
                                              var grn_status = grnData[j].status;
                                              var bill_type = grnData[j].invoice_type;
                                              //total_amount += salesOrderData[j].sale_price;
                                              if(grn_status != "RFS"){
                                                let device_id = grnData[j].nhdin;
                                                return callBack(device_id + " is not in RFS status");
                                              }
                                              if(bill_type.toLowerCase == 'exempt'){
                                                margin = salesOrderData[j].sale_price - (grnData[j].unit_price + grnData[j].unit_price_tax);
                                                exempt = grnData[j].unit_price + grnData[j].unit_price_tax;
                                                taxable = margin / 1.18;
                                                tax = margin - taxable;
                                                if(margin < 0){
                                                  margin = 0;
                                                }
                                                if (exempt > salesOrderData[j].sale_price) {
                                                  exempt = salesOrderData[j].sale_price;
                                                  tax = 0;
                                                  taxable = 0;
                                              }
                                              margin_perc = (margin / salesOrderData[j].sale_price) * 100;
                      
                                              } else{
                                                tax = salesOrderData[j].sale_price - salesOrderData[j].sale_price / 1.18;
                                                taxable = salesOrderData[j].sale_price / 1.18;
                                                exempt = 0.00;
                                                margin = salesOrderData[j].sale_price - (grnData[j].unit_price + grnData[j].unit_price_tax);
                                                margin_perc = (margin / salesOrderData[j].sale_price) * 100;
                        
                                              }
                                              total_tax += tax;
                                              result_obj = {
                                                grnreport_id: grnData[j].grnreport_id,
                                                device_id: grnData[j].nhdin,
                                                price : grnData[j].sale_price,
                                                tax_amount: tax,
                                                taxable_amount: $taxable,
                                                exempt_amount: $exempt,
                                                margin: margin,
                                                margin_perc: margin_perc,
                                                sales_terms: grnData[j].sales_terms,
                                                category: grnData[j].category,
                                                grade: grnData[j].grade,
                                                tax_type: tax_type,
                                                bill_type: grnData[j].bill_type
                                              };
                                              rows.push(result_obj);
                                            }
                                            try{
                                              connect_pool.query(
                                                `SELECT max(CAST(SUBSTRING_INDEX(invoice_code,"-",-1) as UNSIGNED)) as max from tbl_invoice`,
                                                (err_max, max_number) => {
                                  
                                                  if (err_max) {
                                                    return callBack(err_max);
                                                  }
                                  
                                                  var next_number = max_number[0].max + 1;
                                                  var invoice_code = 'SLY-HYD' + '-' + next_number;
                                                  // console.log(invoice_code)
                                                  // return false
                                                  try {
                                                    
                                                    var c = connect_pool.query(
                                                      `INSERT into tbl_invoice (vendor_id,invoice_code, salesorder_id, sales_channel, warehouse, status, invoice_amount, tax_amount, payment_mode)
                                                      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                                      [
                                                        vendor_id,
                                                        invoice_code,
                                                        order_id,
                                                        "DEALERAPP",
                                                        "HYD",
                                                        "INVOICED",
                                                        total_amount,
                                                        total_tax,
                                                        "prepaid" 
                                                      ],
                                                      (post_err, postData, affectedRows) => {
                                                        console.log("Enterd")
                                                        if (post_err) {
                                                          return callBack(post_err);
                                                        }

                                                        if (affectedRows < 1) {
                                                          return callBack("Creation of Invoice is failed");
                                                        }
                                                        rows.invoice_id = postData.insertId;
                                                        invoice_data.push(postData.insertId);
                                                        try{
                                                          let sql1 = 'INSERT INTO tbl_invoice_item (grnreport_id, device_id, price, tax_amount,taxable_amount,exempt_amount, margin,margin_perc,sales_terms,category,grade,tax_type,bill_type) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)';
                                                          connection.query(sql1, [rows], function (error1, result1) { 
                                                              if (error1){
                                                                callBack(error1)
                                                              } 
                                                              let sql2 = 'UPDATE tbl_grnreport SET status = SOLD, remark = ? WHERE grnreport_id IN ? ';
                                                              connection.query(sql2, [invoice_code, grnreportids], function (error2, result2) {  
                                                              if(error2){
                                                                callBack(error2)
                                                              }
                                                              let sql3 = 'UPDATE tbl_salesorder SET status = INVOICED';
                                                              connection.query(sql3, [order_id], function (error3, result3) {  
                                                              if(error3){
                                                                callBack(error3)
                                                              }
                                                              if(invoice_data.length == order_ids.length){
                                                                let msg = "Your payment is success";
                                                                return callBack(null, msg);
                                                              }
                                                            });

                                                          });
                                                        });

                                                       } catch(e){
                                                          callBack(e)
                                                        }

                                                      }
                                                    )} catch(e){
                                                      callBack(e)
                                                    }

                                                }
                                              )

                                            } catch(e){
                                              callBack(e)
                                            }

                                          }
                                        );
                                      } catch(e){
                                        return callBack(e);
                                      }
                                      
                                    }
                                  );
                                } catch(e){
                                  return callBack(e);
                                }
                      
                              }
                            );
                          } catch (e) {
                            return callBack(e);
                          }
                        }
                      );
                    } catch (e) {
                      return callBack(e);
                    }

                  }
                );
              } catch (e) {
                return callBack(e);
              }

            }
          );
        } catch (e) {
          return callBack(e);
        }

      }
    });
  },
  check_payment: (data, callBack) => {

    var order_amount = data.order_amount;
    var max_amount = order_amount + 5;
    var min_amount = order_amount - 5;

    try {
      connect_pool.query(
        `select received_amount, adjusted_amount from RECEIPT_LIST_VIEW WHERE vendor_id = ? AND voucher_no = ? AND voucher_valid = ? `,
        [data.vendor_id, data.voucher_no, "Y"],
        (row_err, row) => {

          if (row_err) {
            return callBack(row_err);
          }
          
          if (row.length < 1) {
            let data = {
              error_code : 0,
              err_msg : "No results found"
            }
            return callBack(1, data);
          }
          var available_amount = row[0].received_amount - row[0].adjusted_amount;

          if (available_amount < min_amount || available_amount > max_amount) {
            let data = {
              error_code : 1,
              err_msg : "Voucher available amount missmatch with order amount"
            }
            return callBack(1, data);
            
          }
          
          var success_msg = "Vocucher is verified successfully";
          return callBack(null, success_msg)
          
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  update_voucher: (data, callBack) => {

    try {
      connect_pool.query(
        `UPDATE tbl_receipt SET voucher_valid = ? WHERE vendor_id = ? AND voucher_no = ?`,
        ["N", data.vendor_id, data.voucher_no],
        (row_err, row) => {

          if (row_err) {
            return callBack(row_err);
          }

          if (row.affectedRows < 1) {
            var err_msg = "Not updated voucher validity";
            return callBack(1, err_msg);
          }

          var success_msg = "Vocucher validity updated successfully";
          return callBack(null, success_msg)
          
        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  offline_payments: (data, callBack) => {

    try {
      connect_pool.query(
        `select * from tbl_receipt WHERE vendor_id = ? AND voucher_no = ? AND voucher_valid = ? `,
        [data.vendor_id, data.voucher_no, "Y"],
        (row_err, row) => {

          if (row_err) {
            return callBack(row_err);
          }

          if (row.length < 1) {
            row_err = "No Receipts found";
            return callBack(1, row_err);
          }

          var amount_paid = data.order_amount;
          var amount = 0;
          for(var k=0; k < amount_paid.length; k++){
            amount += amount_paid[k]
          }

          const insert_arr = [];
          var orderId = data.order_id;
          var amount_paid = data.order_amount;
          
          for(var i=0; i < orderId.length; i++){
            insert_arr.push([ data.vendor_id, orderId[i], row[0].reference_no, row[0].receipt_no, amount_paid[i], amount, "INR"]);
          }

          var sql = "INSERT INTO tbl_dealer_payments (vendor_id, order_id, payment_reference, receipt_no, amount_paid,amount,currency) VALUES ?";

          try {
            connect_pool.query(
              sql,[insert_arr],(error, insertData) => {

                if (error) {
                  return callBack(error);
                }

                if (insertData.affectedRows < 1) {
                  var msg = "Something went wrong while adding offline paymnets";
                  return callBack(1,msg);
                }

                try{
                  connect_pool.query(
                    `DELETE FROM tbl_dealer_cart WHERE vendor_id = ?`,[data.vendor_id],(err, response) => {
      
                      if (err) {
                        return callBack(err);
                      }
                      var msg = "Added offline payments successfully";
                      return callBack(null, msg);
                    }
                  )
                } catch (e) {
                  return callBack(e);
                }
                
              }
            );
          } catch (e) {
            return callBack(e);
          }

        }
      );
    } catch (e) {
      return callBack(e);
    }

  },
  add_account: async (body, callBack) => {

    var qr1 = "SELECT * FROM tbl_dealerapp_bank_accounts WHERE vendor_id = ?"
    var qr2 = "INSERT INTO tbl_dealerapp_bank_accounts (vendor_id, bank_name, branch, ifsc_code, account_no) VALUES (?,?,?,?,?)";
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,
          [body.vendor_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length > 0){
        for (var i = 0; i < qr1_res.length; i += 1) {
            let ifsc_code = qr1_res[i].ifsc_code;

            if(ifsc_code == body.ifsc_code){
              return callBack({status:0, message: ifsc_code + " Already Exist"});
            }
            if(qr1_res[i].active == "Y"){
              return callBack({status:0, message: qr1_res[i].account_no + " is in active mode only"});
            }
        }
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,
          [body.vendor_id, body.bank_name,body.branch, body.ifsc_code, body.account_no], 
          (qr2_err, qr2_results) => {
            
              if (qr2_err){
                connection.rollback(); return callBack({status:0, message:qr2_err});
              } 
              res(qr2_results);
          });
      });
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, message : "Account added successfully"})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  accounts_list: async (vendor_id, callBack) => {

    var qr1 = "SELECT * FROM tbl_dealerapp_bank_accounts WHERE vendor_id = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : qr1_res})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },

  update_account: async (body, callBack) => {

    var qr = "SELECT * FROM tbl_dealerapp_bank_accounts WHERE vendor_id = ? AND active = ?"
    var qr1 = "SELECT * FROM tbl_dealerapp_bank_accounts WHERE account_id = ?"
    var qr2 = "UPDATE tbl_dealerapp_bank_accounts SET active = ? WHERE account_id = ?";
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      if(body.active == "Y"){
        var qr_res = await new Promise((res, rej) => {
          connect_pool.query(qr,
            [body.vendor_id,"Y"], 
            (qr_err, qr_results) => {
              
                if (qr_err){
                  connection.rollback(); return callBack({status:0, message:qr_err});
                } 
                res(qr_results);
            });
        });
        if(qr_res.length > 0){
          return callBack({status:0, message:qr_res[0].account_no + " is already in active mode"});
        }
      }
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,
          [body.account_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res[0].active == body.active){

        return callBack({status:0, message: qr1_res[0].account_no + " is in same mode only"});
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,
          [body.active, body.account_id], 
          (qr2_err, qr2_results) => {
            
              if (qr2_err){
                connection.rollback(); return callBack({status:0, message:qr2_err});
              } 
              res(qr2_results);
          });
      });
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, message : "Account updated successfully"})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  create_voucher: async (body, callBack) => {

    var short_id = shortid.generate();
    var voucher_no = short_id + "_" + body.vendor_id;
    var qr1 = "INSERT INTO tbl_dealerapp_voucher_code (vendor_id, voucher_to, voucher_no, amount, created_by) VALUES (?,?,?,?,?)";
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,
          [body.vendor_id,body.voucher_to, voucher_no, body.amount, body.created_by], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              }
              var d = new Date();
              var min = d.getMinutes();
              var added_min = min + 2;
              var datetime = d.getDate() + "-" + (d.getMonth() + 1) +  "-" + d.getFullYear() +  " " + d.getHours() + ":" + added_min + ":" +  d.getSeconds();
              var text_body = "voucher no : " + voucher_no + ", amount : " + body.amount + ", created at : " + datetime;
              var mobile = body.mobile;
              //var message = "Thank you for connecting with SLOYD - SELTRUE, India's best refurbished smartphone brand. Please wait for a while till your registration request is approved.";
              var message =  "Dear Customer, Your Voucher details are  " + text_body + ". sloyd ventures";
              var sms_url = `http://smslogin.co/v3/api.php?username=Ynewdc&apikey=${process.env.APIKEY}&senderid=${process.env.SENDERID}&templateid=${process.env.TEMPLATEID}&mobile=${mobile}&message=${message}`;
              
              const options = {
                method: "GET",
                uri: sms_url,
              };
              request(options).then(function (response) {})
                .catch((catch_err) => {
                  return callBack({status:0, message:catch_err});
                });
              res(qr1_results);
          });
      });
      connection.commit();
      connection.end();

      return callBack(null, {status :1, message : "Created voucher number is " + voucher_no })
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  vouchers_list: async (vendor_id, callBack) => {

    var qr1 = "SELECT * FROM DEALER_VOUCHER_LIST_VIEW WHERE vendor_id = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : qr1_res})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  valid_vouchers: async (vendor_id, callBack) => {

    var qr1 = "SELECT * FROM DEALER_VOUCHER_LIST_VIEW WHERE voucher_to = ? AND valid = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id,"Y"], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      var result_obj = [];
      for (var i = 0; i < qr1_res.length; i += 1) {
        
        obj = {
          
          "voucher_id" : qr1_res[i].voucher_id,
          "voucher_no" : qr1_res[i].voucher_no,
          "amount" : qr1_res[i].amount,
          "valid_voucher" : qr1_res[i].voucher_no + " - " + qr1_res[i].amount
        }
        result_obj.push(obj)
      };
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : result_obj})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  update_voucher_validity: async (body, callBack) => {

    var qr = "SELECT * FROM tbl_dealerapp_voucher_code WHERE vendor_id = ? AND valid = ?"
    var qr1 = "SELECT * FROM tbl_dealerapp_voucher_code WHERE voucher_id = ?"
    var qr2 = "UPDATE tbl_dealerapp_voucher_code SET valid = ? WHERE voucher_id = ?";
    var qr3 = "SELECT * FROM tbl_dealerapp_order_payment WHERE payment_reference_no = ?"
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      if(body.valid == "Y"){
        var qr_res = await new Promise((res, rej) => {
          connect_pool.query(qr,
            [body.vendor_id,"Y"], 
            (qr_err, qr_results) => {
              
                if (qr_err){
                  connection.rollback(); return callBack({status:0, message:qr_err});
                } 
                res(qr_results);
            });
        });
        if(qr_res.length > 0){
          return callBack({status:0, message:qr_res[0].voucher + " is already in valid mode"});
        }
      }
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,
          [body.voucher_id], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res[0].valid == body.valid){

        return callBack({status:0, message: qr1_res[0].voucher_no + " is in same mode only"});
      }
      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3,
          [qr1_res[0].voucher_no], 
          (qr3_err, qr3_results) => {
            
              if (qr3_err){
                connection.rollback(); return callBack({status:0, message:qr3_err});
              } 
              res(qr3_results);
          });
      });
      if(qr3_res.length > 0){
        return callBack({status:0, message:qr1_res[0].voucher + " is already used"});
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,
          [body.valid, body.voucher_id], 
          (qr2_err, qr2_results) => {
            
              if (qr2_err){
                connection.rollback(); return callBack({status:0, message:qr2_err});
              } 
              res(qr2_results);
          });
      });
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, message : "Voucher validity is updated successfully"})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  },
  vendor_account: async (vendor_id, callBack) => {

    var qr1 = "SELECT * FROM DEALER_BANK_ACCOUNT_DETAILS_LIST_VIEW WHERE vendor_id = ? AND active = ?"
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,[vendor_id, "Y"], 
          (qr1_err, qr1_results) => {
            
              if (qr1_err){
                connection.rollback(); return callBack({status:0, message:qr1_err});
              } 
              res(qr1_results);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message:"No records found"});
      }
      connection.commit();
      connection.end();
      
      return callBack(null, {status :1, data : qr1_res[0]})
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
      return callBack({status:0, message:err});
      }
  }
  
};
