const {
  createPayment,
  checkPayment,
  updateVoucher,
  addOffLinePayments,
  addAccount,
  accountsList,
  updateAccount,
  createVoucher,
  vouchersList,
  validVouchers,
  updateVoucherValidity,
  getVendorAccount
} = require("./payment-controller");

const router = require("express").Router();

router.post("/createPayment", createPayment);
router.post("/checkPayment", checkPayment);
router.post("/updateVoucher", updateVoucher);
router.post("/addOffLinePayments", addOffLinePayments);
router.post("/addAccount", addAccount);
router.get("/accountsList/:vendor_id", accountsList);
router.post("/updateAccount/", updateAccount);
router.post("/createVoucher", createVoucher);
router.get("/vouchersList/:vendor_id", vouchersList);
router.get("/validVouchers/:vendor_id", validVouchers);
router.post("/updateVoucherValidity", updateVoucherValidity);
router.get("/getVendorAccount/:attached_vendor_id", getVendorAccount);

module.exports = router;
