require("dotenv").config({ path: "../.env" });

const {
  create_payment,
  add_log,
  check_payment,
  update_voucher,
  offline_payments,
  add_account,
  accounts_list,
  update_account,
  create_voucher,
  vouchers_list,
  valid_vouchers,
  update_voucher_validity,
  vendor_account

} = require("./payment-service");

module.exports = {
  createPayment: (req, res) => {
    const body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    
    if (body.venodr_id == 0 || body.venodr_id == "" || body.venodr_id == "NAN" ||body.vendor_id == undefined) {
      return res.status(200).json({
        status: 0,
        message: "Order required ",
      });
    }

    if (body.order_id == 0 || body.order_id == "" || body.order_id == "NAN" || body.order_id == undefined) {
      return res.status(200).json({
        status: 0,
        message: "Vendor required ",
      });
    }

    if (body.amount_paid == 0 || body.amount_paid == "NAN" || body.amount_paid == "0") {
      return res.status(200).json({
        status: 0,
        message: "Paid amount should not be zero ",
      });
    }
    
    try {
      create_payment(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  checkPayment: (req, res) => {
    const body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    
    if (body.venodr_id == 0 || body.venodr_id == "" || body.venodr_id == "NAN" ||body.vendor_id == undefined) {
      return res.status(200).json({
        status: 0,
        message: "Vendor required ",
      });
    }

    if (body.voucher_no == 0 || body.voucher_no == "NAN" || body.voucher_no == "0") {
      return res.status(200).json({
        status: 0,
        message: "Provide valid voucher number ",
      });
    }
    
    try {
      check_payment(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              data: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  updateVoucher: (req, res) => {
    const body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    
    if (body.venodr_id == 0 || body.venodr_id == "" || body.venodr_id == "NAN" ||body.vendor_id == undefined) {
      return res.status(200).json({
        status: 0,
        message: "Vendor required ",
      });
    }

    if (body.voucher_no == 0 || body.voucher_no == "NAN" || body.voucher_no == "0") {
      return res.status(200).json({
        status: 0,
        message: "Provide valid voucher number ",
      });
    }
    
    try {
      update_voucher(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  addOffLinePayments: (req, res) => {
    const body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
    
    if (body.venodr_id == 0 || body.venodr_id == "" || body.venodr_id == "NAN" ||body.vendor_id == undefined) {
      return res.status(200).json({
        status: 0,
        message: "Vendor required ",
      });
    }

    if (body.voucher_no == 0 || body.voucher_no == "NAN" || body.voucher_no == "0") {
      return res.status(200).json({
        status: 0,
        message: "Provide valid voucher number ",
      });
    }
    
    var orderId = body.order_id;
    var orderAmount = body.order_amount;

    if (orderId.length < 1 || orderAmount.length < 1|| orderId.length != orderAmount.length) {
      return res.status(200).json({
        status: 0,
        message: "Something went wrong in order amounts ",
      });
    }

    try {
      offline_payments(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  addAccount: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
  
    if (body.length < 1) {
      return res.status(201).json({
        status: 0,
        message: "Please provide account details ",
      });
    }
    try {
      add_account(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  accountsList: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      accounts_list(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  updateAccount: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
  
    if (body.length < 1) {
      return res.status(201).json({
        status: 0,
        message: "Please provide update details ",
      });
    }
    try {
      update_account(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  createVoucher: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
  
    if (body.length < 1) {
      return res.status(201).json({
        status: 0,
        message: "Please provide voucher details ",
      });
    }
    try {
      create_voucher(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  vouchersList: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      vouchers_list(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  validVouchers: (req, res) => {
    const vendor_id = req.params.vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      valid_vouchers(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  updateVoucherValidity: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }
  
    if (body.length < 1) {
      return res.status(201).json({
        status: 0,
        message: "Please provide voucher details ",
      });
    }
    try {
      update_voucher_validity(body, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  getVendorAccount: (req, res) => {
    const vendor_id = req.params.attached_vendor_id;
    var oldSend = res.send;
  
    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    try {
      vendor_account(vendor_id, (err, results) => {
        
        if (err) {
          
            return res.status(500).json(err);
        }
        return res.status(200).json(results);
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  }


};
