const connect_pool = require("./config/database");
const mysql = require('mysql2/promise');
const https = require('https');
require("dotenv").config({ path: "../.env" });
const db_conn = {
  port:process.env.DB_PORT,
  host:process.env.DB_HOST,
  user:process.env.DB_USER,
  password:process.env.DB_PASSWORD,
  database:process.env.DB_NAME
}
module.exports = {
  add_log: (request, response) => {
    var req = JSON.stringify(request);
    
    try {
      connect_pool.query(
        `INSERT into tbl_dealer_error_log(request,response)
        VALUES(?,?)`,
        [req,response]
      );
    } catch (e) {}

  },
  bundle_availability: (data, callBack) => {
    const bundle_data = data.bundle_id;
    var id_list = [];

    for (var i = 0; i < bundle_data.length; i++) {
      var bundle_id = bundle_data[i];
      id_list.push(bundle_id);
    }

    var bundle_ids = [id_list];
    
    try {
      connect_pool.query(
        `SELECT status, bundle_no, quantity, amount, type from tbl_dealer_bundle WHERE bundle_id IN ?`,
        [bundle_ids],
        (check_err, check_data) => {

          if (check_err) {
            return callBack(check_err);
          }

          if (check_data.length < 1) {
            let data_msg = "No data available for selected bundles";
            return callBack(1, data_msg);
          }

          for (var j = 0; j < check_data.length; j++) {
            var bndl_status = check_data[j].status;

            if (bndl_status != "ACTIVE") {
              let msg = check_data[j].bundle_no + " is not available in IN-STOCK";
              return callBack(2, msg);
            }

          }
          let succ_msg = "You can proceed to payment for this bundles";
          return callBack(null, succ_msg);
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  validationRules: function (body_data, cb) {
    var bundle_data = body_data.bundle_data;
    var openbox_data = body_data.open_box_data;
    var prexo_data = body_data.prexo_data;
    var grnid_list = [];

    for (var i = 0; i < openbox_data.length; i++) {
      var grnreport_id = openbox_data[i].grnreport_id;
      grnid_list.push(grnreport_id);
    }

    for (var i = 0; i < prexo_data.length; i++) {
      var grnreport_id = prexo_data[i].grnreport_id;
      grnid_list.push(grnreport_id);
    }

    var bundleid_list = [];

    for (var i = 0; i < bundle_data.length; i++) {
      var bundle_id = bundle_data[i].bundle_id;
      bundleid_list.push(bundle_id);
    }

    if (bundle_data.length > 0) {
      var bundle_ids = [bundleid_list];
    } else {
      var bundle_ids = [[0, 0]];
    }

    try {
      connect_pool.query(
        `SELECT grnreport_id from tbl_dealer_bundle_item WHERE bundle_id IN ?`,
        [bundle_ids],
        (report_err, report_data) => {

          if (report_err) {
            report_data = [];
            return cb(1, report_err);
          }

          // if (report_data.length < 1) {
          //   var err_msg = "Selected bundle is not availble"
          //   return cb(1, err_msg);
          // }

          if (report_data.length > 0) {
            for (var a = 0; a < report_data.length; a++) {
              var grnReportId = report_data[a].grnreport_id;
              grnid_list.push(grnReportId);
            }
          }

          var grnreport_ids = [grnid_list];

          try {
            connect_pool.query(
              `SELECT bundle_id, status, saletype, device_name, nhdin, device_sub_category from tbl_grnreport WHERE grnreport_id IN ?`,
              [grnreport_ids],
              (validate_err, validate_data) => {

                if (validate_err) {
                  return cb(1, validate_err);
                }

                if (validate_data.length > 0) {

                  for (var z = 0; z < validate_data.length; z++) {
                    var device_name = validate_data[z].device_name;
                    var device_status = validate_data[z].status;
                    var sale_type = validate_data[z].saletype;
                    var device_id = validate_data[z].nhdin;
                    var bndlId = validate_data[z].bundle_id;
                    var msg = device_name + " is not availabe in IN-STOCK";

                    if (bndlId == null) {

                      if (device_status != "RFS" || sale_type != "DEALERAPP") {
                        return cb(1, msg);
                      }

                    } else if (bndlId > 0) {

                      if (device_status != "RFS" || sale_type != "OFFLINE") {
                        return cb(1, msg);
                      }

                    }
                  }

                  try {
                    connect_pool.query(
                      `SELECT status,device_name FROM DEALER_SALESORDER_EXPORT_VIEW WHERE grnreport_id IN ?`,
                      [grnreport_ids],
                      (check_err, check_data) => {

                        if (check_err) {
                          return cb(1, check_err);
                        }

                        if (check_data.length > 0) {

                          for (var y = 0; y < check_data.length; y++) {
                            var deviceName = check_data[y].device_name;
                            var status = check_data[y].status;
                            var status_arr = ["FINANCE_PENDING", "FINANCE_APPROVED", "DRAFT", "FINANCE_REJECTED","WAREHOUSE_REJECTED"];
                            
                            if (status_arr.includes(status)) {
                              let msg_er =
                                "Sales order created for " + deviceName;
                              return cb(1, msg_er);
                            }
                          }
                        }
                        try {
                          connect_pool.query(
                            `SELECT status, bundle_no, quantity, amount, type from tbl_dealer_bundle WHERE bundle_id IN ?`,
                            [bundle_ids],
                            (bndle_err, bndle_data) => {

                              if (bndle_err) {
                                return cb(1, bndle_err);
                              }

                              if (bndle_data.length > 0) {

                                for (var j = 0; j < bndle_data.length; j++) {
                                  var bndl_status = bndle_data[j].status;

                                  if (bndl_status != "ACTIVE") {
                                    let msg = bndle_data[j].bundle_no + " is not available in IN-STOCK";
                                    return cb(1, msg);
                                  } else {
                                    return cb(null, true);
                                  }

                                }

                              }
                              return cb(null, true);
                            }
                          );
                        } catch (e) {
                          return cb(1, e);
                        }
                      }
                    );
                  } catch (e) {
                    return cb(1, e);
                  }
                }
              }
            );
          } catch (e) {
            return cb(1, e);
          }
        }
      );
    } catch (e) {
      return cb(1, e);
    }
  },
  openBoxOrder: function (body_data, cb) {
    var vendor_id = body_data.vendor_id;
    var openbox_data = body_data.open_box_data;
    //var discount_amount = body_data.openbox_discount;
    var grnid_list = [];

    for (var i = 0; i < openbox_data.length; i++) {
      var grnreport_id = openbox_data[i].grnreport_id;
      grnid_list.push(grnreport_id);
    }

    if(body_data.openbox_discount == ''){
      var discount_amount = 0;
    } else{
      var discount_amount = body_data.openbox_discount;
    }

    var grnreport_ids = [grnid_list];
    var orders_list = [];
    var order_count = [];
    //var openbox_list = ["OPEN BOX"];
    var grnidorder_list = [];

    for (var i = 0; i < openbox_data.length; i++) {
      var grn_id = openbox_data[i].grnreport_id;
      grnidorder_list.push(grn_id);
    }

    var grnreportids = [grnidorder_list];

    try {
      connect_pool.query(
        `SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?`,
        [vendor_id],
        (tcs_err, total_amount) => {

          if (tcs_err) {
            return cb(2, tcs_err);
          }

          var total_amount = total_amount[0].amount;
          var check_amount = 5000000;

          try {
            connect_pool.query(
              `SELECT max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max from tbl_salesorder`,
              (err_max, max_number) => {

                if (err_max) {
                  return cb(2, err_max);
                }

                var index_no = max_number[0].max + 1;

                try {
                  connect_pool.query(
                    `SELECT sum(mrp) as order_amount, count(grnreport_id) as qnty  from tbl_grnreport WHERE grnreport_id IN ?`,
                    [grnreportids],
                    (type_err, type_data) => {

                      if (type_err) {
                        return cb(2, type_err);
                      }

                      var open_box_amount = type_data[0].order_amount;

                      if (total_amount <= check_amount) {
                        var final_amount = total_amount + open_box_amount;

                        if (final_amount >= check_amount) {
                          var tcs_percent = 0.1;
                          let actual_amount = final_amount - check_amount;
                          var tcs_value = (tcs_percent * actual_amount) / 100;
                        } else {
                          var tcs_percent = 0;
                          var tcs_value = 0;
                        }

                      } else {
                        var tcs_percent = 0.1;
                        var tcs_value = (tcs_percent * open_box_amount) / 100;
                      }

                      var next_number = index_no;
                      let sales_code = "SO-HYD-" + next_number;

                      try {
                        connect_pool.query(
                          `INSERT into tbl_salesorder (salesorder_code,vendor_id, status, cost_center, sales_channel, payment_mode, warehouse, discount_on_amount, discount_on_tax, discount_value, discount_amount, insurance_amount, insurance_value, freight_amount, tcs_percent, tcs_amount,device_sub_category)
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                          [
                            sales_code,
                            vendor_id,
                            "FINANCE_PENDING",
                            "OFFLINE",
                            "DEALERAPP",
                            "prepaid",
                            "HYD",
                            0,0,0,discount_amount,0,0,0,
                            tcs_percent,
                            tcs_value,
                            "STANDARD",
                          ],
                          (post_err, postData, affectedRows) => {

                            if (post_err) {
                              return cb(2, post_err);
                            }

                            if (affectedRows < 1) {
                              return cb(2,"Sales order not created for OPEN BOX devices");
                            }

                            var currentdate = new Date();
                            var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
                            
                            try {
                              connect_pool.query(
                                `SELECT SUM(mrp) as pay_amount FROM tbl_grnreport WHERE grnreport_id IN ?`,
                                [grnreport_ids],
                                (amount_err, amountData) => {

                                  if (amount_err) {
                                    return cb(2, amount_err);
                                  }

                                  var pay_amount = amountData[0].pay_amount;
                                  net_amount = pay_amount + tcs_value;
                                  
                                  result_obj = {
                                    salesorder_id: postData.insertId,
                                    salesorder_code: sales_code,
                                    order_amount : pay_amount - discount_amount,
                                    tcs_percent: tcs_percent,
                                    tcs_value: tcs_value,
                                    net_payment: net_amount,
                                    status: "PENDING",
                                    quantity: type_data[0].qnty,
                                    created_date: datetime,
                                  };
                                  orders_list.push(result_obj);

                                  try {
                                    connect_pool.query(
                                      `SELECT * FROM tbl_grnreport WHERE grnreport_id IN ?`,
                                      [grnreportids],
                                      (data_err, openData) => {

                                        if (data_err) {
                                          return cb(2, data_err);
                                        }

                                        var data_length = openData.length;
                                        order_count.push(postData.insertId);
                                        var insert_array = [];

                                        openData.forEach((grn_openbox_data) => {
                                          connect_pool.query(
                                            `INSERT into tbl_salesorder_item (salesorder_id, brand,device_name,color, ram,rom, sku, quantity, sale_price, amount, category, grade, grnreport_id)
                                              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                            [
                                              postData.insertId,
                                              grn_openbox_data.product_brand,
                                              grn_openbox_data.device_name,
                                              grn_openbox_data.color,
                                              grn_openbox_data.ram,
                                              grn_openbox_data.rom,
                                              grn_openbox_data.SKU,
                                              1,
                                              grn_openbox_data.mrp,
                                              grn_openbox_data.mrp,
                                              grn_openbox_data.stock_type,
                                              grn_openbox_data.certification_grade,
                                              grn_openbox_data.grnreport_id,
                                            ],
                                            (create_err,postRows) => {

                                              if (create_err) {
                                                return cb(2, create_err);
                                              }

                                              if (postRows < 1) {
                                                return cb(2,"Not added sales order items");
                                              }

                                              insert_array.push(true);

                                              if (data_length ==insert_array.length) {
                                                return cb(null, orders_list);
                                              }

                                            }
                                          );
                                        });
                                      }
                                    );
                                  } catch (e) {
                                    return cb(1, e);
                                  }

                                }
                              );
                            } catch (e) {
                              return cb(1, e);
                            }

                          }
                        );
                      } catch (e) {
                        return cb(1, e);
                      }

                    }
                  );
                } catch (e) {
                  return cb(1, e);
                }

              }
            );
          } catch (e) {
            return cb(1, e);
          }

        }
      );
    } catch (e) {
      return cb(1, e);
    }

  },
  bundleOrders: function (body_data, cb) {
    var vendor_id = body_data.vendor_id;
    var bundle_data = body_data.bundle_data;
    
    var type_list = [];
    var orders_list = [];
    var order_count = [];
    var id_list = [];

    for (var i = 0; i < bundle_data.length; i++) {
      var bundle_id = bundle_data[i].bundle_id;
      id_list.push(bundle_id);
    }

    if(body_data.bundle_discount == ''){
      var discount_amount = 0;
    } else{
      var discount_amount = body_data.bundle_discount;
    }
    var bundle_ids = [id_list];

    try {
      connect_pool.query(
        `SELECT status, bundle_no, quantity, amount, type, category, sub_category from tbl_dealer_bundle WHERE bundle_id IN ?`,
        [bundle_ids],
        (check_err, check_data) => {

          if (check_err) {
            return cb(3, check_err);
          }

          var bundle_sub_category = [];
          var selected_qnty = 0;

          for (var j = 0; j < check_data.length; j++) {
            var device_sub_category = check_data[j].sub_category;
            selected_qnty += check_data[j].quantity;
            bundle_sub_category.push(device_sub_category);

            if (type_list.indexOf(check_data[j].category) === -1) {
              let type = check_data[j].category;
              type_list.push(type);
            }

          }

          try {
            connect_pool.query(
              `SELECT count(item_id) as qnty FROM tbl_dealer_bundle_item WHERE bundle_id IN ?`,
              [bundle_ids],
              (data_err, bundleData) => {

                if (data_err) {
                  return cb(3, data_err);
                }

                if (bundleData.length < 0) {
                  let err_bndl = "No items available in selected bundles";
                  return cb(3, err_bndl);
                }

                if (bundleData[0].qnty != selected_qnty) {
                  err_qnty =
                    "Selected bundle items count mismatch with IN-STOCK availability ";
                  return cb(3, err_qnty);
                }

                try {
                  connect_pool.query(
                    `SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?`,
                    [vendor_id],
                    (tcs_err, total_amount) => {

                      if (tcs_err) {
                        return cb(3, tcs_err);
                      }

                      var total_amount = total_amount[0].amount;
                      var check_amount = 5000000;
                      var id_array = [];

                      try {
                        connect_pool.query(
                          `SELECT max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max from tbl_salesorder`,
                          (err_max, max_number) => {

                            if (err_max) {
                              return cb(3, err_max);
                            }

                            var index_no = max_number[0].max + 1;
                            var insert_array = [];

                            type_list.forEach((value, key_no) => {
                              id_array.push(id_list[key_no]);
                              var bundle_type = type_list[key_no];

                              try {
                                connect_pool.query(
                                  `SELECT sum(amount) as order_amount, sum(quantity) as qnty  from tbl_dealer_bundle WHERE bundle_id IN ? AND category = ?`,
                                  [bundle_ids, bundle_type],
                                  (type_err, type_data) => {

                                    if (type_err) {
                                      return cb(3, type_err);
                                    }

                                    if (type_data.length < 1) {
                                      return cb(3, "Bundle not available");
                                    }

                                    bundle_amount = type_data[0].order_amount;
                                    
                                    if (total_amount <= check_amount) {
                                      var final_amount = total_amount + bundle_amount;

                                      if (final_amount >= check_amount) {
                                        var tcs_percent = 0.1;
                                        let actual_amount = final_amount - check_amount;
                                        var tcs_value = (tcs_percent * actual_amount) / 100;
                                      } else {
                                        var tcs_percent = 0;
                                        var tcs_value = 0;
                                      }

                                    } else {
                                      var tcs_percent = 0.1;
                                      //var tcs_value = (tcs_percent * 100) / bundle_amount;
                                      var tcs_value = (tcs_percent * bundle_amount) / 100;
                                    }

                                    var next_number = index_no + key_no;
                                    let sales_code = "SO-HYD-" + next_number;

                                    try {
                                      connect_pool.query(
                                        `INSERT into tbl_salesorder (salesorder_code,vendor_id, status,cost_center, sales_channel, payment_mode, warehouse, discount_on_amount, discount_on_tax, discount_value, discount_amount, insurance_amount, insurance_value, freight_amount, tcs_percent, tcs_amount,device_sub_category)
                                        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                        [
                                          sales_code,
                                          vendor_id,
                                          "FINANCE_PENDING",
                                          "OFFLINE",
                                          "DEALERAPP",
                                          "prepaid",
                                          "HYD",
                                          0, 0, 0, discount_amount, 0, 0, 0,
                                          tcs_percent,
                                          tcs_value,
                                          bundle_sub_category[key_no],
                                        ],
                                        (post_err, postData, affectedRows) => {

                                          if (post_err) {
                                            return cb(3, post_err);
                                          }

                                          if (affectedRows < 1) {
                                            return cb(3,"Failed to create sales order");
                                          }

                                          var currentdate = new Date();
                                          var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
                                          
                                          try {
                                            connect_pool.query(
                                              `SELECT SUM(amount) as pay_amount FROM tbl_dealer_bundle WHERE category = ? AND bundle_id IN ?`,
                                              [bundle_type, bundle_ids],
                                              (amount_err, amountData) => {

                                                if (amount_err) {
                                                  return cb(3, amount_err);
                                                }

                                                var pay_amount = amountData[0].pay_amount;
                                                net_amount = pay_amount + tcs_value;

                                                result_obj = {
                                                  salesorder_id: postData.insertId,
                                                  salesorder_code: sales_code,
                                                  order_amount: pay_amount - discount_amount,
                                                  tcs_percent: tcs_percent,
                                                  tcs_value: tcs_value,
                                                  net_payment: net_amount,
                                                  status: "PENDING",
                                                  quantity: type_data[0].qnty,
                                                  created_date: datetime,
                                                };

                                                orders_list.push(result_obj);

                                                try {
                                                  connect_pool.query(
                                                    `SELECT * FROM DEALER_BUNDLE_LIST_VIEW WHERE category = ? AND bundle_id IN ?`,
                                                    [bundle_type, bundle_ids],
                                                    (data_err,bundleOrderData) => {

                                                      if (data_err) {
                                                        return cb(3, data_err);
                                                      }

                                                      order_count.push(postData.insertId);
                                                      var data_length = bundleOrderData.length;

                                                      bundleOrderData.forEach((bndl_data) => {

                                                          try {
                                                            connect_pool.query(
                                                              `INSERT into tbl_salesorder_item (salesorder_id, brand,device_name,color, ram,rom, sku, quantity, sale_price, amount, category, grade, grnreport_id)
                                                              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                                              [
                                                                postData.insertId,
                                                                bndl_data.brand,
                                                                bndl_data.device_name,
                                                                bndl_data.color,
                                                                bndl_data.ram,
                                                                bndl_data.rom,
                                                                bndl_data.sku,
                                                                1,
                                                                bndl_data.sale_price,
                                                                bndl_data.sale_price,
                                                                //bndl_data.category,
                                                                bndl_data.stock_type,
                                                                bndl_data.grade,
                                                                bndl_data.grnreport_id,
                                                              ],
                                                              (create_err,postRows) => {

                                                                if (create_err) {
                                                                  return create_err;
                                                                }

                                                                if ( postRows < 1) {
                                                                  return cb(3,"Failed to add sales order items");
                                                                }

                                                                insert_array.push(true);

                                                                try {
                                                                  connect_pool.query(
                                                                    `UPDATE tbl_dealer_bundle SET order_id = '${postData.insertId}', status = 'RESERVE' WHERE category = ? AND bundle_id IN ?`,
                                                                    [bundle_type,bundle_ids],
                                                                    (update_err) => {

                                                                      if (update_err) {
                                                                        return cb(3,update_err);
                                                                      }
                                                                      
                                                                    }
                                                                  );
                                                                } catch (e) {
                                                                  return cb(3,e);
                                                                }

                                                                if (data_length == insert_array.length) {
                                                                  return cb(4,orders_list );
                                                                }
                                                              }
                                                            );
                                                          } catch (e) {
                                                            return cb(3, e);
                                                          }
                                                        }
                                                      );
                                                    }
                                                  );
                                                } catch (e) {
                                                  return cb(3, e);
                                                }
                                              }
                                            );
                                          } catch (e) {
                                            return cb(3, e);
                                          }
                                        }
                                      );
                                    } catch (e) {
                                      return cb(3, e);
                                    }
                                  }
                                );
                              } catch (e) {
                                return cb(3, e);
                              }
                            });
                          }
                        );
                      } catch (e) {
                        return cb(3, e);
                      }
                    }
                  );
                } catch (e) {
                  return cb(3, e);
                }
              }
            );
          } catch (e) {
            return cb(3, e);
          }
        }
      );
    } catch (e) {
      return cb(3, e);
    }
  },
  prexoOrder: function (body_data, cb) {
    var vendor_id = body_data.vendor_id;
    var prexo_data = body_data.prexo_data;
    //var discount_amount = body_data.openbox_discount;
    var grnid_list = [];

    for (var i = 0; i < prexo_data.length; i++) {
      var grnreport_id = prexo_data[i].grnreport_id;
      grnid_list.push(grnreport_id);
    }

    if(body_data.openbox_discount == ''){
      var discount_amount = 0;
    } else{
      var discount_amount = body_data.openbox_discount;
    }

    var grnreport_ids = [grnid_list];
    var orders_list = [];
    var order_count = [];
    //var openbox_list = ["OPEN BOX"];
    var grnidorder_list = [];

    for (var i = 0; i < prexo_data.length; i++) {
      var grn_id = prexo_data[i].grnreport_id;
      grnidorder_list.push(grn_id);
    }

    var grnreportids = [grnidorder_list];

    try {
      connect_pool.query(
        `SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?`,
        [vendor_id],
        (tcs_err, total_amount) => {

          if (tcs_err) {
            return cb(5, tcs_err);
          }

          var total_amount = total_amount[0].amount;
          var check_amount = 5000000;

          try {
            connect_pool.query(
              `SELECT max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max from tbl_salesorder`,
              (err_max, max_number) => {

                if (err_max) {
                  return cb(5, err_max);
                }

                var index_no = max_number[0].max + 1;

                try {
                  connect_pool.query(
                    `SELECT sum(mrp) as order_amount, count(grnreport_id) as qnty  from tbl_grnreport WHERE grnreport_id IN ?`,
                    [grnreportids],
                    (type_err, type_data) => {

                      if (type_err) {
                        return cb(5, type_err);
                      }

                      var open_box_amount = type_data[0].order_amount;

                      if (total_amount <= check_amount) {
                        var final_amount = total_amount + open_box_amount;

                        if (final_amount >= check_amount) {
                          var tcs_percent = 0.1;
                          let actual_amount = final_amount - check_amount;
                          var tcs_value = (tcs_percent * actual_amount) / 100;
                        } else {
                          var tcs_percent = 0;
                          var tcs_value = 0;
                        }

                      } else {
                        var tcs_percent = 0.1;
                        var tcs_value = (tcs_percent * open_box_amount) / 100;
                      }

                      var next_number = index_no;
                      let sales_code = "SO-HYD-" + next_number;

                      try {
                        connect_pool.query(
                          `INSERT into tbl_salesorder (salesorder_code,vendor_id, status,cost_center, sales_channel, payment_mode, warehouse, discount_on_amount, discount_on_tax, discount_value, discount_amount, insurance_amount, insurance_value, freight_amount, tcs_percent, tcs_amount,device_sub_category)
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                          [
                            sales_code,
                            vendor_id,
                            "FINANCE_PENDING",
                            "OFFLINE",
                            "DEALERAPP",
                            "prepaid",
                            "HYD",
                            0,0,0,discount_amount,0,0,0,
                            tcs_percent,
                            tcs_value,
                            "SELTRUE",
                          ],
                          (post_err, postData, affectedRows) => {

                            if (post_err) {
                              return cb(5, post_err);
                            }

                            if (affectedRows < 1) {
                              return cb(5,"Sales order not created for OPEN BOX devices");
                            }

                            var currentdate = new Date();
                            var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
                            
                            try {
                              connect_pool.query(
                                `SELECT SUM(mrp) as pay_amount FROM tbl_grnreport WHERE grnreport_id IN ?`,
                                [grnreport_ids],
                                (amount_err, amountData) => {

                                  if (amount_err) {
                                    return cb(5, amount_err);
                                  }

                                  var pay_amount = amountData[0].pay_amount;
                                  net_amount = pay_amount + tcs_value;
                                  
                                  result_obj = {
                                    salesorder_id: postData.insertId,
                                    salesorder_code: sales_code,
                                    order_amount : pay_amount - discount_amount,
                                    tcs_percent: tcs_percent,
                                    tcs_value: tcs_value,
                                    net_payment: net_amount,
                                    status: "PENDING",
                                    quantity: type_data[0].qnty,
                                    created_date: datetime,
                                  };
                                  orders_list.push(result_obj);

                                  try {
                                    connect_pool.query(
                                      `SELECT * FROM tbl_grnreport WHERE grnreport_id IN ?`,
                                      [grnreportids],
                                      (data_err, openData) => {

                                        if (data_err) {
                                          return cb(5, data_err);
                                        }

                                        var data_length = openData.length;
                                        order_count.push(postData.insertId);
                                        var insert_array = [];

                                        openData.forEach((grn_prexo_data) => {
                                          connect_pool.query(
                                            `INSERT into tbl_salesorder_item (salesorder_id, brand,device_name,color, ram,rom, sku, quantity, sale_price, amount, category, grade, grnreport_id)
                                              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`,
                                            [
                                              postData.insertId,
                                              grn_prexo_data.product_brand,
                                              grn_prexo_data.device_name,
                                              grn_prexo_data.color,
                                              grn_prexo_data.ram,
                                              grn_prexo_data.rom,
                                              grn_prexo_data.SKU,
                                              1,
                                              grn_prexo_data.mrp,
                                              grn_prexo_data.mrp,
                                              grn_prexo_data.stock_type,
                                              grn_prexo_data.certification_grade,
                                              grn_prexo_data.grnreport_id,
                                            ],
                                            (create_err,postRows) => {

                                              if (create_err) {
                                                return cb(5, create_err);
                                              }

                                              if (postRows < 1) {
                                                return cb(5,"Not added sales order items");
                                              }

                                              insert_array.push(true);

                                              if (data_length ==insert_array.length) {
                                                return cb(null, orders_list);
                                              }

                                            }
                                          );
                                        });
                                      }
                                    );
                                  } catch (e) {
                                    return cb(1, e);
                                  }

                                }
                              );
                            } catch (e) {
                              return cb(1, e);
                            }

                          }
                        );
                      } catch (e) {
                        return cb(1, e);
                      }

                    }
                  );
                } catch (e) {
                  return cb(1, e);
                }

              }
            );
          } catch (e) {
            return cb(1, e);
          }

        }
      );
    } catch (e) {
      return cb(1, e);
    }

  },
  create_sales_order: (data, callBack) => {
    var bundle_data = data.bundle_data;
    var openbox_data = data.open_box_data;
    var prexo_data = data.prexo_data;
    
    var orders_array = [];
    var openbox_orders = [];
    var prexo_orders = [];
    var bundle_orders = [];
    var validation = module.exports.validationRules(data, (val, msg) => {

      if (val == 1) {
        return callBack(1, msg);
      } else {

        if (openbox_data.length > 0 && prexo_data.length < 1) {
          var openBoxData = module.exports.openBoxOrder(
            data,
            (openbox_val, openbox_msg) => {
              if (openbox_val == 2) {

                return callBack(1, openbox_msg);
              } else {
                orders_array.push(openbox_msg[0]);
                openbox_orders.push(openbox_msg[0]);

                if (bundle_data.length > 0) {
                  var bundleDeviceData = module.exports.bundleOrders(
                    data,
                    (bundle_val, bundle_msg) => {

                      if (bundle_val == 3) {
                        return callBack(1, bundle_msg);
                      } else {
                        orders_array.push(bundle_msg[0]);
                        bundle_orders.push(bundle_msg[0]);
                        var bundle_length = bundle_orders.length;
                        var openbox_length = openbox_orders.length;
                        var final_length = bundle_length + openbox_length;

                        if (final_length == orders_array.length) {
                          return callBack(null, orders_array);
                        }
                      }
                    }
                  );
                } else {
                  return callBack(null, orders_array);
                }
              }
            }
          );
        } else if (prexo_data.length > 0 && openbox_data.length < 1) {
          var prexoData = module.exports.prexoOrder(
            data,
            (prexo_val, prexo_msg) => {
              if (prexo_val == 5) {

                return callBack(1, prexo_msg);
              } else {
                orders_array.push(prexo_msg[0]);
                prexo_orders.push(prexo_msg[0]);

                if (bundle_data.length > 0) {
                  var bundleDeviceData = module.exports.bundleOrders(
                    data,
                    (bundle_val, bundle_msg) => {

                      if (bundle_val == 3) {
                        return callBack(1, bundle_msg);
                      } else {
                        orders_array.push(bundle_msg[0]);
                        bundle_orders.push(bundle_msg[0]);
                        var bundle_length = bundle_orders.length;
                        var prexo_length = prexo_orders.length;
                        var final_length = bundle_length + prexo_length;

                        if (final_length == orders_array.length) {
                          return callBack(null, orders_array);
                        }
                      }
                    }
                  );
                } else {
                  return callBack(null, orders_array);
                }
              }
            }
          );
        } else if (prexo_data.length > 0 && openbox_data.length > 0) {
          var openBoxData = module.exports.openBoxOrder(
            data,
            (openbox_val, openbox_msg) => {
              if (openbox_val == 2) {

                return callBack(1, openbox_msg);
              } else {
                orders_array.push(openbox_msg[0]);
                openbox_orders.push(openbox_msg[0]);

                if(prexo_data.length > 0){
                  var prexoData = module.exports.prexoOrder(
                    data,
                    (prexo_val, prexo_msg) => {
                      if (prexo_val == 5) {
        
                        return callBack(1, prexo_msg);
                      } else {
                        orders_array.push(prexo_msg[0]);
                        prexo_orders.push(prexo_msg[0]);

                        if (bundle_data.length > 0) {
                          var bundleDeviceData = module.exports.bundleOrders(
                            data,
                            (bundle_val, bundle_msg) => {
        
                              if (bundle_val == 3) {
                                return callBack(1, bundle_msg);
                              } else {
                                orders_array.push(bundle_msg[0]);
                                bundle_orders.push(bundle_msg[0]);
                                var bundle_length = bundle_orders.length;
                                var openbox_length = openbox_orders.length;
                                var prexo_length = prexo_orders.length;
                                var final_length = bundle_length + openbox_length + prexo_length;
        
                                if (final_length == orders_array.length) {
                                  return callBack(null, orders_array);
                                }
                              }
                            }
                          );
                        } else {
                          return callBack(null, orders_array);
                        }

                      }
                    }
                )}
              }
            }
          );
        }else {
          var bundleDeviceData = module.exports.bundleOrders(
            data,
            (bundle_val, bundle_msg) => {

              if (bundle_val == 3) {
                return callBack(1, bundle_msg);
              } else {
                orders_array.push(bundle_msg[0]);
                return callBack(null, orders_array);
              }
            }
          );
        }
      }
    });
  },
  get_order_status: (order_id, callBack) => {

    if (order_id == "" || order_id == undefined) {
      return callBack(1);
    }
    try {
      connect_pool.query(
        `SELECT status from tbl_salesorder WHERE salesorder_id = ?`,
        [order_id],
        (error, results) => {

          if (results.length < 1) {
            return callBack(1);
          }

          if (error) {
            return callBack(error);
          }
          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_order_info: (order_id, callBack) => {
    
    try {
      connect_pool.query(
        `select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, status from tbl_dealer_bundle WHERE order_id = ?`,
        [order_id],
        (err, bundle_info) => {
          if (err) {
            return callBack(err);
          }

          if (bundle_info.length < 1) {
            try {
              connect_pool.query(
                `SELECT grnreport_id FROM DEALER_SALESORDER_EXPORT_VIEW WHERE salesorder_id = ?`,
                [order_id],
                (check_err, check_data) => {

                  if (check_err) {
                    return callBack(1, check_err);
                  }

                  if (check_data.length < 1) {
                    var msg = "No bundles found ";
                    return callBack(1, msg);
                  }
                  var id_list = [];
                  var bundle_info = [];

                  if (check_data.length > 0) {

                    for (var y = 0; y < check_data.length; y++) {
                      var grnreport_id = check_data[y].grnreport_id;
                      id_list.push(grnreport_id);
                    }

                    if (id_list.length == check_data.length) {
                      var grnreportids = [id_list];
                      try {
                        connect_pool.query(
                          `SELECT * FROM tbl_grnreport WHERE grnreport_id IN ?`,
                          [grnreportids],
                          (data_err, openData) => {
                            
                            if (data_err) {
                              return callBack(1, data_err);
                            }

                            openData.forEach((grn_openbox_data) => {
                              var server_path = process.env.IMAGE_URL;
                              var image_name = grn_openbox_data.nhmod + '.jpg';
                              var actual_image_url = server_path + image_name;
                              var default_image_url = server_path + "default.jpg";
                              var image_path = ''
                              https.get(actual_image_url,function(res){
                                if(res.statusCode == 200){
                                  image_path = actual_image_url;
                                } else {
                                  image_path = default_image_url;
                                }
                                result_obj = {
                                  grnreport_id: grn_openbox_data.grnreport_id,
                                  device_id: grn_openbox_data.nhdin,
                                  product_brand: grn_openbox_data.product_brand,
                                  device_name: grn_openbox_data.device_name,
                                  ram: grn_openbox_data.ram,
                                  rom: grn_openbox_data.rom,
                                  certification_grade:
                                  grn_openbox_data.certification_grade,
                                  mrp: grn_openbox_data.mrp,
                                  image_path: image_path,
                                  stock_type : grn_openbox_data.stock_type
                                };
                                bundle_info.push(result_obj);
                                try {
                                  connect_pool.query(
                                    `select salesorder_code, status from tbl_salesorder WHERE salesorder_id = ? `,
                                    [order_id],
                                    (status_err, statusData) => {
                                      
                                      if (status_err) {
                                        return callBack(status_err);
                                      }
                                      var orderStatus = statusData[0].status;
                                      var order_status = orderStatus.replace("_", " ");
                                      var salesorder_no = statusData[0].salesorder_code;
                                      const payment_info = [];
                                      try {
                                        connect_pool.query(
                                          `select payment_reference, receipt_no, amount, amount_paid, currency, created_date from tbl_dealer_payments WHERE order_id = ? `,
                                          [order_id],
                                          (payment_err, result) => {
    
                                            if (payment_err) {
                                              return callBack(payment_err);
                                            }
    
                                            if (result.length < 1) {
                                              var pay_err = "No payments for this order ";
                                              return callBack(1, pay_err);
                                            }
                                            var currentdate = result[0].created_date;
                                            var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
                                            result[0].payment_date = datetime;
                                            result[0].salesorder_no = salesorder_no;
                                            result[0].status = order_status;
                                            delete result[0].created_date;
                                            payment_info.push(result[0]);
                                            
                                            if (id_list.length == bundle_info.length) {
                                              const final_result = {bundle_info,payment_info};
                                              id_list.length = 0;
                                              return callBack(null, final_result);
                                            }
                                          }
                                        );
                                      } catch (e) {
                                        return callBack(e);
                                      }
                                    }
                                  );
                                } catch (e) {
                                  return callBack(e);
                                }
                              });
                            });
                          }
                        );
                      } catch (e) {
                        return callBack(e);
                      }
                    }
                  }
                }
              );
            } catch (e) {
              return callBack(e);
            }
          } else {
            var bundle_type = bundle_info[0].type;
            var grade_qnty = "";
            if (bundle_type == "1A") {
              grade_qnty = "SG-A(5) SG-B(5)";
            } else if (bundle_type == "1B") {
              grade_qnty = "SG-A(4) SG-B(6)";
            } else if (bundle_type == "1C") {
              grade_qnty = "SG-A(2) SG-B(3) SG-C(5)";
            } else if (bundle_type == "1D") {
              grade_qnty = "SG-D(10)";
            } else if (bundle_type == "1E") {
              grade_qnty = "SG-B(3) SG-C(7)";
            } else if (bundle_type == "1F") {
              grade_qnty = "SG-B(3) SG-C(5) SG-D(2)";
            } else if ( bundle_type == "2A" || bundle_type == "2B" || bundle_type == "2C" || bundle_type == "2D" || bundle_type == "2E" || bundle_type == "2F") {
              grade_qnty = "SG-A(3) SG-B(3) SG-B(4)";
            }
            try {
              connect_pool.query(
                `select salesorder_code, status from tbl_salesorder WHERE salesorder_id = ? `,
                [order_id],
                (status_err, statusData) => {

                  if (status_err) {
                    return callBack(status_err);
                  }
                  var orderStatus = statusData[0].status;
                  var order_status = orderStatus.replace("_", " ");
                  var salesorder_no = statusData[0].salesorder_code;
                  const payment_info = [];
                  try {
                    connect_pool.query(
                      `select payment_reference, receipt_no, amount, amount_paid, currency, created_date from tbl_dealer_payments WHERE order_id = ? `,
                      [order_id],
                      (payment_err, result) => {

                        if (payment_err) {
                          return callBack(payment_err);
                        }

                        if (result.length < 1) {
                          var pay_err = "No payments for this order ";
                          return callBack(1, pay_err);
                        }
                        var currentdate = result[0].created_date;
                        var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
                        result[0].payment_date = datetime;
                        result[0].salesorder_no = salesorder_no;
                        result[0].status = order_status;
                        bundle_info[0].grade_qnty = grade_qnty;
                        delete result[0].created_date;
                        payment_info.push(result[0]);
                        const final_result = { bundle_info, payment_info };
                        return callBack(null, final_result);
                      }
                    );
                  } catch (e) {
                    return callBack(e);
                  }
                }
              );
            } catch (e) {
              return callBack(e);
            }
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_invoice: (order_id, callBack) => {
    try {
      connect_pool.query(
        `SELECT  invoice_id,invoice_code, salesorder_code, saleschannel_ref_id, amount, insurance_amount, discount_amount, freight_amount, tcs_amount, tcs_percent, CREATION_DATE as invoice_date, payment_mode as payment_type, sales_channel, sales_code, vendor_name, vendor_code, company, address, city, state, state_id, pincode, pan_card, gst_no from PDF_INVOICE_HEADER_VIEW WHERE salesorder_id = ?`,
        [order_id],
        (invoice_error, invoiceData) => {

          if (invoice_error) {
            return callBack(invoice_error);
          }

          if (invoiceData.length < 1) {
            let msg = "No invoice created";
            return callBack(1, msg);
          }
          var invoice_id = invoiceData[0].invoice_id;
          var currentdate = invoiceData[0].invoice_date;
          var datetime = currentdate.getDate() + "-" + (currentdate.getMonth() + 1) + "-" + currentdate.getFullYear();
          delete invoiceData[0].invoice_date;
          var place_of_supply = invoiceData[0].state_id + "-" + invoiceData[0].state;
          invoiceData[0].invoice_date = datetime;
          invoiceData[0].place_of_suplly = place_of_supply;
          var number = invoiceData[0].amount;
        
          function numberToWords(number) {
            var digit = ["zero","one","two","three","four","five","six","seven","eight","nine"];
            var elevenSeries = [ "ten","eleven","twelve","thirteen","fourteen","fifteen","sixteen","seventeen","eighteen","nineteen"];
            var countingByTens = ["twenty","thirty","forty","fifty","sixty","seventy","eighty", "ninety"];
            var shortScale = ["", "thousand", "million", "billion", "trillion"];
            number = number.toString();
            number = number.replace(/[\, ]/g, "");

            if (number != parseFloat(number)) return "not a number";
            var x = number.indexOf(".");

            if (x == -1) x = number.length;

            if (x > 15) return "too big";

            var n = number.split("");
            var str = "";
            var sk = 0;

            for (var i = 0; i < x; i++) {
              if ((x - i) % 3 == 2) {

                if (n[i] == "1") {
                  str += elevenSeries[Number(n[i + 1])] + " ";
                  i++;
                  sk = 1;
                } else if (n[i] != 0) {
                  str += countingByTens[n[i] - 2] + " ";
                  sk = 1;
                }
              } else if (n[i] != 0) {
                str += digit[n[i]] + " ";
                if ((x - i) % 3 == 0) str += "hundred ";
                sk = 1;
              }

              if ((x - i) % 3 == 1) {
                if (sk) str += shortScale[(x - i - 1) / 3] + " ";
                sk = 0;
              }
            }

            if (x != number.length) {
              var y = number.length;
              str += "point ";
              for (var i = x + 1; i < y; i++) str += digit[n[i]] + " ";
            }
            str = str.replace(/\number+/g, " ");
            return str.trim() + ".";
          }
          var amount_words = numberToWords(number);
          invoiceData[0].amount_words = amount_words;
          try {
            connect_pool.query(
              `SELECT category as product_name, SUM(qty) as quantity, sum(total_amount) as price, sum(exempt_amount) as exempt_amount, sum(taxable_amount) as taxable_amount, sum(tax_amount) as tax_amount from INVOICE_EXPORT_REPORT_VIEW WHERE invoice_id = ?`,
              [invoice_id],
              (error, results) => {

                if (error) {
                  return callBack(error);
                }
                results[0].tax_rate = "18%";
                results[0].tcs_percent = invoiceData[0].tcs_percent;
                results[0].tcs_amount = invoiceData[0].tcs_amount;
                var net_amount = invoiceData[0].amount + results[0].tcs_amount;
                delete invoiceData[0].tcs_amount;
                delete invoiceData[0].tcs_percent;
                results[0].amount = invoiceData[0].amount;
                results[0].amount_words = invoiceData[0].amount_words;
                results[0].net_amount = net_amount;
                delete invoiceData[0].amount;
                delete invoiceData[0].amount_words;
                result_obj = {
                  invoice_header: invoiceData[0],
                  invoice_item: results[0],
                };
                return callBack(null, result_obj);
              }
            );
          } catch (e) {
            return callBack(e);
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_invoice_items: (order_id, callBack) => {
    try {
      connect_pool.query(
        `SELECT  invoice_id,company, invoice_code as invoice_number, CREATION_DATE from PDF_INVOICE_HEADER_VIEW WHERE salesorder_id = ?`,
        [order_id],
        (invoice_error, invoiceData) => {

          if (invoice_error) {
            return callBack(invoice_error);
          }

          if (invoiceData.length < 1) {
            let msg = "No invoice created";
            return callBack(1, msg);
          }
          var invoice_id = invoiceData[0].invoice_id;
          var date = invoiceData[0].CREATION_DATE;
          var invoice_date = date.getDate() + "-" + (date.getMonth() + 1) + "-" + date.getFullYear();
          delete invoiceData[0].CREATION_DATE;
          invoiceData[0].invoice_date = invoice_date;
          try {
            connect_pool.query(
              `SELECT grnreport_id, price from tbl_invoice_item WHERE invoice_id = ?`,
              [invoice_id],
              (sum_error, sumData) => {

                if (sum_error) {
                  return callBack(sum_error);
                }
                var count = 0;
                var total_price = 0;
                const items_array = [];

                sumData.forEach((element) => {
                  count++;
                  total_price += element.price;
                  var genReportId = element.grnreport_id;
                  try {
                    connect_pool.query(
                      `SELECT  device_name as product_name, SKU, imei1_no, stock_type, nhdin, mrp from tbl_grnreport WHERE grnreport_id = ?`,
                      [genReportId],
                      (item_error, invoiceItems) => {

                        if (item_error) {
                          return callBack(item_error);
                        }
                        invoiceData[0].total_quantity = sumData.length;
                        invoiceData[0].total_price = total_price;
                        delete invoiceData[0].invoice_id;
                        res = {
                          product_name: invoiceItems[0].product_name,
                          sku: invoiceItems[0].SKU,
                          imei: invoiceItems[0].imei1_no,
                          category: invoiceItems[0].stock_type,
                          device_id: invoiceItems[0].nhdin,
                          qty: 1,
                          price: invoiceItems[0].mrp
                        };
                        items_array.push(res);
                        result_obj = {
                          invoice_header: invoiceData[0],
                          invoice_items: items_array,
                        };

                        if (items_array.length == count) {
                          return callBack(null, result_obj);
                        }
                      }
                    );
                  } catch (e) {
                    return callBack(e);
                  }
                });
              }
            );
          } catch (e) {
            return callBack(e);
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_total_orders:  async (vendor_id, callBack) => {
    
    if (vendor_id == "" || vendor_id == undefined) {
      return callBack(1);
    }
    var sales_channel = "DEALERAPP";
    var total_orders = [];
    const orderstatus = "CANCELED";

    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * from tbl_salesorder WHERE vendor_id = ? AND sales_channel = ? AND status != ? ORDER BY salesorder_id DESC ";
        var qr2 = "SELECT count(salesorder_item_id) as quantity, SUM(amount) as amount from tbl_salesorder_item WHERE salesorder_id = ? ";
        var qr3 = "SELECT count(bundle_id) as bundle_quantity from tbl_dealer_bundle WHERE order_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [vendor_id, sales_channel, orderstatus],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
        });
        if(qr1_res.length < 1){
          return callBack(2)
        }
        
        for (var i = 0; i < qr1_res.length; i += 1) {
          
          var order_id = qr1_res[i].salesorder_id;
          var discount_amount = qr1_res[i].discount_amount;
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2, [order_id],
              (result2_err, results_2) => {
              
                if (result2_err){
                  connection.rollback();
                  return callBack(result2_err);
                } 
                res(results_2);
            });
          });
          if (qr2_res.length < 1) {
            return callBack(2);
          }
          var amount = qr2_res[0].amount;
          var tcs_amount = qr1_res[i].tcs_amount;
          var order_amount = parseFloat(amount + tcs_amount)-parseFloat(discount_amount);
          let order_status = qr1_res[i].status;
          let orderStatus = order_status.replace("_", " ");
          var date = qr1_res[i].CREATION_DATE;
          var datetime = date.getDate() + "-" + (date.getMonth() + 1) + "-" + date.getFullYear();
          var qr3_res = await new Promise((res, rej) => {
            connect_pool.query(qr3, [order_id],
              (result3_err, results_3) => {
                
                  if (result3_err){
                    connection.rollback();
                    return callBack(result3_err);
                  } 
                  res(results_3);
            });
          });
          obj = {
            
            salesorder_id: qr1_res[i].salesorder_id,
            salesorder_code: qr1_res[i].salesorder_code,
            order_amount: order_amount,
            status: orderStatus,
            created_date: datetime,
            quantity: qr3_res[0].bundle_quantity,
          }
          total_orders.push(obj)
        };
        await connection.commit();
        await connection.end();
      
        return callBack(null, total_orders);
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack(err);
      }
  },
  cancel_sales_order: (body, callBack) => {
    var id_list = body.order_id;
    var vendor_id = body.vendor_id;
    var salesorder_ids = [id_list];
    var status = "CANCELED";
    const check_arr = ["CANCELED", "INVOICED"];
    
    try {
      connect_pool.query(
        `UPDATE tbl_salesorder SET status = ? WHERE vendor_id = ? AND salesorder_id IN ? AND status NOT IN  ?`,
        [status, vendor_id, salesorder_ids, [check_arr]],
        (final_err, resData) => {

          if (final_err) {
            return callBack(1, final_err);
          }
          var bundle_status = "ACTIVE";

          try {
            connect_pool.query(
              `UPDATE tbl_dealer_bundle SET status = ? WHERE order_id IN ?`,
              [bundle_status, salesorder_ids],
              (update_err) => {

                if (update_err) {
                  return callBack(1, update_err);
                }

                var remark = "PAYMENT FAILED";
                var dealer_id = 48;
                var reference_type = "salesorder";;
                
                var insert_array = [];

                salesorder_ids.forEach((grn_openbox_data, key_no) => {
                  var reference_id = grn_openbox_data[key_no];
                  insert_array.push(true)

                  try{
                    connect_pool.query(
                      `INSERT into tbl_remark(reference_id,reference_type,user_id, remark)
                        VALUES(?,?,?,?)`,
                        [reference_id,reference_type,dealer_id,remark],
                      (remark_err) => {
        
                        if (remark_err) {
                          return callBack(1, remark_err);
                        }

                        if(insert_array.length == salesorder_ids.length){
                          return callBack(null, resData);
                        }
                        
                      }
                    );
                  } catch (e) {
                    return callBack(e);
                  }
                });
              
              }
            );
          } catch (e) {
            return callBack(e);
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  payment_type: (err, callBack) => {
    try {
      connect_pool.query(
        `SELECT name from tbl_dropdown WHERE type = ?`,
        ["RECEIPT_TYPE"],
        (error, results) => {

          if (results.length < 1) {
            return callBack(1, null);
          }

          if (error) {
            return callBack(error, null);
          }
          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  payment_accounts: (err, callBack) => {
    try {
      connect_pool.query(
        `SELECT name from tbl_dropdown WHERE type = ?`,
        ["BANK_ACCOUNTS"],
        (error, results) => {

          if (results.length < 1) {
            return callBack(1, null);
          }

          if (error) {
            return callBack(error, null);
          }
          return callBack(null, results);
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  update_cart_item: (data, callBack) => {

    if (data.SKU == "" || data.SKU == undefined) {
      return callBack(1);
    }

    if (data.vendor_id == "" || data.vendor_id == undefined) {
      return callBack(1);
    }
    try {
      connect_pool.query(
        `SELECT * from tbl_dealerapp_cart WHERE vendor_id = ? AND SKU = ?`,
        [data.vendor_id, data.SKU],
        (errs, res) => {

          if (errs) {
            return callBack(2);
          }
          let quantity = res[0].quantity;
          let unit_price = res[0].unit_price;
          let total_price = res[0].total_price;

          if (data.argument == "INC") {
            var update_qnty = quantity + 1;
            var update_total_price = total_price + unit_price;
          } else if (data.argument == "DEC") {

            if (res[0].quantity == 1) {
              try {
                connect_pool.query(
                  `DELETE from tbl_dealerapp_cart WHERE vendor_id = ? AND SKU = ?`,
                  [data.vendor_id, data.SKU],
                  (error, results) => {

                    if (error) {
                      return callBack(3);
                    }
                    return callBack(null, true);
                  }
                );
              } catch (e) {
                return callBack(e);
              }
            }
            var update_qnty = quantity - 1;
            var update_total_price = total_price - unit_price;
          }
          try {
            connect_pool.query(
              `UPDATE tbl_dealerapp_cart set quantity =? , total_price =?  WHERE vendor_id = ? AND SKU = ?`,
              [update_qnty, update_total_price, data.vendor_id, data.SKU],
              (final_err, resData) => {

                if (final_err) {
                  return final_err;
                }
                return callBack(null, resData);
              }
            );
          } catch (e) {
            return callBack(e);
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  deleteCartItem: (cart_id, callBack) => {

    if (cart_id == "" || cart_id == undefined) {
      return callBack(1);
    }
    try {
      connect_pool.query(
        `DELETE from tbl_dlr_cart WHERE cart_id = ?`,
        [cart_id],
        (error, results) => {

          if (error) {
            return callBack(error);
          }
          
          if (results.affectedRows < 1) {
            return callBack(2);
          }
          return callBack(null, true);
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_tracking: (order_id, callBack) => {

    if (order_id == "" || order_id == undefined) {
      return callBack(1);
    }
    
    try {
      connect_pool.query(
        `SELECT * from TRACKING_URL_LIST_VIEW WHERE salesorder_id = ? `,
        [order_id],
        (error, results) => {

          if (error) {
            let res_msg = {
              "status" : 0,
              "message" : error
            }
            return callBack(null,res_msg);
          }

          if (results.length < 1) {
            let res_msg = {
              "status" : 0,
              "message" : "No results found"
            }
            return callBack(null,res_msg);
          }
          
          if(results[0].tracking_url == null){
            results[0].tracking_url = "";
          } 
          let res_msg = {
            "status" : 1,
            "data" : results[0]
          }
          return callBack(null,res_msg);
        }
      );
    } catch (e) {
      let res_msg = {
        "status" : 0,
        "message" : e
      }
      return callBack(null,res_msg);
    }
  },
  place_order: async (body, callBack) => {

    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    if(body.tcs_value > 0){
        var tcs_percent = 0.1;
    } else{
        var tcs_percent = 0;
    }
    try {
      
      var qr1 = "SELECT max(CAST(SUBSTRING(order_no,-1) as UNSIGNED)) as max from tbl_dealerapp_orders";
      //await connect_pool.beginTransaction()
      var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1,(row1_err, row1) => {
          
              if (row1_err){
                connection.rollback(); return callBack(row1_err);
              }
              res(row1);
          });
      });

      if(body.category_id == 3){
        var orderStatus = "APPROVED";
        var order_series = "DIST-";
        var bundleStatus = "ACTIVE";
      } else if(body.category_id == 4){

        var order_series = "DELR-";
        var orderStatus = "PENDING";
        var bundleStatus = "IN-ACTIVE";
      }
      
      if(qr1_res[0].max == 0 || qr1_res[0].max == null){
        
        var order_no = order_series + "1";
      }else{
       
        var index_no = qr1_res[0].max + 1
        var order_no = order_series + index_no;
      }
      var bundle_ids = body.bundle_id;
      var qr8 = "SELECT * FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE bundle_id = ? AND vendor_id = ? AND status != ?";
      for (var k = 0; k < bundle_ids.length; k += 1) {
        var bundle_id = bundle_ids[k];
        
        var qr8_res = await new Promise((res, rej) => {
          connect_pool.query(qr8, [bundle_id,body.vendor_id,"CANCELLED"], 
            (result8_err, results_8) => {
                if (result8_err){
                  connection.rollback(); return callBack(result8_err);
                } 
                res(results_8);
            });
        });
        
      }
      let qr2 = "INSERT INTO tbl_dealerapp_orders (order_no,vendor_id, category_id, order_to,discount,discount_percent,tcs_percent, tcs_amount,status,updated_by) VALUES (?,?,?,?,?,?,?,?,?,?)";
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2,
          [order_no, body.vendor_id, 2, body.attached_vendor_id,body.order_discount,body.discount_percent,tcs_percent,body.tcs_value, orderStatus,body.vendor_id], 
          (result_err, results) => {
            
              if (result_err){
                connection.rollback(); return callBack(result_err);
              } 
              res(results);
          });
      });
      var order_id = qr2_res.insertId;
      var qr4 = "SELECT * FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE bundle_id = ? AND vendor_id = ?";
      var qr5 = "INSERT into tbl_dealerapp_order_item (order_id,bundle_id, purchase_price, sale_price, bundle_status) VALUES (?,?,?,?,?)";
      var bundleData = [];
      var orderItemIdList = [];
      for (var j = 0; j < bundle_ids.length; j += 1) {
        var bundle_id = bundle_ids[j];
        var qr4_res = await new Promise((res, rej) => {
        connect_pool.query(qr4, [bundle_id,body.attached_vendor_id], 
          (result1_err, results_1) => {
              if (result1_err){
                connection.rollback(); return callBack(result1_err);
              } 
              res(results_1);
          });
        });
        var purchase_price = qr4_res[0].purchase_price;
        var sale_price = qr4_res[0].purchase_price;
        var orderItemId = qr4_res[0].order_item_id;
        orderItemIdList.push(orderItemId);
        var obj = {
          "order_item_id" : orderItemId,
          "bundle_id" : bundle_id,
        }
        bundleData.push(obj);
        var qr5_res = await new Promise((res, rej) => {
        connect_pool.query(qr5,
          [order_id, bundle_id, purchase_price, sale_price, bundleStatus], 
          (result2_err, results_2) => {
              if (result2_err){ 
                connection.rollback(); return callBack(result2_err);
              }
              res(results_2);
          });
        });
        var order_item_id = qr5_res.insertId;
        let qr6 = "SELECT grnreport_id, purchase_price FROM tbl_dealerapp_order_bundle_item WHERE bundle_id = ? AND order_item_id = ?";
        var qr6_res = await new Promise((res, rej) => {
          connect_pool.query(qr6,[bundle_id,orderItemId], 
          (result3_err, results3) => {
              if (result3_err){ 
                connection.rollback(); return callBack(result3_err)
                };
              res(results3);
          });
        })
        var qr7 = "INSERT into tbl_dealerapp_order_bundle_item (bundle_id,order_item_id, grnreport_id, purchase_price, sale_price) VALUES (?,?,?,?,?)";
        for (var i = 0; i < qr6_res.length; i += 1) {
          var grnreport_id = qr6_res[i].grnreport_id;
          var purchase_price = qr6_res[i].purchase_price;
            var qr7_res = await new Promise((res, rej) => {
            connect_pool.query(qr7,
              [bundle_id, order_item_id, grnreport_id, purchase_price, purchase_price], 
              (result4_err, results4) => {
                
                  if (result4_err){
                    connection.rollback(); return callBack(result4_err);
                  }
                  res(results4);
            });
          })
        };
      }
      var cart_qr = "DELETE FROM tbl_dealer_cart WHERE vendor_id = ?"
      if(order_id > 0){
        var cart_qr_res = await new Promise((res, rej) => {
          connect_pool.query(cart_qr,[body.vendor_id], 
          (cart_qr_err, cart_qr_results) => {
              if (cart_qr_err){ 
                connection.rollback(); return callBack(cart_qr_err)
                };
              res(cart_qr_results);
          });
        })
      }
      let qr9 = "UPDATE tbl_dealerapp_order_item SET bundle_status = ? WHERE bundle_id = ? AND order_item_id = ?";
      if(order_id > 0 && body.category_id == 3){
        for (var a = 0; a < bundleData.length; a += 1) {
          
          var qr9_res = await new Promise((res, rej) => {
          connect_pool.query(qr9,["SOLD",bundleData[a].bundle_id,bundleData[a].order_item_id], 
          (qr9_err, qr9_results) => {
              if (qr9_err){ 
                connection.rollback(); return callBack(qr9_err)
                };
              res(qr9_results);
          });
        })
      }
      var orderItemIds = (orderItemIdList);
      var qr10 = "SELECT order_id FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE order_item_id IN ? GROUP BY order_id";
        var qr10_res = await new Promise((res, rej) => {
          connect_pool.query(qr10, [[orderItemIds]],
            (result10_err, results_10) => {
              
                if (result10_err){
                  connection.rollback();
                  return callBack(result10_err);
                } 
                res(results_10);
          });
        });
        var qr11 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_status != ?";
        var qr12 = "UPDATE tbl_dealerapp_orders SET status = ? WHERE order_id = ?";
        for (var k = 0; k < qr10_res.length; k++) {
          var qr11_res = await new Promise((res, rej) => {
            connect_pool.query(qr11, [qr10_res[k].order_id,"SOLD"],
              (result11_err, results_11) => {
                
                  if (result11_err){
                    connection.rollback();
                    return callBack(result11_err);
                  } 
                  res(results_11);
            });
          });
          if(qr11_res.length < 1){
            var qr12_res = await new Promise((res, rej) => {
              connect_pool.query(qr12, ["SOLD",qr10_res[k].order_id],
                (result12_err, results_12) => {
                  
                    if (result12_err){
                      connection.rollback();
                      return callBack(result12_err);
                    } 
                    res(results_12);
              });
            });
          }
        }
    }
    
    connection.commit();
    connection.end();
    let res_obj = {
      "order_id" : order_id,
    }
    return callBack(null, res_obj)
  } catch (err) {
    connection.rollback();
    //connection.releaseConnection();
      callBack(err)
    }
  },
  create_ss_order: async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    if(body.tcs_value > 0){
        var tcs_percent = 0.1;
    } else{
        var tcs_percent = 0;
    }
    try {
      
      var qr2 = "SELECT max(CAST(SUBSTRING(order_no,-1) as UNSIGNED)) as max from tbl_dealerapp_orders";
      //await connect_pool.beginTransaction()
      var qr2_res = await new Promise((res, rej) => {
      connect_pool.query(qr2,(row2_err, row2) => {
          
              if (row2_err){
                connection.rollback(); return callBack(row2_err);
              }
              res(row2);
          });
      });
      
      if(qr2_res[0].max == 0 || qr2_res[0].max == null){
        var order_no = "SPST-1";
      }else{
       
        var index_no = qr2_res[0].max + 1
        var order_no = "SPST-" + index_no;
      }
      let qr3 = "INSERT INTO tbl_dealerapp_orders (order_no,vendor_id, category_id, order_to,discount,discount_percent,tcs_percent,tcs_amount, status,updated_by) VALUES (?,?,?,?,?,?,?,?,?,?)";
      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3,
          [order_no, body.vendor_id, 2, body.attached_vendor_id,body.order_discount,body.discount_percent,tcs_percent,body.tcs_value, "PENDING",body.vendor_id], 
          (result_err, results) => {
            
              if (result_err){
                connection.rollback(); return callBack(result_err);
              } 
              res(results);
          });
      });
      
      var bundle_ids = body.bundle_id;
      var order_id = qr3_res.insertId;
      var qr4 = "SELECT * FROM tbl_dealer_bundle WHERE bundle_id = ?";
      var qr5 = "INSERT into tbl_dealerapp_order_item (order_id,bundle_id, purchase_price, sale_price, bundle_status) VALUES (?,?,?,?,?)";
      
      for (var j = 0; j < bundle_ids.length; j += 1) {
        var bundle_id = bundle_ids[j];
        
        var qr4_res = await new Promise((res, rej) => {
        connect_pool.query(qr4, bundle_id, 
          (result1_err, results_1) => {
              if (result1_err){
                connection.rollback(); return callBack(result1_err);
              } 
              res(results_1);
          });
        });
        
        var purchase_price = qr4_res[0].amount;
        var sale_price = qr4_res[0].amount;
        var qr5_res = await new Promise((res, rej) => {
        connect_pool.query(qr5,
          [order_id, bundle_id, purchase_price, sale_price, "IN-ACTIVE"], 
          (result2_err, results_2) => {
              if (result2_err){ 
                connection.rollback(); return callBack(result2_err);
              }
              res(results_2);
          });
        });
        var order_item_id = qr5_res.insertId;
        let qr6 = "SELECT grnreport_id, price FROM tbl_dealer_bundle_item WHERE bundle_id = ?";
        var qr6_res = await new Promise((res, rej) => {
          connect_pool.query(qr6,bundle_id, 
          (result3_err, results3) => {
              if (result3_err){ 
                connection.rollback(); return callBack(result3_err)
                };
              res(results3);
          });
        })
        
        var qr7 = "INSERT into tbl_dealerapp_order_bundle_item (bundle_id,order_item_id, grnreport_id, purchase_price, sale_price) VALUES (?,?,?,?,?)";
      
        for (var i = 0; i < qr6_res.length; i += 1) {
          var grnreport_id = qr6_res[i].grnreport_id;
          var purchase_price = qr6_res[i].price;
            var qr7_res = await new Promise((res, rej) => {
            connect_pool.query(qr7,
              [bundle_id, order_item_id, grnreport_id, purchase_price, purchase_price], 
              (result4_err, results4) => {
                
                  if (result4_err){
                    connection.rollback(); return callBack(result4_err);
                  }
                  res(results4);
            });
          })
        };
      }
      connection.commit();
      connection.end();
      let res_obj = {
        "order_id" : order_id,
      }
      return callBack(null, res_obj)
    } catch (err) {
      connection.rollback();
      connection.releaseConnection();
        callBack(err)
      }
  },
  change_order_status:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        var vendor_id = body.vendor_id;
        var order_id = body.order_id;
        var change_status = body.status;
        var qr1 = "SELECT * FROM tbl_dealerapp_orders WHERE order_id = ? AND vendor_id = ?";
        var qr2 = "SELECT count(*) as available_count FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_status != ?";
        var qr3 = "UPDATE tbl_dealerapp_orders SET status = ? WHERE order_id = ? AND vendor_id = ?";
        var qr4 = "UPDATE tbl_dealerapp_order_item SET bundle_status = ? WHERE order_id = ? AND bundle_status != ?";
        
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [order_id,vendor_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
        });
      
        if(qr1_res[0].status == change_status){
            var res1_obj = {
              "status" : 0,
              "message" : "Your is already in "+ change_status
            }
            return callBack(null,res1_obj)
        }

        var qr2_res = await new Promise((res, rej) => {
          connect_pool.query(qr2, [order_id, "SOLD"],
            (result2_err, results_2) => {
                if (result2_err){
                  connection.rollback();
                  return callBack(result2_err);
                } 
                res(results_2);
          });
        });
        if(qr2_res[0].available_count == 0){
          var res2_obj = {
            "status" : 0,
            "message" : " All bundle are sold in " +  qr1_res[0].order_no
          }
          return callBack(null,res2_obj)
        }
        var qr3_res = await new Promise((res, rej) => {
          connect_pool.query(qr3, [change_status,order_id,vendor_id],
            (result3_err, results_3) => {
                if (result3_err){
                  connection.rollback();
                  return callBack(result3_err);
                } 
                res(results_3);
          });
        });
        if(change_status == "PENDING"){
            var bundle_stauts = "IN-ACTIVE";
        } else if(change_status == "APPROVED"){
          var bundle_stauts = "ACTIVE";
        }

        var qr4_res = await new Promise((res, rej) => {
          connect_pool.query(qr4, [bundle_stauts,order_id,"SOLD"],
            (result4_err, results_4) => {
                if (result4_err){
                  connection.rollback();
                  return callBack(result4_err);
                } 
                res(results_4);
          });
        });
        await connection.commit()
        await connection.end()
        let res3_obj = {
          "status" : 1,
          "message" :"Your have changed order status to " + change_status + " for " + qr1_res[0].order_no
        }
        return callBack(null, res3_obj)
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack(err);
      }
  },
  change_bundle_status:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        var bundle_id = body.bundle_id;
        var order_id = body.order_id;
        var change_status = body.status;
        var qr1 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_id = ?";
        var qr2 = "UPDATE tbl_dealerapp_order_item SET bundle_status = ? WHERE order_id = ? AND bundle_id = ?";
        var qr3 = "SELECT count(bundle_id) as available_bundles FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_status!=?";
        var qr4 = "UPDATE tbl_dealerapp_orders SET status = ? WHERE order_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [order_id,bundle_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
        });
      
        if(qr1_res[0].status == change_status){
            var res1_obj = {
              "status" : 0,
              "message" : "Your is already in "+ change_status
            }
            return callBack(null,res1_obj)
        }
        if(qr1_res[0].status == "SOLD"){
          var res2_obj = {
            "status" : 0,
            "message" : "This is the SOLD bundle"
          }
          return callBack(null,res2_obj)
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, [change_status, order_id, bundle_id],
          (result2_err, results_2) => {
              if (result2_err){
                connection.rollback();
                return callBack(result2_err);
              } 
              res(results_2);
        });
      });
      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3, [order_id,"SOLD"],
          (result3_err, results_3) => {
              if (result3_err){
                connection.rollback();
                return callBack(result2_err);
              } 
              res(results_3);
        });
      });
      if(qr3_res[0].available_bundles == 0){
        var qr4_res = await new Promise((res, rej) => {
          connect_pool.query(qr4, ["SOLD", order_id],
            (result4_err, results_4) => {
                if (result4_err){
                  connection.rollback();
                  return callBack(result4_err);
                } 
                res(results_4);
          });
      });
      }
      await connection.commit()
      await connection.end()
      let res3_obj = {
        "status" : 1,
        "message" :"Your have chanaged bundle status to " + change_status
      }
      return callBack(null, res3_obj)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(err);
    }
  },
  update_bundle_sale_price:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        var bundle_id = body.bundle_id;
        var order_id = body.order_id;
        var sale_price = body.sale_price;
        var qr1 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_id = ?";
        var qr2 = "UPDATE tbl_dealerapp_order_item SET sale_price = ? WHERE order_id = ? AND bundle_id = ?";
        
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [order_id,bundle_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
      });
      if(qr1_res[0].status == "SOLD"){
          var res2_obj = {
            "status" : 0,
            "message" : "This is the SOLD bundle"
          }
          return callBack(null,res2_obj)
      }
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, [sale_price, order_id, bundle_id],
          (result2_err, results_2) => {
              if (result2_err){
                connection.rollback();
                return callBack(result2_err);
              } 
              res(results_2);
        });
    });
    await connection.commit();
    await connection.end();
    let res3_obj = {
      "status" : 1,
      "message" :"Your have updated sale price successfully"
    }
    return callBack(null, res3_obj)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(err);
    }
  },
  update_bundle_item_sale_price:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        var bundle_id = body.bundle_id;
        var bundle_item_id = body.bundle_item_id;
        var sale_price = body.sale_price;
        var qr1 = "SELECT * FROM tbl_dealerapp_order_bundle_item WHERE bundle_item_id = ?";
        var qr2 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_item_id = ?";
        var qr3 = "UPDATE tbl_dealerapp_order_bundle_item SET sale_price = ? WHERE bundle_item_id = ? AND bundle_id = ?";
        var qr4 = "SELECT SUM(sale_price) as total_sale_price FROM tbl_dealerapp_order_bundle_item WHERE order_item_id = ?";
        var qr5 = "UPDATE tbl_dealerapp_order_item SET sale_price = ? WHERE order_item_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [bundle_item_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
      });
      var order_item_id =qr1_res[0].order_item_id;
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, [order_item_id],
          (result2_err, results_2) => {
            
              if (result2_err){
                connection.rollback();
                return callBack(result2_err);
              } 
              res(results_2);
        });
      });
      if(qr2_res[0].bundle_status == "SOLD"){
        let res1_obj = {
          "status" : 1,
          "message" : "This item is already SOLD"
        }
        return callBack(null, res1_obj)
      }

      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3, [sale_price, bundle_item_id, bundle_id],
          (result3_err, results_3) => {
              if (result3_err){
                connection.rollback();
                return callBack(result3_err);
              } 
              res(results_3);
        });
    });

    var qr4_res = await new Promise((res, rej) => {
      connect_pool.query(qr4, [order_item_id],
        (result4_err, results_4) => {
            if (result4_err){
              connection.rollback();
              return callBack(result4_err);
            } 
            res(results_4);
      });
    });
    var total_sale_price = qr4_res[0].total_sale_price;
    var qr4_res = await new Promise((res, rej) => {
      connect_pool.query(qr5, [total_sale_price,order_item_id],
        (result5_err, results_5) => {
            if (result5_err){
              connection.rollback();
              return callBack(result5_err);
            } 
            res(results_5);
      });
    });
    await connection.commit();
    await connection.end();
    let res2_obj = {
      "status" : 1,
      "message" :"Your have updated bundle item sale price successfully"
    }
    return callBack(null, res2_obj)
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(err);
    }
  },
  purchase_orders:  async (vendor_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT order_id, order_no,status,discount,order_to,tcs_amount, DATE(CREATED_DATE) AS created_date FROM tbl_dealerapp_orders WHERE vendor_id = ?";
        var qr2 = "SELECT count(bundle_id) as purchased_bundles, SUM(purchase_price) as total_purchase_price FROM tbl_dealerapp_order_item WHERE order_id = ?";
        var qr3 = "SELECT count(order_item_id) as available_bundles FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_status != ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [vendor_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status: 0, message:result1_err});
                } 
                res(results_1);
          });
        });
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No orders found"
          }
          return callBack(res1_obj)
        }
        var result_obj = [];
        for (var i = 0; i < qr1_res.length; i += 1) {
          var order_id =qr1_res[i].order_id;
          var created_date = qr1_res[i].created_date;
          var curr_date = created_date.getDate();
          var curr_month = created_date.getMonth();
          var curr_year = created_date.getFullYear();
          var order_placed_on = curr_date +'-'+ curr_month + '-' + curr_year;
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2, [order_id],
              (result2_err, results_2) => {
              
                if (result2_err){
                  connection.rollback();
                  return callBack({status: 0, message:result2_err});
                } 
                res(results_2);
            });
          });
          var qr3_res = await new Promise((res, rej) => {
            connect_pool.query(qr3, [order_id,"SOLD"],
              (result3_err, results_3) => {
              
                if (result3_err){
                  connection.rollback();
                  return callBack({status: 0, message:result3_err});
                } 
                res(results_3);
            });
          });
          obj = {
            
            "order_id" : qr1_res[i].order_id,
            "order_no" : qr1_res[i].order_no, 
            "order_to" : qr1_res[i].order_to, 
            "bundles_quantity" : qr2_res[0].purchased_bundles,
            "available_bundles" : qr3_res[0].available_bundles, 
            "purchase_price" : parseFloat(qr2_res[0].total_purchase_price - qr1_res[i].discount),
            "tcs_amount" : qr1_res[i].tcs_amount,
            "discount" : qr1_res[i].discount,
            "order_status" : qr1_res[i].status, 
            "order_placed_on" : order_placed_on
          }
          result_obj.push(obj)
        };
        
        await connection.commit();
        await connection.end();
      
        return callBack(null, result_obj)
      }
      catch (err) {
        await connection.rollback()
        //connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  purchase_order_info:  async (order_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_id = ?";
        var qr2 = "SELECT bundle_no FROM tbl_dealer_bundle WHERE bundle_id = ?";
        var qr3 = "SELECT status FROM tbl_dealerapp_orders WHERE order_id = ?";
        
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [order_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status : 0, message:result1_err});
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No order items found"
          }
          return callBack(res1_obj)
        }
        var result_obj = [];
        for (var i = 0; i < qr1_res.length; i += 1) {
          
          var last_updated = qr1_res[i].last_updated;
          var curr_date = last_updated.getDate();
          var curr_month = last_updated.getMonth();
          var curr_year = last_updated.getFullYear();
          var last_updated = curr_date +'-'+ curr_month + '-' + curr_year;
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2, [qr1_res[i].bundle_id],
              (result2_err, results_2) => {
              
                if (result2_err){
                  connection.rollback();
                  return callBack({status : 0, message:result2_err});
                } 
                res(results_2);
            });
          });
          var qr3_res = await new Promise((res, rej) => {
            connect_pool.query(qr3, [qr1_res[i].order_id],
              (result3_err, results_3) => {
              
                if (result3_err){
                  connection.rollback();
                  return callBack({status : 0, message:result3_err});
                } 
                res(results_3);
            });
          });
          obj = {
            
            "order_item_id" : qr1_res[i].order_item_id,
            "order_id" : qr1_res[i].order_id,
            "bundle_id" : qr1_res[i].bundle_id,
            "purchase_price" : qr1_res[i].purchase_price,
            "sale_price" : qr1_res[i].sale_price,
            "bundle_no" : qr2_res[0].bundle_no, 
            "order_status" : qr3_res[0].status,
            "bundle_status" : qr1_res[i].bundle_status,
            "last_updated" : last_updated
          }
          result_obj.push(obj)
        };
        
        await connection.commit();
        await connection.end();
      
        return callBack(null, result_obj)
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  purchase_bundle_info:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * FROM SS_ORDER_BUNDLE_LIST_VIEW WHERE bundle_id = ? AND order_item_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [body.bundle_id, body.order_item_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status : 0, message:result1_err});
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No Bundle items found"
          }
          return callBack(res1_obj)
        }
        await connection.commit();
        await connection.end();
      
        return callBack(null, qr1_res)
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  create_invoice:  async (body, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {

        var qr1 = "SELECT max(CAST(SUBSTRING(order_no,-1) as UNSIGNED)) as max from tbl_dealerapp_order_invoice";
        var qr2 = "INSERT INTO tbl_dealerapp_order_invoice(invoice_no, vendor_id, order_id) VALUES (?,?,?)";
        await connect_pool.beginTransaction()
        var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,(row1_err, row1) => {
            
                if (row1_err){
                  connection.rollback(); return callBack({status:0, message:row1_err});
                }
                res(row1);
            });
        });
        
        if(qr1_res[0].max == 0 || qr1_res[0].max == null){
          var invoice_no = "INVC-1";
        }else{
        
          var index_no = qr1_res[0].max + 1
          var invoice_no = "INVC-" + index_no;
        }
        var qr2_res = await new Promise((res, rej) => {
          connect_pool.query(qr2, [invoice_no, body.vendor_id, body.order_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status:0, message:result1_err});
                } 
                res(results_1);
          });
        });
        if(qr2_res.insertId == null || qr2_res.insertId == ''){

          let res1_obj = {
            "status" : 0,
            "message" : "Invoice not created"
          }
          return callBack(res1_obj)
        }
        let res1_obj = {
          "status" : 1,
          "message" : "Your have created invoice successfully"
        }
        await connection.commit();
        await connection.end();
      
        return callBack(null, res1_obj)
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  invoice_list:  async (vendor_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * FROM DEALER_ORDER_INVOICE_LIST_VIEW WHERE vendor_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [vendor_id],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack(result1_err);
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No Invoice found"
          }
          return callBack(null, res1_obj)
        }
        await connection.commit();
        await connection.end();
      
        return callBack(null, qr1_res)
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack(err);
      }
  },
  sold_orders:  async (order_to, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT order_id,vendor_id, order_no,status, DATE(CREATED_DATE) AS created_date FROM tbl_dealerapp_orders WHERE order_to = ?";
        var qr2 = "SELECT count(bundle_id) as sold_bundles, SUM(sale_price) as total_sale_price FROM tbl_dealerapp_order_item WHERE order_id = ?";
        var qr3 = "SELECT name, company,vendor_code,mobile FROM tbl_vendor WHERE vendor_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, [order_to],
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status: 0, message:result1_err});
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No orders found"
          }
          return callBack({status: 0, message:res1_obj})
        }
        var result_obj = [];
        for (var i = 0; i < qr1_res.length; i += 1) {
          var order_id =qr1_res[i].order_id;
          var vendor_id =qr1_res[i].vendor_id;
          var created_date = qr1_res[i].created_date;
          var curr_date = created_date.getDate();
          var curr_month = created_date.getMonth();
          var curr_year = created_date.getFullYear();
          var order_placed_on = curr_date +'-'+ curr_month + '-' + curr_year;
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2, [order_id],
              (result2_err, results_2) => {
              
                if (result2_err){
                  connection.rollback();
                  return callBack({status: 0, message:result2_err});
                } 
                res(results_2);
            });
          });
          var qr3_res = await new Promise((res, rej) => {
            connect_pool.query(qr3, [vendor_id],
              (result3_err, results_3) => {
              
                if (result3_err){
                  connection.rollback();
                  return callBack({status: 0, message:result3_err});
                } 
                res(results_3);
            });
          });
          obj = {
            
            "order_id" : qr1_res[i].order_id,
            "order_no" : qr1_res[i].order_no, 
            "bundles_quantity" : qr2_res[0].sold_bundles, 
            "sale_price" : qr2_res[0].total_sale_price, 
            "order_status" : qr1_res[i].status, 
            "order_placed_on" : order_placed_on,
            "vendor_name" : qr3_res[0].name,
            "company" : qr3_res[0].company,
            "vendor_code" : qr3_res[0].vendor_code,
            "mobile" : qr3_res[0].mobile
          }
          result_obj.push(obj)
        };
        await connection.commit();
        await connection.end();
      
        return callBack(null, {status: 1, results:result_obj})
      }
      catch (err) {
        await connection.rollback()
        //connection.releaseConnection()
        
        return callBack({status: 1, message:err});
      }
  },
  dispatch_address:  async (order_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * FROM SS_ORDER_DISPATCH_ADDRESS_LIST_VIEW WHERE salesorder_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, order_id,
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status : 0, message:result1_err});
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No Results found"
          }
          return callBack(res1_obj)
        }
        await connection.commit();
        await connection.end();
      
        return callBack(null, qr1_res[0])
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  order_payment_info:  async (order_id, callBack) => {
    
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    
      try {
        
        var qr1 = "SELECT * FROM tbl_dealerapp_order_payment WHERE order_id = ?";
        var qr1_res = await new Promise((res, rej) => {
          connect_pool.query(qr1, order_id,
            (result1_err, results_1) => {
              
                if (result1_err){
                  connection.rollback();
                  return callBack({status : 0, message:result1_err});
                } 
                res(results_1);
          });
      } );
        if(qr1_res.length == 0){

          let res1_obj = {
            "status" : 0,
            "message" : "No Results found"
          }
          return callBack(res1_obj)
        }
        await connection.commit();
        await connection.end();
      
        return callBack(null, qr1_res[0])
      }
      catch (err) {
        await connection.rollback()
        connection.releaseConnection()
        return callBack({status : 0, message : err});
      }
  },
  add_payment: async (body, callBack) => {

    var qr = "SELECT category_id FROM tbl_vendor WHERE vendor_id = ?"
    var qr1 = "INSERT INTO tbl_dealerapp_order_payment (payment_reference_no, payment_type, vendor_id, payment_to, order_id, amount, remarks, updated_by,status) VALUES (?,?,?,?,?,?,?,?,?)";
    var qr2 = "UPDATE tbl_dealerapp_voucher_code SET valid = ? WHERE voucher_to = ? AND voucher_no = ?";
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr_res = await new Promise((res, rej) => {
        connect_pool.query(qr,
          [body.vendor_id], 
          (qr_err, qr_res) => {
            
              if (qr_err){
                connection.rollback(); return callBack(qr_err);
              } 
              res(qr_res);
          });
      });
      if(qr_res[0].category_id == 2 || qr_res[0].category_id == 3){
        var status = "APPROVED";
      } else {
        var status = "PENDING";
      }
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1,
          [body.payment_reference_no, body.payment_type,body.vendor_id, body.payment_to, body.order_id, body.amount, body.remarks,body.updated_by, status], 
          (result_err, results) => {
            
              if (result_err){
                connection.rollback(); return callBack(result_err);
              } 
              res(results);
          });
      });
      var payment_id = qr1_res.insertId;
      if(Number.isInteger(payment_id)){
        if(body.payment_type == "VOUCHER"){
          var qr2_res = await new Promise((res, rej) => {
            connect_pool.query(qr2,
              ["N", body.vendor_id,  body.payment_reference_no], 
              (result1_err, results_1) => {
                
                  if (result1_err){
                    connection.rollback(); return callBack(result1_err);
                  } 
                  res(results_1);
              });
          });
        }
      }
      connection.commit();
      connection.end();
      let res_obj = {
        "payment_id" : payment_id,
      }
      return callBack(null, res_obj)
    } catch (err) {
      connection.rollback();
      //connection.releaseConnection();
        callBack(err)
      }
  },
  update_payment_status:  async (body, callBack) => {
    
    var payment_id = body.payment_id;
    var order_id = body.order_id;
    var status = body.status;

    var qr1 = "SELECT payment_to FROM tbl_dealerapp_order_payment WHERE payment_id = ?";
    var qr2 = "UPDATE tbl_dealerapp_order_payment SET status = ?, updated_by = ? WHERE payment_id = ?";
    var qr3 = "UPDATE tbl_dealerapp_orders SET status = ?, updated_by = ? WHERE order_id = ?";
    var qr4 = "SELECT bundle_id,order_to FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE order_id = ?";
    var qr5 = "SELECT order_item_id FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE vendor_id = ? AND bundle_id IN ?";
    var qr6 = "UPDATE tbl_dealerapp_order_item SET bundle_status = ? WHERE order_item_id IN ? ";
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, [payment_id],
          (result1_err, results_1) => {
            
              if (result1_err){
                connection.rollback();
                return callBack(result1_err);
              } 
              res(results_1);
        });
      });
      var updated_by = qr1_res[0].payment_to;
      var qr2_res = await new Promise((res, rej) => {
        connect_pool.query(qr2, [status, updated_by, payment_id],
          (result2_err, results_2) => {
            
              if (result2_err){
                connection.rollback();
                return callBack(result2_err);
              } 
              res(results_2);
        });
      });
      var qr3_res = await new Promise((res, rej) => {
        connect_pool.query(qr3, [status, updated_by, order_id],
          (result3_err, results_3) => {
            
              if (result3_err){
                connection.rollback();
                return callBack(result3_err);
              } 
              res(results_3);
        });
      });
      if(status == "APPROVED"){
        var qr4_res = await new Promise((res, rej) => {
          connect_pool.query(qr4, [order_id],
            (result4_err, results_4) => {
              
                if (result4_err){
                  connection.rollback();
                  return callBack(result4_err);
                } 
                res(results_4);
          });
        });
        var order_to = qr4_res[0].order_to;
        var bundleid_list = [];
        for (var i = 0; i < qr4_res.length; i++) {
          var bundle_id = qr4_res[i].bundle_id;
          bundleid_list.push(bundle_id);
        }
        var bundle_ids = (bundleid_list);
       
        var qr5_res = await new Promise((res, rej) => {
          connect_pool.query(qr5, [order_to,[bundle_ids]],
            (result5_err, results_5) => {
              
                if (result5_err){
                  connection.rollback();
                  return callBack(result5_err);
                } 
                res(results_5);
          });
        });
        var orderItemIdList = [];
        for (var j = 0; j < qr5_res.length; j++) {
          var order_item_id = qr5_res[j].order_item_id;
          orderItemIdList.push(order_item_id);
        }
        var orderItemIds = (orderItemIdList);
        var qr6_res = await new Promise((res, rej) => {
          connect_pool.query(qr6, ["SOLD", [orderItemIds]],
            (result6_err, results_6) => {
              
                if (result6_err){
                  connection.rollback();
                  return callBack(result6_err);
                } 
                res(results_6);
          });
        });
        var qr7 = "SELECT order_id FROM DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE order_item_id IN ? GROUP BY order_id";
        var qr7_res = await new Promise((res, rej) => {
          connect_pool.query(qr7, [[orderItemIds]],
            (result7_err, results_7) => {
              
                if (result7_err){
                  connection.rollback();
                  return callBack(result7_err);
                } 
                res(results_7);
          });
        });
        var qr8 = "SELECT * FROM tbl_dealerapp_order_item WHERE order_id = ? AND bundle_status != ?";
        var qr9 = "UPDATE tbl_dealerapp_orders SET status = ? WHERE order_id = ?";
        for (var k = 0; k < qr7_res.length; k++) {
          var qr8_res = await new Promise((res, rej) => {
            connect_pool.query(qr8, [qr7_res[k].order_id,"SOLD"],
              (result8_err, results_8) => {
                
                  if (result8_err){
                    connection.rollback();
                    return callBack(result8_err);
                  } 
                  res(results_8);
            });
          });
          if(qr8_res.length < 1){
            var qr9_res = await new Promise((res, rej) => {
              connect_pool.query(qr9, ["SOLD",qr7_res[k].order_id],
                (result9_err, results_9) => {
                  
                    if (result9_err){
                      connection.rollback();
                      return callBack(result9_err);
                    } 
                    res(results_9);
              });
            });
          }
        }

      }
      await connection.commit();
      await connection.end();
      
      return callBack(null, "Your have approved the payment")
    }
    catch (err) {
      await connection.rollback()
      //connection.releaseConnection()
      return callBack(err);
    }
  },
  update_payment_to_order:  async (body, callBack) => {
    
    var qr1 = "UPDATE tbl_dealerapp_order_payment SET order_id = ? WHERE payment_id = ?";
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, [body.order_id,body.payment_id],
          (result1_err, results_1) => {
            
              if (result1_err){
                connection.rollback();
                return callBack(result1_err);
              } 
              res(results_1);
        });
      });
      
      await connection.commit();
      await connection.end();
      
      return callBack(null, "Order Id is updated successfully")
    }
    catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(err);
    }
  },
  purchase_bundles_list: async (vendor_id, callBack) => {
    const connection = await mysql.createConnection(db_conn);
    await connection.beginTransaction();
    try {
      let qr1 = "select * from SS_PURCHASE_BUNDLE_LIST_VIEW where vendor_id = ? ";
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr1, [vendor_id], (row1_err, row1) => {
              if (row1_err) return callBack({status:0, message: row1_err});
              res(row1);
          });
      });
      if(qr1_res.length < 1){
        return callBack({status:0, message: "No results found"})
      }

      var result_obj = [];
      for (var i = 0; i < qr1_res.length; i += 1) {
        
        obj = {
          
          "bundle_id" : qr1_res[i].bundle_id,
          "bundle_no" : qr1_res[i].bundle_no, 
          "quantity" : qr1_res[i].quantity,
          "purchase_price" : qr1_res[i].purchase_price, 
          "category" : qr1_res[i].category, 
          "order_id" : qr1_res[i].order_id, 
          "order_no" : qr1_res[i].order_no, 
          "order_item_id" : qr1_res[i].order_item_id,
          "bundle_status" : qr1_res[i].bundle_status
        }
        result_obj.push(obj)
      };
      await connection.commit();
      await connection.end();
      return callBack(null, result_obj)
    } catch (err) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack({status:0, message: err});
    }
  }
  

};
