const {
  createSalesOrder,
  cancelSalesOrder,
  bundleAvailability,
  getOrderStatus,
  getInvoice,
  getInvoiceItems,
  paymentTypes,
  paymentAccounts,
  getOrderInfo,
  getTotalOrders,
  orderTracking,
  placeOrder,
  spstSalesOrder,
  changeOrderStatus,
  changeBundleStatus,
  updateBundleSalePrice,
  updateBundleItemSalePrice,
  purchaseOrders,
  purchaseOrderInfo,
  purchaseBundleInfo,
  createInvoice,
  invoiceList,
  soldOrders,
  dispatchAddress,
  orderPaymentInfo,
  addPayment,
  updatePaymentStatus,
  updatePaymentToOrder,
  purchaseBundlesList
  
} = require("./order-controller");

const router = require("express").Router();
router.post("/createOrder", createSalesOrder);
router.post("/cancelOrder", cancelSalesOrder);
router.post("/bundleAvailability", bundleAvailability);
router.post("/getInvoice", getInvoice);
router.post("/getInvoiceItems", getInvoiceItems);
router.get("/getOrderStatus/:order_id", getOrderStatus);
router.get("/paymentTypes", paymentTypes);
router.get("/paymentAccounts", paymentAccounts);
router.get("/getOrderInfo/:order_id", getOrderInfo);
router.get("/getTotalOrders/:vendor_id", getTotalOrders);
router.get("/orderTracking/:order_id", orderTracking);
router.post("/placeOrder", placeOrder);
router.post("/spstSalesOrder", spstSalesOrder);
router.post("/changeOrderStatus", changeOrderStatus);
router.post("/changeBundleStatus", changeBundleStatus);
router.post("/updateBundleSalePrice", updateBundleSalePrice);
router.post("/updateBundleItemSalePrice", updateBundleItemSalePrice);
router.get("/purchaseOrders/:vendor_id", purchaseOrders);
router.get("/purchaseOrderInfo/:order_id", purchaseOrderInfo);
router.post("/purchaseBundleInfo", purchaseBundleInfo);
router.post("/createInvoice", createInvoice);
router.get("/invoiceList/:vendor_id", invoiceList);
router.get("/soldOrders/:order_to", soldOrders);
router.get("/dispatchAddress/:order_id", dispatchAddress);
router.get("/orderPaymentInfo/:order_id", orderPaymentInfo);
router.post("/addPayment", addPayment);
router.post("/updatePaymentStatus", updatePaymentStatus);
router.post("/updatePaymentToOrder", updatePaymentToOrder);
router.get("/purchaseBundlesList/:vendor_id", purchaseBundlesList);

module.exports = router;
