const {
  create_sales_order,
  cancel_sales_order,
  get_order_status,
  bundle_availability,
  get_invoice,
  add_log,
  get_invoice_items,
  payment_type,
  payment_accounts,
  get_order_info,
  get_total_orders,
  get_tracking,
  place_order,
  create_ss_order,
  change_order_status,
  change_bundle_status,
  update_bundle_sale_price,
  update_bundle_item_sale_price,
  purchase_orders,
  purchase_order_info,
  purchase_bundle_info,
  create_invoice,
  invoice_list,
  sold_orders,
  dispatch_address,
  order_payment_info,
  add_payment,
  update_payment_status,
  update_payment_to_order,
  purchase_bundles_list

} = require("./order-service");

module.exports = {
  createSalesOrder: (req, res) => {
    const body = req.body;
    var bundleData = body.bundle_data;
    var opebBoxData = body.open_box_data;
    var prexoData = body.prexo_data;
    var vendor_id = body.vendor_id;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if (vendor_id == "" || vendor_id == undefined) {
      return res.status(201).json({
        status: 0,
        message: "Please provide vendor ",
      });
    }

    if (bundleData.length == 0 && opebBoxData.length == 0 && prexoData.length == 0) {
      return res.status(201).json({
        status: 0,
        message: "Your cart is empty ... !!",
      });
    }

    try {
      create_sales_order(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }

        }

        return res.status(200).json({
          status: 1,
          message: "Your order Placed sucessfully",
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  bundleAvailability: (req, res) => {
    const body = req.body;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    try {
      bundle_availability(body, (err, results) => {

        if (err) {
            
          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else if (err == 2) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }
        return res.status(200).json({
          status: 1,
          message: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  getOrderStatus: (req, res) => {
    var order_id = req.params.order_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }

    try {
      get_order_status(order_id, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(404).json({
              status: 0,
              msg: "No results found",
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        return res.status(200).json({
          status: 1,
          order_status: results[0].status,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  paymentTypes: (req, res) => {

    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.body, response)
      oldSend.apply(res, arguments);
    }
    
    try {
      payment_type(null, (err, results) => {

        if (err) {

          if (err == 1) {
            res.status(404).json({
              status: 0,
              message: "Results not found",
            });
          } else {
            return err;
          }
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  paymentAccounts: (req, res) => {

    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.body, response)
      oldSend.apply(res, arguments);
    }

    try {
      payment_accounts(null, (err, results) => {

        if (err) {

          if (err == 1) {
            res.status(404).json({
              status: 0,
              message: "Results not found",
            });
          } else {
            return err;
          }
        }

        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  getOrderInfo: (req, res) => {
    var order_id = req.params.order_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }

    if (order_id == "" || order_id == undefined ||order_id == 0 || order_id == "NaN") {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid vendor id",
      });
    }

    try {
      get_order_info(order_id, (err, result) => {

        if (err) {
          if (err == 1) {
            return res.status(404).json({
              status: 0,
              msg: result,
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }

        return res.status(200).json({
          status: 1,
          data: result,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  getTotalOrders: (req, res) => {
    var vendor_id = req.params.vendor_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }
    
    try {
      get_total_orders(vendor_id, (err, order_items) => {

        if (err) {

          if (err == 1) {
            return res.status(404).json({
              status: 0,
              msg: "Need Vendor id ",
            });
          } else if (err == 2) {
            return res.status(404).json({
              status: 0,
              msg: "No results found",
            });
          }

          return res.status(500).json({
            status: 0,
            err: err,
          });
        }
        return res.status(200).json({
          status: 1,
          total_orders: order_items.length,
          order_items: order_items,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  getInvoice: (req, res) => {
    const body = req.body;
    var order_id = body.order_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if (order_id == "" || order_id == undefined || order_id == "NaN" || order_id == 0) {
      return res.status(200).json({
        status: 0,
        message: "Order id required",
      });
    }

    try {
      get_invoice(order_id, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  getInvoiceItems: (req, res) => {
    const body = req.body;
    var order_id = body.order_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if ( order_id == "" || order_id == undefined || order_id == "NaN" || order_id == 0) {
      return res.status(200).json({
        status: 0,
        message: "Order id required",
      });
    }

    try {
      get_invoice_items(order_id, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  updateCartItem: (req, res) => {
    const body = req.body;

    var oldSend = res.send;
    
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    try {
      update_cart_item(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: "Both vendor id and SKU required",
            });
          } else if (err == 2) {
            return res.status(404).json({
              status: 0,
              message: "Results not found",
            });
          } else if (err == 3) {
            return res.status(201).json({
              status: 0,
              message: "Item is not deleted",
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        if (results == true) {
          return res.status(200).json({
            status: 1,
            message: "You cart item is deleted",
          });
        }

        return res.status(200).json({
          status: 1,
          message: "Updated cart successfully",
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  cancelSalesOrder: (req, res) => {
    const body = req.body;
    var id_list = body.order_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    if (id_list.length <= 0 || body.order_id == undefined) {
      return res.status(201).json({
        status: 0,
        message: "Please send order id",
      });
    }

    try {
      cancel_sales_order(body, (err, results) => {

        if (err) {
            
          if (err == 1) {
            return res.status(201).json({
              status: 0,
              message: results,
            });
          } else {
            return res.status(500).json({
              status: 0,
              message: err,
            });
          }
        }

        return res.status(200).json({
          status: 1,
          message: "Sales order cancelled...",
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }

  },
  deleteCartItem: (req, res, cb) => {
    var cart_id = req.params.cart_id;
    var oldSend = res.send;
    
    res.send = function(response){
      add_log(req.params, response)
      oldSend.apply(res, arguments);
    }

    deleteCartItem(cart_id, (err, results) => {

      if (err) {
          
        if (err == 1) {
          res.status(201).json({
            status: 0,
            message: "Please Provide cart id",
          });

          cb(null, res);

        } else if (err == 2) {
          res.status(201).json({
            status: 0,
            message: "Record not found",
          });

          cb(null, res);

        } else {
          return;
        }
      }
      return res.json({
        status: 1,
        message: "Cart item deleted successfully",
      });
    });
  },
  orderTracking: (req, res) => {
  
  var order_id = req.params.order_id;
  var oldSend = res.send;
  
  res.send = function(response){
    add_log(req.params, response)
    oldSend.apply(res, arguments);
  }
  try {
    get_tracking(order_id, (err, tracking_data) => {

      return res.status(200).json({
        tracking_data
      });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
placeOrder: (req, res) => {
  const body = req.body;
  const bundleData = body.bundle_id;
  var oldSend = res.send;
  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.vendor_id == "" || body.vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor ",
    });
  }

  if (bundleData.length == 0) {
    return res.status(201).json({
      status: 0,
      message: "Your cart is empty ... !!",
    });
  }

  try {
    place_order(body, (err, results) => {

      if (err) {

        if (err == 1) {
          return res.status(201).json({
            status: 0,
            message: results,
          });
        } else {
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }

      }

      return res.status(200).json({
        status: 1,
        message: "Your order Placed sucessfully",
        data: results,
      });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }

},
spstSalesOrder: (req, res) => {
  const body = req.body;
  var bundleData = body.bundle_id;
  
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.vendor_id == "" || body.vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor ",
    });
  }

  if (bundleData.length == 0) {
    return res.status(201).json({
      status: 0,
      message: "Your cart is empty ... !!",
    });
  }

  try {
    create_ss_order(body, (err, results) => {

      if (err) {
        
        if (err == 1) {
          return res.status(201).json({
            status: 0,
            message: results,
          });
        } else {
          return res.status(500).json({
            status: 0,
            message: err,
          });
        }

      }
      return res.status(200).json({
        status: 1,
        message: "Your order Placed sucessfully",
        data: results,
      });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
changeOrderStatus: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.vendor_id == "" || body.vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor ",
    });
  }

  if (body.order_id == "" || body.order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order ",
    });
  }
  
  try {
    change_order_status(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({ results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
changeBundleStatus: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.order_id == "" || body.order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order ",
    });
  }

  if (body.bundle_id == "" || body.bundle_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide bundle ",
    });
  }
  
  try {
    change_bundle_status(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({ results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
updateBundleSalePrice: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.order_id == "" || body.order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order ",
    });
  }

  if (body.bundle_id == "" || body.bundle_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide bundle ",
    });
  }
  
  try {
    update_bundle_sale_price(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({ results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
updateBundleItemSalePrice: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.bundle_item_id == "" || body.bundle_item_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide bundle item ",
    });
  }

  if (body.bundle_id == "" || body.bundle_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide bundle ",
    });
  }
  
  try {
    update_bundle_item_sale_price(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json({
            status: 0,
            message: err,
          });
      }
      return res.status(200).json({ results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
purchaseOrders: (req, res) => {
  const vendor_id = req.params.vendor_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(vendor_id, response)
    oldSend.apply(res, arguments);
  }

  if (vendor_id == "" || vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide Vendor ",
    });
  }
  try {
    purchase_orders(vendor_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
purchaseOrderInfo: (req, res) => {
  const order_id = req.params.order_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(order_id, response)
    oldSend.apply(res, arguments);
  }

  if (order_id == "" || order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order ",
    });
  }
  try {
    purchase_order_info(order_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
purchaseBundleInfo: (req, res) => {
  const body = req.body;
  var bundle_id = body.bundle_id;
  var order_item_id = body.order_item_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (bundle_id == "" || bundle_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please select bundle ",
    });
  }
  if (order_item_id == "" || order_item_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please Provide Order Item ",
    });
  }
  try {
    purchase_bundle_info(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
createInvoice: (req, res) => {
  const body = req.body;
  var order_id = body.order_id;
  var vendor_id = body.vendor_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (order_id == "" || order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order ",
    });
  }
  if (vendor_id == "" || vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor ",
    });
  }
  try {
    create_invoice(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
invoiceList: (req, res) => {
  const vendor_id = req.params.vendor_id;
  var order_id = body.order_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(vendor_id, response)
    oldSend.apply(res, arguments);
  }
  if (vendor_id == "" || vendor_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor ",
    });
  }
  try {
    invoice_list(vendor_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
soldOrders: (req, res) => {
  const order_to = req.params.order_to;
  var oldSend = res.send;

  res.send = function(response){
    add_log(order_to, response)
    oldSend.apply(res, arguments);
  }

  if (order_to == "" || order_to == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please provide Vendor ",
    });
  }
  try {
    sold_orders(order_to, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json(results);
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
dispatchAddress: (req, res) => {
  const order_id = req.params.order_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(order_id, response)
    oldSend.apply(res, arguments);
  }
  if (order_id == "" || order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please select order ",
    });
  }
  try {
    dispatch_address(order_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
orderPaymentInfo: (req, res) => {
  const order_id = req.params.order_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(order_id, response)
    oldSend.apply(res, arguments);
  }
  if (order_id == "" || order_id == undefined) {
    return res.status(201).json({
      status: 0,
      message: "Please select order ",
    });
  }
  try {
    order_payment_info(order_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
addPayment: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.length < 1) {
    return res.status(201).json({
      status: 0,
      message: "Please provide payment details ",
    });
  }
  try {
    add_payment(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
updatePaymentStatus: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.length < 1) {
    return res.status(201).json({
      status: 0,
      message: "Please provide payment details ",
    });
  }
  try {
    update_payment_status(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,message:results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
updatePaymentToOrder: (req, res) => {
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    add_log(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.length < 1) {
    return res.status(201).json({
      status: 0,
      message: "Please provide order details ",
    });
  }
  try {
    update_payment_to_order(body, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,message:results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
},
purchaseBundlesList: (req, res) => {
  const vendor_id = req.params.vendor_id;
  var oldSend = res.send;

  res.send = function(response){
    add_log(vendor_id, response)
    oldSend.apply(res, arguments);
  }

  if (vendor_id == "" || vendor_id == null) {
    return res.status(201).json({
      status: 0,
      message: "Please provide vendor details ",
    });
  }
  try {
    purchase_bundles_list(vendor_id, (err, results) => {
      
      if (err) {
        
          return res.status(500).json(err);
      }
      return res.status(200).json({ "status": 1,data:results });
    });
  } catch (error) {
    return res.status(500).json({
      status: 0,
      err: error,
    });
  }
}

};
