import { extendError } from "./extend-error";
import { normalizeArgs, normalizeOptions } from "./normalize";
import { toJSON as errorToJSON } from "./to-json";
const constructor = Ono;
export { constructor as Ono };
/**
 * Returns an object containing all properties of the given Error object,
 * which can be used with `JSON.stringify()`.
 */
Ono.toJSON = function toJSON(error) {
    return errorToJSON.call(error);
};
/**
 * Creates an `Ono` instance for a specifc error type.
 */
// tslint:disable-next-line: variable-name
function Ono(ErrorConstructor, options) {
    options = normalizeOptions(options);
    function ono(...args) {
        let { originalError, props, message } = normalizeArgs(args, options);
        // Create a new error of the specified type
        let newError = new ErrorConstructor(message);
        // Extend the error with the properties of the original error and the `props` object
        extendError(newError, originalError, props);
        return newError;
    }
    ono[Symbol.species] = ErrorConstructor;
    return ono;
}
//# sourceMappingURL=constructor.js.map