"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const extend_error_1 = require("./extend-error");
const normalize_1 = require("./normalize");
const to_json_1 = require("./to-json");
const constructor = Ono;
exports.Ono = constructor;
/**
 * Returns an object containing all properties of the given Error object,
 * which can be used with `JSON.stringify()`.
 */
Ono.toJSON = function toJSON(error) {
    return to_json_1.toJSON.call(error);
};
/**
 * Creates an `Ono` instance for a specifc error type.
 */
// tslint:disable-next-line: variable-name
function Ono(ErrorConstructor, options) {
    options = normalize_1.normalizeOptions(options);
    function ono(...args) {
        let { originalError, props, message } = normalize_1.normalizeArgs(args, options);
        // Create a new error of the specified type
        let newError = new ErrorConstructor(message);
        // Extend the error with the properties of the original error and the `props` object
        extend_error_1.extendError(newError, originalError, props);
        return newError;
    }
    ono[Symbol.species] = ErrorConstructor;
    return ono;
}
//# sourceMappingURL=constructor.js.map