"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _standardAsCallback = _interopRequireDefault(require("standard-as-callback"));

var commands = _interopRequireWildcard(require("./commands"));

var _command = require("./command");

var _promiseContainer = _interopRequireDefault(require("./promise-container"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Pipeline = /*#__PURE__*/function () {
  function Pipeline(redis) {
    var _this = this;

    _classCallCheck(this, Pipeline);

    this.batch = [];
    this.redis = redis;
    this._transactions = 0;
    Object.keys(commands).forEach(function (command) {
      _this[command] = _this._createCommand(command);
    });
  }

  _createClass(Pipeline, [{
    key: "_createCommand",
    value: function _createCommand(commandName) {
      var _this2 = this;

      return function () {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        var lastArgIndex = args.length - 1;
        var callback = args[lastArgIndex];

        if (typeof callback !== 'function') {
          callback = undefined;
        } else {
          // eslint-disable-next-line no-param-reassign
          args.length = lastArgIndex;
        }

        var commandEmulator = commands[commandName].bind(_this2.redis);
        var commandArgs = (0, _command.processArguments)(args, commandName, _this2.redis);

        _this2._addTransaction(commandEmulator, commandName, commandArgs, callback);

        return _this2;
      };
    }
  }, {
    key: "_addTransaction",
    value: function _addTransaction(commandEmulator, commandName, commandArgs, callback) {
      var _this3 = this;

      var Promise = _promiseContainer.default.get();

      this.batch.push(function () {
        return (0, _standardAsCallback.default)(new Promise(function (resolve) {
          return resolve(_command.safelyExecuteCommand.apply(void 0, [commandEmulator, commandName, _this3.redis].concat(_toConsumableArray(commandArgs))));
        }), callback);
      });
      this._transactions += 1;
    }
  }, {
    key: "exec",
    value: function exec(callback) {
      // eslint-disable-next-line prefer-destructuring
      var batch = this.batch;

      var Promise = _promiseContainer.default.get();

      this.batch = [];
      return (0, _standardAsCallback.default)(Promise.all(batch.map(function (cmd) {
        return cmd();
      })).then(function (replies) {
        return replies.map(function (reply) {
          return [null, reply];
        });
      }), callback);
    }
  }]);

  return Pipeline;
}();

var _default = Pipeline;
exports.default = _default;