"use strict";

var _events = require("events");

var _ioredis = require("ioredis");

var commands = _interopRequireWildcard(require("./commands"));

var commandsStream = _interopRequireWildcard(require("./commands-stream"));

var _command = _interopRequireDefault(require("./command"));

var _data = _interopRequireDefault(require("./data"));

var _expires = _interopRequireDefault(require("./expires"));

var _emitConnectEvent = _interopRequireDefault(require("./commands-utils/emitConnectEvent"));

var _pipeline = _interopRequireDefault(require("./pipeline"));

var _promiseContainer = _interopRequireDefault(require("./promise-container"));

var _keyspaceNotifications = _interopRequireDefault(require("./keyspace-notifications"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var defaultOptions = {
  data: {},
  keyPrefix: '',
  lazyConnect: false,
  notifyKeyspaceEvents: '' // string pattern as specified in https://redis.io/topics/notifications#configuration e.g. 'gxK'

};

var RedisMock = /*#__PURE__*/function (_EventEmitter) {
  _inherits(RedisMock, _EventEmitter);

  var _super = _createSuper(RedisMock);

  function RedisMock() {
    var _this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, RedisMock);

    _this = _super.call(this);
    _this.channels = new _events.EventEmitter();
    _this.patternChannels = new _events.EventEmitter();
    _this.batch = undefined;
    _this.connected = false;
    _this.subscriberMode = false; // eslint-disable-next-line prefer-object-spread

    var optionsWithDefault = Object.assign({}, defaultOptions, options);
    _this.expires = (0, _expires.default)(optionsWithDefault.keyPrefix);
    _this.data = (0, _data.default)(_this.expires, optionsWithDefault.data, optionsWithDefault.keyPrefix);

    _this._initCommands();

    _this.keyspaceEvents = (0, _keyspaceNotifications.default)(optionsWithDefault.notifyKeyspaceEvents);

    if (optionsWithDefault.lazyConnect === false) {
      _this.connected = true;
      (0, _emitConnectEvent.default)(_assertThisInitialized(_this));
    }

    return _this;
  }

  _createClass(RedisMock, [{
    key: "multi",
    value: function multi() {
      var _this2 = this;

      var batch = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      this.batch = new _pipeline.default(this); // eslint-disable-next-line no-underscore-dangle

      this.batch._transactions += 1;
      batch.forEach(function (_ref) {
        var _this2$batch;

        var _ref2 = _toArray(_ref),
            command = _ref2[0],
            options = _ref2.slice(1);

        return (_this2$batch = _this2.batch)[command].apply(_this2$batch, _toConsumableArray(options));
      });
      return this.batch;
    }
  }, {
    key: "pipeline",
    value: function pipeline() {
      var _this3 = this;

      var batch = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      this.batch = new _pipeline.default(this);
      batch.forEach(function (_ref3) {
        var _this3$batch;

        var _ref4 = _toArray(_ref3),
            command = _ref4[0],
            options = _ref4.slice(1);

        return (_this3$batch = _this3.batch)[command].apply(_this3$batch, _toConsumableArray(options));
      });
      return this.batch;
    }
  }, {
    key: "exec",
    value: function exec(callback) {
      var Promise = _promiseContainer.default.get();

      if (!this.batch) {
        return Promise.reject(new Error('ERR EXEC without MULTI'));
      }

      var pipeline = this.batch;
      this.batch = undefined;
      return pipeline.exec(callback);
    }
  }, {
    key: "createConnectedClient",
    value: function createConnectedClient() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var mock = new RedisMock(options);
      mock.expires = typeof options.keyPrefix === 'string' ? this.expires.withKeyPrefix(options.keyPrefix) : this.expires;
      mock.data = typeof options.keyPrefix === 'string' ? this.data.withKeyPrefix(options.keyPrefix) : this.data;
      mock.channels = this.channels;
      mock.patternChannels = this.patternChannels;
      return mock;
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "disconnect",
    value: function disconnect() {// no-op
    }
  }, {
    key: "_initCommands",
    value: function _initCommands() {
      var _this4 = this;

      Object.keys(commands).forEach(function (command) {
        var commandName = command === 'evaluate' ? 'eval' : command;
        _this4[commandName] = (0, _command.default)(commands[command].bind(_this4), commandName, _this4);
      });
      Object.keys(commandsStream).forEach(function (command) {
        _this4[command] = commandsStream[command].bind(_this4);
      });
    }
  }]);

  return RedisMock;
}(_events.EventEmitter);

RedisMock.prototype.Command = {
  // eslint-disable-next-line no-underscore-dangle
  transformers: _ioredis.Command._transformer,
  setArgumentTransformer: function setArgumentTransformer(name, func) {
    RedisMock.prototype.Command.transformers.argument[name] = func;
  },
  setReplyTransformer: function setReplyTransformer(name, func) {
    RedisMock.prototype.Command.transformers.reply[name] = func;
  }
};
Object.defineProperty(RedisMock, 'Promise', {
  get: function get() {
    return _promiseContainer.default.get();
  },
  set: function set(lib) {
    return _promiseContainer.default.set(lib);
  }
});
module.exports = RedisMock;