"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createExpires;

function createExpires() {
  var keyPrefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var expires = {};

  function createInstance(prefix) {
    return {
      get: function get(key) {
        return expires["".concat(prefix).concat(key)];
      },
      set: function set(key, timestamp) {
        expires["".concat(prefix).concat(key)] = +timestamp;
      },
      has: function has(key) {
        return {}.hasOwnProperty.call(expires, "".concat(prefix).concat(key));
      },
      isExpired: function isExpired(key) {
        return expires["".concat(prefix).concat(key)] <= Date.now();
      },
      delete: function _delete(key) {
        delete expires["".concat(prefix).concat(key)];
      },
      withKeyPrefix: function withKeyPrefix(newPrefix) {
        if (newPrefix === prefix) return this;
        return createInstance(newPrefix);
      }
    };
  }

  return createInstance(keyPrefix);
}