"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createData;

var _es6Set = _interopRequireDefault(require("es6-set"));

var _es6Map = _interopRequireDefault(require("es6-map"));

var _lodash = require("lodash");

var _buffer = _interopRequireDefault(require("./buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function createData(expiresInstance) {
  var initial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var keyPrefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  var raw = {};

  function createInstance(prefix, expires) {
    return Object.freeze({
      clear: function clear() {
        raw = {};
      },
      delete: function _delete(key) {
        if (expires.has(key)) {
          expires.delete(key);
        }

        delete raw["".concat(prefix).concat(key)];
      },
      get: function get(key) {
        if (expires.has(key) && expires.isExpired(key)) {
          this.delete(key);
        }

        var value = raw["".concat(prefix).concat(key)];

        if (Array.isArray(value)) {
          return value.slice();
        }

        if (Buffer.isBuffer(value)) {
          return (0, _buffer.default)(value);
        }

        if (value instanceof _es6Set.default) {
          return new _es6Set.default(value);
        }

        if (value instanceof _es6Map.default) {
          return new _es6Map.default(value);
        }

        if (_typeof(value) === 'object' && value) {
          return (0, _lodash.assign)({}, value);
        }

        return value;
      },
      has: function has(key) {
        if (expires.has(key) && expires.isExpired(key)) {
          this.delete(key);
        }

        return {}.hasOwnProperty.call(raw, "".concat(prefix).concat(key));
      },
      keys: function keys() {
        return Object.keys(raw);
      },
      set: function set(key, val) {
        var item = val;

        if (Array.isArray(val)) {
          item = val.slice();
        } else if (Buffer.isBuffer(val)) {
          item = (0, _buffer.default)(val);
        } else if (val instanceof _es6Set.default) {
          item = new _es6Set.default(val);
        } else if (val instanceof _es6Map.default) {
          item = new _es6Map.default(val);
        } else if (_typeof(val) === 'object' && val) {
          item = (0, _lodash.assign)({}, val);
        }

        raw["".concat(prefix).concat(key)] = item;
      },
      withKeyPrefix: function withKeyPrefix(newKeyPrefix) {
        if (newKeyPrefix === prefix) return this;
        return createInstance(newKeyPrefix, expires.withKeyPrefix(newKeyPrefix));
      }
    });
  }

  var data = createInstance(keyPrefix, expiresInstance);
  Object.keys(initial).forEach(function (key) {
    return data.set(key, initial[key]);
  });
  return data;
}