"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zrangebyscore = zrangebyscore;

var _es6Map = _interopRequireDefault(require("es6-map"));

var _arrayFrom = _interopRequireDefault(require("array-from"));

var _lodash = require("lodash");

var _zrangeCommand = require("./zrange-command.common");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function zrangebyscore(key, inputMin, inputMax) {
  var map = this.data.get(key);

  if (!map) {
    return [];
  }

  if (this.data.has(key) && !(this.data.get(key) instanceof _es6Map.default)) {
    return [];
  }

  for (var _len = arguments.length, args = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
    args[_key - 3] = arguments[_key];
  }

  var _getWithScoresAndLimi = (0, _zrangeCommand.getWithScoresAndLimit)(args),
      withScores = _getWithScoresAndLimi.withScores,
      limit = _getWithScoresAndLimi.limit,
      offset = _getWithScoresAndLimi.offset;

  var min = (0, _zrangeCommand.parseLimit)(inputMin);
  var max = (0, _zrangeCommand.parseLimit)(inputMax);
  var filteredArray = (0, _lodash.filter)((0, _arrayFrom.default)(map.values()), (0, _zrangeCommand.filterPredicate)(min, max));
  var ordered = (0, _lodash.orderBy)(filteredArray, ['score', 'value']);

  if (withScores) {
    if (limit !== null) {
      ordered = (0, _zrangeCommand.offsetAndLimit)(ordered, offset, limit);
    }

    return (0, _lodash.flatMap)(ordered, function (it) {
      return [it.value, it.score];
    });
  }

  var results = ordered.map(function (it) {
    return it.value;
  });

  if (limit !== null) {
    return (0, _zrangeCommand.offsetAndLimit)(results, offset, limit);
  }

  return results;
}