"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zpopmax = zpopmax;

var _es6Map = _interopRequireDefault(require("es6-map"));

var _arrayFrom = _interopRequireDefault(require("array-from"));

var _lodash = require("lodash");

var _zrangeCommand = require("./zrange-command.common");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function zpopmax(key) {
  var count = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  var map = this.data.get(key);

  if (map == null || !(map instanceof _es6Map.default)) {
    return [];
  }

  var ordered = (0, _lodash.reverse)((0, _zrangeCommand.slice)((0, _lodash.orderBy)((0, _arrayFrom.default)(map.values()), ['score', 'value']), -count, -1));
  (0, _lodash.forEach)(ordered, function (it) {
    map.delete(it.value);
  });
  this.data.set(key, map);
  return (0, _lodash.flatMap)(ordered, function (it) {
    return [it.value, it.score];
  });
}