"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zinterstore = zinterstore;

var _es6Map = _interopRequireDefault(require("es6-map"));

var _arrayFrom = _interopRequireDefault(require("array-from"));

var _lodash = require("lodash");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function zinterstore(destKey, numKeys) {
  var srcMaps = [];

  for (var _len = arguments.length, keys = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    keys[_key - 2] = arguments[_key];
  }

  if (parseInt(numKeys, 10) !== keys.length) {
    throw new Error('ERR syntax error');
  }

  for (var i = 0; i < keys.length; i += 1) {
    // @TODO investigate a more stable way to detect sorted lists
    if (!this.data.has(keys[i]) || !(this.data.get(keys[i]) instanceof _es6Map.default)) {
      return 0;
    }

    srcMaps.push(this.data.get(keys[i]));
  } // deep copy inputs


  var inputs = srcMaps.map(function (x) {
    return JSON.parse(JSON.stringify((0, _arrayFrom.default)(x.values())));
  });

  var intersected = _lodash.intersectionBy.apply(void 0, _toConsumableArray(inputs).concat(['value']));

  if (intersected.length === 0) {
    // make sure we don't have destKey set anymore
    this.data.delete(destKey);
    return 0;
  } // @TODO: support AGGREGATE option
  // @TODO: support WEIGHTS option
  // aggregate weights


  for (var _i = 0; _i < intersected.length; _i += 1) {
    var weightSum = 0;

    for (var j = 0; j < srcMaps.length; j += 1) {
      if (srcMaps[j].get(intersected[_i].value)) {
        weightSum += srcMaps[j].get(intersected[_i].value).score;
      }
    }

    intersected[_i].score = weightSum;
    intersected[_i] = [intersected[_i].value, intersected[_i]];
  }

  var intersectedMap = new _es6Map.default(intersected); // store new sorted set

  this.data.set(destKey, intersectedMap);
  return intersected.length;
}