"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.xread = xread;

var _promiseContainer = _interopRequireDefault(require("../promise-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function xread(option) {
  var _this = this;

  var Promise = _promiseContainer.default.get();

  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  var _ref = option === 'STREAMS' ? {
    op: 'COUNT',
    opVal: Infinity,
    rest: args
  } : {
    op: option,
    opVal: parseInt(args[0], 10),
    rest: args.slice(2)
  },
      op = _ref.op,
      opVal = _ref.opVal,
      rest = _ref.rest;

  if (['COUNT', 'BLOCK'].indexOf(op) < 0) {
    throw new Error('ERR syntax error');
  }

  if (rest.length % 2 !== 0) {
    throw new Error("ERR Unbalanced XREAD list of streams: for each stream key an ID or '$' must be specified.");
  } // Turn ["stream1", "stream2", "id1", "id2"] into tuples of
  //      [["stream1", "id1"], ["stream2", "id2"]]


  var toPoll = rest.reduce(function (memo, arg, i) {
    var chunk = Math.floor(i / 2);
    var tuple = memo[chunk] || []; // eslint-disable-next-line no-param-reassign

    memo[chunk] = tuple.concat(arg);
    return memo;
  }, []);

  var pollStream = function pollStream(stream, id) {
    var count = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

    var data = _this.data.get(stream);

    if (!data) return [];
    return data.reduce(function (memo, _ref2) {
      var _ref3 = _toArray(_ref2),
          eventId = _ref3[0],
          row = _ref3.slice(1);

      var _this$data$get = _this.data.get("stream:".concat(stream, ":").concat(eventId)),
          polled = _this$data$get.polled;

      if (!polled && (id === '$' || eventId >= id) && memo.length < count) {
        _this.data.set("stream:".concat(stream, ":").concat(eventId), {
          polled: true
        });

        return memo.concat([[eventId].concat(_toConsumableArray(row))]);
      }

      return memo;
    }, []);
  };

  var pollEvents = function pollEvents(streams, countVal) {
    return streams.reduce(function (memo, _ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
          stream = _ref5[0],
          id = _ref5[1];

      return [[stream, pollStream(stream, id, countVal)]].concat(memo);
    }, []);
  };

  return op === 'BLOCK' ? new Promise(function (resolve) {
    var timeElapsed = 0;

    var f = function f() {
      return setTimeout(function () {
        if (opVal > 0 && timeElapsed < opVal) return resolve(null);
        var events = pollEvents(toPoll, 1);
        if (events.length > 0) return resolve(events);
        timeElapsed += 100;
        return f();
      }, 100);
    };

    f();
  }) : new Promise(function (resolve) {
    var events = pollEvents(toPoll, opVal);
    if (events.length === 0) return resolve(null);
    return resolve(events.slice().reverse());
  });
}