"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsubscribe = unsubscribe;

var _channelSubscription = require("../commands-utils/channel-subscription");

function unsubscribe() {
  var _this = this;

  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 0) {
    (0, _channelSubscription.getSubscribedChannels)(this, this.channels).forEach(function (channel) {
      (0, _channelSubscription.unsubscribeFromChannel)(_this, channel, _this.channels);
    });
    return 0;
  }

  args.forEach(function (chan) {
    (0, _channelSubscription.unsubscribeFromChannel)(_this, chan, _this.channels);
  });
  var numberOfSubscribedChannels = (0, _channelSubscription.getSubscribedChannels)(this, this.channels).length;

  if (numberOfSubscribedChannels + (0, _channelSubscription.getSubscribedChannels)(this, this.patternChannels).length === 0) {
    this.subscriberMode = false;
  }

  return numberOfSubscribedChannels;
}