"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subscribe = subscribe;

var _channelSubscription = require("../commands-utils/channel-subscription");

function subscribe() {
  var _this = this;

  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  args.forEach(function (chan) {
    if (!_this.channels.instanceListeners) {
      _this.channels.instanceListeners = new Map();
    }

    (0, _channelSubscription.subscribeToChannel)(_this, chan, _this.channels);
  });

  if (!this.channels.instanceListeners) {
    return 0;
  }

  var numberOfSubscribedChannels = (0, _channelSubscription.getSubscribedChannels)(this, this.channels).length;

  if (numberOfSubscribedChannels > 0) {
    this.subscriberMode = true;
  }

  return numberOfSubscribedChannels;
}