"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.punsubscribe = punsubscribe;

var _channelSubscription = require("../commands-utils/channel-subscription");

function punsubscribe() {
  var _this = this;

  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 0) {
    (0, _channelSubscription.getSubscribedChannels)(this, this.patternChannels).forEach(function (channel) {
      (0, _channelSubscription.unsubscribeFromChannel)(_this, channel, _this.patternChannels);
    });
  }

  args.forEach(function (pattern) {
    (0, _channelSubscription.unsubscribeFromChannel)(_this, pattern, _this.patternChannels);
  });
  var numberOfSubscribedChannels = (0, _channelSubscription.getSubscribedChannels)(this, this.patternChannels).length;

  if (numberOfSubscribedChannels + (0, _channelSubscription.getSubscribedChannels)(this, this.channels).length === 0) {
    this.subscriberMode = false;
  }

  return numberOfSubscribedChannels;
}