"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.publish = publish;

var _minimatch = _interopRequireDefault(require("minimatch"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function publish(channel, message) {
  var _this = this;

  this.channels.emit(channel, message);
  var matchingPatterns = this.patternChannels.eventNames().filter(function (pattern) {
    return (0, _minimatch.default)(channel, pattern);
  });
  matchingPatterns.forEach(function (matchingChannel) {
    return _this.patternChannels.emit(matchingChannel, message, channel);
  });
  var numberOfSubscribers = matchingPatterns.length + this.channels.listenerCount(channel);
  return numberOfSubscribers;
}