"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lrem = lrem;

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function lrem(key, c, value) {
  if (this.data.has(key) && !(this.data.get(key) instanceof Array)) {
    return 0;
  }

  var count = parseInt(c, 10);

  var list = _toConsumableArray(this.data.get(key) || []);

  var indexFun = (count < 0 ? [].lastIndexOf : [].indexOf).bind(list);
  var max = count === 0 ? list.length : Math.abs(count);
  var removed = 0;
  var idx = indexFun(value);

  while (idx !== -1 && removed < max) {
    removed++;
    list.splice(idx, 1);
    idx = indexFun(value);
  }

  this.data.set(key, list);
  return removed;
}