"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hdel = hdel;

function hdel(key) {
  var value = this.data.get(key);

  if (!value) {
    return 0;
  }

  for (var _len = arguments.length, fields = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    fields[_key - 1] = arguments[_key];
  }

  var numDeleted = fields.filter(function (field) {
    if ({}.hasOwnProperty.call(value, field)) {
      delete value[field];
      return true;
    }

    return false;
  }).length;
  var numLeft = Object.getOwnPropertyNames(value).length;

  if (numLeft > 0) {
    this.data.set(key, value);
  } else {
    this.data.delete(key);
  }

  return numDeleted;
}