"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineKeys = defineKeys;
exports.defineArgv = defineArgv;
exports.defineCommand = defineCommand;
exports.customCommand = exports.defineRedisObject = void 0;

var _fengari = _interopRequireDefault(require("fengari"));

var _fengariInterop = _interopRequireDefault(require("fengari-interop"));

var _command = _interopRequireDefault(require("../command"));

var _lua = require("../lua");

var commands = _interopRequireWildcard(require("."));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var lua = _fengari.default.lua,
    toLuaString = _fengari.default.to_luastring;
/**
 * exported to test
 *
 * @param {*} vm - object with the lua state (L) and some utils
 * ->
 * @param fn - a function returning 0 for non-error and != 0 for error
 */

var defineRedisObject = function defineRedisObject(vm) {
  return function (fn) {
    vm.defineGlobalFunction(fn, 'call'); // define redis object with call method
    // convert nil to false base on https://redis.io/commands/eval#conversion-between-lua-and-redis-data-types

    vm.luaExecString("\n    local redis = {}\n    function repair(val)\n      if val == nil then\n        return false\n      end\n      return val\n    end\n    redis.call = function(...)\n        return repair(call(false, ...))\n    end\n    redis.pcall = function(...)\n        return repair(call(true, ...))\n    end\n    return redis\n  "); // loads the redis object from the stack into the global table under key 'redis'

    lua.lua_setglobal(vm.L, toLuaString('redis'));
  };
};

exports.defineRedisObject = defineRedisObject;

var callToRedisCommand = function callToRedisCommand(vm) {
  return function callToRedisCommand2() {
    var rawArgs = vm.extractArgs();
    var returnError = rawArgs[0];
    var result;

    try {
      var args = rawArgs.slice(1);
      var name = args[0].toLowerCase();
      var redisCmd = commands[name].bind(this);
      result = redisCmd.apply(void 0, _toConsumableArray(args.slice(1)));
    } catch (err) {
      if (!returnError) {
        throw err;
      }

      _fengariInterop.default.push(vm.L, ['error', err.toString()]);

      return 1;
    }

    if (!!result || result === 0) {
      if (Array.isArray(result)) {
        result.unshift(null);
      }

      _fengariInterop.default.push(vm.L, result);

      return 1;
    }

    return 0;
  };
}; // exported to test


function defineKeys(vm, numberOfKeys, commandArgs) {
  var keys = commandArgs.slice(0, numberOfKeys);
  vm.defineGlobalArray(keys, 'KEYS');
} // exported to test


function defineArgv(vm, numberOfKeys, commandArgs) {
  var args = commandArgs.slice(numberOfKeys);
  vm.defineGlobalArray(args, 'ARGV');
} // exported to test


var customCommand = function customCommand(numberOfKeys, luaCode) {
  return function customCommand2() {
    var vm = (0, _lua.init)();
    defineRedisObject(vm)(callToRedisCommand(vm).bind(this));

    for (var _len = arguments.length, luaScriptArgs = new Array(_len), _key = 0; _key < _len; _key++) {
      luaScriptArgs[_key] = arguments[_key];
    }

    defineKeys.bind(this)(vm, numberOfKeys, luaScriptArgs);
    defineArgv.bind(this)(vm, numberOfKeys, luaScriptArgs);
    var topBeforeExecute = lua.lua_gettop(vm.L);
    vm.luaExecString(luaCode);
    var retVal = vm.popReturnValue(topBeforeExecute);
    (0, _lua.dispose)(vm);
    return retVal;
  };
};

exports.customCommand = customCommand;

function defineCommand(command, _ref) {
  var numberOfKeys = _ref.numberOfKeys,
      luaCode = _ref.lua;
  this[command] = (0, _command.default)(customCommand(numberOfKeys, luaCode).bind(this), command, this);
}